/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.support;

import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.BasicEntityDetails;
import org.apache.hc.core5.http.support.BasicRequestBuilder;
import org.apache.hc.core5.http.support.ExpectSupport;
import org.apache.hc.core5.http.support.Expectation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestExpectSupport {
    TestExpectSupport() {
    }

    @Test
    void testExpectParsingBasics() throws Exception {
        Assertions.assertEquals((Object)Expectation.CONTINUE, (Object)ExpectSupport.parse((HttpRequest)BasicRequestBuilder.post().addHeader("Expect", "100-continue").build(), (EntityDetails)new BasicEntityDetails(100L, ContentType.TEXT_PLAIN)));
    }

    @Test
    void testExpectParsingTolerateEmptyTokens() throws Exception {
        Assertions.assertEquals((Object)Expectation.CONTINUE, (Object)ExpectSupport.parse((HttpRequest)BasicRequestBuilder.post().addHeader("Expect", ",,,").addHeader("Expect", ",100-continue").addHeader("Expect", ",,,").build(), (EntityDetails)new BasicEntityDetails(100L, ContentType.TEXT_PLAIN)));
    }

    @Test
    void testExpectParsingMissingEntity() {
        Assertions.assertThrows(ProtocolException.class, () -> ExpectSupport.parse((HttpRequest)BasicRequestBuilder.post().addHeader("Expect", "100-continue").build(), null));
    }

    @Test
    void testExpectParsingUnknownExpectation() throws Exception {
        Assertions.assertEquals((Object)Expectation.UNKNOWN, (Object)ExpectSupport.parse((HttpRequest)BasicRequestBuilder.post().addHeader("Expect", "whatever").addHeader("Expect", "100-continue").build(), (EntityDetails)new BasicEntityDetails(100L, ContentType.TEXT_PLAIN)));
    }

    @Test
    void testExpectParsingUnknownExpectation2() throws Exception {
        Assertions.assertEquals((Object)Expectation.UNKNOWN, (Object)ExpectSupport.parse((HttpRequest)BasicRequestBuilder.post().addHeader("Expect", "100-continue, whatever").build(), (EntityDetails)new BasicEntityDetails(100L, ContentType.TEXT_PLAIN)));
    }

    @Test
    void testExpectParsingNoExpectation() throws Exception {
        Assertions.assertNull((Object)ExpectSupport.parse((HttpRequest)BasicRequestBuilder.post().build(), (EntityDetails)new BasicEntityDetails(100L, ContentType.TEXT_PLAIN)));
    }

    @Test
    void testExpectParsingIgnoreHTTP10() throws Exception {
        Assertions.assertNull((Object)ExpectSupport.parse((HttpRequest)BasicRequestBuilder.post().setVersion((ProtocolVersion)HttpVersion.HTTP_1_0).addHeader("Expect", "100-continue").build(), (EntityDetails)new BasicEntityDetails(100L, ContentType.TEXT_PLAIN)));
    }
}

