/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.exceptions;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.io.SyncFailedException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hbase.CallDroppedException;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.MultiActionResultTooLarge;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.RetryImmediatelyException;
import org.apache.hadoop.hbase.exceptions.ConnectionClosedException;
import org.apache.hadoop.hbase.exceptions.ConnectionClosingException;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hadoop.hbase.exceptions.RequestTooBigException;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.ipc.FailedServerException;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class ClientExceptionsUtil {
    private static final ImmutableSet<Class<? extends Throwable>> CONNECTION_EXCEPTION_TYPES = ImmutableSet.of(SocketTimeoutException.class, ConnectException.class, ClosedChannelException.class, SyncFailedException.class, EOFException.class, TimeoutException.class, new Class[]{TimeoutIOException.class, CallTimeoutException.class, ConnectionClosingException.class, FailedServerException.class, ConnectionClosedException.class});

    private ClientExceptionsUtil() {
    }

    public static boolean isMetaClearingException(Throwable cur) {
        if ((cur = ClientExceptionsUtil.findException(cur)) == null) {
            return true;
        }
        return !ClientExceptionsUtil.isSpecialException(cur) || cur instanceof RegionMovedException || cur instanceof NotServingRegionException;
    }

    public static boolean isSpecialException(Throwable cur) {
        return cur instanceof RegionMovedException || cur instanceof RegionOpeningException || cur instanceof RegionTooBusyException || cur instanceof RpcThrottlingException || cur instanceof MultiActionResultTooLarge || cur instanceof RetryImmediatelyException || cur instanceof CallQueueTooBigException || cur instanceof CallDroppedException || cur instanceof NotServingRegionException || cur instanceof RequestTooBigException;
    }

    public static Throwable findException(Object exception) {
        if (exception == null || !(exception instanceof Throwable)) {
            return null;
        }
        Throwable cur = (Throwable)exception;
        while (cur != null) {
            if (ClientExceptionsUtil.isSpecialException(cur)) {
                return cur;
            }
            if (cur instanceof RemoteException) {
                RemoteException re = (RemoteException)cur;
                if ((cur = re.unwrapRemoteException()) != re) continue;
                return cur;
            }
            if (cur.getCause() != null && !(cur.getCause() instanceof RemoteException)) {
                cur = cur.getCause();
                continue;
            }
            return cur;
        }
        return null;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    @SuppressWarnings(value={"MS_EXPOSE_REP"}, justification="test only")
    public static Set<Class<? extends Throwable>> getConnectionExceptionTypes() {
        return CONNECTION_EXCEPTION_TYPES;
    }

    public static boolean isConnectionException(Throwable e) {
        if (e == null) {
            return false;
        }
        for (Class clazz : CONNECTION_EXCEPTION_TYPES) {
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            return true;
        }
        return false;
    }

    public static Throwable translatePFFE(Throwable t) throws IOException {
        if (t instanceof NoSuchMethodError) {
            throw (NoSuchMethodError)t;
        }
        if (t instanceof NullPointerException) {
            throw (NullPointerException)t;
        }
        if (t instanceof UndeclaredThrowableException) {
            t = t.getCause();
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        if (t instanceof DoNotRetryIOException) {
            throw (DoNotRetryIOException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        return t;
    }
}

