/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.example;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.Export;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ExportEndpointExample {
    public static void main(String[] args) throws Throwable {
        int rowCount = 100;
        byte[] family = Bytes.toBytes((String)"family");
        Configuration conf = HBaseConfiguration.create();
        TableName tableName = TableName.valueOf((String)"ExportEndpointExample");
        try (Connection con = ConnectionFactory.createConnection((Configuration)conf);
             Admin admin = con.getAdmin();){
            Object bs;
            TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setCoprocessor(Export.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
            admin.createTable(desc);
            ArrayList<Put> puts = new ArrayList<Put>(rowCount);
            for (int row = 0; row != rowCount; ++row) {
                bs = Bytes.toBytes((int)row);
                Put put = new Put((byte[])bs);
                put.addColumn(family, (byte[])bs, (byte[])bs);
                puts.add(put);
            }
            Table table = con.getTable(tableName);
            bs = null;
            try {
                table.put(puts);
            }
            catch (Throwable put) {
                bs = put;
                throw put;
            }
            finally {
                if (table != null) {
                    if (bs != null) {
                        try {
                            table.close();
                        }
                        catch (Throwable put) {
                            ((Throwable)bs).addSuppressed(put);
                        }
                    } else {
                        table.close();
                    }
                }
            }
            Path output = new Path("/tmp/ExportEndpointExample_output");
            Scan scan = new Scan();
            Map result = Export.run((Configuration)conf, (TableName)tableName, (Scan)scan, (Path)output);
            long totalOutputRows = result.values().stream().mapToLong(v -> v.getRowCount()).sum();
            long totalOutputCells = result.values().stream().mapToLong(v -> v.getCellCount()).sum();
            System.out.println("table:" + tableName);
            System.out.println("output:" + output);
            System.out.println("total rows:" + totalOutputRows);
            System.out.println("total cells:" + totalOutputCells);
        }
    }

    private ExportEndpointExample() {
    }
}

