/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.io.ByteArrayOutputStream;
import org.jruby.RubyModule;
import org.jruby.compiler.Compilable;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.persistence.IRDumper;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InterpretedIRMethod
extends AbstractIRMethod
implements Compilable<InterpreterContext> {
    private static final Logger LOG = LoggerFactory.getLogger(InterpretedIRMethod.class);
    private boolean displayedCFG = false;

    public InterpretedIRMethod(IRScope method2, Visibility visibility, RubyModule implementationClass) {
        super(method2, visibility, implementationClass);
        if (implementationClass.getRuntime().getInstanceConfig().getJitThreshold() == -1) {
            this.setCallCount(-1);
        }
        method2.compilable = this;
    }

    protected void post(InterpreterContext ic, ThreadContext context) {
        context.popFrame();
        if (ic.popDynScope()) {
            context.popScope();
        }
    }

    protected void pre(InterpreterContext ic, ThreadContext context, IRubyObject self2, String name2, Block block, RubyModule implClass) {
        context.preMethodFrameOnly(implClass, name2, self2, block);
        if (ic.pushNewDynScope()) {
            context.pushScope(DynamicScope.newDynamicScope(ic.getStaticScope()));
        }
    }

    @Override
    protected void printMethodIR() {
        ByteArrayOutputStream baos = IRDumper.printIR(this.method, false, true);
        LOG.info("Printing simple IR for " + this.method.getId() + ":\n" + new String(baos.toByteArray()), new Object[0]);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, args2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, args2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), ic.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, args2, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, args2, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), ic.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, arg0, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, arg0, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), ic.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, arg0, arg1, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, arg0, arg1, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), ic.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, arg2, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, arg2, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, arg0, arg1, arg2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, arg0, arg1, arg2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), ic.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, arg2, arg3, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, arg2, arg3, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    protected void doDebug() {
        this.ensureInstrsReady();
        LOG.info("Executing '" + this.method.getId() + "'", new Object[0]);
        if (!this.displayedCFG) {
            LOG.info(this.method.debugOutput(), new Object[0]);
            this.displayedCFG = true;
        }
    }

    @Override
    public void completeBuild(InterpreterContext interpreterContext) {
        this.interpreterContext = interpreterContext;
        this.displayedCFG = false;
    }

    private void promoteToFullBuild(ThreadContext context) {
        InterpretedIRMethod.tryJit(context, this);
        if (IRRuntimeHelpers.shouldPrintIR(context.runtime)) {
            ByteArrayOutputStream baos = IRDumper.printIR(this.method, true, true);
            LOG.info("Printing full IR for " + this.method.getId() + ":\n" + new String(baos.toByteArray()), new Object[0]);
        }
    }

    @Override
    public String getClassName(ThreadContext context) {
        return null;
    }
}

