/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.function.Supplier;
import org.apache.hadoop.hbase.Waiter;
import org.apache.yetus.audience.InterfaceAudience;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

@InterfaceAudience.Private
public class MatcherPredicate<T>
implements Waiter.ExplainingPredicate<RuntimeException> {
    private final String reason;
    private final Supplier<T> supplier;
    private final Matcher<? super T> matcher;
    private T currentValue;

    public MatcherPredicate(Supplier<T> supplier, Matcher<? super T> matcher) {
        this("", supplier, matcher);
    }

    public MatcherPredicate(String reason, Supplier<T> supplier, Matcher<? super T> matcher) {
        this.reason = reason;
        this.supplier = supplier;
        this.matcher = matcher;
        this.currentValue = null;
    }

    @Override
    public boolean evaluate() {
        this.currentValue = this.supplier.get();
        return this.matcher.matches(this.currentValue);
    }

    @Override
    public String explainFailure() {
        Description description = new StringDescription().appendText(this.reason).appendText("\nExpected: ").appendDescriptionOf(this.matcher).appendText("\n     but: ");
        this.matcher.describeMismatch(this.currentValue, description);
        return description.toString();
    }
}

