/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.AutoValue_DbClientMetrics_State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.DbClientMetricsAdvice;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.OperationMetricsUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class DbClientMetrics
implements OperationListener {
    private static final double NANOS_PER_S = TimeUnit.SECONDS.toNanos(1L);
    private static final ContextKey<State> DB_CLIENT_OPERATION_METRICS_STATE = ContextKey.named("db-client-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(DbClientMetrics.class.getName());
    private final DoubleHistogram duration;

    public static OperationMetrics get() {
        if (SemconvStability.emitStableDatabaseSemconv()) {
            return OperationMetricsUtil.create("database client", DbClientMetrics::new);
        }
        return meter -> OperationMetricsUtil.NOOP_OPERATION_LISTENER;
    }

    private DbClientMetrics(Meter meter) {
        DoubleHistogramBuilder stableDurationBuilder = meter.histogramBuilder("db.client.operation.duration").setUnit("s").setDescription("Duration of database client operations.").setExplicitBucketBoundariesAdvice(DbClientMetricsAdvice.DURATION_SECONDS_BUCKETS);
        DbClientMetricsAdvice.applyClientDurationAdvice(stableDurationBuilder);
        this.duration = stableDurationBuilder.build();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(DB_CLIENT_OPERATION_METRICS_STATE, new AutoValue_DbClientMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        State state = context.get(DB_CLIENT_OPERATION_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record database operation metrics.", context);
            return;
        }
        Attributes attributes = state.startAttributes().toBuilder().putAll(endAttributes).build();
        this.duration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_S, attributes, context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

