/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminClient;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRSGroupUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupUtil.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRSGroupUtil.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static HMaster master;
    private static RSGroupAdminClient rsGroupAdminClient;
    private static final String GROUP_NAME = "rsg";
    private static RSGroupInfoManager rsGroupInfoManager;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().set("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class.getName());
        UTIL.getConfiguration().set("hbase.coprocessor.master.classes", RSGroupAdminEndpoint.class.getName());
        UTIL.startMiniCluster(5);
        master = UTIL.getMiniHBaseCluster().getMaster();
        UTIL.waitFor(60000L, () -> master.isInitialized() && ((RSGroupBasedLoadBalancer)master.getLoadBalancer()).isOnline());
        rsGroupAdminClient = new RSGroupAdminClient(UTIL.getConnection());
        List cps = master.getMasterCoprocessorHost().findCoprocessors(RSGroupAdminEndpoint.class);
        Assert.assertTrue((cps.size() > 0 ? 1 : 0) != 0);
        rsGroupInfoManager = ((RSGroupAdminEndpoint)cps.get(0)).getGroupInfoManager();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void rsGroupHasOnlineServer() throws IOException {
        rsGroupInfoManager.refresh();
        RSGroupInfo defaultGroup = rsGroupInfoManager.getRSGroup("default");
        Assert.assertTrue((boolean)RSGroupUtil.rsGroupHasOnlineServer((MasterServices)master, (RSGroupInfo)defaultGroup));
        HRegionServer rs = UTIL.getHBaseCluster().getRegionServer(0);
        rsGroupAdminClient.addRSGroup(GROUP_NAME);
        rsGroupAdminClient.moveServers(Collections.singleton(rs.getServerName().getAddress()), GROUP_NAME);
        rsGroupInfoManager.refresh();
        RSGroupInfo rsGroup = rsGroupInfoManager.getRSGroup(GROUP_NAME);
        Assert.assertTrue((boolean)RSGroupUtil.rsGroupHasOnlineServer((MasterServices)master, (RSGroupInfo)rsGroup));
        rsGroupAdminClient.addRSGroup("empty");
        rsGroupInfoManager.refresh();
        RSGroupInfo emptyGroup = rsGroupInfoManager.getRSGroup("empty");
        Assert.assertFalse((boolean)RSGroupUtil.rsGroupHasOnlineServer((MasterServices)master, (RSGroupInfo)emptyGroup));
    }
}

