/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.executor;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@InterfaceAudience.Private
public abstract class EventHandler
implements Runnable,
Comparable<EventHandler> {
    private static final Logger LOG = LoggerFactory.getLogger(EventHandler.class);
    protected EventType eventType;
    protected Server server;
    protected static final AtomicLong seqids = new AtomicLong(0L);
    private final long seqid;
    protected int waitingTimeForEvents;
    private final Span parent = Span.current();

    public EventHandler(Server server, EventType eventType) {
        this.server = server;
        this.eventType = eventType;
        this.seqid = seqids.incrementAndGet();
        if (server != null) {
            this.waitingTimeForEvents = server.getConfiguration().getInt("hbase.master.event.waiting.time", 1000);
        }
    }

    public EventHandler prepare() throws Exception {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Span span = TraceUtil.getGlobalTracer().spanBuilder(this.getClass().getSimpleName()).setParent(Context.current().with((ImplicitContextKeyed)this.parent)).startSpan();
        try (Scope scope = span.makeCurrent();){
            MDC.put((String)"event_type", (String)this.eventType.toString());
            this.process();
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        finally {
            span.end();
            MDC.clear();
        }
    }

    public abstract void process() throws IOException;

    public EventType getEventType() {
        return this.eventType;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public long getSeqid() {
        return this.seqid;
    }

    @Override
    public int compareTo(EventHandler o) {
        if (o == null) {
            return 1;
        }
        if (this.getPriority() != o.getPriority()) {
            return this.getPriority() < o.getPriority() ? -1 : 1;
        }
        return this.seqid < o.seqid ? -1 : 1;
    }

    public String toString() {
        return "Event #" + this.getSeqid() + " of type " + (Object)((Object)this.eventType) + " (" + this.getInformativeName() + ")";
    }

    public String getInformativeName() {
        return this.getClass().toString();
    }

    protected void handleException(Throwable t) {
        String msg = "Caught throwable while processing event " + (Object)((Object)this.eventType);
        LOG.error(msg, t);
        if (this.server != null && (t instanceof Error || t instanceof RuntimeException)) {
            this.server.abort(msg, t);
        }
    }
}

