/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader.security;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timelineservice.reader.security.TimelineReaderWhitelistAuthorizationFilter;

public class TimelineReaderWhitelistAuthorizationFilterInitializer
extends FilterInitializer {
    public void initFilter(FilterContainer container, Configuration conf) {
        HashMap<String, String> params = new HashMap<String, String>();
        String isWhitelistReadAuthEnabled = Boolean.toString(conf.getBoolean("yarn.timeline-service.read.authentication.enabled", YarnConfiguration.DEFAULT_TIMELINE_SERVICE_READ_AUTH_ENABLED.booleanValue()));
        params.put("yarn.timeline-service.read.authentication.enabled", isWhitelistReadAuthEnabled);
        params.put("yarn.timeline-service.read.allowed.users", conf.get("yarn.timeline-service.read.allowed.users", ""));
        params.put("yarn.admin.acl", conf.get("yarn.admin.acl", ""));
        container.addGlobalFilter("Timeline Reader Whitelist Authorization Filter", TimelineReaderWhitelistAuthorizationFilter.class.getName(), params);
    }
}

