/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationStatusSourceStartedTargetStoppedNewOp
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationStatusSourceStartedTargetStoppedNewOp.class);

    @Test
    public void testReplicationStatusSourceStartedTargetStoppedNewOp() throws Exception {
        UTIL2.shutdownMiniHBaseCluster();
        TestReplicationStatusSourceStartedTargetStoppedNewOp.restartSourceCluster(1);
        Admin hbaseAdmin = UTIL1.getAdmin();
        for (int i = 0; i < 100; ++i) {
            Put p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(famName, Bytes.toBytes((String)"col1"), Bytes.toBytes((String)("val" + i)));
            htable1.put(p);
        }
        Thread.sleep(10000L);
        ServerName serverName = UTIL1.getHBaseCluster().getRegionServer(0).getServerName();
        ClusterMetrics metrics = hbaseAdmin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS));
        List loadSources = ((ServerMetrics)metrics.getLiveServerMetrics().get(serverName)).getReplicationLoadSourceList();
        Assert.assertEquals((long)1L, (long)loadSources.size());
        ReplicationLoadSource loadSource = (ReplicationLoadSource)loadSources.get(0);
        Assert.assertTrue((boolean)loadSource.hasEditsSinceRestart());
        Assert.assertEquals((long)0L, (long)loadSource.getTimestampOfLastShippedOp());
        Assert.assertTrue((loadSource.getReplicationLag() > 0L ? 1 : 0) != 0);
        Assert.assertFalse((boolean)loadSource.isRecovered());
    }
}

