/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.CreateStoreFileWriterParams;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.TestCompactor;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, SmallTests.class})
public class TestStripeCompactor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStripeCompactor.class);
    private static final byte[] NAME_OF_THINGS = Bytes.toBytes((String)"foo");
    private static final TableName TABLE_NAME = TableName.valueOf((byte[])NAME_OF_THINGS, (byte[])NAME_OF_THINGS);
    private static final byte[] KEY_B = Bytes.toBytes((String)"bbb");
    private static final byte[] KEY_C = Bytes.toBytes((String)"ccc");
    private static final byte[] KEY_D = Bytes.toBytes((String)"ddd");
    private static final KeyValue KV_A = TestStripeCompactor.kvAfter(Bytes.toBytes((String)"aaa"));
    private static final KeyValue KV_B = TestStripeCompactor.kvAfter(KEY_B);
    private static final KeyValue KV_C = TestStripeCompactor.kvAfter(KEY_C);
    private static final KeyValue KV_D = TestStripeCompactor.kvAfter(KEY_D);
    @Parameterized.Parameter
    public boolean usePrivateReaders;

    @Parameterized.Parameters(name="{index}: usePrivateReaders={0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    private static KeyValue kvAfter(byte[] key) {
        return new KeyValue(Arrays.copyOf(key, key.length + 1), 0L);
    }

    private static <T> T[] a(T ... a) {
        return a;
    }

    private static KeyValue[] e() {
        return TestStripeCompactor.a(new KeyValue[0]);
    }

    @Test
    public void testBoundaryCompactions() throws Exception {
        this.verifyBoundaryCompaction(TestStripeCompactor.a(KV_A, KV_A, KV_B, KV_B, KV_C, KV_D), (byte[][])TestStripeCompactor.a(StripeStoreFileManager.OPEN_KEY, KEY_B, KEY_D, StripeStoreFileManager.OPEN_KEY), (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A, KV_A), TestStripeCompactor.a(KV_B, KV_B, KV_C), TestStripeCompactor.a(KV_D)));
        this.verifyBoundaryCompaction(TestStripeCompactor.a(KV_B, KV_C), (byte[][])TestStripeCompactor.a(KEY_B, KEY_C, KEY_D), (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_B), TestStripeCompactor.a(KV_C)));
        this.verifyBoundaryCompaction(TestStripeCompactor.a(KV_B, KV_C), (byte[][])TestStripeCompactor.a(KEY_B, KEY_D), new KeyValue[][]{TestStripeCompactor.a(KV_B, KV_C)});
    }

    @Test
    public void testBoundaryCompactionEmptyFiles() throws Exception {
        this.verifyBoundaryCompaction(TestStripeCompactor.a(KV_B), (byte[][])TestStripeCompactor.a(KEY_B, KEY_C, KEY_D, StripeStoreFileManager.OPEN_KEY), (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_B), null, null), null, null, false);
        this.verifyBoundaryCompaction(TestStripeCompactor.a(KV_A, KV_C), (byte[][])TestStripeCompactor.a(StripeStoreFileManager.OPEN_KEY, KEY_B, KEY_C, KEY_D), (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A), null, TestStripeCompactor.a(KV_C)), null, null, false);
        this.verifyBoundaryCompaction(TestStripeCompactor.e(), (byte[][])TestStripeCompactor.a(StripeStoreFileManager.OPEN_KEY, KEY_B, KEY_C, StripeStoreFileManager.OPEN_KEY), (KeyValue[][])TestStripeCompactor.a(null, null, TestStripeCompactor.e()), null, null, false);
        this.verifyBoundaryCompaction(TestStripeCompactor.e(), (byte[][])TestStripeCompactor.a(StripeStoreFileManager.OPEN_KEY, KEY_B, KEY_C, StripeStoreFileManager.OPEN_KEY), (KeyValue[][])TestStripeCompactor.a(null, TestStripeCompactor.e(), null), KEY_B, KEY_C, false);
        this.verifyBoundaryCompaction(TestStripeCompactor.e(), (byte[][])TestStripeCompactor.a(StripeStoreFileManager.OPEN_KEY, KEY_B, KEY_C, StripeStoreFileManager.OPEN_KEY), (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.e(), TestStripeCompactor.e(), null), StripeStoreFileManager.OPEN_KEY, KEY_C, false);
        this.verifyBoundaryCompaction(TestStripeCompactor.a(KV_A), (byte[][])TestStripeCompactor.a(StripeStoreFileManager.OPEN_KEY, KEY_B, KEY_C, KEY_D, StripeStoreFileManager.OPEN_KEY), (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A), TestStripeCompactor.e(), TestStripeCompactor.e(), null), KEY_B, KEY_D, false);
        this.verifyBoundaryCompaction(TestStripeCompactor.a(KV_C), (byte[][])TestStripeCompactor.a(StripeStoreFileManager.OPEN_KEY, KEY_B, KEY_C, KEY_D, StripeStoreFileManager.OPEN_KEY), (KeyValue[][])TestStripeCompactor.a(null, null, TestStripeCompactor.a(KV_C), TestStripeCompactor.e()), KEY_C, StripeStoreFileManager.OPEN_KEY, false);
    }

    private void verifyBoundaryCompaction(KeyValue[] input, byte[][] boundaries, KeyValue[][] output) throws Exception {
        this.verifyBoundaryCompaction(input, boundaries, output, null, null, true);
    }

    private void verifyBoundaryCompaction(KeyValue[] input, byte[][] boundaries, KeyValue[][] output, byte[] majorFrom, byte[] majorTo, boolean allFiles) throws Exception {
        TestCompactor.StoreFileWritersCapture writers = new TestCompactor.StoreFileWritersCapture();
        StripeCompactor sc = this.createCompactor(writers, input);
        List paths = sc.compact(TestCompactor.createDummyRequest(), Arrays.asList(boundaries), majorFrom, majorTo, (ThroughputController)NoLimitThroughputController.INSTANCE, null);
        writers.verifyKvs(output, allFiles, true);
        if (allFiles) {
            Assert.assertEquals((long)output.length, (long)paths.size());
            writers.verifyBoundaries(boundaries);
        }
    }

    @Test
    public void testSizeCompactions() throws Exception {
        this.verifySizeCompaction(TestStripeCompactor.a(KV_A, KV_A, KV_B, KV_C, KV_D), 3, 2L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A, KV_A), TestStripeCompactor.a(KV_B, KV_C), TestStripeCompactor.a(KV_D)));
        this.verifySizeCompaction(TestStripeCompactor.a(KV_A, KV_B, KV_C, KV_D), 4, 1L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A), TestStripeCompactor.a(KV_B), TestStripeCompactor.a(KV_C), TestStripeCompactor.a(KV_D)));
        this.verifySizeCompaction(TestStripeCompactor.a(KV_B, KV_C), 2, 1L, KEY_B, KEY_D, (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_B), TestStripeCompactor.a(KV_C)));
        this.verifySizeCompaction(TestStripeCompactor.a(KV_A, KV_A, KV_A, KV_C, KV_D), 3, 2L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A, KV_A, KV_A), TestStripeCompactor.a(KV_C, KV_D)));
        this.verifySizeCompaction(TestStripeCompactor.a(KV_A, KV_B, KV_B, KV_C), 3, 1L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A), TestStripeCompactor.a(KV_B, KV_B), TestStripeCompactor.a(KV_C)));
        this.verifySizeCompaction(TestStripeCompactor.a(KV_A, KV_B, KV_C, KV_D), 2, 1L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A), TestStripeCompactor.a(KV_B, KV_C, KV_D)));
        this.verifySizeCompaction(TestStripeCompactor.a(KV_A, KV_B, KV_C), 1, Long.MAX_VALUE, StripeStoreFileManager.OPEN_KEY, KEY_D, new KeyValue[][]{TestStripeCompactor.a(KV_A, KV_B, KV_C)});
        this.verifySizeCompaction(TestStripeCompactor.a(KV_A, KV_B, KV_C, KV_D), Integer.MAX_VALUE, 2L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A, KV_B), TestStripeCompactor.a(KV_C, KV_D)));
    }

    private void verifySizeCompaction(KeyValue[] input, int targetCount, long targetSize, byte[] left, byte[] right, KeyValue[][] output) throws Exception {
        TestCompactor.StoreFileWritersCapture writers = new TestCompactor.StoreFileWritersCapture();
        StripeCompactor sc = this.createCompactor(writers, input);
        List paths = sc.compact(TestCompactor.createDummyRequest(), targetCount, targetSize, left, right, null, null, (ThroughputController)NoLimitThroughputController.INSTANCE, null);
        Assert.assertEquals((long)output.length, (long)paths.size());
        writers.verifyKvs(output, true, true);
        ArrayList<byte[]> boundaries = new ArrayList<byte[]>(output.length + 2);
        boundaries.add(left);
        for (int i = 1; i < output.length; ++i) {
            boundaries.add(CellUtil.cloneRow((Cell)output[i][0]));
        }
        boundaries.add(right);
        writers.verifyBoundaries((byte[][])boundaries.toArray((T[])new byte[0][]));
    }

    private StripeCompactor createCompactor(TestCompactor.StoreFileWritersCapture writers, KeyValue[] input) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.regionserver.compaction.private.readers", this.usePrivateReaders);
        final TestCompactor.Scanner scanner = new TestCompactor.Scanner(input);
        HColumnDescriptor col = new HColumnDescriptor(NAME_OF_THINGS);
        ScanInfo si = new ScanInfo(conf, (ColumnFamilyDescriptor)col, Long.MAX_VALUE, 0L, (CellComparator)CellComparatorImpl.COMPARATOR);
        HStore store = (HStore)Mockito.mock(HStore.class);
        Mockito.when((Object)store.getColumnFamilyDescriptor()).thenReturn((Object)col);
        Mockito.when((Object)store.getScanInfo()).thenReturn((Object)si);
        Mockito.when((Object)store.areWritesEnabled()).thenReturn((Object)true);
        Mockito.when((Object)store.getFileSystem()).thenReturn(Mockito.mock(FileSystem.class));
        Mockito.when((Object)store.getRegionInfo()).thenReturn((Object)RegionInfoBuilder.newBuilder((TableName)TABLE_NAME).build());
        StoreEngine storeEngine = (StoreEngine)Mockito.mock(StoreEngine.class);
        Mockito.when((Object)storeEngine.createWriter((CreateStoreFileWriterParams)ArgumentMatchers.any(CreateStoreFileWriterParams.class))).thenAnswer((Answer)writers);
        Mockito.when((Object)store.getStoreEngine()).thenReturn((Object)storeEngine);
        Mockito.when((Object)store.getComparator()).thenReturn((Object)CellComparatorImpl.COMPARATOR);
        return new StripeCompactor(conf, store){

            protected InternalScanner createScanner(HStore store, ScanInfo scanInfo, List<StoreFileScanner> scanners, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
                return scanner;
            }

            protected InternalScanner createScanner(HStore store, ScanInfo scanInfo, List<StoreFileScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs) throws IOException {
                return scanner;
            }
        };
    }
}

