/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.errorhandling.TimeoutException;
import org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hadoop.hbase.procedure.ProcedureMemberRpcs;
import org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hadoop.hbase.procedure.SubprocedureFactory;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureMember {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureMember.class);
    private static final long WAKE_FREQUENCY = 100L;
    private static final long TIMEOUT = 100000L;
    private static final long POOL_KEEP_ALIVE = 1L;
    private final String op = "some op";
    private final byte[] data = new byte[0];
    private final ForeignExceptionDispatcher mockListener = (ForeignExceptionDispatcher)Mockito.spy((Object)new ForeignExceptionDispatcher());
    private final SubprocedureFactory mockBuilder = (SubprocedureFactory)Mockito.mock(SubprocedureFactory.class);
    private final ProcedureMemberRpcs mockMemberComms = (ProcedureMemberRpcs)Mockito.mock(ProcedureMemberRpcs.class);
    private ProcedureMember member;
    private ForeignExceptionDispatcher dispatcher;
    Subprocedure spySub;

    @After
    public void resetTest() throws IOException {
        Mockito.reset((Object[])new Object[]{this.mockListener, this.mockBuilder, this.mockMemberComms});
        Closeables.close((Closeable)this.member, (boolean)true);
    }

    private ProcedureMember buildCohortMember() {
        String name = "node";
        ThreadPoolExecutor pool = ProcedureMember.defaultPool((String)name, (int)1, (long)1L);
        return new ProcedureMember(this.mockMemberComms, pool, this.mockBuilder);
    }

    private void buildCohortMemberPair() throws IOException {
        this.dispatcher = new ForeignExceptionDispatcher();
        String name = "node";
        ThreadPoolExecutor pool = ProcedureMember.defaultPool((String)name, (int)1, (long)1L);
        this.member = new ProcedureMember(this.mockMemberComms, pool, this.mockBuilder);
        Mockito.when((Object)this.mockMemberComms.getMemberName()).thenReturn((Object)"membername");
        EmptySubprocedure subproc = new EmptySubprocedure(this.member, this.dispatcher);
        this.spySub = (Subprocedure)Mockito.spy((Object)((Object)subproc));
        Mockito.when((Object)this.mockBuilder.buildSubprocedure("some op", this.data)).thenReturn((Object)this.spySub);
        this.addCommitAnswer();
    }

    private void addCommitAnswer() throws IOException {
        ((ProcedureMemberRpcs)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                TestProcedureMember.this.member.receivedReachedGlobalBarrier("some op");
                return null;
            }
        }).when((Object)this.mockMemberComms)).sendMemberAcquired((Subprocedure)ArgumentMatchers.any());
    }

    @Test
    public void testSimpleRun() throws Exception {
        this.member = this.buildCohortMember();
        EmptySubprocedure subproc = new EmptySubprocedure(this.member, this.mockListener);
        EmptySubprocedure spy = (EmptySubprocedure)((Object)Mockito.spy((Object)((Object)subproc)));
        Mockito.when((Object)this.mockBuilder.buildSubprocedure("some op", this.data)).thenReturn((Object)spy);
        this.addCommitAnswer();
        Subprocedure subproc1 = this.member.createSubprocedure("some op", this.data);
        this.member.submitSubprocedure(subproc1);
        subproc.waitForLocallyCompleted();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.mockMemberComms, spy});
        ((EmptySubprocedure)((Object)order.verify((Object)spy))).acquireBarrier();
        ((ProcedureMemberRpcs)order.verify((Object)this.mockMemberComms)).sendMemberAcquired((Subprocedure)ArgumentMatchers.eq((Object)((Object)spy)));
        ((EmptySubprocedure)((Object)order.verify((Object)spy))).insideBarrier();
        ((ProcedureMemberRpcs)order.verify((Object)this.mockMemberComms)).sendMemberCompleted((Subprocedure)ArgumentMatchers.eq((Object)((Object)spy)), (byte[])ArgumentMatchers.eq((Object)this.data));
        ((ProcedureMemberRpcs)order.verify((Object)this.mockMemberComms, Mockito.never())).sendMemberAborted((Subprocedure)ArgumentMatchers.eq((Object)((Object)spy)), (ForeignException)((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testMemberPrepareException() throws Exception {
        this.buildCohortMemberPair();
        ((Subprocedure)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                throw new IOException("Forced IOException in member acquireBarrier");
            }
        }).when((Object)this.spySub)).acquireBarrier();
        Subprocedure subproc = this.member.createSubprocedure("some op", this.data);
        this.member.submitSubprocedure(subproc);
        this.member.closeAndWait(100000L);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.mockMemberComms, this.spySub});
        ((Subprocedure)order.verify((Object)this.spySub)).acquireBarrier();
        ((ProcedureMemberRpcs)order.verify((Object)this.mockMemberComms, Mockito.never())).sendMemberAcquired((Subprocedure)ArgumentMatchers.eq((Object)this.spySub));
        ((Subprocedure)order.verify((Object)this.spySub, Mockito.never())).insideBarrier();
        ((ProcedureMemberRpcs)order.verify((Object)this.mockMemberComms, Mockito.never())).sendMemberCompleted((Subprocedure)ArgumentMatchers.eq((Object)this.spySub), (byte[])ArgumentMatchers.eq((Object)this.data));
        ((Subprocedure)order.verify((Object)this.spySub)).cancel(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any());
        ((Subprocedure)order.verify((Object)this.spySub)).cleanup((Exception)ArgumentMatchers.any());
    }

    @Test
    public void testSendMemberAcquiredCommsFailure() throws Exception {
        this.buildCohortMemberPair();
        ((ProcedureMemberRpcs)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                throw new IOException("Forced IOException in member prepare");
            }
        }).when((Object)this.mockMemberComms)).sendMemberAcquired((Subprocedure)ArgumentMatchers.any());
        Subprocedure subproc = this.member.createSubprocedure("some op", this.data);
        this.member.submitSubprocedure(subproc);
        this.member.closeAndWait(100000L);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.mockMemberComms, this.spySub});
        ((Subprocedure)order.verify((Object)this.spySub)).acquireBarrier();
        ((ProcedureMemberRpcs)order.verify((Object)this.mockMemberComms)).sendMemberAcquired((Subprocedure)ArgumentMatchers.eq((Object)this.spySub));
        ((Subprocedure)order.verify((Object)this.spySub, Mockito.never())).insideBarrier();
        ((ProcedureMemberRpcs)order.verify((Object)this.mockMemberComms, Mockito.never())).sendMemberCompleted((Subprocedure)ArgumentMatchers.eq((Object)this.spySub), (byte[])ArgumentMatchers.eq((Object)this.data));
        ((Subprocedure)order.verify((Object)this.spySub)).cancel(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any());
        ((Subprocedure)order.verify((Object)this.spySub)).cleanup((Exception)ArgumentMatchers.any());
    }

    @Test
    public void testCoordinatorAbort() throws Exception {
        this.buildCohortMemberPair();
        final TimeoutException oate = new TimeoutException("bogus timeout", 1L, 2L, 0L);
        ((Subprocedure)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                TestProcedureMember.this.spySub.cancel("bogus message", (Throwable)oate);
                Thread.sleep(100L);
                return null;
            }
        }).when((Object)this.spySub)).waitForReachedGlobalBarrier();
        Subprocedure subproc = this.member.createSubprocedure("some op", this.data);
        this.member.submitSubprocedure(subproc);
        this.member.closeAndWait(100000L);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.mockMemberComms, this.spySub});
        ((Subprocedure)order.verify((Object)this.spySub)).acquireBarrier();
        ((ProcedureMemberRpcs)order.verify((Object)this.mockMemberComms)).sendMemberAcquired((Subprocedure)ArgumentMatchers.eq((Object)this.spySub));
        ((Subprocedure)order.verify((Object)this.spySub, Mockito.never())).insideBarrier();
        ((ProcedureMemberRpcs)order.verify((Object)this.mockMemberComms, Mockito.never())).sendMemberCompleted((Subprocedure)ArgumentMatchers.eq((Object)this.spySub), (byte[])ArgumentMatchers.eq((Object)this.data));
        ((Subprocedure)order.verify((Object)this.spySub)).cancel(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any());
        ((Subprocedure)order.verify((Object)this.spySub)).cleanup((Exception)ArgumentMatchers.any());
    }

    @Test
    public void testMemberCommitException() throws Exception {
        this.buildCohortMemberPair();
        ((Subprocedure)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                throw new IOException("Forced IOException in member prepare");
            }
        }).when((Object)this.spySub)).insideBarrier();
        Subprocedure subproc = this.member.createSubprocedure("some op", this.data);
        this.member.submitSubprocedure(subproc);
        this.member.closeAndWait(100000L);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.mockMemberComms, this.spySub});
        ((Subprocedure)order.verify((Object)this.spySub)).acquireBarrier();
        ((ProcedureMemberRpcs)order.verify((Object)this.mockMemberComms)).sendMemberAcquired((Subprocedure)ArgumentMatchers.eq((Object)this.spySub));
        ((Subprocedure)order.verify((Object)this.spySub)).insideBarrier();
        ((ProcedureMemberRpcs)order.verify((Object)this.mockMemberComms, Mockito.never())).sendMemberCompleted((Subprocedure)ArgumentMatchers.eq((Object)this.spySub), (byte[])ArgumentMatchers.eq((Object)this.data));
        ((Subprocedure)order.verify((Object)this.spySub)).cancel(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any());
        ((Subprocedure)order.verify((Object)this.spySub)).cleanup((Exception)ArgumentMatchers.any());
    }

    @Test
    public void testMemberCommitCommsFailure() throws Exception {
        this.buildCohortMemberPair();
        final TimeoutException oate = new TimeoutException("bogus timeout", 1L, 2L, 0L);
        ((ProcedureMemberRpcs)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                TestProcedureMember.this.spySub.cancel("commit comms fail", (Throwable)oate);
                Thread.sleep(100L);
                return null;
            }
        }).when((Object)this.mockMemberComms)).sendMemberCompleted((Subprocedure)ArgumentMatchers.any(), (byte[])ArgumentMatchers.eq((Object)this.data));
        Subprocedure subproc = this.member.createSubprocedure("some op", this.data);
        this.member.submitSubprocedure(subproc);
        this.member.closeAndWait(100000L);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.mockMemberComms, this.spySub});
        ((Subprocedure)order.verify((Object)this.spySub)).acquireBarrier();
        ((ProcedureMemberRpcs)order.verify((Object)this.mockMemberComms)).sendMemberAcquired((Subprocedure)ArgumentMatchers.eq((Object)this.spySub));
        ((Subprocedure)order.verify((Object)this.spySub)).insideBarrier();
        ((ProcedureMemberRpcs)order.verify((Object)this.mockMemberComms)).sendMemberCompleted((Subprocedure)ArgumentMatchers.eq((Object)this.spySub), (byte[])ArgumentMatchers.eq((Object)this.data));
        ((Subprocedure)order.verify((Object)this.spySub)).cancel(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any());
        ((Subprocedure)order.verify((Object)this.spySub)).cleanup((Exception)ArgumentMatchers.any());
    }

    @Test
    public void testPropagateConnectionErrorBackToManager() throws Exception {
        this.member = this.buildCohortMember();
        ProcedureMember memberSpy = (ProcedureMember)Mockito.spy((Object)this.member);
        ForeignExceptionDispatcher dispatcher = new ForeignExceptionDispatcher();
        ForeignExceptionDispatcher dispSpy = (ForeignExceptionDispatcher)Mockito.spy((Object)dispatcher);
        EmptySubprocedure commit = new EmptySubprocedure(this.member, dispatcher);
        Subprocedure spy = (Subprocedure)Mockito.spy((Object)((Object)commit));
        Mockito.when((Object)this.mockBuilder.buildSubprocedure("some op", this.data)).thenReturn((Object)spy);
        ((Subprocedure)Mockito.doThrow((Throwable[])new Throwable[]{new ForeignException("SRC", "prepare exception")}).when((Object)spy)).acquireBarrier();
        ((ProcedureMemberRpcs)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Controller is down!")}).when((Object)this.mockMemberComms)).sendMemberAborted((Subprocedure)ArgumentMatchers.eq((Object)spy), (ForeignException)((Object)ArgumentMatchers.any()));
        Subprocedure subproc = memberSpy.createSubprocedure("some op", this.data);
        memberSpy.submitSubprocedure(subproc);
        memberSpy.closeAndWait(100000L);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.mockMemberComms, spy, dispSpy});
        ((Subprocedure)order.verify((Object)spy)).acquireBarrier();
        ((ProcedureMemberRpcs)order.verify((Object)this.mockMemberComms, Mockito.never())).sendMemberAcquired(spy);
    }

    @Test
    public void testNoTaskToBeRunFromRequest() throws Exception {
        ThreadPoolExecutor pool = (ThreadPoolExecutor)Mockito.mock(ThreadPoolExecutor.class);
        Mockito.when((Object)this.mockBuilder.buildSubprocedure("some op", this.data)).thenReturn(null).thenThrow(new Throwable[]{new IllegalStateException("Wrong state!"), new IllegalArgumentException("can't understand the args")});
        this.member = new ProcedureMember(this.mockMemberComms, pool, this.mockBuilder);
        Subprocedure subproc = this.member.createSubprocedure("some op", this.data);
        this.member.submitSubprocedure(subproc);
        try {
            Subprocedure subproc2 = this.member.createSubprocedure("some op", this.data);
            this.member.submitSubprocedure(subproc2);
        }
        catch (IllegalStateException subproc2) {
            // empty catch block
        }
        try {
            Subprocedure subproc3 = this.member.createSubprocedure("some op", this.data);
            this.member.submitSubprocedure(subproc3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{pool});
    }

    public class EmptySubprocedure
    extends Subprocedure.SubprocedureImpl {
        public EmptySubprocedure(ProcedureMember member, ForeignExceptionDispatcher dispatcher) {
            super(member, "some op", dispatcher, 100L, 100000L);
        }
    }
}

