/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AppPriorityACLGroup;

public class AppPriorityACLsManager {
    private static final Log LOG = LogFactory.getLog(AppPriorityACLsManager.class);
    private boolean isACLsEnable;
    private final ConcurrentMap<String, List<PriorityACL>> allAcls = new ConcurrentHashMap<String, List<PriorityACL>>();

    public AppPriorityACLsManager(Configuration conf) {
        this.isACLsEnable = conf.getBoolean("yarn.acl.enable", false);
    }

    public void clearPriorityACLs(String queueName) {
        this.allAcls.remove(queueName);
    }

    public void addPrioirityACLs(List<AppPriorityACLGroup> priorityACLGroups, String queueName) {
        ArrayList<PriorityACL> priorityACL = (ArrayList<PriorityACL>)this.allAcls.get(queueName);
        if (null == priorityACL) {
            priorityACL = new ArrayList<PriorityACL>();
            this.allAcls.put(queueName, priorityACL);
        }
        Collections.sort(priorityACLGroups);
        for (AppPriorityACLGroup priorityACLGroup : priorityACLGroups) {
            priorityACL.add(new PriorityACL(priorityACLGroup.getMaxPriority(), priorityACLGroup.getDefaultPriority(), priorityACLGroup.getACLList()));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Priority ACL group added: max-priority - " + priorityACLGroup.getMaxPriority() + "default-priority - " + priorityACLGroup.getDefaultPriority()));
        }
    }

    public boolean checkAccess(UserGroupInformation callerUGI, String queueName, Priority submittedPriority) {
        if (!this.isACLsEnable) {
            return true;
        }
        List acls = (List)this.allAcls.get(queueName);
        if (acls == null || acls.isEmpty()) {
            return true;
        }
        PriorityACL approvedPriorityACL = this.getMappedPriorityAclForUGI(acls, callerUGI, submittedPriority);
        return approvedPriorityACL != null;
    }

    public Priority getDefaultPriority(String queueName, UserGroupInformation user) {
        if (!this.isACLsEnable) {
            return null;
        }
        List acls = (List)this.allAcls.get(queueName);
        if (acls == null || acls.isEmpty()) {
            return null;
        }
        PriorityACL approvedPriorityACL = this.getMappedPriorityAclForUGI(acls, user, null);
        if (approvedPriorityACL == null) {
            return null;
        }
        Priority defaultPriority = Priority.newInstance((int)approvedPriorityACL.getDefaultPriority().getPriority());
        return defaultPriority;
    }

    private PriorityACL getMappedPriorityAclForUGI(List<PriorityACL> acls, UserGroupInformation user, Priority submittedPriority) {
        PriorityACL selectedAcl = null;
        for (PriorityACL entry : acls) {
            AccessControlList list = entry.getAcl();
            if (!list.isUserAllowed(user)) continue;
            selectedAcl = entry;
            if (submittedPriority == null) continue;
            selectedAcl = null;
            if (submittedPriority.getPriority() > entry.getPriority().getPriority()) continue;
            return entry;
        }
        return selectedAcl;
    }

    private static class PriorityACL {
        private Priority priority;
        private Priority defaultPriority;
        private AccessControlList acl;

        PriorityACL(Priority priority, Priority defaultPriority, AccessControlList acl) {
            this.setPriority(priority);
            this.setDefaultPriority(defaultPriority);
            this.setAcl(acl);
        }

        public Priority getPriority() {
            return this.priority;
        }

        public void setPriority(Priority maxPriority) {
            this.priority = maxPriority;
        }

        public Priority getDefaultPriority() {
            return this.defaultPriority;
        }

        public void setDefaultPriority(Priority defaultPriority) {
            this.defaultPriority = defaultPriority;
        }

        public AccessControlList getAcl() {
            return this.acl;
        }

        public void setAcl(AccessControlList acl) {
            this.acl = acl;
        }
    }
}

