/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.test;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.chaos.util.ChaosMonkeyRunner;
import org.apache.hadoop.hbase.chaos.util.Monkeys;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestMonkeys
extends ChaosMonkeyRunner {
    private static final int RUN_SECS = 15000;
    private static final int WAIT_SECS = 10000;

    @Override
    protected int doWork() throws Exception {
        super.setUpCluster();
        this.runMonkeys();
        return 0;
    }

    @Test
    public void runMonkeys() throws Exception {
        try (Monkeys monkeys = new Monkeys();){
            for (int i = 0; i < 2; ++i) {
                monkeys.startChaos();
                Thread.sleep(15000L);
                monkeys.stopChaos();
                Thread.sleep(10000L);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int exitCode = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestMonkeys(), (String[])args);
        System.exit(exitCode);
    }
}

