/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.tool.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestBulkLoad
extends IntegrationTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestBulkLoad.class);
    private static final byte[] CHAIN_FAM = Bytes.toBytes((String)"L");
    private static final byte[] SORT_FAM = Bytes.toBytes((String)"S");
    private static final byte[] DATA_FAM = Bytes.toBytes((String)"D");
    private static String CHAIN_LENGTH_KEY = "hbase.IntegrationTestBulkLoad.chainLength";
    private static int CHAIN_LENGTH = 500000;
    private static String NUM_MAPS_KEY = "hbase.IntegrationTestBulkLoad.numMaps";
    private static int NUM_MAPS = 1;
    private static String NUM_IMPORT_ROUNDS_KEY = "hbase.IntegrationTestBulkLoad.numImportRounds";
    private static int NUM_IMPORT_ROUNDS = 1;
    private static String ROUND_NUM_KEY = "hbase.IntegrationTestBulkLoad.roundNum";
    private static String TABLE_NAME_KEY = "hbase.IntegrationTestBulkLoad.tableName";
    private static String TABLE_NAME = "IntegrationTestBulkLoad";
    private static String NUM_REPLICA_COUNT_KEY = "hbase.IntegrationTestBulkLoad.replicaCount";
    private static int NUM_REPLICA_COUNT_DEFAULT = 1;
    private static final String OPT_LOAD = "load";
    private static final String OPT_CHECK = "check";
    private boolean load = false;
    private boolean check = false;

    private void installSlowingCoproc() throws IOException, InterruptedException {
        int replicaCount = this.conf.getInt(NUM_REPLICA_COUNT_KEY, NUM_REPLICA_COUNT_DEFAULT);
        if (replicaCount == NUM_REPLICA_COUNT_DEFAULT) {
            return;
        }
        TableName t = this.getTablename();
        Admin admin = this.util.getAdmin();
        TableDescriptor desc = admin.getDescriptor(t);
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)desc);
        builder.setCoprocessor(SlowMeCoproScanOperations.class.getName());
        HBaseTestingUtility.modifyTableSync((Admin)admin, (TableDescriptor)builder.build());
    }

    @Test
    public void testBulkLoad() throws Exception {
        this.runLoad();
        this.installSlowingCoproc();
        this.runCheckWithRetry();
    }

    public void runLoad() throws Exception {
        this.setupTable();
        int numImportRounds = this.getConf().getInt(NUM_IMPORT_ROUNDS_KEY, NUM_IMPORT_ROUNDS);
        LOG.info("Running load with numIterations:" + numImportRounds);
        for (int i = 0; i < numImportRounds; ++i) {
            this.runLinkedListMRJob(i);
        }
    }

    private byte[][] getSplits(int numRegions) {
        RegionSplitter.UniformSplit split = new RegionSplitter.UniformSplit();
        split.setFirstRow(Bytes.toBytes((long)0L));
        split.setLastRow(Bytes.toBytes((long)Long.MAX_VALUE));
        return split.split(numRegions);
    }

    private void setupTable() throws IOException, InterruptedException {
        if (this.util.getAdmin().tableExists(this.getTablename())) {
            this.util.deleteTable(this.getTablename());
        }
        this.util.createTable(this.getTablename(), new byte[][]{CHAIN_FAM, SORT_FAM, DATA_FAM}, this.getSplits(16));
        int replicaCount = this.conf.getInt(NUM_REPLICA_COUNT_KEY, NUM_REPLICA_COUNT_DEFAULT);
        if (replicaCount == NUM_REPLICA_COUNT_DEFAULT) {
            return;
        }
        TableName t = this.getTablename();
        HBaseTestingUtility.setReplicas((Admin)this.util.getAdmin(), (TableName)t, (int)replicaCount);
    }

    private void runLinkedListMRJob(int iteration) throws Exception {
        String jobName = IntegrationTestBulkLoad.class.getSimpleName() + " - " + EnvironmentEdgeManager.currentTime();
        Configuration conf = new Configuration(this.util.getConfiguration());
        Path p = null;
        p = conf.get("importtsv.bulk.output") == null ? this.util.getDataTestDirOnTestFS(this.getTablename() + "-" + iteration) : new Path(conf.get("importtsv.bulk.output"));
        conf.setBoolean("mapreduce.map.speculative", false);
        conf.setBoolean("mapreduce.reduce.speculative", false);
        conf.setInt(ROUND_NUM_KEY, iteration);
        Job job = new Job(conf);
        job.setJobName(jobName);
        job.setInputFormatClass(ITBulkLoadInputFormat.class);
        job.setMapperClass(LinkedListCreationMapper.class);
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job.setMapOutputValueClass(KeyValue.class);
        job.setJarByClass(((Object)((Object)this)).getClass());
        FileOutputFormat.setOutputPath((Job)job, (Path)p);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
             Admin admin = conn.getAdmin();
             Table table = conn.getTable(this.getTablename());
             RegionLocator regionLocator = conn.getRegionLocator(this.getTablename());){
            HFileOutputFormat2.configureIncrementalLoad((Job)job, (TableDescriptor)table.getTableDescriptor(), (RegionLocator)regionLocator);
            Assert.assertEquals((Object)true, (Object)job.waitForCompletion(true));
            LoadIncrementalHFiles loader = new LoadIncrementalHFiles(conf);
            loader.doBulkLoad(p, admin, table, regionLocator);
        }
        this.util.getTestFileSystem().delete(p, true);
    }

    private void runCheckWithRetry() throws IOException, ClassNotFoundException, InterruptedException {
        try {
            this.runCheck();
        }
        catch (Throwable t) {
            LOG.warn("Received " + StringUtils.stringifyException((Throwable)t));
            LOG.warn("Running the check MR Job again to see whether an ephemeral problem or not");
            this.runCheck();
            throw t;
        }
    }

    private void runCheck() throws IOException, ClassNotFoundException, InterruptedException {
        LOG.info("Running check");
        Configuration conf = this.getConf();
        String jobName = this.getTablename() + "_check" + EnvironmentEdgeManager.currentTime();
        Path p = this.util.getDataTestDirOnTestFS(jobName);
        Job job = new Job(conf);
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setJobName(jobName);
        job.setPartitionerClass(NaturalKeyPartitioner.class);
        job.setGroupingComparatorClass(NaturalKeyGroupingComparator.class);
        job.setSortComparatorClass(CompositeKeyComparator.class);
        Scan scan = new Scan();
        scan.addFamily(CHAIN_FAM);
        scan.addFamily(SORT_FAM);
        scan.setMaxVersions(1);
        scan.setCacheBlocks(false);
        scan.setBatch(1000);
        int replicaCount = conf.getInt(NUM_REPLICA_COUNT_KEY, NUM_REPLICA_COUNT_DEFAULT);
        if (replicaCount != NUM_REPLICA_COUNT_DEFAULT) {
            scan.setConsistency(Consistency.TIMELINE);
        }
        TableMapReduceUtil.initTableMapperJob((byte[])this.getTablename().getName(), (Scan)scan, LinkedListCheckingMapper.class, LinkKey.class, LinkChain.class, (Job)job);
        job.setReducerClass(LinkedListCheckingReducer.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(NullWritable.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)p);
        Assert.assertEquals((Object)true, (Object)job.waitForCompletion(true));
        this.util.getTestFileSystem().delete(p, true);
    }

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        this.util.initializeCluster(1);
        int replicaCount = this.getConf().getInt(NUM_REPLICA_COUNT_KEY, NUM_REPLICA_COUNT_DEFAULT);
        if (LOG.isDebugEnabled() && replicaCount != NUM_REPLICA_COUNT_DEFAULT) {
            LOG.debug("Region Replicas enabled: " + replicaCount);
        }
        if (this.util.isDistributedCluster()) {
            this.util.getConfiguration().setIfUnset(NUM_MAPS_KEY, Integer.toString(this.util.getAdmin().getRegionServers().size() * 10));
            this.util.getConfiguration().setIfUnset(NUM_IMPORT_ROUNDS_KEY, "5");
        } else {
            this.util.startMiniMapReduceCluster();
        }
    }

    @Override
    protected void addOptions() {
        super.addOptions();
        super.addOptNoArg(OPT_CHECK, "Run check only");
        super.addOptNoArg(OPT_LOAD, "Run load only");
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        super.processOptions(cmd);
        this.check = cmd.hasOption(OPT_CHECK);
        this.load = cmd.hasOption(OPT_LOAD);
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        if (this.load) {
            this.runLoad();
        } else if (this.check) {
            this.installSlowingCoproc();
            this.runCheckWithRetry();
        } else {
            this.testBulkLoad();
        }
        return 0;
    }

    @Override
    public TableName getTablename() {
        return IntegrationTestBulkLoad.getTableName(this.getConf());
    }

    public static TableName getTableName(Configuration conf) {
        return TableName.valueOf((String)conf.get(TABLE_NAME_KEY, TABLE_NAME));
    }

    @Override
    protected Set<String> getColumnFamilies() {
        return Sets.newHashSet((Object[])new String[]{Bytes.toString((byte[])CHAIN_FAM), Bytes.toString((byte[])DATA_FAM), Bytes.toString((byte[])SORT_FAM)});
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int status = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestBulkLoad(), (String[])args);
        System.exit(status);
    }

    public static class LinkedListCheckingReducer
    extends Reducer<LinkKey, LinkChain, NullWritable, NullWritable> {
        protected void reduce(LinkKey key, Iterable<LinkChain> values, Reducer.Context context) throws IOException, InterruptedException {
            long next = -1L;
            long prev = -1L;
            long count = 0L;
            for (LinkChain lc : values) {
                if (next == -1L) {
                    if (lc.getRk() != 0L) {
                        String msg = "Chains should all start at rk 0, but read rk " + lc.getRk() + ". Chain:" + key.chainId + ", order:" + key.order;
                        LinkedListCheckingReducer.logError(msg, context);
                        throw new RuntimeException(msg);
                    }
                    next = lc.getNext();
                } else {
                    if (next != lc.getRk()) {
                        String msg = "Missing a link in the chain. Prev rk " + prev + " was, expecting " + next + " but got " + lc.getRk() + ". Chain:" + key.chainId + ", order:" + key.order;
                        LinkedListCheckingReducer.logError(msg, context);
                        throw new RuntimeException(msg);
                    }
                    prev = lc.getRk();
                    next = lc.getNext();
                }
                ++count;
            }
            int expectedChainLen = context.getConfiguration().getInt(CHAIN_LENGTH_KEY, CHAIN_LENGTH);
            if (count != (long)expectedChainLen) {
                String msg = "Chain wasn't the correct length.  Expected " + expectedChainLen + " got " + count + ". Chain:" + key.chainId + ", order:" + key.order;
                LinkedListCheckingReducer.logError(msg, context);
                throw new RuntimeException(msg);
            }
        }

        private static void logError(String msg, Reducer.Context context) throws IOException {
            TableName table = IntegrationTestBulkLoad.getTableName(context.getConfiguration());
            LOG.error("Failure in chain verification: " + msg);
            try (Connection connection = ConnectionFactory.createConnection((Configuration)context.getConfiguration());
                 Admin admin = connection.getAdmin();){
                LOG.error("cluster status:\n" + admin.getClusterStatus());
                LOG.error("table regions:\n" + Joiner.on((String)"\n").join((Iterable)admin.getTableRegions(table)));
            }
        }
    }

    public static class LinkedListCheckingMapper
    extends TableMapper<LinkKey, LinkChain> {
        protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            long longRk = Bytes.toLong((byte[])value.getRow());
            for (Map.Entry entry : value.getFamilyMap(CHAIN_FAM).entrySet()) {
                long chainId = Bytes.toLong((byte[])((byte[])entry.getKey()));
                long next = Bytes.toLong((byte[])((byte[])entry.getValue()));
                Cell c = (Cell)value.getColumnCells(SORT_FAM, (byte[])entry.getKey()).get(0);
                long order = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)c));
                context.write((Object)new LinkKey(chainId, order), (Object)new LinkChain(longRk, next));
            }
        }
    }

    public static class CompositeKeyComparator
    extends WritableComparator {
        protected CompositeKeyComparator() {
            super(LinkKey.class, true);
        }

        public int compare(WritableComparable w1, WritableComparable w2) {
            LinkKey k1 = (LinkKey)w1;
            LinkKey k2 = (LinkKey)w2;
            return k1.compareTo(k2);
        }
    }

    public static class NaturalKeyGroupingComparator
    extends WritableComparator {
        protected NaturalKeyGroupingComparator() {
            super(LinkKey.class, true);
        }

        public int compare(WritableComparable w1, WritableComparable w2) {
            LinkKey k1 = (LinkKey)w1;
            LinkKey k2 = (LinkKey)w2;
            return k1.getChainId().compareTo(k2.getChainId());
        }
    }

    public static class NaturalKeyPartitioner
    extends Partitioner<LinkKey, LinkChain> {
        public int getPartition(LinkKey linkKey, LinkChain linkChain, int numPartitions) {
            int hash = linkKey.getChainId().hashCode();
            return Math.abs(hash % numPartitions);
        }
    }

    public static class LinkChain
    implements WritableComparable<LinkChain> {
        private Long rk;
        private Long next;

        public Long getNext() {
            return this.next;
        }

        public Long getRk() {
            return this.rk;
        }

        public LinkChain() {
        }

        public LinkChain(Long rk, Long next) {
            this.rk = rk;
            this.next = next;
        }

        public int compareTo(LinkChain linkChain) {
            int res = this.getRk().compareTo(linkChain.getRk());
            if (res == 0) {
                res = this.getNext().compareTo(linkChain.getNext());
            }
            return res;
        }

        public void write(DataOutput dataOutput) throws IOException {
            WritableUtils.writeVLong((DataOutput)dataOutput, (long)this.rk);
            WritableUtils.writeVLong((DataOutput)dataOutput, (long)this.next);
        }

        public void readFields(DataInput dataInput) throws IOException {
            this.rk = WritableUtils.readVLong((DataInput)dataInput);
            this.next = WritableUtils.readVLong((DataInput)dataInput);
        }
    }

    public static class LinkKey
    implements WritableComparable<LinkKey> {
        private Long chainId;
        private Long order;

        public Long getOrder() {
            return this.order;
        }

        public Long getChainId() {
            return this.chainId;
        }

        public LinkKey() {
        }

        public LinkKey(long chainId, long order) {
            this.chainId = chainId;
            this.order = order;
        }

        public int compareTo(LinkKey linkKey) {
            int res = this.getChainId().compareTo(linkKey.getChainId());
            if (res == 0) {
                res = this.getOrder().compareTo(linkKey.getOrder());
            }
            return res;
        }

        public void write(DataOutput dataOutput) throws IOException {
            WritableUtils.writeVLong((DataOutput)dataOutput, (long)this.chainId);
            WritableUtils.writeVLong((DataOutput)dataOutput, (long)this.order);
        }

        public void readFields(DataInput dataInput) throws IOException {
            this.chainId = WritableUtils.readVLong((DataInput)dataInput);
            this.order = WritableUtils.readVLong((DataInput)dataInput);
        }
    }

    public static class LinkedListCreationMapper
    extends Mapper<LongWritable, LongWritable, ImmutableBytesWritable, KeyValue> {
        protected void map(LongWritable key, LongWritable value, Mapper.Context context) throws IOException, InterruptedException {
            long chainId = value.get();
            LOG.info("Starting mapper with chainId:" + chainId);
            byte[] chainIdArray = Bytes.toBytes((long)chainId);
            long currentRow = 0L;
            long chainLength = context.getConfiguration().getLong(CHAIN_LENGTH_KEY, (long)CHAIN_LENGTH);
            long nextRow = this.getNextRow(0L, chainLength);
            byte[] valueBytes = new byte[50];
            for (long i = 0L; i < chainLength; ++i) {
                byte[] rk = Bytes.toBytes((long)currentRow);
                KeyValue linkKv = new KeyValue(rk, CHAIN_FAM, chainIdArray, Bytes.toBytes((long)nextRow));
                KeyValue sortKv = new KeyValue(rk, SORT_FAM, chainIdArray, Bytes.toBytes((long)i));
                Bytes.random((byte[])valueBytes);
                KeyValue dataKv = new KeyValue(rk, DATA_FAM, chainIdArray, valueBytes);
                context.write((Object)new ImmutableBytesWritable(rk), (Object)linkKv);
                context.write((Object)new ImmutableBytesWritable(rk), (Object)sortKv);
                context.write((Object)new ImmutableBytesWritable(rk), (Object)dataKv);
                currentRow = nextRow;
                nextRow = this.getNextRow(i + 1L, chainLength);
            }
        }

        private long getNextRow(long index, long chainLength) {
            long nextRow = ThreadLocalRandom.current().nextLong(Long.MAX_VALUE);
            nextRow = nextRow - nextRow % chainLength + index;
            return nextRow;
        }
    }

    public static class ITBulkLoadInputFormat
    extends InputFormat<LongWritable, LongWritable> {
        public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
            int numSplits = context.getConfiguration().getInt(NUM_MAPS_KEY, NUM_MAPS);
            ArrayList<InputSplit> ret = new ArrayList<InputSplit>(numSplits);
            for (int i = 0; i < numSplits; ++i) {
                ret.add(new EmptySplit());
            }
            return ret;
        }

        public RecordReader<LongWritable, LongWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            int taskId = context.getTaskAttemptID().getTaskID().getId();
            int numMapTasks = context.getConfiguration().getInt(NUM_MAPS_KEY, NUM_MAPS);
            int numIterations = context.getConfiguration().getInt(NUM_IMPORT_ROUNDS_KEY, NUM_IMPORT_ROUNDS);
            int iteration = context.getConfiguration().getInt(ROUND_NUM_KEY, 0);
            taskId += iteration * numMapTasks;
            long chainId = ThreadLocalRandom.current().nextLong(Long.MAX_VALUE);
            chainId = chainId - chainId % (long)(numMapTasks *= numIterations) + (long)taskId;
            LongWritable[] keys = new LongWritable[]{new LongWritable(chainId)};
            return new FixedRecordReader<LongWritable, LongWritable>(keys, keys);
        }
    }

    public static class FixedRecordReader<K, V>
    extends RecordReader<K, V> {
        private int index = -1;
        private K[] keys;
        private V[] values;

        public FixedRecordReader(K[] keys, V[] values) {
            this.keys = keys;
            this.values = values;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return ++this.index < this.keys.length;
        }

        public K getCurrentKey() throws IOException, InterruptedException {
            return this.keys[this.index];
        }

        public V getCurrentValue() throws IOException, InterruptedException {
            return this.values[this.index];
        }

        public float getProgress() throws IOException, InterruptedException {
            return (float)this.index / (float)this.keys.length;
        }

        public void close() throws IOException {
        }
    }

    public static class EmptySplit
    extends InputSplit
    implements Writable {
        public void write(DataOutput out) throws IOException {
        }

        public void readFields(DataInput in) throws IOException {
        }

        public long getLength() {
            return 0L;
        }

        public String[] getLocations() {
            return new String[0];
        }
    }

    public static class SlowMeCoproScanOperations
    implements RegionCoprocessor,
    RegionObserver {
        static final AtomicLong sleepTime = new AtomicLong(2000L);
        AtomicLong countOfNext = new AtomicLong(0L);
        AtomicLong countOfOpen = new AtomicLong(0L);

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan) throws IOException {
            if (this.countOfOpen.incrementAndGet() == 2L) {
                this.slowdownCode(e);
            }
        }

        public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
            this.countOfNext.incrementAndGet();
            if (this.countOfNext.get() == 0L || this.countOfNext.get() == 4L) {
                this.slowdownCode(e);
            }
            return true;
        }

        protected void slowdownCode(ObserverContext<RegionCoprocessorEnvironment> e) {
            if (((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getReplicaId() == 0) {
                try {
                    if (sleepTime.get() > 0L) {
                        LOG.info("Sleeping for " + sleepTime.get() + " ms");
                        Thread.sleep(sleepTime.get());
                    }
                }
                catch (InterruptedException e1) {
                    LOG.error(e1.toString(), (Throwable)e1);
                }
            }
        }
    }
}

