/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeVersionsAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeVersionsAction.class);
    private final TableName tableName;

    public ChangeVersionsAction(TableName tableName) {
        this.tableName = tableName;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws IOException {
        int versions = ThreadLocalRandom.current().nextInt(3) + 1;
        this.getLogger().debug("Performing action: Changing versions on " + this.tableName + " to " + versions);
        this.modifyAllTableColumns(this.tableName, (ColumnFamilyDescriptorBuilder columnBuilder) -> columnBuilder.setMinVersions(versions).setMaxVersions(versions));
        this.getLogger().debug("Performing action: Just changed versions on " + this.tableName);
    }
}

