/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.MockHttpApiRule;
import org.apache.hadoop.hbase.RESTApiClusterManager;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SmallTests.class})
public class TestRESTApiClusterManager {
    @ClassRule
    public static final HBaseClassTestRule testRule = HBaseClassTestRule.forClass(TestRESTApiClusterManager.class);
    @ClassRule
    public static MockHttpApiRule mockHttpApi = new MockHttpApiRule();
    @Rule
    public final TestName testName = new TestName();
    private static HBaseCommonTestingUtility testingUtility;
    private ClusterManager clusterManager;

    @BeforeClass
    public static void beforeClass() {
        testingUtility = new HBaseCommonTestingUtility();
        TestRESTApiClusterManager.configureClusterManager(testingUtility.getConfiguration());
    }

    @Before
    public void before() {
        mockHttpApi.clearRegistrations();
        Configuration methodConf = new Configuration(testingUtility.getConfiguration());
        methodConf.set("hbase.it.clustermanager.restapi.clustername", this.testName.getMethodName());
        this.clusterManager = new RESTApiClusterManager();
        this.clusterManager.setConf(methodConf);
    }

    @Test
    public void isRunningPositive() throws IOException {
        String clusterName = this.testName.getMethodName();
        String hostName = "somehost";
        String serviceName = "hbase";
        String hostId = "some-id";
        TestRESTApiClusterManager.registerServiceName(clusterName, RESTApiClusterManager.Service.HBASE, "hbase");
        TestRESTApiClusterManager.registerHost("somehost", "some-id");
        HashMap<String, String> hostProperties = new HashMap<String, String>();
        hostProperties.put("roleState", "STARTED");
        hostProperties.put("healthSummary", "GOOD");
        TestRESTApiClusterManager.registerHostProperties(clusterName, "hbase", "some-id", ClusterManager.ServiceType.HBASE_MASTER, hostProperties);
        Assert.assertTrue((boolean)this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_MASTER, "somehost", -1));
    }

    private static void configureClusterManager(Configuration conf) {
        conf.set("hbase.it.clustermanager.restapi.hostname", mockHttpApi.getURI().toString());
    }

    private static void registerServiceName(String clusterName, RESTApiClusterManager.Service service, String serviceName) {
        String target = String.format("^/api/v6/clusters/%s/services", clusterName);
        String response = String.format("{ \"items\": [ { \"type\": \"%s\", \"name\": \"%s\" } ] }", new Object[]{service, serviceName});
        mockHttpApi.registerOk(target, response);
    }

    private static void registerHost(String hostName, String hostId) {
        String target = "^/api/v6/hosts";
        String response = String.format("{ \"items\": [ { \"hostname\": \"%s\", \"hostId\": \"%s\" } ] }", hostName, hostId);
        mockHttpApi.registerOk("^/api/v6/hosts", response);
    }

    private static void registerHostProperties(String clusterName, String serviceName, String hostId, ClusterManager.ServiceType serviceType, Map<String, String> properties) {
        String target = String.format("^/api/v6/clusters/%s/services/%s/roles", clusterName, serviceName);
        StringBuilder builder = new StringBuilder().append("{ \"items\": [ ").append("{ \"hostRef\": { \"hostId\": \"").append(hostId).append("\" }, \"type\": \"").append((Object)serviceType).append("\"");
        properties.forEach((k, v) -> builder.append(", \"").append((String)k).append("\": \"").append((String)v).append("\""));
        builder.append(" } ] }");
        mockHttpApi.registerOk(target, builder.toString());
    }
}

