/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.AccessControlException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.HSClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.security.authorize.ClientHSPolicyProvider;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.JHSDelegationTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsWebApp;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;

public class HistoryClientService
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(HistoryClientService.class);
    private HSClientProtocol protocolHandler;
    private Server server;
    private WebApp webApp;
    private InetSocketAddress bindAddress;
    private HistoryContext history;
    private JHSDelegationTokenSecretManager jhsDTSecretManager;

    public HistoryClientService(HistoryContext history, JHSDelegationTokenSecretManager jhsDTSecretManager) {
        super("HistoryClientService");
        this.history = history;
        this.protocolHandler = new HSClientProtocolHandler();
        this.jhsDTSecretManager = jhsDTSecretManager;
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.initializeWebApp(conf);
        InetSocketAddress address = conf.getSocketAddr("mapreduce.jobhistory.bind-host", "mapreduce.jobhistory.address", "0.0.0.0:10020", 10020);
        this.server = rpc.getServer(HSClientProtocol.class, (Object)this.protocolHandler, address, conf, (SecretManager)this.jhsDTSecretManager, conf.getInt("mapreduce.jobhistory.client.thread-count", 10));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.server.refreshServiceAcl(conf, (PolicyProvider)new ClientHSPolicyProvider());
        }
        this.server.start();
        this.bindAddress = conf.updateConnectAddr("mapreduce.jobhistory.bind-host", "mapreduce.jobhistory.address", "0.0.0.0:10020", this.server.getListenerAddress());
        LOG.info((Object)("Instantiated HistoryClientService at " + this.bindAddress));
        super.serviceStart();
    }

    @VisibleForTesting
    protected void initializeWebApp(Configuration conf) {
        this.webApp = new HsWebApp(this.history);
        InetSocketAddress bindAddress = MRWebAppUtil.getJHSWebBindAddress((Configuration)conf);
        WebApps.$for((String)"jobhistory", HistoryClientService.class, (Object)((Object)this), (String)"ws").with(conf).withHttpSpnegoKeytabKey("mapreduce.jobhistory.webapp.spnego-keytab-file").withHttpSpnegoPrincipalKey("mapreduce.jobhistory.webapp.spnego-principal").withCSRFProtection("mapreduce.jobhistory.webapp.rest-csrf.").withXFSProtection("mapreduce.jobhistory.webapp.xfs-filter.").at(NetUtils.getHostPortString((InetSocketAddress)bindAddress)).start(this.webApp);
        String connectHost = MRWebAppUtil.getJHSWebappURLWithoutScheme((Configuration)conf).split(":")[0];
        MRWebAppUtil.setJHSWebappURLWithoutScheme((Configuration)conf, (String)(connectHost + ":" + this.webApp.getListenerAddress().getPort()));
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        if (this.webApp != null) {
            this.webApp.stop();
        }
        super.serviceStop();
    }

    @InterfaceAudience.Private
    public MRClientProtocol getClientHandler() {
        return this.protocolHandler;
    }

    @InterfaceAudience.Private
    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    private class HSClientProtocolHandler
    implements HSClientProtocol {
        private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

        private HSClientProtocolHandler() {
        }

        public InetSocketAddress getConnectAddress() {
            return HistoryClientService.this.getBindAddress();
        }

        private Job verifyAndGetJob(final JobId jobID, boolean exceptionThrow) throws IOException {
            UserGroupInformation loginUgi = null;
            Job job = null;
            try {
                loginUgi = UserGroupInformation.getLoginUser();
                job = (Job)loginUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Job>(){

                    @Override
                    public Job run() throws Exception {
                        Job job = HistoryClientService.this.history.getJob(jobID);
                        return job;
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            if (job == null && exceptionThrow) {
                throw new IOException("Unknown Job " + jobID);
            }
            if (job != null) {
                JobACL operation = JobACL.VIEW_JOB;
                this.checkAccess(job, operation);
            }
            return job;
        }

        public GetCountersResponse getCounters(GetCountersRequest request) throws IOException {
            JobId jobId = request.getJobId();
            Job job = this.verifyAndGetJob(jobId, true);
            GetCountersResponse response = (GetCountersResponse)this.recordFactory.newRecordInstance(GetCountersResponse.class);
            response.setCounters(TypeConverter.toYarn((Counters)job.getAllCounters()));
            return response;
        }

        public GetJobReportResponse getJobReport(GetJobReportRequest request) throws IOException {
            JobId jobId = request.getJobId();
            Job job = this.verifyAndGetJob(jobId, false);
            GetJobReportResponse response = (GetJobReportResponse)this.recordFactory.newRecordInstance(GetJobReportResponse.class);
            if (job != null) {
                response.setJobReport(job.getReport());
            } else {
                response.setJobReport(null);
            }
            return response;
        }

        public GetTaskAttemptReportResponse getTaskAttemptReport(GetTaskAttemptReportRequest request) throws IOException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            Job job = this.verifyAndGetJob(taskAttemptId.getTaskId().getJobId(), true);
            GetTaskAttemptReportResponse response = (GetTaskAttemptReportResponse)this.recordFactory.newRecordInstance(GetTaskAttemptReportResponse.class);
            response.setTaskAttemptReport(job.getTask(taskAttemptId.getTaskId()).getAttempt(taskAttemptId).getReport());
            return response;
        }

        public GetTaskReportResponse getTaskReport(GetTaskReportRequest request) throws IOException {
            TaskId taskId = request.getTaskId();
            Job job = this.verifyAndGetJob(taskId.getJobId(), true);
            GetTaskReportResponse response = (GetTaskReportResponse)this.recordFactory.newRecordInstance(GetTaskReportResponse.class);
            response.setTaskReport(job.getTask(taskId).getReport());
            return response;
        }

        public GetTaskAttemptCompletionEventsResponse getTaskAttemptCompletionEvents(GetTaskAttemptCompletionEventsRequest request) throws IOException {
            JobId jobId = request.getJobId();
            int fromEventId = request.getFromEventId();
            int maxEvents = request.getMaxEvents();
            Job job = this.verifyAndGetJob(jobId, true);
            GetTaskAttemptCompletionEventsResponse response = (GetTaskAttemptCompletionEventsResponse)this.recordFactory.newRecordInstance(GetTaskAttemptCompletionEventsResponse.class);
            response.addAllCompletionEvents(Arrays.asList(job.getTaskAttemptCompletionEvents(fromEventId, maxEvents)));
            return response;
        }

        public KillJobResponse killJob(KillJobRequest request) throws IOException {
            throw new IOException("Invalid operation on completed job");
        }

        public KillTaskResponse killTask(KillTaskRequest request) throws IOException {
            throw new IOException("Invalid operation on completed job");
        }

        public KillTaskAttemptResponse killTaskAttempt(KillTaskAttemptRequest request) throws IOException {
            throw new IOException("Invalid operation on completed job");
        }

        public GetDiagnosticsResponse getDiagnostics(GetDiagnosticsRequest request) throws IOException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            Job job = this.verifyAndGetJob(taskAttemptId.getTaskId().getJobId(), true);
            GetDiagnosticsResponse response = (GetDiagnosticsResponse)this.recordFactory.newRecordInstance(GetDiagnosticsResponse.class);
            response.addAllDiagnostics(job.getTask(taskAttemptId.getTaskId()).getAttempt(taskAttemptId).getDiagnostics());
            return response;
        }

        public FailTaskAttemptResponse failTaskAttempt(FailTaskAttemptRequest request) throws IOException {
            throw new IOException("Invalid operation on completed job");
        }

        public GetTaskReportsResponse getTaskReports(GetTaskReportsRequest request) throws IOException {
            JobId jobId = request.getJobId();
            TaskType taskType = request.getTaskType();
            GetTaskReportsResponse response = (GetTaskReportsResponse)this.recordFactory.newRecordInstance(GetTaskReportsResponse.class);
            Job job = this.verifyAndGetJob(jobId, true);
            Collection tasks = job.getTasks(taskType).values();
            for (Task task : tasks) {
                response.addTaskReport(task.getReport());
            }
            return response;
        }

        public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws IOException {
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be issued only with kerberos authentication");
            }
            GetDelegationTokenResponse response = (GetDelegationTokenResponse)this.recordFactory.newRecordInstance(GetDelegationTokenResponse.class);
            String user = ugi.getUserName();
            Text owner = new Text(user);
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            MRDelegationTokenIdentifier tokenIdentifier = new MRDelegationTokenIdentifier(owner, new Text(request.getRenewer()), realUser);
            Token realJHSToken = new Token((TokenIdentifier)tokenIdentifier, (SecretManager)HistoryClientService.this.jhsDTSecretManager);
            org.apache.hadoop.yarn.api.records.Token mrDToken = org.apache.hadoop.yarn.api.records.Token.newInstance((byte[])realJHSToken.getIdentifier(), (String)realJHSToken.getKind().toString(), (byte[])realJHSToken.getPassword(), (String)realJHSToken.getService().toString());
            response.setDelegationToken(mrDToken);
            return response;
        }

        public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws IOException {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be renewed only with kerberos authentication");
            }
            org.apache.hadoop.yarn.api.records.Token protoToken = request.getDelegationToken();
            Token token = new Token(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
            String user = UserGroupInformation.getCurrentUser().getShortUserName();
            long nextExpTime = HistoryClientService.this.jhsDTSecretManager.renewToken(token, user);
            RenewDelegationTokenResponse renewResponse = (RenewDelegationTokenResponse)Records.newRecord(RenewDelegationTokenResponse.class);
            renewResponse.setNextExpirationTime(nextExpTime);
            return renewResponse;
        }

        public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws IOException {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be cancelled only with kerberos authentication");
            }
            org.apache.hadoop.yarn.api.records.Token protoToken = request.getDelegationToken();
            Token token = new Token(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
            String user = UserGroupInformation.getCurrentUser().getUserName();
            HistoryClientService.this.jhsDTSecretManager.cancelToken(token, user);
            return (CancelDelegationTokenResponse)Records.newRecord(CancelDelegationTokenResponse.class);
        }

        private void checkAccess(Job job, JobACL jobOperation) throws IOException {
            UserGroupInformation callerUGI = UserGroupInformation.getCurrentUser();
            if (!job.checkAccess(callerUGI, jobOperation)) {
                throw new IOException(new AccessControlException("User " + callerUGI.getShortUserName() + " cannot perform operation " + jobOperation.name() + " on " + job.getID()));
            }
        }

        private boolean isAllowedDelegationTokenOp() throws IOException {
            if (UserGroupInformation.isSecurityEnabled()) {
                return EnumSet.of(UserGroupInformation.AuthenticationMethod.KERBEROS, UserGroupInformation.AuthenticationMethod.KERBEROS_SSL, UserGroupInformation.AuthenticationMethod.CERTIFICATE).contains(UserGroupInformation.getCurrentUser().getRealAuthenticationMethod());
            }
            return true;
        }
    }
}

