/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.wal.WALHeaderEOFException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALStreamReader;
import org.apache.hadoop.hbase.wal.WALTailingReader;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestParsePartialWALFile {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestParsePartialWALFile.class);
    private static final HBaseCommonTestingUtility UTIL = new HBaseCommonTestingUtility();
    private static FileSystem FS;
    private static TableName TN;
    private static RegionInfo RI;
    private static byte[] ROW;
    private static byte[] FAMILY;
    private static byte[] QUAL;
    private static byte[] VALUE;

    @BeforeClass
    public static void setUp() throws IOException {
        UTIL.getConfiguration().setBoolean("hbase.unsafe.stream.capability.enforce", false);
        FS = FileSystem.getLocal((Configuration)UTIL.getConfiguration());
        if (!FS.mkdirs(UTIL.getDataTestDir())) {
            throw new IOException("can not create " + UTIL.getDataTestDir());
        }
    }

    @AfterClass
    public static void tearDown() {
        UTIL.cleanupTestDir();
    }

    private Path generateBrokenWALFile(byte[] content, int length) throws IOException {
        Path walFile = UTIL.getDataTestDir("wal-" + length);
        try (FSDataOutputStream out = FS.create(walFile);){
            out.write(content, 0, length);
        }
        return walFile;
    }

    private void assertEntryEquals(WAL.Entry entry, int index) {
        WALKeyImpl key = entry.getKey();
        Assert.assertEquals((Object)TN, (Object)key.getTableName());
        Assert.assertArrayEquals((byte[])RI.getEncodedNameAsBytes(), (byte[])key.getEncodedRegionName());
        WALEdit edit = entry.getEdit();
        Assert.assertEquals((long)1L, (long)edit.getCells().size());
        Cell cell = (Cell)edit.getCells().get(0);
        Assert.assertArrayEquals((byte[])ROW, (byte[])CellUtil.cloneRow((Cell)cell));
        Assert.assertArrayEquals((byte[])FAMILY, (byte[])CellUtil.cloneFamily((Cell)cell));
        if (index % 2 == 0) {
            Assert.assertEquals((Object)Cell.Type.Put, (Object)cell.getType());
            Assert.assertArrayEquals((byte[])QUAL, (byte[])CellUtil.cloneQualifier((Cell)cell));
            Assert.assertArrayEquals((byte[])VALUE, (byte[])CellUtil.cloneValue((Cell)cell));
        } else {
            Assert.assertEquals((Object)Cell.Type.DeleteFamily, (Object)cell.getType());
        }
    }

    private void testReadEntry(Path file, int entryCount) throws IOException {
        int i;
        try (WALStreamReader reader = WALFactory.createStreamReader((FileSystem)FS, (Path)file, (Configuration)UTIL.getConfiguration());){
            for (i = 0; i < entryCount; ++i) {
                this.assertEntryEquals(reader.next(), i);
            }
            Assert.assertThrows(EOFException.class, () -> reader.next());
        }
        reader = WALFactory.createTailingReader((FileSystem)FS, (Path)file, (Configuration)UTIL.getConfiguration(), (long)-1L);
        var4_4 = null;
        try {
            for (i = 0; i < entryCount; ++i) {
                WALTailingReader.Result result = reader.next(-1L);
                Assert.assertEquals((Object)WALTailingReader.State.NORMAL, (Object)result.getState());
                this.assertEntryEquals(result.getEntry(), i);
            }
            WALTailingReader.Result result = reader.next(-1L);
            Assert.assertEquals((Object)WALTailingReader.State.EOF_AND_RESET, (Object)result.getState());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (var4_4 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
    }

    @Test
    public void testPartialParse() throws Exception {
        Object edit;
        long headerLength;
        Path walFile = UTIL.getDataTestDir("wal");
        ArrayList<Long> endOffsets = new ArrayList<Long>();
        try (WALProvider.Writer writer = WALFactory.createWALWriter((FileSystem)FS, (Path)walFile, (Configuration)UTIL.getConfiguration());){
            headerLength = writer.getLength();
            for (int i = 0; i < 3; ++i) {
                WALKeyImpl key = new WALKeyImpl(RI.getEncodedNameAsBytes(), TN, (long)i, EnvironmentEdgeManager.currentTime(), HConstants.DEFAULT_CLUSTER_ID);
                edit = new WALEdit();
                if (i % 2 == 0) {
                    edit.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.Put).setRow(ROW).setFamily(FAMILY).setQualifier(QUAL).setValue(VALUE).build());
                } else {
                    edit.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.DeleteFamily).setRow(ROW).setFamily(FAMILY).build());
                }
                writer.append(new WAL.Entry(key, (WALEdit)edit));
                writer.sync(true);
                endOffsets.add(writer.getLength());
            }
        }
        long fileLength = FS.getFileStatus(walFile).getLen();
        byte[] content = new byte[(int)fileLength];
        FSDataInputStream in = FS.open(walFile);
        edit = null;
        try {
            in.readFully(content);
        }
        catch (Throwable throwable) {
            edit = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (edit != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)edit).addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        int i = 0;
        while ((long)i < headerLength) {
            Path brokenFile = this.generateBrokenWALFile(content, i);
            Assert.assertThrows(WALHeaderEOFException.class, () -> WALFactory.createStreamReader((FileSystem)FS, (Path)brokenFile, (Configuration)UTIL.getConfiguration()));
            Assert.assertThrows(WALHeaderEOFException.class, () -> WALFactory.createTailingReader((FileSystem)FS, (Path)brokenFile, (Configuration)UTIL.getConfiguration(), (long)-1L));
            FS.delete(brokenFile, false);
            ++i;
        }
        for (i = 0; i <= endOffsets.size(); ++i) {
            int endOffset;
            int startOffset;
            if (i == 0) {
                startOffset = (int)headerLength;
                endOffset = ((Long)endOffsets.get(i)).intValue();
            } else if (i == endOffsets.size()) {
                startOffset = ((Long)endOffsets.get(i - 1)).intValue();
                endOffset = (int)fileLength;
            } else {
                startOffset = ((Long)endOffsets.get(i - 1)).intValue();
                endOffset = ((Long)endOffsets.get(i)).intValue();
            }
            for (int j = startOffset; j < endOffset; ++j) {
                Path brokenFile = this.generateBrokenWALFile(content, j);
                this.testReadEntry(brokenFile, i);
                FS.delete(brokenFile, false);
            }
        }
        i = ((Long)endOffsets.get(endOffsets.size() - 1)).intValue();
        while ((long)i < fileLength) {
            Path brokenFile = this.generateBrokenWALFile(content, i);
            this.testReadEntry(brokenFile, endOffsets.size());
            FS.delete(brokenFile, false);
            ++i;
        }
    }

    static {
        TN = TableName.valueOf((String)"test");
        RI = RegionInfoBuilder.newBuilder((TableName)TN).build();
        ROW = Bytes.toBytes((String)"row");
        FAMILY = Bytes.toBytes((String)"family");
        QUAL = Bytes.toBytes((String)"qualifier");
        VALUE = Bytes.toBytes((String)"value");
    }
}

