/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.Future;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={ClientTests.class, MediumTests.class})
public class TestAsyncAdminClearMasterStubCache
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncAdminClearMasterStubCache.class);

    @Before
    public void waitMasterReady() throws Exception {
        Assert.assertTrue((boolean)TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster(30000L));
    }

    @After
    public void clearPortConfig() {
        TEST_UTIL.getHBaseCluster().getConf().setInt("hbase.master.port", 0);
    }

    @Test
    public void testClearMasterStubCache() throws Exception {
        Assert.assertNotNull((Object)FutureUtils.get((Future)this.admin.getClusterMetrics()));
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        JVMClusterUtil.MasterThread mt = cluster.getMasterThread();
        ServerName sn = mt.getMaster().getServerName();
        mt.getMaster().abort("for testing");
        mt.join();
        Assert.assertTrue((boolean)TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster(30000L));
        cluster.getConf().setInt("hbase.master.port", sn.getPort());
        cluster.startMaster();
        TEST_UTIL.waitFor(30000L, () -> {
            try (Socket socket = new Socket(sn.getHostname(), sn.getPort());){
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                return false;
            }
        });
        Assert.assertNotNull((Object)FutureUtils.get((Future)this.admin.getClusterMetrics()));
    }
}

