/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.agrona.generation;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.shaded.org.agrona.generation.OutputManager;

public class StringWriterOutputManager
implements OutputManager {
    private String packageName;
    private final HashMap<String, StringWriter> sourceFileByName = new HashMap();

    @Override
    public Writer createOutput(String name) {
        StringWriter stringWriter = new StringWriter();
        this.sourceFileByName.put(this.packageName + "." + name, stringWriter);
        return stringWriter;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public CharSequence getSource(String name) {
        StringWriter stringWriter = this.sourceFileByName.get(name);
        if (null == stringWriter) {
            throw new IllegalArgumentException("unknown source file name: " + name);
        }
        return stringWriter.toString();
    }

    public Map<String, CharSequence> getSources() {
        HashMap<String, CharSequence> sources = new HashMap<String, CharSequence>();
        for (Map.Entry<String, StringWriter> entry : this.sourceFileByName.entrySet()) {
            sources.put(entry.getKey(), entry.getValue().toString());
        }
        return sources;
    }

    public void clear() {
        this.packageName = "";
        this.sourceFileByName.clear();
    }
}

