/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.KeyException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.regionserver.wal.AsyncProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.SecureWALCellCodec;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.regionserver.wal.WALHeaderEOFException;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EncryptionTest;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractProtobufWALReader
implements AbstractFSWALProvider.Initializer,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProtobufWALReader.class);
    public static final byte[] PB_WAL_MAGIC = Bytes.toBytes("PWAL");
    public static final byte[] PB_WAL_COMPLETE_MAGIC = Bytes.toBytes("LAWP");
    static final String WAL_TRAILER_WARN_SIZE = "hbase.regionserver.waltrailer.warn.size";
    static final int DEFAULT_WAL_TRAILER_WARN_SIZE = 0x100000;
    private static final List<String> WRITER_CLS_NAMES = ImmutableList.of(ProtobufLogWriter.class.getSimpleName(), AsyncProtobufLogWriter.class.getSimpleName(), "SecureProtobufLogWriter", "SecureAsyncProtobufLogWriter");
    protected Configuration conf;
    protected FileSystem fs;
    protected Path path;
    protected long fileLength;
    protected FSDataInputStream inputStream;
    protected CompressionContext compressionCtx;
    protected boolean hasCompression = false;
    protected boolean hasTagCompression = false;
    protected boolean hasValueCompression = false;
    protected Compression.Algorithm valueCompressionType;
    protected Codec.Decoder cellDecoder;
    protected WALCellCodec.ByteStringUncompressor byteStringUncompressor;
    protected long walEditsStopOffset;
    protected boolean trailerPresent;
    protected WALProtos.WALTrailer trailer;
    protected int trailerWarnSize;
    protected String codecClsName;
    protected Decryptor decryptor;

    protected abstract InputStream getCellCodecInputStream(FSDataInputStream var1);

    protected abstract void skipTo(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(FileSystem fs, Path path, Configuration conf, long startPosition) throws IOException {
        this.conf = conf;
        this.path = path;
        this.fs = fs;
        this.trailerWarnSize = conf.getInt(WAL_TRAILER_WARN_SIZE, 0x100000);
        Pair<FSDataInputStream, FileStatus> pair = this.open();
        FSDataInputStream stream = pair.getFirst();
        FileStatus stat = pair.getSecond();
        boolean initSucceeded = false;
        try {
            WALProtos.WALHeader header = this.readHeader(stream);
            this.initDecryptor(header);
            this.initCompression(header);
            this.initWALCellCodec(header, this.getCellCodecInputStream(stream));
            this.readTrailer(stream, stat);
            this.inputStream = stream;
            if (startPosition >= 0L && startPosition != this.inputStream.getPos()) {
                if (this.compressionCtx != null) {
                    this.skipTo(startPosition);
                } else {
                    stream.seek(startPosition);
                }
            }
            initSucceeded = true;
        }
        finally {
            if (!initSucceeded) {
                Closeables.close((Closeable)stream, initSucceeded);
                this.inputStream = null;
            }
        }
    }

    private Pair<FSDataInputStream, FileStatus> openArchivedWAL() throws IOException {
        Path archivedWAL = AbstractFSWALProvider.findArchivedLog(this.path, this.conf);
        if (archivedWAL != null) {
            return Pair.newPair(this.fs.open(archivedWAL), this.fs.getFileStatus(archivedWAL));
        }
        return null;
    }

    protected final Pair<FSDataInputStream, FileStatus> open() throws IOException {
        try {
            return Pair.newPair(this.fs.open(this.path), this.fs.getFileStatus(this.path));
        }
        catch (FileNotFoundException e) {
            Pair<FSDataInputStream, FileStatus> pair = this.openArchivedWAL();
            if (pair != null) {
                return pair;
            }
            throw e;
        }
        catch (RemoteException re) {
            IOException ioe = re.unwrapRemoteException(new Class[]{FileNotFoundException.class});
            if (!(ioe instanceof FileNotFoundException)) {
                throw ioe;
            }
            Pair<FSDataInputStream, FileStatus> pair = this.openArchivedWAL();
            if (pair != null) {
                return pair;
            }
            throw ioe;
        }
    }

    protected final WALProtos.WALHeader readHeader(FSDataInputStream stream) throws IOException {
        WALProtos.WALHeader header;
        byte[] magic = new byte[PB_WAL_MAGIC.length];
        try {
            stream.readFully(magic);
        }
        catch (EOFException e) {
            throw new WALHeaderEOFException("EOF while reading PB WAL magic", e);
        }
        if (!Arrays.equals(PB_WAL_MAGIC, magic)) {
            throw new IOException("Invalid PB WAL magic " + Bytes.toStringBinary(magic) + ", expected " + Bytes.toStringBinary(PB_WAL_MAGIC));
        }
        try {
            header = ProtobufUtil.parseDelimitedFrom((InputStream)stream, WALProtos.WALHeader.parser());
        }
        catch (InvalidProtocolBufferException e) {
            if (ProtobufUtil.isEOF(e)) {
                throw new WALHeaderEOFException("EOF while reading PB header", e);
            }
            throw e;
        }
        catch (EOFException e) {
            throw new WALHeaderEOFException("EOF while reading PB header", e);
        }
        if (header == null) {
            throw new WALHeaderEOFException("EOF while reading PB header");
        }
        if (header.hasWriterClsName() && !this.getWriterClsNames().contains(header.getWriterClsName())) {
            throw new IOException("Got unknown writer class: " + header.getWriterClsName());
        }
        return header;
    }

    private void initDecryptor(WALProtos.WALHeader header) throws IOException {
        Cipher cipher;
        if (!header.hasEncryptionKey()) {
            return;
        }
        EncryptionTest.testKeyProvider(this.conf);
        EncryptionTest.testCipherProvider(this.conf);
        byte[] keyBytes = header.getEncryptionKey().toByteArray();
        Key key = null;
        String walKeyName = this.conf.get("hbase.crypto.wal.key.name");
        if (walKeyName != null) {
            try {
                key = EncryptionUtil.unwrapWALKey(this.conf, walKeyName, keyBytes);
            }
            catch (KeyException e) {
                LOG.debug("Unable to unwrap key with WAL key '{}'", (Object)walKeyName, (Object)e);
                key = null;
            }
        }
        if (key == null) {
            String masterKeyName = this.conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName());
            try {
                key = EncryptionUtil.unwrapWALKey(this.conf, masterKeyName, keyBytes);
            }
            catch (KeyException e) {
                LOG.debug("Unable to unwrap key with current master key '{}'", (Object)masterKeyName, (Object)e);
                String alternateKeyName = this.conf.get("hbase.crypto.master.alternate.key.name");
                if (alternateKeyName != null) {
                    try {
                        key = EncryptionUtil.unwrapWALKey(this.conf, alternateKeyName, keyBytes);
                    }
                    catch (KeyException ex) {
                        throw new IOException(ex);
                    }
                }
                throw new IOException(e);
            }
        }
        if ((cipher = Encryption.getCipher(this.conf, key.getAlgorithm())) == null) {
            throw new IOException("Cipher '" + key.getAlgorithm() + "' is not available");
        }
        this.decryptor = cipher.getDecryptor();
        this.decryptor.setKey(key);
        LOG.debug("Initialized secure protobuf WAL: cipher={}", (Object)cipher.getName());
    }

    private void initCompression(WALProtos.WALHeader header) throws IOException {
        boolean bl = this.hasCompression = header.hasHasCompression() && header.getHasCompression();
        if (!this.hasCompression) {
            return;
        }
        this.hasTagCompression = header.hasHasTagCompression() && header.getHasTagCompression();
        boolean bl2 = this.hasValueCompression = header.hasHasValueCompression() && header.getHasValueCompression();
        if (header.hasValueCompressionAlgorithm()) {
            try {
                this.valueCompressionType = Compression.Algorithm.values()[header.getValueCompressionAlgorithm()];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Invalid compression type", e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing compression context for {}: isRecoveredEdits={}, hasTagCompression={}, hasValueCompression={}, valueCompressionType={}", new Object[]{this.path, CommonFSUtils.isRecoveredEdits(this.path), this.hasTagCompression, this.hasValueCompression, this.valueCompressionType});
        }
        try {
            this.compressionCtx = new CompressionContext(LRUDictionary.class, CommonFSUtils.isRecoveredEdits(this.path), this.hasTagCompression, this.hasValueCompression, this.valueCompressionType);
        }
        catch (Exception e) {
            throw new IOException("Failed to initialize CompressionContext", e);
        }
    }

    private WALCellCodec getCodec(Configuration conf, String cellCodecClsName, CompressionContext compressionContext) throws IOException {
        return WALCellCodec.create(conf, cellCodecClsName, compressionContext);
    }

    protected final void initWALCellCodec(WALProtos.WALHeader header, InputStream inputStream) throws IOException {
        String cellCodecClsName;
        String string = cellCodecClsName = header.hasCellCodecClsName() ? header.getCellCodecClsName() : null;
        if (this.decryptor != null && SecureWALCellCodec.class.getName().equals(cellCodecClsName)) {
            WALCellCodec codec = SecureWALCellCodec.getCodec(this.conf, this.decryptor);
            this.cellDecoder = codec.getDecoder(inputStream);
            this.compressionCtx = null;
            this.byteStringUncompressor = WALCellCodec.getNoneUncompressor();
            this.hasCompression = false;
            this.hasTagCompression = false;
            this.hasValueCompression = false;
        } else {
            WALCellCodec codec = this.getCodec(this.conf, cellCodecClsName, this.compressionCtx);
            this.cellDecoder = codec.getDecoder(inputStream);
            this.byteStringUncompressor = this.hasCompression ? codec.getByteStringUncompressor() : WALCellCodec.getNoneUncompressor();
        }
        this.codecClsName = cellCodecClsName;
    }

    protected final void readTrailer(FSDataInputStream stream, FileStatus stat) throws IOException {
        this.walEditsStopOffset = this.fileLength = stat.getLen();
        long currentPos = stream.getPos();
        this.trailerPresent = this.setTrailerIfPresent(stream);
        if (currentPos != stream.getPos()) {
            stream.seek(currentPos);
        }
    }

    private boolean setTrailerIfPresent(FSDataInputStream stream) throws IOException {
        try {
            long trailerSizeOffset = this.fileLength - (long)(PB_WAL_COMPLETE_MAGIC.length + 4);
            if (trailerSizeOffset <= 0L) {
                return false;
            }
            stream.seek(trailerSizeOffset);
            int trailerSize = stream.readInt();
            ByteBuffer buf = ByteBuffer.allocate(PB_WAL_COMPLETE_MAGIC.length);
            stream.readFully(buf.array(), buf.arrayOffset(), buf.capacity());
            if (!Arrays.equals(buf.array(), PB_WAL_COMPLETE_MAGIC)) {
                LOG.trace("No trailer found.");
                return false;
            }
            if (trailerSize < 0) {
                LOG.warn("Invalid trailer Size " + trailerSize + ", ignoring the trailer");
                return false;
            }
            if (trailerSize > this.trailerWarnSize) {
                LOG.warn("Please investigate WALTrailer usage. Trailer size > maximum configured size : " + trailerSize + " > " + this.trailerWarnSize);
            }
            long positionOfTrailer = trailerSizeOffset - (long)trailerSize;
            stream.seek(positionOfTrailer);
            buf = ByteBuffer.allocate(trailerSize);
            stream.readFully(buf.array(), buf.arrayOffset(), buf.capacity());
            this.trailer = WALProtos.WALTrailer.parseFrom(buf.array());
            this.walEditsStopOffset = positionOfTrailer;
            return true;
        }
        catch (IOException ioe) {
            LOG.warn("Got IOE while reading the trailer. Continuing as if no trailer is present.", (Throwable)ioe);
            return false;
        }
    }

    protected final boolean reachWALEditsStopOffset(long pos) {
        if (this.trailerPresent && pos > 0L && pos == this.walEditsStopOffset) {
            LOG.trace("Reached end of expected edits area at offset {}", (Object)pos);
            return true;
        }
        return false;
    }

    public List<String> getWriterClsNames() {
        return WRITER_CLS_NAMES;
    }

    public String getCodecClsName() {
        return this.codecClsName;
    }

    public long getPosition() throws IOException {
        return this.inputStream != null ? this.inputStream.getPos() : -1L;
    }

    public long trailerSize() {
        if (this.trailerPresent) {
            long expectedSize = this.fileLength - this.walEditsStopOffset;
            long calculatedSize = (long)PB_WAL_COMPLETE_MAGIC.length + 4L + (long)this.trailer.getSerializedSize();
            if (expectedSize != calculatedSize) {
                LOG.warn("After parsing the trailer, we expect the total footer to be {} bytes, but we calculate it as being {}", (Object)expectedSize, (Object)calculatedSize);
            }
            return expectedSize;
        }
        return -1L;
    }

    protected final String getPositionQuietly() {
        try {
            long pos = this.getPosition();
            return pos >= 0L ? Long.toString(pos) : "<unknown>";
        }
        catch (Exception e) {
            LOG.warn("failed to get position, ignoring", (Throwable)e);
            return "<unknown>";
        }
    }

    protected final IOException extractHiddenEof(Exception ex) {
        IOException ioEx = null;
        if (ex instanceof EOFException) {
            return (EOFException)ex;
        }
        if (ex instanceof IOException) {
            ioEx = (IOException)ex;
        } else if (ex instanceof RuntimeException && ex.getCause() != null && ex.getCause() instanceof IOException) {
            ioEx = (IOException)ex.getCause();
        }
        if (ioEx != null && ioEx.getMessage() != null) {
            if (ioEx.getMessage().contains("EOF")) {
                return ioEx;
            }
            return null;
        }
        return null;
    }

    protected final boolean isWALTrailer(long startPosition) throws IOException {
        int r;
        int i;
        int trailerSize = PB_WAL_COMPLETE_MAGIC.length + 4;
        if (this.fileLength - startPosition >= (long)trailerSize) {
            return false;
        }
        this.inputStream.seek(startPosition);
        for (i = 0; i < 4; ++i) {
            r = this.inputStream.read();
            if (r == -1) {
                return true;
            }
            if (r == 0) continue;
            return false;
        }
        for (i = 0; i < PB_WAL_COMPLETE_MAGIC.length; ++i) {
            r = this.inputStream.read();
            if (r == -1) {
                return true;
            }
            if (r == (PB_WAL_COMPLETE_MAGIC[i] & 0xFF)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        if (this.inputStream != null) {
            IOUtils.closeQuietly((InputStream)this.inputStream);
            this.inputStream = null;
        }
    }
}

