/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.KeyOnlyCellComparable;
import org.apache.hadoop.hbase.util.MapReduceExtendedCell;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class PreSortedCellsReducer
extends Reducer<KeyOnlyCellComparable, Cell, ImmutableBytesWritable, Cell> {
    protected void reduce(KeyOnlyCellComparable key, Iterable<Cell> values, Reducer.Context context) throws IOException, InterruptedException {
        int index = 0;
        for (Cell cell : values) {
            context.write((Object)new ImmutableBytesWritable(CellUtil.cloneRow(key.getCell())), (Object)new MapReduceExtendedCell(cell));
            if (++index % 100 != 0) continue;
            context.setStatus("Wrote " + index + " cells");
        }
    }
}

