/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.log;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.logging.Log4jUtils;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.util.HttpExceptionUtils;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.Tool;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class LogLevel {
    private static final String USAGES = "\nUsage: General options are:\n\t[-getlevel <host:port> <classname> [-protocol (http|https)]\n\t[-setlevel <host:port> <classname> <level> [-protocol (http|https)]";
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    public static final String READONLY_LOGGERS_CONF_KEY = "hbase.ui.logLevels.readonly.loggers";
    private static final String MARKER = "<!-- OUTPUT -->";
    private static final Pattern TAG = Pattern.compile("<[^>]*>");

    public static void main(String[] args) throws Exception {
        CLI cli = new CLI(new Configuration());
        System.exit(cli.run(args));
    }

    private static void printUsage() {
        System.err.println(USAGES);
        System.exit(-1);
    }

    public static boolean isValidProtocol(String protocol) {
        return protocol.equals(PROTOCOL_HTTP) || protocol.equals(PROTOCOL_HTTPS);
    }

    private LogLevel() {
    }

    @InterfaceAudience.Private
    public static class Servlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        static final String FORMS = "<div class='container-fluid content'>\n<div class='row inner_header top_header'>\n<div class='page-header'>\n<h1>Get/Set Log Level</h1>\n</div>\n</div>\n\n<h2>Actions</h2>\n\n<div class='row mb-4'>\n<div class='col'>\n<form class='row g-3 align-items-center justify-content-center'>\n<div class='col-sm-auto'>\n<button type='submit' class='btn btn-primary'>Get Log Level</button>\n</div>\n  <div class='col-sm-auto'>\n<input type='text' name='log' class='form-control' size='50' required='required' placeholder='Log Name (required)'>\n</div>\n  <div class='col-sm-auto'>\n<span>Gets the current log level for the specified log name.</span>\n</div>\n</form>\n</div>\n</div>\n\n<div class='row'>\n<div class='col'>\n\n<form class='row g-3 align-items-center justify-content-center'>\n<div class='col-sm-auto'>\n<button type='submit' class='btn btn-primary'>Set Log Level</button>\n</div>\n<div class='col-sm-auto'>\n<input type='text' name='log' class='form-control mb-2' size='50' required='required' placeholder='Log Name (required)'>\n<input type='text' name='level' class='form-control' size='50' required='required' placeholder='Log Level (required)'>\n</div>\n<div class='col-sm-auto'>\n<span>Sets the specified log level for the specified log name.</span>\n</div>\n</form>\n\n</div>\n</div><hr>\n";

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter out;
            if (!HttpServer.hasAdministratorAccess(this.getServletContext(), request, response)) {
                return;
            }
            Configuration conf = (Configuration)this.getServletContext().getAttribute("hbase.conf");
            if (conf.getBoolean("hbase.master.ui.readonly", false)) {
                this.sendError(response, 403, "Modification of HBase via the UI is disallowed in configuration.");
                return;
            }
            response.setContentType("text/html");
            try {
                String headerPath = "header.jsp?pageTitle=Log Level";
                request.getRequestDispatcher(headerPath).include((ServletRequest)request, (ServletResponse)response);
                out = response.getWriter();
            }
            catch (FileNotFoundException e) {
                out = ServletUtil.initHTML((ServletResponse)response, (String)"Log Level");
            }
            out.println(FORMS);
            String logName = ServletUtil.getParameter((ServletRequest)request, (String)"log");
            String level = ServletUtil.getParameter((ServletRequest)request, (String)"level");
            String[] readOnlyLogLevels = conf.getStrings(LogLevel.READONLY_LOGGERS_CONF_KEY);
            if (logName != null) {
                out.println("<h2>Results</h2>");
                out.println("<!-- OUTPUT -->Submitted Log Name: <b>" + logName + "</b><br />");
                Logger log = LoggerFactory.getLogger((String)logName);
                out.println("<!-- OUTPUT -->Log Class: <b>" + log.getClass().getName() + "</b><br />");
                if (level != null) {
                    if (!this.isLogLevelChangeAllowed(logName, readOnlyLogLevels)) {
                        this.sendError(response, 412, "Modification of logger " + logName + " is disallowed in configuration.");
                        return;
                    }
                    out.println("<!-- OUTPUT -->Submitted Level: <b>" + level + "</b><br />");
                }
                Servlet.process(log, level, out);
            }
            try {
                String footerPath = "footer.jsp";
                out.println("</div>");
                request.getRequestDispatcher(footerPath).include((ServletRequest)request, (ServletResponse)response);
            }
            catch (FileNotFoundException e) {
                out.println(ServletUtil.HTML_TAIL);
            }
            out.close();
        }

        private boolean isLogLevelChangeAllowed(String logger, String[] readOnlyLogLevels) {
            if (readOnlyLogLevels == null) {
                return true;
            }
            for (String readOnlyLogLevel : readOnlyLogLevels) {
                if (!logger.startsWith(readOnlyLogLevel)) continue;
                return false;
            }
            return true;
        }

        private void sendError(HttpServletResponse response, int code, String message) throws IOException {
            response.setStatus(code, message);
            response.sendError(code, message);
        }

        private static void process(Logger logger, String levelName, PrintWriter out) {
            if (levelName != null) {
                try {
                    Log4jUtils.setLogLevel(logger.getName(), levelName);
                    out.println("<!-- OUTPUT --><div class='text-success'>Setting Level to <strong>" + levelName + "</strong> ...<br /></div>");
                }
                catch (IllegalArgumentException e) {
                    out.println("<!-- OUTPUT --><div class='text-danger'>Bad level : <strong>" + levelName + "</strong><br /></div>");
                }
            }
            out.println("<!-- OUTPUT -->Effective level: <b>" + Log4jUtils.getEffectiveLevel(logger.getName()) + "</b><br />");
        }
    }

    static class CLI
    extends Configured
    implements Tool {
        private Operations operation = Operations.UNKNOWN;
        private String protocol;
        private String hostName;
        private String className;
        private String level;

        CLI(Configuration conf) {
            this.setConf(conf);
        }

        public int run(String[] args) throws Exception {
            try {
                this.parseArguments(args);
                this.sendLogLevelRequest();
            }
            catch (HadoopIllegalArgumentException e) {
                LogLevel.printUsage();
            }
            return 0;
        }

        private void sendLogLevelRequest() throws HadoopIllegalArgumentException, Exception {
            switch (this.operation) {
                case GETLEVEL: {
                    this.doGetLevel();
                    break;
                }
                case SETLEVEL: {
                    this.doSetLevel();
                    break;
                }
                default: {
                    throw new HadoopIllegalArgumentException("Expect either -getlevel or -setlevel");
                }
            }
        }

        public void parseArguments(String[] args) throws HadoopIllegalArgumentException {
            if (args.length == 0) {
                throw new HadoopIllegalArgumentException("No arguments specified");
            }
            int nextArgIndex = 0;
            block10: while (nextArgIndex < args.length) {
                switch (args[nextArgIndex]) {
                    case "-getlevel": {
                        nextArgIndex = this.parseGetLevelArgs(args, nextArgIndex);
                        continue block10;
                    }
                    case "-setlevel": {
                        nextArgIndex = this.parseSetLevelArgs(args, nextArgIndex);
                        continue block10;
                    }
                    case "-protocol": {
                        nextArgIndex = this.parseProtocolArgs(args, nextArgIndex);
                        continue block10;
                    }
                }
                throw new HadoopIllegalArgumentException("Unexpected argument " + args[nextArgIndex]);
            }
            if (this.operation == Operations.UNKNOWN) {
                throw new HadoopIllegalArgumentException("Must specify either -getlevel or -setlevel");
            }
            if (this.protocol == null) {
                this.protocol = LogLevel.PROTOCOL_HTTP;
            }
        }

        private int parseGetLevelArgs(String[] args, int index) throws HadoopIllegalArgumentException {
            if (this.operation != Operations.UNKNOWN) {
                throw new HadoopIllegalArgumentException("Redundant -getlevel command");
            }
            if (index + 2 >= args.length) {
                throw new HadoopIllegalArgumentException("-getlevel needs two parameters");
            }
            this.operation = Operations.GETLEVEL;
            this.hostName = args[index + 1];
            this.className = args[index + 2];
            return index + 3;
        }

        private int parseSetLevelArgs(String[] args, int index) throws HadoopIllegalArgumentException {
            if (this.operation != Operations.UNKNOWN) {
                throw new HadoopIllegalArgumentException("Redundant -setlevel command");
            }
            if (index + 3 >= args.length) {
                throw new HadoopIllegalArgumentException("-setlevel needs three parameters");
            }
            this.operation = Operations.SETLEVEL;
            this.hostName = args[index + 1];
            this.className = args[index + 2];
            this.level = args[index + 3];
            return index + 4;
        }

        private int parseProtocolArgs(String[] args, int index) throws HadoopIllegalArgumentException {
            if (this.protocol != null) {
                throw new HadoopIllegalArgumentException("Redundant -protocol command");
            }
            if (index + 1 >= args.length) {
                throw new HadoopIllegalArgumentException("-protocol needs one parameter");
            }
            this.protocol = args[index + 1];
            if (!LogLevel.isValidProtocol(this.protocol)) {
                throw new HadoopIllegalArgumentException("Invalid protocol: " + this.protocol);
            }
            return index + 2;
        }

        private void doGetLevel() throws Exception {
            this.process(this.protocol + "://" + this.hostName + "/logLevel?log=" + this.className);
        }

        private void doSetLevel() throws Exception {
            this.process(this.protocol + "://" + this.hostName + "/logLevel?log=" + this.className + "&level=" + this.level);
        }

        private HttpURLConnection connect(URL url) throws Exception {
            HttpURLConnection connection;
            AuthenticatedURL.Token token = new AuthenticatedURL.Token();
            if (LogLevel.PROTOCOL_HTTPS.equals(url.getProtocol())) {
                SSLFactory clientSslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, this.getConf());
                clientSslFactory.init();
                SSLSocketFactory sslSocketF = clientSslFactory.createSSLSocketFactory();
                AuthenticatedURL aUrl = new AuthenticatedURL((Authenticator)new KerberosAuthenticator(), (ConnectionConfigurator)clientSslFactory);
                connection = aUrl.openConnection(url, token);
                HttpsURLConnection httpsConn = (HttpsURLConnection)connection;
                httpsConn.setSSLSocketFactory(sslSocketF);
            } else {
                AuthenticatedURL aUrl = new AuthenticatedURL((Authenticator)new KerberosAuthenticator());
                connection = aUrl.openConnection(url, token);
            }
            connection.connect();
            return connection;
        }

        private void process(String urlString) throws Exception {
            URL url = new URL(urlString);
            System.out.println("Connecting to " + url);
            HttpURLConnection connection = this.connect(url);
            HttpExceptionUtils.validateResponse((HttpURLConnection)connection, (int)200);
            try (InputStreamReader streamReader = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);
                 BufferedReader bufferedReader = new BufferedReader(streamReader);){
                bufferedReader.lines().filter(Objects::nonNull).filter(line -> line.startsWith(LogLevel.MARKER)).forEach(line -> System.out.println(TAG.matcher((CharSequence)line).replaceAll("")));
            }
            catch (IOException ioe) {
                System.err.println("" + ioe);
            }
        }
    }

    private static enum Operations {
        GETLEVEL,
        SETLEVEL,
        UNKNOWN;

    }
}

