/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.bulkdatagenerator;

import java.io.IOException;
import org.apache.hadoop.hbase.util.bulkdatagenerator.BulkDataGeneratorInputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;

public class BulkDataGeneratorRecordReader
extends RecordReader<Text, NullWritable> {
    private int numRecordsToCreate = 0;
    private int createdRecords = 0;
    private Text key = new Text();
    private NullWritable value = NullWritable.get();
    public static final String RECORDS_PER_MAPPER_TASK_KEY = BulkDataGeneratorInputFormat.class.getName() + "records.per.mapper.task";

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.numRecordsToCreate = context.getConfiguration().getInt(RECORDS_PER_MAPPER_TASK_KEY, -1);
        Preconditions.checkArgument((this.numRecordsToCreate > 0 ? 1 : 0) != 0, (Object)"Number of records to be created by per mapper should be greater than 0.");
    }

    public boolean nextKeyValue() {
        ++this.createdRecords;
        return this.createdRecords <= this.numRecordsToCreate;
    }

    public Text getCurrentKey() {
        this.key.set(String.valueOf(this.createdRecords));
        return this.key;
    }

    public NullWritable getCurrentValue() {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.createdRecords / (float)this.numRecordsToCreate;
    }

    public void close() throws IOException {
    }
}

