/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class KeyOnlyCellComparable
implements WritableComparable<KeyOnlyCellComparable> {
    private ExtendedCell cell = null;

    public KeyOnlyCellComparable() {
    }

    public KeyOnlyCellComparable(ExtendedCell cell) {
        this.cell = cell;
    }

    public ExtendedCell getCell() {
        return this.cell;
    }

    @SuppressWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="This is wrong, yes, but we should be purging Writables, not fixing them")
    public int compareTo(KeyOnlyCellComparable o) {
        return CellComparator.getInstance().compare((Cell)this.cell, (Cell)o.cell);
    }

    public void write(DataOutput out) throws IOException {
        int keyLen = PrivateCellUtil.estimatedSerializedSizeOfKey((Cell)this.cell);
        int valueLen = 0;
        out.writeInt(keyLen + valueLen + 8);
        out.writeInt(keyLen);
        out.writeInt(valueLen);
        PrivateCellUtil.writeFlatKey((Cell)this.cell, (DataOutput)out);
        out.writeLong(this.cell.getSequenceId());
    }

    public void readFields(DataInput in) throws IOException {
        this.cell = KeyValue.create((DataInput)in);
        long seqId = in.readLong();
        this.cell.setSequenceId(seqId);
    }

    static {
        WritableComparator.define(KeyOnlyCellComparable.class, (WritableComparator)new KeyOnlyCellComparator());
    }

    public static class KeyOnlyCellComparator
    extends WritableComparator {
        /*
         * Exception decompiling
         */
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

