/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.MetaCellComparator;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SmallTests.class})
public class TestKeyValue {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestKeyValue.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestKeyValue.class);
    private final byte[] rowA = Bytes.toBytes((String)"rowA");
    private final byte[] rowB = Bytes.toBytes((String)"rowB");
    private final byte[] family = Bytes.toBytes((String)"family");
    private final byte[] qualA = Bytes.toBytes((String)"qfA");

    @Test
    public void testColumnCompare() {
        byte[] a = Bytes.toBytes((String)"aaa");
        byte[] family1 = Bytes.toBytes((String)"abc");
        byte[] qualifier1 = Bytes.toBytes((String)"def");
        byte[] family2 = Bytes.toBytes((String)"abcd");
        byte[] qualifier2 = Bytes.toBytes((String)"ef");
        KeyValue aaa = new KeyValue(a, family1, qualifier1, 0L, KeyValue.Type.Put, a);
        Assert.assertFalse((boolean)CellUtil.matchingColumn((Cell)aaa, (byte[])family2, (byte[])qualifier2));
        Assert.assertTrue((boolean)CellUtil.matchingColumn((Cell)aaa, (byte[])family1, (byte[])qualifier1));
        aaa = new KeyValue(a, family2, qualifier2, 0L, KeyValue.Type.Put, a);
        Assert.assertFalse((boolean)CellUtil.matchingColumn((Cell)aaa, (byte[])family1, (byte[])qualifier1));
        Assert.assertTrue((boolean)CellUtil.matchingColumn((Cell)aaa, (byte[])family2, (byte[])qualifier2));
        byte[] nullQualifier = new byte[]{};
        aaa = new KeyValue(a, family1, nullQualifier, 0L, KeyValue.Type.Put, a);
        Assert.assertTrue((boolean)CellUtil.matchingColumn((Cell)aaa, (byte[])family1, null));
        Assert.assertFalse((boolean)CellUtil.matchingColumn((Cell)aaa, (byte[])family2, (byte[])qualifier2));
    }

    @Test
    public void testColumnCompare_prefix() {
        byte[] a = Bytes.toBytes((String)"aaa");
        byte[] family1 = Bytes.toBytes((String)"abc");
        byte[] qualifier1 = Bytes.toBytes((String)"def");
        byte[] family2 = Bytes.toBytes((String)"ab");
        byte[] qualifier2 = Bytes.toBytes((String)"def");
        KeyValue aaa = new KeyValue(a, family1, qualifier1, 0L, KeyValue.Type.Put, a);
        Assert.assertFalse((boolean)CellUtil.matchingColumn((Cell)aaa, (byte[])family2, (byte[])qualifier2));
    }

    @Test
    public void testBasics() {
        LOG.info("LOWKEY: " + KeyValue.LOWESTKEY.toString());
        String name = "testBasics";
        this.check(Bytes.toBytes((String)name), Bytes.toBytes((String)name), Bytes.toBytes((String)name), 1L, Bytes.toBytes((String)name));
        this.check(Bytes.toBytes((String)name), Bytes.toBytes((String)name), null, 1L, null);
        this.check(HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)name), null, 1L, null);
        Assert.assertEquals((Object)new KeyValue(Bytes.toBytes((String)"rk"), Bytes.toBytes((String)"fam"), null, 1L, (byte[])null), (Object)new KeyValue(Bytes.toBytes((String)"rk"), Bytes.toBytes((String)"fam"), HConstants.EMPTY_BYTE_ARRAY, 1L, (byte[])null));
    }

    private void check(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte[] value) {
        KeyValue kv = new KeyValue(row, family, qualifier, timestamp, value);
        Assert.assertTrue((Bytes.compareTo((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])row, (int)0, (int)row.length) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)CellUtil.matchingColumn((Cell)kv, (byte[])family, (byte[])qualifier));
        LOG.info(kv.toString());
    }

    @Test
    public void testPlainCompare() {
        KeyValue bbb;
        byte[] qf;
        byte[] a = Bytes.toBytes((String)"aaa");
        byte[] b = Bytes.toBytes((String)"bbb");
        byte[] fam = Bytes.toBytes((String)"col");
        KeyValue aaa = new KeyValue(a, fam, qf = Bytes.toBytes((String)"umn"), a);
        Assert.assertTrue((CellComparatorImpl.COMPARATOR.compare((Cell)aaa, (Cell)(bbb = new KeyValue(b, fam, qf, b))) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparatorImpl.COMPARATOR.compare((Cell)bbb, (Cell)aaa) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparatorImpl.COMPARATOR.compare((Cell)bbb, (Cell)bbb) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparatorImpl.COMPARATOR.compare((Cell)aaa, (Cell)aaa) == 0 ? 1 : 0) != 0);
        aaa = new KeyValue(a, fam, qf, 1L, a);
        bbb = new KeyValue(a, fam, qf, 2L, a);
        Assert.assertTrue((CellComparatorImpl.COMPARATOR.compare((Cell)aaa, (Cell)bbb) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparatorImpl.COMPARATOR.compare((Cell)bbb, (Cell)aaa) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparatorImpl.COMPARATOR.compare((Cell)aaa, (Cell)aaa) == 0 ? 1 : 0) != 0);
        aaa = new KeyValue(a, fam, qf, 1L, KeyValue.Type.Delete, a);
        bbb = new KeyValue(a, fam, qf, 1L, a);
        Assert.assertTrue((CellComparatorImpl.COMPARATOR.compare((Cell)aaa, (Cell)bbb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparatorImpl.COMPARATOR.compare((Cell)bbb, (Cell)aaa) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparatorImpl.COMPARATOR.compare((Cell)aaa, (Cell)aaa) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMoreComparisons() {
        long now = EnvironmentEdgeManager.currentTime();
        KeyValue aaa = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,row_0500,1236020145502"), now);
        MetaCellComparator c = MetaCellComparator.META_COMPARATOR;
        KeyValue bbb = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,,99999999999999"), now);
        Assert.assertTrue((c.compare((Cell)bbb, (Cell)aaa) < 0 ? 1 : 0) != 0);
        KeyValue aaaa = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,,1236023996656"), Bytes.toBytes((String)"info"), Bytes.toBytes((String)"regioninfo"), 1236024396271L, (byte[])null);
        Assert.assertTrue((c.compare((Cell)aaaa, (Cell)bbb) < 0 ? 1 : 0) != 0);
        KeyValue x = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,row_0500,1236034574162"), Bytes.toBytes((String)"info"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null);
        KeyValue y = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,row_0500,1236034574162"), Bytes.toBytes((String)"info"), Bytes.toBytes((String)"regioninfo"), 1236034574912L, (byte[])null);
        Assert.assertTrue((c.compare((Cell)x, (Cell)y) < 0 ? 1 : 0) != 0);
        this.comparisons((CellComparatorImpl)MetaCellComparator.META_COMPARATOR);
        this.comparisons(CellComparatorImpl.COMPARATOR);
        this.metacomparisons((CellComparatorImpl)MetaCellComparator.META_COMPARATOR);
    }

    @Test
    public void testMetaComparatorTableKeysWithCommaOk() {
        KeyValue b;
        MetaCellComparator c = MetaCellComparator.META_COMPARATOR;
        long now = EnvironmentEdgeManager.currentTime();
        KeyValue a = new KeyValue(Bytes.toBytes((String)"table,key,with,commas1,1234"), now);
        Assert.assertTrue((c.compare((Cell)a, (Cell)(b = new KeyValue(Bytes.toBytes((String)"table,key,with,commas2,0123"), now))) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testKeyValueBorderCases() {
        KeyValue rowB;
        KeyValue rowA = new KeyValue(Bytes.toBytes((String)"testtable,www.hbase.org/,1234"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null);
        Assert.assertTrue((MetaCellComparator.META_COMPARATOR.compare((Cell)rowA, (Cell)(rowB = new KeyValue(Bytes.toBytes((String)"testtable,www.hbase.org/%20,99999"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null))) < 0 ? 1 : 0) != 0);
        rowA = new KeyValue(Bytes.toBytes((String)"testtable,,1234"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null);
        rowB = new KeyValue(Bytes.toBytes((String)"testtable,$www.hbase.org/,99999"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null);
        Assert.assertTrue((MetaCellComparator.META_COMPARATOR.compare((Cell)rowA, (Cell)rowB) < 0 ? 1 : 0) != 0);
    }

    private void metacomparisons(CellComparatorImpl c) {
        long now = EnvironmentEdgeManager.currentTime();
        Assert.assertTrue((c.compare((Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1")), now), (Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1")), now)) == 0 ? 1 : 0) != 0);
        KeyValue a = new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1")), now);
        KeyValue b = new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,2")), now);
        Assert.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compare((Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,2")), now), (Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1")), now)) > 0 ? 1 : 0) != 0);
    }

    private void comparisons(CellComparatorImpl c) {
        long now = EnvironmentEdgeManager.currentTime();
        Assert.assertTrue((c.compare((Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,1")), now), (Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,1")), now)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compare((Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,1")), now), (Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,2")), now)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compare((Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,2")), now), (Cell)new KeyValue(Bytes.toBytes((String)(TableName.META_TABLE_NAME.getNameAsString() + ",,1")), now)) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBinaryKeys() {
        TreeSet set = new TreeSet(CellComparatorImpl.COMPARATOR);
        byte[] fam = Bytes.toBytes((String)"col");
        byte[] qf = Bytes.toBytes((String)"umn");
        byte[] nb = new byte[]{};
        KeyValue[] keys = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"aaaaa,\u0000\u0000,2"), fam, qf, 2L, nb), new KeyValue(Bytes.toBytes((String)"aaaaa,\u0001,3"), fam, qf, 3L, nb), new KeyValue(Bytes.toBytes((String)"aaaaa,,1"), fam, qf, 1L, nb), new KeyValue(Bytes.toBytes((String)"aaaaa,\u1000,5"), fam, qf, 5L, nb), new KeyValue(Bytes.toBytes((String)"aaaaa,a,4"), fam, qf, 4L, nb), new KeyValue(Bytes.toBytes((String)"a,a,0"), fam, qf, 0L, nb)};
        Collections.addAll(set, keys);
        boolean assertion = false;
        int count = 0;
        for (KeyValue k : set) {
            if ((long)count++ == k.getTimestamp()) continue;
            assertion = true;
        }
        Assert.assertTrue((boolean)assertion);
        set = new TreeSet(MetaCellComparator.META_COMPARATOR);
        Collections.addAll(set, keys);
        count = 0;
        for (KeyValue k : set) {
            Assert.assertEquals((long)count++, (long)k.getTimestamp());
        }
    }

    @Test
    public void testStackedUpKeyValue() {
    }

    private void assertKVLess(CellComparator c, KeyValue less, KeyValue greater) {
        int cmp = c.compare((Cell)less, (Cell)greater);
        Assert.assertTrue((cmp < 0 ? 1 : 0) != 0);
        cmp = c.compare((Cell)greater, (Cell)less);
        Assert.assertTrue((cmp > 0 ? 1 : 0) != 0);
    }

    private void assertKVLessWithoutRow(CellComparator c, KeyValue less, KeyValue greater) {
        int cmp = c.compare((Cell)less, (Cell)greater);
        Assert.assertTrue((cmp < 0 ? 1 : 0) != 0);
        cmp = c.compare((Cell)greater, (Cell)less);
        Assert.assertTrue((cmp > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareWithoutRow() {
        CellComparatorImpl c = CellComparatorImpl.COMPARATOR;
        byte[] row = Bytes.toBytes((String)"row");
        byte[] fa = Bytes.toBytes((String)"fa");
        byte[] fami = Bytes.toBytes((String)"fami");
        byte[] fami1 = Bytes.toBytes((String)"fami1");
        byte[] qual0 = Bytes.toBytes((String)"");
        byte[] qual1 = Bytes.toBytes((String)"qf1");
        byte[] qual2 = Bytes.toBytes((String)"qf2");
        long ts = 1L;
        KeyValue kv_0 = new KeyValue(row, fa, qual0, ts, KeyValue.Type.Put);
        KeyValue kv0_0 = new KeyValue(row, fami, qual0, ts, KeyValue.Type.Put);
        KeyValue kv0_1 = new KeyValue(row, fami, qual1, ts, KeyValue.Type.Put);
        KeyValue kv0_2 = new KeyValue(row, fami, qual2, ts, KeyValue.Type.Put);
        KeyValue kv1_0 = new KeyValue(row, fami1, qual0, ts, KeyValue.Type.Put);
        this.assertKVLessWithoutRow((CellComparator)c, kv0_1, kv0_2);
        this.assertKVLessWithoutRow((CellComparator)c, kv0_1, kv1_0);
        this.assertKVLessWithoutRow((CellComparator)c, kv_0, kv0_0);
        this.assertKVLessWithoutRow((CellComparator)c, kv0_0, kv0_1);
        this.assertKVLessWithoutRow((CellComparator)c, kv0_1, kv1_0);
        this.assertKVLessWithoutRow((CellComparator)c, kv0_1, kv0_2);
    }

    @Test
    public void testFirstLastOnRow() {
        CellComparatorImpl c = CellComparatorImpl.COMPARATOR;
        long ts = 1L;
        byte[] bufferA = new byte[128];
        int offsetA = 0;
        byte[] bufferB = new byte[128];
        int offsetB = 7;
        KeyValue firstOnRowA = KeyValueUtil.createFirstOnRow((byte[])this.rowA);
        KeyValue firstOnRowABufferFamQual = KeyValueUtil.createFirstOnRow((byte[])bufferA, (int)offsetA, (byte[])this.rowA, (int)0, (int)this.rowA.length, (byte[])this.family, (int)0, (int)this.family.length, (byte[])this.qualA, (int)0, (int)this.qualA.length);
        KeyValue kvA_1 = new KeyValue(this.rowA, null, null, ts, KeyValue.Type.Put);
        KeyValue kvA_2 = new KeyValue(this.rowA, this.family, this.qualA, ts, KeyValue.Type.Put);
        KeyValue lastOnRowA = KeyValueUtil.createLastOnRow((byte[])this.rowA);
        KeyValue firstOnRowB = KeyValueUtil.createFirstOnRow((byte[])this.rowB);
        KeyValue firstOnRowBBufferFam = KeyValueUtil.createFirstOnRow((byte[])bufferB, (int)offsetB, (byte[])this.rowB, (int)0, (int)this.rowB.length, (byte[])this.family, (int)0, (int)this.family.length, null, (int)0, (int)0);
        KeyValue kvB = new KeyValue(this.rowB, this.family, this.qualA, ts, KeyValue.Type.Put);
        this.assertKVLess((CellComparator)c, firstOnRowA, firstOnRowB);
        this.assertKVLess((CellComparator)c, firstOnRowA, firstOnRowBBufferFam);
        this.assertKVLess((CellComparator)c, firstOnRowABufferFamQual, firstOnRowB);
        this.assertKVLess((CellComparator)c, firstOnRowA, kvA_1);
        this.assertKVLess((CellComparator)c, firstOnRowA, kvA_2);
        this.assertKVLess((CellComparator)c, firstOnRowABufferFamQual, kvA_2);
        this.assertKVLess((CellComparator)c, kvA_1, kvA_2);
        this.assertKVLess((CellComparator)c, kvA_2, firstOnRowB);
        this.assertKVLess((CellComparator)c, kvA_1, firstOnRowB);
        this.assertKVLess((CellComparator)c, kvA_2, firstOnRowBBufferFam);
        this.assertKVLess((CellComparator)c, kvA_1, firstOnRowBBufferFam);
        this.assertKVLess((CellComparator)c, lastOnRowA, firstOnRowB);
        this.assertKVLess((CellComparator)c, lastOnRowA, firstOnRowBBufferFam);
        this.assertKVLess((CellComparator)c, firstOnRowB, kvB);
        this.assertKVLess((CellComparator)c, firstOnRowBBufferFam, kvB);
        this.assertKVLess((CellComparator)c, lastOnRowA, kvB);
        this.assertKVLess((CellComparator)c, kvA_2, lastOnRowA);
        this.assertKVLess((CellComparator)c, kvA_1, lastOnRowA);
        this.assertKVLess((CellComparator)c, firstOnRowA, lastOnRowA);
        this.assertKVLess((CellComparator)c, firstOnRowABufferFamQual, lastOnRowA);
    }

    @Test
    public void testCreateKeyOnly() {
        long ts = 1L;
        byte[] value = Bytes.toBytes((String)"a real value");
        byte[] evalue = new byte[]{};
        for (byte[] val : new byte[][]{value, evalue}) {
            for (boolean useLen : new boolean[]{false, true}) {
                KeyValue kv1 = new KeyValue(this.rowA, this.family, this.qualA, ts, val);
                KeyValue kv1ko = kv1.createKeyOnly(useLen);
                Assert.assertTrue((boolean)kv1.equals((Object)kv1ko));
                Assert.assertTrue((kv1ko.getValueLength() == (useLen ? 4 : 0) ? 1 : 0) != 0);
                if (!useLen) continue;
                Assert.assertEquals((long)kv1.getValueLength(), (long)Bytes.toInt((byte[])kv1ko.getValueArray(), (int)kv1ko.getValueOffset(), (int)kv1ko.getValueLength()));
            }
        }
    }

    @Test
    public void testCreateKeyValueFromKey() {
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"myRow"), Bytes.toBytes((String)"myCF"), Bytes.toBytes((String)"myQualifier"), 12345L, Bytes.toBytes((String)"myValue"));
        int initialPadding = 10;
        int endingPadding = 20;
        int keyLen = kv.getKeyLength();
        byte[] tmpArr = new byte[initialPadding + endingPadding + keyLen];
        System.arraycopy(kv.getBuffer(), kv.getKeyOffset(), tmpArr, initialPadding, keyLen);
        KeyValue kvFromKey = KeyValueUtil.createKeyValueFromKey((byte[])tmpArr, (int)initialPadding, (int)keyLen);
        Assert.assertEquals((long)keyLen, (long)kvFromKey.getKeyLength());
        Assert.assertEquals((long)(8 + keyLen), (long)kvFromKey.getBuffer().length);
        System.err.println("kv=" + kv);
        System.err.println("kvFromKey=" + kvFromKey);
        Assert.assertEquals((Object)kvFromKey.toString(), (Object)kv.toString().replaceAll("=[0-9]+", "=0"));
    }

    @Test
    public void testGetTimestamp() {
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"myRow"), Bytes.toBytes((String)"myCF"), Bytes.toBytes((String)"myQualifier"), Long.MAX_VALUE, Bytes.toBytes((String)"myValue"));
        long time1 = kv.getTimestamp();
        kv.updateLatestStamp(Bytes.toBytes((long)12345L));
        long time2 = kv.getTimestamp();
        Assert.assertEquals((long)Long.MAX_VALUE, (long)time1);
        Assert.assertEquals((long)12345L, (long)time2);
    }

    @Test
    public void testKVsWithTags() {
        byte[] row = Bytes.toBytes((String)"myRow");
        byte[] cf = Bytes.toBytes((String)"myCF");
        byte[] q = Bytes.toBytes((String)"myQualifier");
        byte[] value = Bytes.toBytes((String)"myValue");
        byte[] metaValue1 = Bytes.toBytes((String)"metaValue1");
        byte[] metaValue2 = Bytes.toBytes((String)"metaValue2");
        KeyValue kv = new KeyValue(row, cf, q, Long.MAX_VALUE, value, new Tag[]{new ArrayBackedTag(1, metaValue1), new ArrayBackedTag(2, metaValue2)});
        Assert.assertTrue((kv.getTagsLength() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])row, (int)0, (int)row.length));
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength(), (byte[])cf, (int)0, (int)cf.length));
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])q, (int)0, (int)q.length));
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength(), (byte[])value, (int)0, (int)value.length));
        List tags = PrivateCellUtil.getTags((Cell)kv);
        Assert.assertNotNull((Object)tags);
        Assert.assertEquals((long)2L, (long)tags.size());
        boolean meta1Ok = false;
        boolean meta2Ok = false;
        for (Tag tag : tags) {
            if (tag.getType() == 1) {
                if (!Bytes.equals((byte[])Tag.cloneValue((Tag)tag), (byte[])metaValue1)) continue;
                meta1Ok = true;
                continue;
            }
            if (!Bytes.equals((byte[])Tag.cloneValue((Tag)tag), (byte[])metaValue2)) continue;
            meta2Ok = true;
        }
        Assert.assertTrue((boolean)meta1Ok);
        Assert.assertTrue((boolean)meta2Ok);
        Iterator tagItr = PrivateCellUtil.tagsIterator((Cell)kv);
        Assert.assertTrue((boolean)tagItr.hasNext());
        Tag next = (Tag)tagItr.next();
        Assert.assertEquals((long)10L, (long)next.getValueLength());
        Assert.assertEquals((long)1L, (long)next.getType());
        Bytes.equals((byte[])Tag.cloneValue((Tag)next), (byte[])metaValue1);
        Assert.assertTrue((boolean)tagItr.hasNext());
        next = (Tag)tagItr.next();
        Assert.assertEquals((long)10L, (long)next.getValueLength());
        Assert.assertEquals((long)2L, (long)next.getType());
        Bytes.equals((byte[])Tag.cloneValue((Tag)next), (byte[])metaValue2);
        Assert.assertFalse((boolean)tagItr.hasNext());
        tagItr = PrivateCellUtil.tagsIterator((Cell)kv);
        Assert.assertTrue((boolean)tagItr.hasNext());
        next = (Tag)tagItr.next();
        Assert.assertEquals((long)10L, (long)next.getValueLength());
        Assert.assertEquals((long)1L, (long)next.getType());
        Bytes.equals((byte[])Tag.cloneValue((Tag)next), (byte[])metaValue1);
        Assert.assertTrue((boolean)tagItr.hasNext());
        next = (Tag)tagItr.next();
        Assert.assertEquals((long)10L, (long)next.getValueLength());
        Assert.assertEquals((long)2L, (long)next.getType());
        Bytes.equals((byte[])Tag.cloneValue((Tag)next), (byte[])metaValue2);
        Assert.assertFalse((boolean)tagItr.hasNext());
    }

    @Test
    public void testMetaKeyComparator() {
        KeyValue b;
        MetaCellComparator c = MetaCellComparator.META_COMPARATOR;
        long now = EnvironmentEdgeManager.currentTime();
        KeyValue a = new KeyValue(Bytes.toBytes((String)"table1"), now);
        Assert.assertTrue((c.compare((Cell)a, (Cell)(b = new KeyValue(Bytes.toBytes((String)"table2"), now))) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table1,111"), now);
        b = new KeyValue(Bytes.toBytes((String)"table2"), now);
        Assert.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table1"), now);
        b = new KeyValue(Bytes.toBytes((String)"table2,111"), now);
        Assert.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table,111"), now);
        b = new KeyValue(Bytes.toBytes((String)"table,2222"), now);
        Assert.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table,111,aaaa"), now);
        b = new KeyValue(Bytes.toBytes((String)"table,2222"), now);
        Assert.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table,111"), now);
        b = new KeyValue(Bytes.toBytes((String)"table,2222.bbb"), now);
        Assert.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table,,aaaa"), now);
        b = new KeyValue(Bytes.toBytes((String)"table,111,bbb"), now);
        Assert.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table,111,aaaa"), now);
        b = new KeyValue(Bytes.toBytes((String)"table,111,bbb"), now);
        Assert.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table,111,xxxx"), now);
        b = new KeyValue(Bytes.toBytes((String)"table,111,222,bbb"), now);
        Assert.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes((String)"table,111,11,xxx"), now);
        b = new KeyValue(Bytes.toBytes((String)"table,111,222,bbb"), now);
        Assert.assertTrue((c.compare((Cell)a, (Cell)b) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsAndHashCode() {
        KeyValue kvA1 = new KeyValue(Bytes.toBytes((String)"key"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"qualA"), Bytes.toBytes((String)"1"));
        KeyValue kvA2 = new KeyValue(Bytes.toBytes((String)"key"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"qualA"), Bytes.toBytes((String)"2"));
        kvA2.setSequenceId(2L);
        KeyValue kvB = new KeyValue(Bytes.toBytes((String)"key"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"qualB"), Bytes.toBytes((String)"1"));
        Assert.assertEquals((Object)kvA1, (Object)kvA2);
        Assert.assertNotEquals((Object)kvA1, (Object)kvB);
        Assert.assertEquals((long)kvA1.hashCode(), (long)kvA2.hashCode());
        Assert.assertNotEquals((long)kvA1.hashCode(), (long)kvB.hashCode());
    }

    @Test
    public void testKeyValueSerialization() throws Exception {
        KeyValue[] keyValues = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"key"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"qualA"), Bytes.toBytes((String)"1")), new KeyValue(Bytes.toBytes((String)"key"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"qualA"), Bytes.toBytes((String)"2")), new KeyValue(Bytes.toBytes((String)"key"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"qualA"), EnvironmentEdgeManager.currentTime(), Bytes.toBytes((String)"2"), new Tag[]{new ArrayBackedTag(120, "tagA"), new ArrayBackedTag(121, Bytes.toBytes((String)"tagB"))}), new KeyValue(Bytes.toBytes((String)"key"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"qualA"), EnvironmentEdgeManager.currentTime(), Bytes.toBytes((String)"2"), new Tag[]{new ArrayBackedTag(0, "tagA")}), new KeyValue(Bytes.toBytes((String)"key"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)""), Bytes.toBytes((String)"1"))};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (KeyValue kv : keyValues) {
            DataOutputStream os = new DataOutputStream(byteArrayOutputStream);
            ByteBufferUtils.putInt((OutputStream)os, (int)KeyValueUtil.getSerializedSize((Cell)kv, (boolean)true));
            KeyValueUtil.oswrite((Cell)kv, (OutputStream)os, (boolean)true);
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        for (int i = 0; i < keyValues.length; ++i) {
            LOG.info("Case#" + i + ": deserialize the kv: " + keyValues[i]);
            KeyValue destKv = KeyValueUtil.createKeyValueFromInputStream((InputStream)is, (boolean)true);
            Assert.assertEquals((Object)keyValues[i], (Object)destKv);
            Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)keyValues[i]), (byte[])CellUtil.cloneValue((Cell)destKv));
            Assert.assertArrayEquals((byte[])PrivateCellUtil.cloneTags((Cell)keyValues[i]), (byte[])PrivateCellUtil.cloneTags((Cell)destKv));
        }
    }

    @Test
    public void testNullByteArrayKeyValueFailure() {
        try {
            new KeyValue(null, 0, 0);
        }
        catch (IllegalArgumentException iae) {
            Assert.assertEquals((Object)"Invalid to have null byte array in KeyValue.", (Object)iae.getMessage());
            return;
        }
        Assert.fail((String)"Should have thrown an IllegalArgumentException when creating a KeyValue with a null buffer");
    }

    @Test
    public void testCheckKeyValueBytesFailureCase() throws Exception {
        int i;
        byte[][] inputs = new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytesBinary((String)"a"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x01"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x01\\x00"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x01\\x00\\x00\\x00\\x01"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x01\\x00\\x00\\x00\\x01\\x00"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x01\\x00\\x00\\x00\\x01\\x00\\x01"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x01\\x00\\x00\\x00\\x01\\x00\\x03ROW"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x01\\x00\\x00\\x00\\x01\\x00\\x03ROW\\x01"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x11\\x00\\x00\\x00\\x01\\x00\\x03ROW\\x01FQ\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\x03"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x11\\x00\\x00\\x00\\x01\\x00\\x03ROW\\x01FQ\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01\\x03"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x11\\x00\\x00\\x00\\x01\\x00\\x03ROW\\x01FQ\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01\\x04"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x11\\x00\\x00\\x00\\x01\\x00\\x03ROW\\x01FQ\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01\\x04VALUE")};
        String[] outputs = new String[]{"Overflow when reading key length at position=0", "Overflow when reading key length at position=0", "Invalid key length in KeyValue. keyLength=1", "Overflow when reading value length at position=4", "Invalid value length in KeyValue, valueLength=1", "Overflow when reading row length at position=8", "Invalid row length in KeyValue, rowLength=1", "Overflow when reading family length at position=13", "Invalid family length in KeyValue, familyLength=1", "Timestamp cannot be negative, ts=-1", "Invalid type in KeyValue, type=3", "Overflow when reading value part at position=25", "Invalid tags length in KeyValue at position=26"};
        byte[][] withTagsInputs = new byte[][]{Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x11\\x00\\x00\\x00\\x01\\x00\\x03ROW\\x01FQ\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01\\x04V\\x01"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x11\\x00\\x00\\x00\\x01\\x00\\x03ROW\\x01FQ\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01\\x04V\\x00\\x01"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x11\\x00\\x00\\x00\\x01\\x00\\x03ROW\\x01FQ\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01\\x04V\\x00\\x04\\x00\\x03\\x00A"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x11\\x00\\x00\\x00\\x01\\x00\\x03ROW\\x01FQ\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01\\x04V\\x00\\x0A\\x00\\x04\\x00TAG\\x00\\x04\\xFFT"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x11\\x00\\x00\\x00\\x01\\x00\\x03ROW\\x01FQ\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01\\x04V\\x00\\x0C\\x00\\x04\\x00TAG\\x00\\x05\\xF0COME\\x00"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x11\\x00\\x00\\x00\\x01\\x00\\x03ROW\\x01FQ\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01\\x04V\\x00\\x0C\\x00\\x04\\x00TAG\\x00\\x05\\xF0COME"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x11\\x00\\x00\\x00\\x01\\x00\\x03ROW\\x01FQ\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01\\x04V\\x00\\x00"), Bytes.toBytesBinary((String)"\\x00\\x00\\x00\\x11\\x00\\x00\\x00\\x01\\x00\\x03ROW\\x01FQ\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01\\x04V\\x00\\x1B\\x00\\x05\\x01TAG1\\x00\\x05\\x02TAG2\\x00\\x05\\x03TAG3\\x00\\x05\\x04TAG4")};
        String[] withTagsOutputs = new String[]{"Overflow when reading tags length at position=26", "Invalid tags length in KeyValue at position=26", "Invalid tag length at position=28, tagLength=3", "Invalid tag length at position=34, tagLength=4", "Some redundant bytes in KeyValue's buffer, startOffset=41, endOffset=42", null, null, null};
        Assert.assertEquals((long)inputs.length, (long)outputs.length);
        Assert.assertEquals((long)withTagsInputs.length, (long)withTagsOutputs.length);
        FailureCase[] cases = new FailureCase[inputs.length + withTagsInputs.length];
        for (i = 0; i < inputs.length; ++i) {
            cases[i] = new FailureCase(inputs[i], 0, inputs[i].length, false, outputs[i]);
        }
        for (i = 0; i < withTagsInputs.length; ++i) {
            cases[inputs.length + i] = new FailureCase(withTagsInputs[i], 0, withTagsInputs[i].length, true, withTagsOutputs[i]);
        }
        for (i = 0; i < cases.length; ++i) {
            FailureCase c = cases[i];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(baos);
            ByteBufferUtils.putInt((OutputStream)os, (int)c.length);
            os.write(c.buf, c.offset, c.length);
            try {
                KeyValueUtil.createKeyValueFromInputStream((InputStream)new DataInputStream(new ByteArrayInputStream(baos.toByteArray())), (boolean)c.withTags);
                if (c.expectedMessage == null) continue;
                Assert.fail((String)("Should fail when parse kv from an invalid bytes, case#" + i + ". " + c));
                continue;
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((String)("Case#" + i + " failed," + c), (Object)c.getExpectedMessage(), (Object)e.getMessage());
            }
        }
    }

    private static class FailureCase {
        byte[] buf;
        int offset;
        int length;
        boolean withTags;
        String expectedMessage;

        public FailureCase(byte[] buf, int offset, int length, boolean withTags, String expectedMessage) {
            this.buf = buf;
            this.offset = offset;
            this.length = length;
            this.withTags = withTags;
            this.expectedMessage = expectedMessage;
        }

        public String toString() {
            return "FailureCaseDetails: [buf=" + Bytes.toStringBinary((byte[])this.buf, (int)this.offset, (int)this.length) + ", offset=" + this.offset + ", length=" + this.length + ", expectedMessage=" + this.expectedMessage + ", withtags=" + this.withTags + "]";
        }

        public String getExpectedMessage() {
            return this.expectedMessage + KeyValueUtil.bytesToHex((byte[])this.buf, (int)this.offset, (int)this.length);
        }
    }
}

