/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.WALPlayer;
import org.apache.hadoop.hbase.regionserver.TestRecoveredEdits;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.tool.BulkLoadHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={MapReduceTests.class, LargeTests.class})
public class TestWALPlayer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALPlayer.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster;
    private static Path rootDir;
    private static Path walRootDir;
    private static FileSystem fs;
    private static FileSystem logFs;
    private static Configuration conf;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        rootDir = TEST_UTIL.createRootDir();
        walRootDir = TEST_UTIL.createWALRootDir();
        fs = CommonFSUtils.getRootDirFileSystem((Configuration)conf);
        logFs = CommonFSUtils.getWALFileSystem((Configuration)conf);
        cluster = TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        fs.delete(rootDir, true);
        logFs.delete(walRootDir, true);
    }

    @Test
    public void testPlayingRecoveredEdit() throws Exception {
        TableName tn = TableName.valueOf((String)"IntegrationTestBigLinkedList");
        TEST_UTIL.createTable(tn, TestRecoveredEdits.RECOVEREDEDITS_COLUMNFAMILY);
        String hbaseServerTestResourcesEdits = System.getProperty("test.build.classes") + "/../../../hbase-server/src/test/resources/" + TestRecoveredEdits.RECOVEREDEDITS_PATH.getName();
        Assert.assertTrue((boolean)new File(hbaseServerTestResourcesEdits).exists());
        DistributedFileSystem dfs = TEST_UTIL.getDFSCluster().getFileSystem();
        Path targetDir = new Path("edits").makeQualified(dfs.getUri(), dfs.getHomeDirectory());
        Assert.assertTrue((boolean)dfs.mkdirs(targetDir));
        dfs.copyFromLocalFile(new Path(hbaseServerTestResourcesEdits), targetDir);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)new WALPlayer(conf), (String[])new String[]{targetDir.toString()}));
        Assert.assertTrue((TEST_UTIL.countRows(tn) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWALPlayerBulkLoadWithOverriddenTimestamps() throws Exception {
        TableName tableName = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        byte[] family = Bytes.toBytes((String)"family");
        byte[] column1 = Bytes.toBytes((String)"c1");
        byte[] column2 = Bytes.toBytes((String)"c2");
        byte[] row = Bytes.toBytes((String)"row");
        Table table = TEST_UTIL.createTable(tableName, family);
        long now = EnvironmentEdgeManager.currentTime();
        Put p = new Put(row);
        p.addColumn(family, column1, now, column1);
        p.addColumn(family, column2, now, column2);
        table.put(p);
        byte[] lastVal = null;
        for (int i = 0; i < 50; ++i) {
            lastVal = Bytes.toBytes((long)ThreadLocalRandom.current().nextLong());
            p = new Put(row);
            p.addColumn(family, column1, now, lastVal);
            table.put(p);
            if (i % 10 != 0) continue;
            WAL log = cluster.getRegionServer(0).getWAL(null);
            log.rollWriter();
        }
        WAL log = cluster.getRegionServer(0).getWAL(null);
        log.rollWriter();
        String walInputDir = new Path(cluster.getMaster().getMasterFileSystem().getWALRootDir(), "WALs").toString();
        Configuration configuration = new Configuration(TEST_UTIL.getConfiguration());
        String outPath = "/tmp/" + this.name.getMethodName();
        configuration.set("wal.bulk.output", outPath);
        WALPlayer player = new WALPlayer(configuration);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)configuration, (Tool)player, (String[])new String[]{walInputDir, tableName.getNameAsString()}));
        Get g = new Get(row);
        Result result = table.get(g);
        byte[] value = CellUtil.cloneValue((Cell)result.getColumnLatestCell(family, column1));
        MatcherAssert.assertThat((Object)Bytes.toStringBinary((byte[])value), (Matcher)CoreMatchers.equalTo((Object)Bytes.toStringBinary((byte[])lastVal)));
        table = TEST_UTIL.truncateTable(tableName);
        g = new Get(row);
        result = table.get(g);
        MatcherAssert.assertThat((Object)result.listCells(), (Matcher)CoreMatchers.nullValue());
        BulkLoadHFiles.create((Configuration)configuration).bulkLoad(tableName, new Path(outPath));
        g = new Get(row);
        result = table.get(g);
        value = CellUtil.cloneValue((Cell)result.getColumnLatestCell(family, column1));
        MatcherAssert.assertThat((Object)result.listCells(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)Bytes.toStringBinary((byte[])value), (Matcher)CoreMatchers.equalTo((Object)Bytes.toStringBinary((byte[])lastVal)));
    }

    @Test
    public void testWALPlayer() throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN1 = Bytes.toBytes((String)"c1");
        byte[] COLUMN2 = Bytes.toBytes((String)"c2");
        byte[] ROW = Bytes.toBytes((String)"row");
        Table t1 = TEST_UTIL.createTable(tableName1, FAMILY);
        Table t2 = TEST_UTIL.createTable(tableName2, FAMILY);
        Put p = new Put(ROW);
        p.addColumn(FAMILY, COLUMN1, COLUMN1);
        p.addColumn(FAMILY, COLUMN2, COLUMN2);
        t1.put(p);
        Delete d = new Delete(ROW);
        d.addColumns(FAMILY, COLUMN1);
        t1.delete(d);
        WAL log = cluster.getRegionServer(0).getWAL(null);
        log.rollWriter();
        String walInputDir = new Path(cluster.getMaster().getMasterFileSystem().getWALRootDir(), "WALs").toString();
        Configuration configuration = TEST_UTIL.getConfiguration();
        WALPlayer player = new WALPlayer(configuration);
        String optionName = "_test_.name";
        configuration.set(optionName, "1000");
        player.setupTime(configuration, optionName);
        Assert.assertEquals((long)1000L, (long)configuration.getLong(optionName, 0L));
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)configuration, (Tool)player, (String[])new String[]{walInputDir, tableName1.getNameAsString(), tableName2.getNameAsString()}));
        Get g = new Get(ROW);
        Result r = t2.get(g);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)r.rawCells()[0], (byte[])COLUMN2));
    }

    @Test
    public void testWALKeyValueMapper() throws Exception {
        this.testWALKeyValueMapper("wal.input.tables");
    }

    @Test
    public void testWALKeyValueMapperWithDeprecatedConfig() throws Exception {
        this.testWALKeyValueMapper("hlog.input.tables");
    }

    private void testWALKeyValueMapper(String tableConfigKey) throws Exception {
        Configuration configuration = new Configuration();
        configuration.set(tableConfigKey, "table");
        WALPlayer.WALKeyValueMapper mapper = new WALPlayer.WALKeyValueMapper();
        WALKey key = (WALKey)Mockito.mock(WALKey.class);
        Mockito.when((Object)key.getTableName()).thenReturn((Object)TableName.valueOf((String)"table"));
        Mapper.Context context = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)configuration);
        WALEdit value = (WALEdit)Mockito.mock(WALEdit.class);
        ArrayList<KeyValue> values = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"family"), null);
        values.add(kv1);
        Mockito.when((Object)value.getCells()).thenReturn(values);
        mapper.setup(context);
        ((Mapper.Context)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ImmutableBytesWritable writer = (ImmutableBytesWritable)invocation.getArgument(0);
                KeyValue key = (KeyValue)invocation.getArgument(1);
                Assert.assertEquals((Object)"row", (Object)Bytes.toString((byte[])writer.get()));
                Assert.assertEquals((Object)"row", (Object)Bytes.toString((byte[])CellUtil.cloneRow((Cell)key)));
                return null;
            }
        }).when((Object)context)).write(ArgumentMatchers.any(), ArgumentMatchers.any());
        mapper.map(key, value, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMainMethod() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager((SecurityManager)newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            try {
                WALPlayer.main((String[])args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
                Assert.assertTrue((boolean)data.toString().contains("ERROR: Wrong number of arguments:"));
                Assert.assertTrue((boolean)data.toString().contains("Usage: WALPlayer [options] <WAL inputdir> [<tables> <tableMappings>]"));
                Assert.assertTrue((boolean)data.toString().contains("-Dwal.bulk.output=/path/for/output"));
            }
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }
}

