/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts;

import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.groovy.contracts.AssertionViolation;
import org.apache.groovy.contracts.util.Validate;

public class ViolationTracker {
    public static final ThreadLocal<ViolationTracker> INSTANCE = new ThreadLocal();
    private final NavigableMap<Long, AssertionViolation> violations = new TreeMap<Long, AssertionViolation>();

    public static void init() {
        INSTANCE.set(new ViolationTracker());
    }

    public static void deinit() {
        INSTANCE.remove();
    }

    public static boolean violationsOccurred() {
        return INSTANCE.get().hasViolations();
    }

    public static void rethrowFirst() {
        throw INSTANCE.get().first();
    }

    public static void rethrowLast() {
        throw INSTANCE.get().last();
    }

    public void track(AssertionViolation assertionViolation) {
        Validate.notNull((Object)assertionViolation);
        this.violations.put(System.nanoTime(), assertionViolation);
    }

    public boolean hasViolations() {
        return !this.violations.isEmpty();
    }

    public AssertionViolation first() {
        return this.violations.firstEntry().getValue();
    }

    public AssertionViolation last() {
        return this.violations.lastEntry().getValue();
    }
}

