/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.31.1(337587859b1c171314b40503171188b6cea6a32a)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
define("vs/language/html/htmlMode",[],()=>{
var moduleExports=(()=>{var qe=Object.create;var M=Object.defineProperty;var Qe=Object.getOwnPropertyDescriptor;var Ge=Object.getOwnPropertyNames;var Je=Object.getPrototypeOf,Ye=Object.prototype.hasOwnProperty;var Z=n=>M(n,"__esModule",{value:!0});var Ze=(n,r)=>()=>(r||n((r={exports:{}}).exports,r),r.exports),en=(n,r)=>{Z(n);for(var i in r)M(n,i,{get:r[i],enumerable:!0})},ee=(n,r,i)=>{if(r&&typeof r=="object"||typeof r=="function")for(let t of Ge(r))!Ye.call(n,t)&&t!=="default"&&M(n,t,{get:()=>r[t],enumerable:!(i=Qe(r,t))||i.enumerable});return n},nn=n=>ee(Z(M(n!=null?qe(Je(n)):{},"default",n&&n.__esModule&&"default"in n?{get:()=>n.default,enumerable:!0}:{value:n,enumerable:!0})),n);var ge=Ze((yn,le)=>{le.exports=self.monaco});var vn={};en(vn,{setupMode:()=>hn,setupMode1:()=>mn});var d={};Z(d);ee(d,nn(ge()));var tn=2*60*1e3,A=class{constructor(r){this._defaults=r,this._worker=null,this._client=null,this._idleCheckInterval=window.setInterval(()=>this._checkIfIdle(),30*1e3),this._lastUsedTime=0,this._configChangeListener=this._defaults.onDidChange(()=>this._stopWorker())}_stopWorker(){this._worker&&(this._worker.dispose(),this._worker=null),this._client=null}dispose(){clearInterval(this._idleCheckInterval),this._configChangeListener.dispose(),this._stopWorker()}_checkIfIdle(){if(!this._worker)return;Date.now()-this._lastUsedTime>tn&&this._stopWorker()}_getClient(){return this._lastUsedTime=Date.now(),this._client||(this._worker=d.editor.createWebWorker({moduleId:"vs/language/html/htmlWorker",createData:{languageSettings:this._defaults.options,languageId:this._defaults.languageId},label:this._defaults.languageId}),this._client=this._worker.getProxy()),this._client}getLanguageServiceWorker(...r){let i;return this._getClient().then(t=>{i=t}).then(t=>{if(this._worker)return this._worker.withSyncedResources(r)}).then(t=>i)}};"use strict";var fe;(function(n){n.MIN_VALUE=-2147483648,n.MAX_VALUE=2147483647})(fe||(fe={}));var H;(function(n){n.MIN_VALUE=0,n.MAX_VALUE=2147483647})(H||(H={}));var x;(function(n){function r(t,e){return t===Number.MAX_VALUE&&(t=H.MAX_VALUE),e===Number.MAX_VALUE&&(e=H.MAX_VALUE),{line:t,character:e}}n.create=r;function i(t){var e=t;return s.objectLiteral(e)&&s.uinteger(e.line)&&s.uinteger(e.character)}n.is=i})(x||(x={}));var v;(function(n){function r(t,e,o,a){if(s.uinteger(t)&&s.uinteger(e)&&s.uinteger(o)&&s.uinteger(a))return{start:x.create(t,e),end:x.create(o,a)};if(x.is(t)&&x.is(e))return{start:t,end:e};throw new Error("Range#create called with invalid arguments["+t+", "+e+", "+o+", "+a+"]")}n.create=r;function i(t){var e=t;return s.objectLiteral(e)&&x.is(e.start)&&x.is(e.end)}n.is=i})(v||(v={}));var ne;(function(n){function r(t,e){return{uri:t,range:e}}n.create=r;function i(t){var e=t;return s.defined(e)&&v.is(e.range)&&(s.string(e.uri)||s.undefined(e.uri))}n.is=i})(ne||(ne={}));var pe;(function(n){function r(t,e,o,a){return{targetUri:t,targetRange:e,targetSelectionRange:o,originSelectionRange:a}}n.create=r;function i(t){var e=t;return s.defined(e)&&v.is(e.targetRange)&&s.string(e.targetUri)&&(v.is(e.targetSelectionRange)||s.undefined(e.targetSelectionRange))&&(v.is(e.originSelectionRange)||s.undefined(e.originSelectionRange))}n.is=i})(pe||(pe={}));var te;(function(n){function r(t,e,o,a){return{red:t,green:e,blue:o,alpha:a}}n.create=r;function i(t){var e=t;return s.numberRange(e.red,0,1)&&s.numberRange(e.green,0,1)&&s.numberRange(e.blue,0,1)&&s.numberRange(e.alpha,0,1)}n.is=i})(te||(te={}));var me;(function(n){function r(t,e){return{range:t,color:e}}n.create=r;function i(t){var e=t;return v.is(e.range)&&te.is(e.color)}n.is=i})(me||(me={}));var he;(function(n){function r(t,e,o){return{label:t,textEdit:e,additionalTextEdits:o}}n.create=r;function i(t){var e=t;return s.string(e.label)&&(s.undefined(e.textEdit)||I.is(e))&&(s.undefined(e.additionalTextEdits)||s.typedArray(e.additionalTextEdits,I.is))}n.is=i})(he||(he={}));var b;(function(n){n.Comment="comment",n.Imports="imports",n.Region="region"})(b||(b={}));var ve;(function(n){function r(t,e,o,a,u){var g={startLine:t,endLine:e};return s.defined(o)&&(g.startCharacter=o),s.defined(a)&&(g.endCharacter=a),s.defined(u)&&(g.kind=u),g}n.create=r;function i(t){var e=t;return s.uinteger(e.startLine)&&s.uinteger(e.startLine)&&(s.undefined(e.startCharacter)||s.uinteger(e.startCharacter))&&(s.undefined(e.endCharacter)||s.uinteger(e.endCharacter))&&(s.undefined(e.kind)||s.string(e.kind))}n.is=i})(ve||(ve={}));var re;(function(n){function r(t,e){return{location:t,message:e}}n.create=r;function i(t){var e=t;return s.defined(e)&&ne.is(e.location)&&s.string(e.message)}n.is=i})(re||(re={}));var ie;(function(n){n.Error=1,n.Warning=2,n.Information=3,n.Hint=4})(ie||(ie={}));var Te;(function(n){n.Unnecessary=1,n.Deprecated=2})(Te||(Te={}));var ye;(function(n){function r(i){var t=i;return t!=null&&s.string(t.href)}n.is=r})(ye||(ye={}));var K;(function(n){function r(t,e,o,a,u,g){var f={range:t,message:e};return s.defined(o)&&(f.severity=o),s.defined(a)&&(f.code=a),s.defined(u)&&(f.source=u),s.defined(g)&&(f.relatedInformation=g),f}n.create=r;function i(t){var e,o=t;return s.defined(o)&&v.is(o.range)&&s.string(o.message)&&(s.number(o.severity)||s.undefined(o.severity))&&(s.integer(o.code)||s.string(o.code)||s.undefined(o.code))&&(s.undefined(o.codeDescription)||s.string((e=o.codeDescription)===null||e===void 0?void 0:e.href))&&(s.string(o.source)||s.undefined(o.source))&&(s.undefined(o.relatedInformation)||s.typedArray(o.relatedInformation,re.is))}n.is=i})(K||(K={}));var R;(function(n){function r(t,e){for(var o=[],a=2;a<arguments.length;a++)o[a-2]=arguments[a];var u={title:t,command:e};return s.defined(o)&&o.length>0&&(u.arguments=o),u}n.create=r;function i(t){var e=t;return s.defined(e)&&s.string(e.title)&&s.string(e.command)}n.is=i})(R||(R={}));var I;(function(n){function r(o,a){return{range:o,newText:a}}n.replace=r;function i(o,a){return{range:{start:o,end:o},newText:a}}n.insert=i;function t(o){return{range:o,newText:""}}n.del=t;function e(o){var a=o;return s.objectLiteral(a)&&s.string(a.newText)&&v.is(a.range)}n.is=e})(I||(I={}));var w;(function(n){function r(t,e,o){var a={label:t};return e!==void 0&&(a.needsConfirmation=e),o!==void 0&&(a.description=o),a}n.create=r;function i(t){var e=t;return e!==void 0&&s.objectLiteral(e)&&s.string(e.label)&&(s.boolean(e.needsConfirmation)||e.needsConfirmation===void 0)&&(s.string(e.description)||e.description===void 0)}n.is=i})(w||(w={}));var T;(function(n){function r(i){var t=i;return typeof t=="string"}n.is=r})(T||(T={}));var _;(function(n){function r(o,a,u){return{range:o,newText:a,annotationId:u}}n.replace=r;function i(o,a,u){return{range:{start:o,end:o},newText:a,annotationId:u}}n.insert=i;function t(o,a){return{range:o,newText:"",annotationId:a}}n.del=t;function e(o){var a=o;return I.is(a)&&(w.is(a.annotationId)||T.is(a.annotationId))}n.is=e})(_||(_={}));var U;(function(n){function r(t,e){return{textDocument:t,edits:e}}n.create=r;function i(t){var e=t;return s.defined(e)&&O.is(e.textDocument)&&Array.isArray(e.edits)}n.is=i})(U||(U={}));var P;(function(n){function r(t,e,o){var a={kind:"create",uri:t};return e!==void 0&&(e.overwrite!==void 0||e.ignoreIfExists!==void 0)&&(a.options=e),o!==void 0&&(a.annotationId=o),a}n.create=r;function i(t){var e=t;return e&&e.kind==="create"&&s.string(e.uri)&&(e.options===void 0||(e.options.overwrite===void 0||s.boolean(e.options.overwrite))&&(e.options.ignoreIfExists===void 0||s.boolean(e.options.ignoreIfExists)))&&(e.annotationId===void 0||T.is(e.annotationId))}n.is=i})(P||(P={}));var W;(function(n){function r(t,e,o,a){var u={kind:"rename",oldUri:t,newUri:e};return o!==void 0&&(o.overwrite!==void 0||o.ignoreIfExists!==void 0)&&(u.options=o),a!==void 0&&(u.annotationId=a),u}n.create=r;function i(t){var e=t;return e&&e.kind==="rename"&&s.string(e.oldUri)&&s.string(e.newUri)&&(e.options===void 0||(e.options.overwrite===void 0||s.boolean(e.options.overwrite))&&(e.options.ignoreIfExists===void 0||s.boolean(e.options.ignoreIfExists)))&&(e.annotationId===void 0||T.is(e.annotationId))}n.is=i})(W||(W={}));var D;(function(n){function r(t,e,o){var a={kind:"delete",uri:t};return e!==void 0&&(e.recursive!==void 0||e.ignoreIfNotExists!==void 0)&&(a.options=e),o!==void 0&&(a.annotationId=o),a}n.create=r;function i(t){var e=t;return e&&e.kind==="delete"&&s.string(e.uri)&&(e.options===void 0||(e.options.recursive===void 0||s.boolean(e.options.recursive))&&(e.options.ignoreIfNotExists===void 0||s.boolean(e.options.ignoreIfNotExists)))&&(e.annotationId===void 0||T.is(e.annotationId))}n.is=i})(D||(D={}));var oe;(function(n){function r(i){var t=i;return t&&(t.changes!==void 0||t.documentChanges!==void 0)&&(t.documentChanges===void 0||t.documentChanges.every(function(e){return s.string(e.kind)?P.is(e)||W.is(e)||D.is(e):U.is(e)}))}n.is=r})(oe||(oe={}));var j=function(){function n(r,i){this.edits=r,this.changeAnnotations=i}return n.prototype.insert=function(r,i,t){var e,o;if(t===void 0?e=I.insert(r,i):T.is(t)?(o=t,e=_.insert(r,i,t)):(this.assertChangeAnnotations(this.changeAnnotations),o=this.changeAnnotations.manage(t),e=_.insert(r,i,o)),this.edits.push(e),o!==void 0)return o},n.prototype.replace=function(r,i,t){var e,o;if(t===void 0?e=I.replace(r,i):T.is(t)?(o=t,e=_.replace(r,i,t)):(this.assertChangeAnnotations(this.changeAnnotations),o=this.changeAnnotations.manage(t),e=_.replace(r,i,o)),this.edits.push(e),o!==void 0)return o},n.prototype.delete=function(r,i){var t,e;if(i===void 0?t=I.del(r):T.is(i)?(e=i,t=_.del(r,i)):(this.assertChangeAnnotations(this.changeAnnotations),e=this.changeAnnotations.manage(i),t=_.del(r,e)),this.edits.push(t),e!==void 0)return e},n.prototype.add=function(r){this.edits.push(r)},n.prototype.all=function(){return this.edits},n.prototype.clear=function(){this.edits.splice(0,this.edits.length)},n.prototype.assertChangeAnnotations=function(r){if(r===void 0)throw new Error("Text edit change is not configured to manage change annotations.")},n}(),xe=function(){function n(r){this._annotations=r===void 0?Object.create(null):r,this._counter=0,this._size=0}return n.prototype.all=function(){return this._annotations},Object.defineProperty(n.prototype,"size",{get:function(){return this._size},enumerable:!1,configurable:!0}),n.prototype.manage=function(r,i){var t;if(T.is(r)?t=r:(t=this.nextId(),i=r),this._annotations[t]!==void 0)throw new Error("Id "+t+" is already in use.");if(i===void 0)throw new Error("No annotation provided for id "+t);return this._annotations[t]=i,this._size++,t},n.prototype.nextId=function(){return this._counter++,this._counter.toString()},n}(),bn=function(){function n(r){var i=this;this._textEditChanges=Object.create(null),r!==void 0?(this._workspaceEdit=r,r.documentChanges?(this._changeAnnotations=new xe(r.changeAnnotations),r.changeAnnotations=this._changeAnnotations.all(),r.documentChanges.forEach(function(t){if(U.is(t)){var e=new j(t.edits,i._changeAnnotations);i._textEditChanges[t.textDocument.uri]=e}})):r.changes&&Object.keys(r.changes).forEach(function(t){var e=new j(r.changes[t]);i._textEditChanges[t]=e})):this._workspaceEdit={}}return Object.defineProperty(n.prototype,"edit",{get:function(){return this.initDocumentChanges(),this._changeAnnotations!==void 0&&(this._changeAnnotations.size===0?this._workspaceEdit.changeAnnotations=void 0:this._workspaceEdit.changeAnnotations=this._changeAnnotations.all()),this._workspaceEdit},enumerable:!1,configurable:!0}),n.prototype.getTextEditChange=function(r){if(O.is(r)){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var i={uri:r.uri,version:r.version},t=this._textEditChanges[i.uri];if(!t){var e=[],o={textDocument:i,edits:e};this._workspaceEdit.documentChanges.push(o),t=new j(e,this._changeAnnotations),this._textEditChanges[i.uri]=t}return t}else{if(this.initChanges(),this._workspaceEdit.changes===void 0)throw new Error("Workspace edit is not configured for normal text edit changes.");var t=this._textEditChanges[r];if(!t){var e=[];this._workspaceEdit.changes[r]=e,t=new j(e),this._textEditChanges[r]=t}return t}},n.prototype.initDocumentChanges=function(){this._workspaceEdit.documentChanges===void 0&&this._workspaceEdit.changes===void 0&&(this._changeAnnotations=new xe,this._workspaceEdit.documentChanges=[],this._workspaceEdit.changeAnnotations=this._changeAnnotations.all())},n.prototype.initChanges=function(){this._workspaceEdit.documentChanges===void 0&&this._workspaceEdit.changes===void 0&&(this._workspaceEdit.changes=Object.create(null))},n.prototype.createFile=function(r,i,t){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var e;w.is(i)||T.is(i)?e=i:t=i;var o,a;if(e===void 0?o=P.create(r,t):(a=T.is(e)?e:this._changeAnnotations.manage(e),o=P.create(r,t,a)),this._workspaceEdit.documentChanges.push(o),a!==void 0)return a},n.prototype.renameFile=function(r,i,t,e){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var o;w.is(t)||T.is(t)?o=t:e=t;var a,u;if(o===void 0?a=W.create(r,i,e):(u=T.is(o)?o:this._changeAnnotations.manage(o),a=W.create(r,i,e,u)),this._workspaceEdit.documentChanges.push(a),u!==void 0)return u},n.prototype.deleteFile=function(r,i,t){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var e;w.is(i)||T.is(i)?e=i:t=i;var o,a;if(e===void 0?o=D.create(r,t):(a=T.is(e)?e:this._changeAnnotations.manage(e),o=D.create(r,t,a)),this._workspaceEdit.documentChanges.push(o),a!==void 0)return a},n}();var ke;(function(n){function r(t){return{uri:t}}n.create=r;function i(t){var e=t;return s.defined(e)&&s.string(e.uri)}n.is=i})(ke||(ke={}));var Ie;(function(n){function r(t,e){return{uri:t,version:e}}n.create=r;function i(t){var e=t;return s.defined(e)&&s.string(e.uri)&&s.integer(e.version)}n.is=i})(Ie||(Ie={}));var O;(function(n){function r(t,e){return{uri:t,version:e}}n.create=r;function i(t){var e=t;return s.defined(e)&&s.string(e.uri)&&(e.version===null||s.integer(e.version))}n.is=i})(O||(O={}));var _e;(function(n){function r(t,e,o,a){return{uri:t,languageId:e,version:o,text:a}}n.create=r;function i(t){var e=t;return s.defined(e)&&s.string(e.uri)&&s.string(e.languageId)&&s.integer(e.version)&&s.string(e.text)}n.is=i})(_e||(_e={}));var L;(function(n){n.PlainText="plaintext",n.Markdown="markdown"})(L||(L={}));(function(n){function r(i){var t=i;return t===n.PlainText||t===n.Markdown}n.is=r})(L||(L={}));var ae;(function(n){function r(i){var t=i;return s.objectLiteral(i)&&L.is(t.kind)&&s.string(t.value)}n.is=r})(ae||(ae={}));var p;(function(n){n.Text=1,n.Method=2,n.Function=3,n.Constructor=4,n.Field=5,n.Variable=6,n.Class=7,n.Interface=8,n.Module=9,n.Property=10,n.Unit=11,n.Value=12,n.Enum=13,n.Keyword=14,n.Snippet=15,n.Color=16,n.File=17,n.Reference=18,n.Folder=19,n.EnumMember=20,n.Constant=21,n.Struct=22,n.Event=23,n.Operator=24,n.TypeParameter=25})(p||(p={}));var N;(function(n){n.PlainText=1,n.Snippet=2})(N||(N={}));var Ce;(function(n){n.Deprecated=1})(Ce||(Ce={}));var be;(function(n){function r(t,e,o){return{newText:t,insert:e,replace:o}}n.create=r;function i(t){var e=t;return e&&s.string(e.newText)&&v.is(e.insert)&&v.is(e.replace)}n.is=i})(be||(be={}));var we;(function(n){n.asIs=1,n.adjustIndentation=2})(we||(we={}));var Ee;(function(n){function r(i){return{label:i}}n.create=r})(Ee||(Ee={}));var Re;(function(n){function r(i,t){return{items:i||[],isIncomplete:!!t}}n.create=r})(Re||(Re={}));var V;(function(n){function r(t){return t.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")}n.fromPlainText=r;function i(t){var e=t;return s.string(e)||s.objectLiteral(e)&&s.string(e.language)&&s.string(e.value)}n.is=i})(V||(V={}));var Pe;(function(n){function r(i){var t=i;return!!t&&s.objectLiteral(t)&&(ae.is(t.contents)||V.is(t.contents)||s.typedArray(t.contents,V.is))&&(i.range===void 0||v.is(i.range))}n.is=r})(Pe||(Pe={}));var We;(function(n){function r(i,t){return t?{label:i,documentation:t}:{label:i}}n.create=r})(We||(We={}));var De;(function(n){function r(i,t){for(var e=[],o=2;o<arguments.length;o++)e[o-2]=arguments[o];var a={label:i};return s.defined(t)&&(a.documentation=t),s.defined(e)?a.parameters=e:a.parameters=[],a}n.create=r})(De||(De={}));var E;(function(n){n.Text=1,n.Read=2,n.Write=3})(E||(E={}));var Le;(function(n){function r(i,t){var e={range:i};return s.number(t)&&(e.kind=t),e}n.create=r})(Le||(Le={}));var m;(function(n){n.File=1,n.Module=2,n.Namespace=3,n.Package=4,n.Class=5,n.Method=6,n.Property=7,n.Field=8,n.Constructor=9,n.Enum=10,n.Interface=11,n.Function=12,n.Variable=13,n.Constant=14,n.String=15,n.Number=16,n.Boolean=17,n.Array=18,n.Object=19,n.Key=20,n.Null=21,n.EnumMember=22,n.Struct=23,n.Event=24,n.Operator=25,n.TypeParameter=26})(m||(m={}));var Fe;(function(n){n.Deprecated=1})(Fe||(Fe={}));var Se;(function(n){function r(i,t,e,o,a){var u={name:i,kind:t,location:{uri:o,range:e}};return a&&(u.containerName=a),u}n.create=r})(Se||(Se={}));var Me;(function(n){function r(t,e,o,a,u,g){var f={name:t,detail:e,kind:o,range:a,selectionRange:u};return g!==void 0&&(f.children=g),f}n.create=r;function i(t){var e=t;return e&&s.string(e.name)&&s.number(e.kind)&&v.is(e.range)&&v.is(e.selectionRange)&&(e.detail===void 0||s.string(e.detail))&&(e.deprecated===void 0||s.boolean(e.deprecated))&&(e.children===void 0||Array.isArray(e.children))&&(e.tags===void 0||Array.isArray(e.tags))}n.is=i})(Me||(Me={}));var Ae;(function(n){n.Empty="",n.QuickFix="quickfix",n.Refactor="refactor",n.RefactorExtract="refactor.extract",n.RefactorInline="refactor.inline",n.RefactorRewrite="refactor.rewrite",n.Source="source",n.SourceOrganizeImports="source.organizeImports",n.SourceFixAll="source.fixAll"})(Ae||(Ae={}));var He;(function(n){function r(t,e){var o={diagnostics:t};return e!=null&&(o.only=e),o}n.create=r;function i(t){var e=t;return s.defined(e)&&s.typedArray(e.diagnostics,K.is)&&(e.only===void 0||s.typedArray(e.only,s.string))}n.is=i})(He||(He={}));var Ke;(function(n){function r(t,e,o){var a={title:t},u=!0;return typeof e=="string"?(u=!1,a.kind=e):R.is(e)?a.command=e:a.edit=e,u&&o!==void 0&&(a.kind=o),a}n.create=r;function i(t){var e=t;return e&&s.string(e.title)&&(e.diagnostics===void 0||s.typedArray(e.diagnostics,K.is))&&(e.kind===void 0||s.string(e.kind))&&(e.edit!==void 0||e.command!==void 0)&&(e.command===void 0||R.is(e.command))&&(e.isPreferred===void 0||s.boolean(e.isPreferred))&&(e.edit===void 0||oe.is(e.edit))}n.is=i})(Ke||(Ke={}));var Ue;(function(n){function r(t,e){var o={range:t};return s.defined(e)&&(o.data=e),o}n.create=r;function i(t){var e=t;return s.defined(e)&&v.is(e.range)&&(s.undefined(e.command)||R.is(e.command))}n.is=i})(Ue||(Ue={}));var je;(function(n){function r(t,e){return{tabSize:t,insertSpaces:e}}n.create=r;function i(t){var e=t;return s.defined(e)&&s.uinteger(e.tabSize)&&s.boolean(e.insertSpaces)}n.is=i})(je||(je={}));var Oe;(function(n){function r(t,e,o){return{range:t,target:e,data:o}}n.create=r;function i(t){var e=t;return s.defined(e)&&v.is(e.range)&&(s.undefined(e.target)||s.string(e.target))}n.is=i})(Oe||(Oe={}));var Ne;(function(n){function r(t,e){return{range:t,parent:e}}n.create=r;function i(t){var e=t;return e!==void 0&&v.is(e.range)&&(e.parent===void 0||n.is(e.parent))}n.is=i})(Ne||(Ne={}));var Ve;(function(n){function r(o,a,u,g){return new rn(o,a,u,g)}n.create=r;function i(o){var a=o;return!!(s.defined(a)&&s.string(a.uri)&&(s.undefined(a.languageId)||s.string(a.languageId))&&s.uinteger(a.lineCount)&&s.func(a.getText)&&s.func(a.positionAt)&&s.func(a.offsetAt))}n.is=i;function t(o,a){for(var u=o.getText(),g=e(a,function(C,S){var ce=C.range.start.line-S.range.start.line;return ce===0?C.range.start.character-S.range.start.character:ce}),f=u.length,l=g.length-1;l>=0;l--){var h=g[l],k=o.offsetAt(h.range.start),c=o.offsetAt(h.range.end);if(c<=f)u=u.substring(0,k)+h.newText+u.substring(c,u.length);else throw new Error("Overlapping edit");f=k}return u}n.applyEdits=t;function e(o,a){if(o.length<=1)return o;var u=o.length/2|0,g=o.slice(0,u),f=o.slice(u);e(g,a),e(f,a);for(var l=0,h=0,k=0;l<g.length&&h<f.length;){var c=a(g[l],f[h]);c<=0?o[k++]=g[l++]:o[k++]=f[h++]}for(;l<g.length;)o[k++]=g[l++];for(;h<f.length;)o[k++]=f[h++];return o}})(Ve||(Ve={}));var rn=function(){function n(r,i,t,e){this._uri=r,this._languageId=i,this._version=t,this._content=e,this._lineOffsets=void 0}return Object.defineProperty(n.prototype,"uri",{get:function(){return this._uri},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"languageId",{get:function(){return this._languageId},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"version",{get:function(){return this._version},enumerable:!1,configurable:!0}),n.prototype.getText=function(r){if(r){var i=this.offsetAt(r.start),t=this.offsetAt(r.end);return this._content.substring(i,t)}return this._content},n.prototype.update=function(r,i){this._content=r.text,this._version=i,this._lineOffsets=void 0},n.prototype.getLineOffsets=function(){if(this._lineOffsets===void 0){for(var r=[],i=this._content,t=!0,e=0;e<i.length;e++){t&&(r.push(e),t=!1);var o=i.charAt(e);t=o==="\r"||o===`
`,o==="\r"&&e+1<i.length&&i.charAt(e+1)===`
`&&e++}t&&i.length>0&&r.push(i.length),this._lineOffsets=r}return this._lineOffsets},n.prototype.positionAt=function(r){r=Math.max(Math.min(r,this._content.length),0);var i=this.getLineOffsets(),t=0,e=i.length;if(e===0)return x.create(0,r);for(;t<e;){var o=Math.floor((t+e)/2);i[o]>r?e=o:t=o+1}var a=t-1;return x.create(a,r-i[a])},n.prototype.offsetAt=function(r){var i=this.getLineOffsets();if(r.line>=i.length)return this._content.length;if(r.line<0)return 0;var t=i[r.line],e=r.line+1<i.length?i[r.line+1]:this._content.length;return Math.max(Math.min(t+r.character,e),t)},Object.defineProperty(n.prototype,"lineCount",{get:function(){return this.getLineOffsets().length},enumerable:!1,configurable:!0}),n}(),s;(function(n){var r=Object.prototype.toString;function i(c){return typeof c!="undefined"}n.defined=i;function t(c){return typeof c=="undefined"}n.undefined=t;function e(c){return c===!0||c===!1}n.boolean=e;function o(c){return r.call(c)==="[object String]"}n.string=o;function a(c){return r.call(c)==="[object Number]"}n.number=a;function u(c,C,S){return r.call(c)==="[object Number]"&&C<=c&&c<=S}n.numberRange=u;function g(c){return r.call(c)==="[object Number]"&&-2147483648<=c&&c<=2147483647}n.integer=g;function f(c){return r.call(c)==="[object Number]"&&0<=c&&c<=2147483647}n.uinteger=f;function l(c){return r.call(c)==="[object Function]"}n.func=l;function h(c){return c!==null&&typeof c=="object"}n.objectLiteral=h;function k(c,C){return Array.isArray(c)&&c.every(C)}n.typedArray=k})(s||(s={}));var se=class{constructor(r,i){this._worker=r;this._triggerCharacters=i}get triggerCharacters(){return this._triggerCharacters}provideCompletionItems(r,i,t,e){let o=r.uri;return this._worker(o).then(a=>a.doComplete(o.toString(),F(i))).then(a=>{if(!a)return;let u=r.getWordUntilPosition(i),g=new d.Range(i.lineNumber,u.startColumn,i.lineNumber,u.endColumn),f=a.items.map(l=>{let h={label:l.label,insertText:l.insertText||l.label,sortText:l.sortText,filterText:l.filterText,documentation:l.documentation,detail:l.detail,command:un(l.command),range:g,kind:sn(l.kind)};return l.textEdit&&(an(l.textEdit)?h.range={insert:y(l.textEdit.insert),replace:y(l.textEdit.replace)}:h.range=y(l.textEdit.range),h.insertText=l.textEdit.newText),l.additionalTextEdits&&(h.additionalTextEdits=l.additionalTextEdits.map(ue)),l.insertTextFormat===N.Snippet&&(h.insertTextRules=d.languages.CompletionItemInsertTextRule.InsertAsSnippet),h});return{isIncomplete:a.isIncomplete,suggestions:f}})}};function F(n){if(!!n)return{character:n.column-1,line:n.lineNumber-1}}function on(n){if(!!n)return{start:{line:n.startLineNumber-1,character:n.startColumn-1},end:{line:n.endLineNumber-1,character:n.endColumn-1}}}function y(n){if(!!n)return new d.Range(n.start.line+1,n.start.character+1,n.end.line+1,n.end.character+1)}function an(n){return typeof n.insert!="undefined"&&typeof n.replace!="undefined"}function sn(n){let r=d.languages.CompletionItemKind;switch(n){case p.Text:return r.Text;case p.Method:return r.Method;case p.Function:return r.Function;case p.Constructor:return r.Constructor;case p.Field:return r.Field;case p.Variable:return r.Variable;case p.Class:return r.Class;case p.Interface:return r.Interface;case p.Module:return r.Module;case p.Property:return r.Property;case p.Unit:return r.Unit;case p.Value:return r.Value;case p.Enum:return r.Enum;case p.Keyword:return r.Keyword;case p.Snippet:return r.Snippet;case p.Color:return r.Color;case p.File:return r.File;case p.Reference:return r.Reference}return r.Property}function ue(n){if(!!n)return{range:y(n.range),text:n.newText}}function un(n){return n&&n.command==="editor.action.triggerSuggest"?{id:n.command,title:n.title,arguments:n.arguments}:void 0}var z=class{constructor(r){this._worker=r}provideHover(r,i,t){let e=r.uri;return this._worker(e).then(o=>o.doHover(e.toString(),F(i))).then(o=>{if(!!o)return{range:y(o.range),contents:cn(o.contents)}})}};function dn(n){return n&&typeof n=="object"&&typeof n.kind=="string"}function ze(n){return typeof n=="string"?{value:n}:dn(n)?n.kind==="plaintext"?{value:n.value.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")}:{value:n.value}:{value:"```"+n.language+`
`+n.value+"\n```\n"}}function cn(n){if(!!n)return Array.isArray(n)?n.map(ze):[ze(n)]}var X=class{constructor(r){this._worker=r}provideDocumentHighlights(r,i,t){let e=r.uri;return this._worker(e).then(o=>o.findDocumentHighlights(e.toString(),F(i))).then(o=>{if(!!o)return o.map(a=>({range:y(a.range),kind:ln(a.kind)}))})}};function ln(n){switch(n){case E.Read:return d.languages.DocumentHighlightKind.Read;case E.Write:return d.languages.DocumentHighlightKind.Write;case E.Text:return d.languages.DocumentHighlightKind.Text}return d.languages.DocumentHighlightKind.Text}var B=class{constructor(r){this._worker=r}provideRenameEdits(r,i,t,e){let o=r.uri;return this._worker(o).then(a=>a.doRename(o.toString(),F(i),t)).then(a=>gn(a))}};function gn(n){if(!n||!n.changes)return;let r=[];for(let i in n.changes){let t=d.Uri.parse(i);for(let e of n.changes[i])r.push({resource:t,edit:{range:y(e.range),text:e.newText}})}return{edits:r}}var $=class{constructor(r){this._worker=r}provideDocumentSymbols(r,i){let t=r.uri;return this._worker(t).then(e=>e.findDocumentSymbols(t.toString())).then(e=>{if(!!e)return e.map(o=>({name:o.name,detail:"",containerName:o.containerName,kind:fn(o.kind),range:y(o.location.range),selectionRange:y(o.location.range),tags:[]}))})}};function fn(n){let r=d.languages.SymbolKind;switch(n){case m.File:return r.Array;case m.Module:return r.Module;case m.Namespace:return r.Namespace;case m.Package:return r.Package;case m.Class:return r.Class;case m.Method:return r.Method;case m.Property:return r.Property;case m.Field:return r.Field;case m.Constructor:return r.Constructor;case m.Enum:return r.Enum;case m.Interface:return r.Interface;case m.Function:return r.Function;case m.Variable:return r.Variable;case m.Constant:return r.Constant;case m.String:return r.String;case m.Number:return r.Number;case m.Boolean:return r.Boolean;case m.Array:return r.Array}return r.Function}var q=class{constructor(r){this._worker=r}provideLinks(r,i){let t=r.uri;return this._worker(t).then(e=>e.findDocumentLinks(t.toString())).then(e=>{if(!!e)return{links:e.map(o=>({range:y(o.range),url:o.target}))}})}},Q=class{constructor(r){this._worker=r}provideDocumentFormattingEdits(r,i,t){let e=r.uri;return this._worker(e).then(o=>o.format(e.toString(),null,Xe(i)).then(a=>{if(!(!a||a.length===0))return a.map(ue)}))}},G=class{constructor(r){this._worker=r}provideDocumentRangeFormattingEdits(r,i,t,e){let o=r.uri;return this._worker(o).then(a=>a.format(o.toString(),on(i),Xe(t)).then(u=>{if(!(!u||u.length===0))return u.map(ue)}))}};function Xe(n){return{tabSize:n.tabSize,insertSpaces:n.insertSpaces}}var J=class{constructor(r){this._worker=r}provideFoldingRanges(r,i,t){let e=r.uri;return this._worker(e).then(o=>o.getFoldingRanges(e.toString(),i)).then(o=>{if(!!o)return o.map(a=>{let u={start:a.startLine+1,end:a.endLine+1};return typeof a.kind!="undefined"&&(u.kind=pn(a.kind)),u})})}};function pn(n){switch(n){case b.Comment:return d.languages.FoldingRangeKind.Comment;case b.Imports:return d.languages.FoldingRangeKind.Imports;case b.Region:return d.languages.FoldingRangeKind.Region}}var Y=class{constructor(r){this._worker=r}provideSelectionRanges(r,i,t){let e=r.uri;return this._worker(e).then(o=>o.getSelectionRanges(e.toString(),i.map(F))).then(o=>{if(!!o)return o.map(a=>{let u=[];for(;a;)u.push({range:y(a.range)}),a=a.parent;return u})})}};var de=class extends se{constructor(r){super(r,[".",":","<",'"',"=","/"])}};function mn(n){let r=new A(n),i=(...e)=>r.getLanguageServiceWorker(...e),t=n.languageId;d.languages.registerCompletionItemProvider(t,new de(i)),d.languages.registerHoverProvider(t,new z(i)),d.languages.registerDocumentHighlightProvider(t,new X(i)),d.languages.registerLinkProvider(t,new q(i)),d.languages.registerFoldingRangeProvider(t,new J(i)),d.languages.registerDocumentSymbolProvider(t,new $(i)),d.languages.registerSelectionRangeProvider(t,new Y(i)),d.languages.registerRenameProvider(t,new B(i)),t==="html"&&(d.languages.registerDocumentFormattingEditProvider(t,new Q(i)),d.languages.registerDocumentRangeFormattingEditProvider(t,new G(i)))}function hn(n){let r=[],i=[],t=new A(n);r.push(t);let e=(...a)=>t.getLanguageServiceWorker(...a);function o(){let{languageId:a,modeConfiguration:u}=n;$e(i),u.completionItems&&i.push(d.languages.registerCompletionItemProvider(a,new de(e))),u.hovers&&i.push(d.languages.registerHoverProvider(a,new z(e))),u.documentHighlights&&i.push(d.languages.registerDocumentHighlightProvider(a,new X(e))),u.links&&i.push(d.languages.registerLinkProvider(a,new q(e))),u.documentSymbols&&i.push(d.languages.registerDocumentSymbolProvider(a,new $(e))),u.rename&&i.push(d.languages.registerRenameProvider(a,new B(e))),u.foldingRanges&&i.push(d.languages.registerFoldingRangeProvider(a,new J(e))),u.selectionRanges&&i.push(d.languages.registerSelectionRangeProvider(a,new Y(e))),u.documentFormattingEdits&&i.push(d.languages.registerDocumentFormattingEditProvider(a,new Q(e))),u.documentRangeFormattingEdits&&i.push(d.languages.registerDocumentRangeFormattingEditProvider(a,new G(e)))}return o(),r.push(Be(i)),Be(r)}function Be(n){return{dispose:()=>$e(n)}}function $e(n){for(;n.length;)n.pop().dispose()}return vn;})();
return moduleExports;
});
