/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.datadog;

import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.metrics.datadog.Clock;
import org.apache.flink.metrics.datadog.DSeries;
import org.apache.flink.metrics.datadog.MetricMetaData;
import org.apache.flink.metrics.datadog.MetricType;
import org.apache.flink.metrics.datadog.StaticDMetric;

public class DHistogram {
    @VisibleForTesting
    static final String SUFFIX_AVG = ".avg";
    @VisibleForTesting
    static final String SUFFIX_COUNT = ".count";
    @VisibleForTesting
    static final String SUFFIX_MEDIAN = ".median";
    @VisibleForTesting
    static final String SUFFIX_95_PERCENTILE = ".95percentile";
    @VisibleForTesting
    static final String SUFFIX_MIN = ".min";
    @VisibleForTesting
    static final String SUFFIX_MAX = ".max";
    private final Histogram histogram;
    private final MetricMetaData metaDataAvg;
    private final MetricMetaData metaDataCount;
    private final MetricMetaData metaDataMedian;
    private final MetricMetaData metaData95Percentile;
    private final MetricMetaData metaDataMin;
    private final MetricMetaData metaDataMax;

    public DHistogram(Histogram histogram, String metricName, String host, List<String> tags, Clock clock) {
        this.histogram = histogram;
        this.metaDataAvg = new MetricMetaData(MetricType.gauge, metricName + SUFFIX_AVG, host, tags, clock);
        this.metaDataCount = new MetricMetaData(MetricType.gauge, metricName + SUFFIX_COUNT, host, tags, clock);
        this.metaDataMedian = new MetricMetaData(MetricType.gauge, metricName + SUFFIX_MEDIAN, host, tags, clock);
        this.metaData95Percentile = new MetricMetaData(MetricType.gauge, metricName + SUFFIX_95_PERCENTILE, host, tags, clock);
        this.metaDataMin = new MetricMetaData(MetricType.gauge, metricName + SUFFIX_MIN, host, tags, clock);
        this.metaDataMax = new MetricMetaData(MetricType.gauge, metricName + SUFFIX_MAX, host, tags, clock);
    }

    public void addTo(DSeries series) {
        HistogramStatistics statistics = this.histogram.getStatistics();
        series.add(new StaticDMetric(statistics.getMean(), this.metaDataAvg));
        series.add(new StaticDMetric(this.histogram.getCount(), this.metaDataCount));
        series.add(new StaticDMetric(statistics.getQuantile(0.5), this.metaDataMedian));
        series.add(new StaticDMetric(statistics.getQuantile(0.95), this.metaData95Percentile));
        series.add(new StaticDMetric(statistics.getMin(), this.metaDataMin));
        series.add(new StaticDMetric(statistics.getMax(), this.metaDataMax));
    }
}

