/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.runtimefilter.util;

import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.operators.util.BloomFilter;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;

public class RuntimeFilterUtils {
    public static final int OVER_MAX_ROW_COUNT = -1;
    private static final double EXPECTED_FPP = 0.05;

    public static BloomFilter createOnHeapBloomFilter(int numExpectedEntries) {
        int byteSize = (int)Math.ceil((double)BloomFilter.optimalNumOfBits((long)numExpectedEntries, (double)0.05) / 8.0);
        BloomFilter filter = new BloomFilter(numExpectedEntries, byteSize);
        filter.setBitsLocation(MemorySegmentFactory.allocateUnpooledSegment((int)byteSize), 0);
        return filter;
    }

    public static RowData convertBloomFilterToRowData(int actualRowCount, @Nullable BloomFilter bloomFilter) {
        return RuntimeFilterUtils.convertBloomFilterToRowData(actualRowCount, bloomFilter == null ? null : BloomFilter.toBytes((BloomFilter)bloomFilter));
    }

    public static RowData convertBloomFilterToRowData(int actualRowCount, @Nullable byte[] serializedBloomFilter) {
        GenericRowData rowData = new GenericRowData(2);
        rowData.setField(0, (Object)actualRowCount);
        rowData.setField(1, (Object)serializedBloomFilter);
        return rowData;
    }
}

