/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table.lookup;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.ThreadSafeSimpleCounter;
import org.apache.flink.metrics.groups.CacheMetricGroup;
import org.apache.flink.runtime.metrics.groups.InternalCacheMetricGroup;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AsyncLookupFunction;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.runtime.functions.table.lookup.LookupCacheManager;

public class CachingAsyncLookupFunction
extends AsyncLookupFunction {
    private static final long serialVersionUID = 1L;
    public static final String LOOKUP_CACHE_METRIC_GROUP_NAME = "cache";
    private static final long UNINITIALIZED = -1L;
    private final AsyncLookupFunction delegate;
    private LookupCache cache;
    private transient String cacheIdentifier;
    private transient CacheMetricGroup cacheMetricGroup;
    private transient Counter loadCounter;
    private transient Counter numLoadFailuresCounter;
    private volatile long latestLoadTime = -1L;

    public CachingAsyncLookupFunction(LookupCache cache, AsyncLookupFunction delegate) {
        this.cache = cache;
        this.delegate = delegate;
    }

    public void open(FunctionContext context) throws Exception {
        this.cacheIdentifier = this.functionIdentifier();
        this.cache = LookupCacheManager.getInstance().registerCacheIfAbsent(this.cacheIdentifier, this.cache);
        this.cacheMetricGroup = new InternalCacheMetricGroup(context.getMetricGroup(), LOOKUP_CACHE_METRIC_GROUP_NAME);
        this.loadCounter = new ThreadSafeSimpleCounter();
        this.cacheMetricGroup.loadCounter(this.loadCounter);
        this.numLoadFailuresCounter = new ThreadSafeSimpleCounter();
        this.cacheMetricGroup.numLoadFailuresCounter(this.numLoadFailuresCounter);
        this.cache.open(this.cacheMetricGroup);
        this.delegate.open(context);
    }

    public CompletableFuture<Collection<RowData>> asyncLookup(RowData keyRow) {
        Collection cachedValues = this.cache.getIfPresent(keyRow);
        if (cachedValues != null) {
            return CompletableFuture.completedFuture(cachedValues);
        }
        long loadStartTime = System.currentTimeMillis();
        return this.delegate.asyncLookup(keyRow).whenComplete((lookupValues, throwable) -> {
            if (throwable != null) {
                this.numLoadFailuresCounter.inc();
                throw new RuntimeException(String.format("Failed to lookup key '%s'", keyRow), (Throwable)throwable);
            }
            this.updateLatestLoadTime(System.currentTimeMillis() - loadStartTime);
            this.loadCounter.inc();
            List cachingValues = lookupValues;
            if (lookupValues == null || lookupValues.isEmpty()) {
                cachingValues = Collections.emptyList();
            }
            this.cache.put(keyRow, cachingValues);
        });
    }

    public void close() throws Exception {
        this.delegate.close();
        if (this.cacheIdentifier != null) {
            LookupCacheManager.getInstance().unregisterCache(this.cacheIdentifier);
        }
    }

    @VisibleForTesting
    public LookupCache getCache() {
        return this.cache;
    }

    private synchronized void updateLatestLoadTime(long loadTime) {
        if (this.latestLoadTime == -1L) {
            this.cacheMetricGroup.latestLoadTimeGauge(() -> this.latestLoadTime);
        }
        this.latestLoadTime = loadTime;
    }
}

