// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite('nereids_arith_p0_date') {
	sql 'use regression_test_nereids_arith_p0'
	sql 'set enable_nereids_planner=true'
	sql 'set enable_fallback_to_original_planner=false'
	qt_sql_test_Date_TinyInt_0 """
		select id, kdt + ktint, kdt - ktint from expr_test order by id"""
	qt_sql_test_Date_TinyInt_notn_0 """
		select id, kdt + ktint, kdt - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_TinyInt_1 """
		select id, kdt * ktint, kdt / ktint, kdt % ktint from expr_test order by id"""
	qt_sql_test_Date_TinyInt_notn_1 """
		select id, kdt * ktint, kdt / ktint, kdt % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_TinyInt_2 """
		select id, kdt DIV ktint from expr_test order by id"""
	qt_sql_test_Date_TinyInt_notn_2 """
		select id, kdt DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_TinyInt_3 """
		select id, kdt & ktint, kdt | ktint, kdt ^ ktint from expr_test order by id"""
	qt_sql_test_Date_TinyInt_notn_3 """
		select id, kdt & ktint, kdt | ktint, kdt ^ ktint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_TinyInt_4 """
		select id, BITAND(kdt, ktint), BITOR(kdt, ktint), BITXOR(kdt, ktint) from expr_test order by id"""
	qt_sql_test_Date_TinyInt_notn_4 """
		select id, BITAND(kdt, ktint), BITOR(kdt, ktint), BITXOR(kdt, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_SmallInt_0 """
		select id, kdt + ksint, kdt - ksint from expr_test order by id"""
	qt_sql_test_Date_SmallInt_notn_0 """
		select id, kdt + ksint, kdt - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_SmallInt_1 """
		select id, kdt * ksint, kdt / ksint, kdt % ksint from expr_test order by id"""
	qt_sql_test_Date_SmallInt_notn_1 """
		select id, kdt * ksint, kdt / ksint, kdt % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_SmallInt_2 """
		select id, kdt DIV ksint from expr_test order by id"""
	qt_sql_test_Date_SmallInt_notn_2 """
		select id, kdt DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_SmallInt_3 """
		select id, kdt & ksint, kdt | ksint, kdt ^ ksint from expr_test order by id"""
	qt_sql_test_Date_SmallInt_notn_3 """
		select id, kdt & ksint, kdt | ksint, kdt ^ ksint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_SmallInt_4 """
		select id, BITAND(kdt, ksint), BITOR(kdt, ksint), BITXOR(kdt, ksint) from expr_test order by id"""
	qt_sql_test_Date_SmallInt_notn_4 """
		select id, BITAND(kdt, ksint), BITOR(kdt, ksint), BITXOR(kdt, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Integer_0 """
		select id, kdt + kint, kdt - kint from expr_test order by id"""
	qt_sql_test_Date_Integer_notn_0 """
		select id, kdt + kint, kdt - kint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Integer_1 """
		select id, kdt * kint, kdt / kint, kdt % kint from expr_test order by id"""
	qt_sql_test_Date_Integer_notn_1 """
		select id, kdt * kint, kdt / kint, kdt % kint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Integer_2 """
		select id, kdt DIV kint from expr_test order by id"""
	qt_sql_test_Date_Integer_notn_2 """
		select id, kdt DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Integer_3 """
		select id, kdt & kint, kdt | kint, kdt ^ kint from expr_test order by id"""
	qt_sql_test_Date_Integer_notn_3 """
		select id, kdt & kint, kdt | kint, kdt ^ kint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Integer_4 """
		select id, BITAND(kdt, kint), BITOR(kdt, kint), BITXOR(kdt, kint) from expr_test order by id"""
	qt_sql_test_Date_Integer_notn_4 """
		select id, BITAND(kdt, kint), BITOR(kdt, kint), BITXOR(kdt, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_BigInt_0 """
		select id, kdt + kbint, kdt - kbint from expr_test order by id"""
	qt_sql_test_Date_BigInt_notn_0 """
		select id, kdt + kbint, kdt - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_BigInt_1 """
		select id, kdt * kbint, kdt / kbint, kdt % kbint from expr_test order by id"""
	qt_sql_test_Date_BigInt_notn_1 """
		select id, kdt * kbint, kdt / kbint, kdt % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_BigInt_2 """
		select id, kdt DIV kbint from expr_test order by id"""
	qt_sql_test_Date_BigInt_notn_2 """
		select id, kdt DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_BigInt_3 """
		select id, kdt & kbint, kdt | kbint, kdt ^ kbint from expr_test order by id"""
	qt_sql_test_Date_BigInt_notn_3 """
		select id, kdt & kbint, kdt | kbint, kdt ^ kbint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_BigInt_4 """
		select id, BITAND(kdt, kbint), BITOR(kdt, kbint), BITXOR(kdt, kbint) from expr_test order by id"""
	qt_sql_test_Date_BigInt_notn_4 """
		select id, BITAND(kdt, kbint), BITOR(kdt, kbint), BITXOR(kdt, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_LargeInt_0 """
		select id, kdt + klint, kdt - klint from expr_test order by id"""
	qt_sql_test_Date_LargeInt_notn_0 """
		select id, kdt + klint, kdt - klint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_LargeInt_1 """
		select id, kdt * klint, kdt / klint, kdt % klint from expr_test order by id"""
	qt_sql_test_Date_LargeInt_notn_1 """
		select id, kdt * klint, kdt / klint, kdt % klint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Date_LargeInt_2 """
	//original planner  	select id, kdt DIV klint from expr_test order by id"""
	//original planner  qt_sql_test_Date_LargeInt_notn_2 """
	//original planner  	select id, kdt DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_LargeInt_3 """
		select id, kdt & klint, kdt | klint, kdt ^ klint from expr_test order by id"""
	qt_sql_test_Date_LargeInt_notn_3 """
		select id, kdt & klint, kdt | klint, kdt ^ klint from expr_test_not_nullable order by id"""
	qt_sql_test_Date_LargeInt_4 """
		select id, BITAND(kdt, klint), BITOR(kdt, klint), BITXOR(kdt, klint) from expr_test order by id"""
	qt_sql_test_Date_LargeInt_notn_4 """
		select id, BITAND(kdt, klint), BITOR(kdt, klint), BITXOR(kdt, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Float_0 """
		select id, kdt + kfloat, kdt - kfloat from expr_test order by id"""
	qt_sql_test_Date_Float_notn_0 """
		select id, kdt + kfloat, kdt - kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_Date_Float_1 """
	// 	select id, kdt * kfloat, kdt / kfloat, kdt % kfloat from expr_test order by id"""
	// qt_sql_test_Date_Float_notn_1 """
	// 	select id, kdt * kfloat, kdt / kfloat, kdt % kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Float_2 """
		select id, kdt DIV kfloat from expr_test order by id"""
	qt_sql_test_Date_Float_notn_2 """
		select id, kdt DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Float_3 """
		select id, kdt & kfloat, kdt | kfloat, kdt ^ kfloat from expr_test order by id"""
	qt_sql_test_Date_Float_notn_3 """
		select id, kdt & kfloat, kdt | kfloat, kdt ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_Date_Float_4 """
	// 	select id, BITAND(kdt, kfloat), BITOR(kdt, kfloat), BITXOR(kdt, kfloat) from expr_test order by id"""
	// qt_sql_test_Date_Float_notn_4 """
	// 	select id, BITAND(kdt, kfloat), BITOR(kdt, kfloat), BITXOR(kdt, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Double_0 """
		select id, kdt + kdbl, kdt - kdbl from expr_test order by id"""
	qt_sql_test_Date_Double_notn_0 """
		select id, kdt + kdbl, kdt - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Double_1 """
		select id, kdt * kdbl, kdt / kdbl, kdt % kdbl from expr_test order by id"""
	qt_sql_test_Date_Double_notn_1 """
		select id, kdt * kdbl, kdt / kdbl, kdt % kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Double_2 """
		select id, kdt DIV kdbl from expr_test order by id"""
	qt_sql_test_Date_Double_notn_2 """
		select id, kdt DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Double_3 """
		select id, kdt & kdbl, kdt | kdbl, kdt ^ kdbl from expr_test order by id"""
	qt_sql_test_Date_Double_notn_3 """
		select id, kdt & kdbl, kdt | kdbl, kdt ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_Date_Double_4 """
	// 	select id, BITAND(kdt, kdbl), BITOR(kdt, kdbl), BITXOR(kdt, kdbl) from expr_test order by id"""
	// qt_sql_test_Date_Double_notn_4 """
	// 	select id, BITAND(kdt, kdbl), BITOR(kdt, kdbl), BITXOR(kdt, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DecimalV2_0 """
		select id, kdt + kdcml, kdt - kdcml from expr_test order by id"""
	qt_sql_test_Date_DecimalV2_notn_0 """
		select id, kdt + kdcml, kdt - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DecimalV2_1 """
		select id, kdt * kdcml, kdt / kdcml, kdt % kdcml from expr_test order by id"""
	qt_sql_test_Date_DecimalV2_notn_1 """
		select id, kdt * kdcml, kdt / kdcml, kdt % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DecimalV2_2 """
		select id, kdt DIV kdcml from expr_test order by id"""
	qt_sql_test_Date_DecimalV2_notn_2 """
		select id, kdt DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DecimalV2_3 """
		select id, kdt & kdcml, kdt | kdcml, kdt ^ kdcml from expr_test order by id"""
	qt_sql_test_Date_DecimalV2_notn_3 """
		select id, kdt & kdcml, kdt | kdcml, kdt ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_Date_DecimalV2_4 """
	// 	select id, BITAND(kdt, kdcml), BITOR(kdt, kdcml), BITXOR(kdt, kdcml) from expr_test order by id"""
	// qt_sql_test_Date_DecimalV2_notn_4 """
	// 	select id, BITAND(kdt, kdcml), BITOR(kdt, kdcml), BITXOR(kdt, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Decimal32V3_0 """
		select id, kdt + kdcml32v3, kdt - kdcml32v3 from expr_test order by id"""
	qt_sql_test_Date_Decimal32V3_notn_0 """
		select id, kdt + kdcml32v3, kdt - kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Date_Decimal32V3_1 """
	//original planner  	select id, kdt * kdcml32v3, kdt / kdcml32v3, kdt % kdcml32v3 from expr_test order by id"""
	//original planner  qt_sql_test_Date_Decimal32V3_notn_1 """
	//original planner  	select id, kdt * kdcml32v3, kdt / kdcml32v3, kdt % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Decimal32V3_2 """
		select id, kdt DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_Date_Decimal32V3_notn_2 """
		select id, kdt DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Decimal32V3_3 """
		select id, kdt & kdcml32v3, kdt | kdcml32v3, kdt ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_Date_Decimal32V3_notn_3 """
		select id, kdt & kdcml32v3, kdt | kdcml32v3, kdt ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Date_Decimal32V3_4 """
	// 	select id, BITAND(kdt, kdcml32v3), BITOR(kdt, kdcml32v3), BITXOR(kdt, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_Date_Decimal32V3_notn_4 """
	// 	select id, BITAND(kdt, kdcml32v3), BITOR(kdt, kdcml32v3), BITXOR(kdt, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Decimal64V3_0 """
		select id, kdt + kdcml64v3, kdt - kdcml64v3 from expr_test order by id"""
	qt_sql_test_Date_Decimal64V3_notn_0 """
		select id, kdt + kdcml64v3, kdt - kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Date_Decimal64V3_1 """
	//original planner  	select id, kdt * kdcml64v3, kdt / kdcml64v3, kdt % kdcml64v3 from expr_test order by id"""
	//original planner  qt_sql_test_Date_Decimal64V3_notn_1 """
	//original planner  	select id, kdt * kdcml64v3, kdt / kdcml64v3, kdt % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Decimal64V3_2 """
		select id, kdt DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_Date_Decimal64V3_notn_2 """
		select id, kdt DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Decimal64V3_3 """
		select id, kdt & kdcml64v3, kdt | kdcml64v3, kdt ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_Date_Decimal64V3_notn_3 """
		select id, kdt & kdcml64v3, kdt | kdcml64v3, kdt ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Date_Decimal64V3_4 """
	// 	select id, BITAND(kdt, kdcml64v3), BITOR(kdt, kdcml64v3), BITXOR(kdt, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_Date_Decimal64V3_notn_4 """
	// 	select id, BITAND(kdt, kdcml64v3), BITOR(kdt, kdcml64v3), BITXOR(kdt, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Decimal128V3_0 """
		select id, kdt + kdcml128v3, kdt - kdcml128v3 from expr_test order by id"""
	qt_sql_test_Date_Decimal128V3_notn_0 """
		select id, kdt + kdcml128v3, kdt - kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_Date_Decimal128V3_1 """
	//original planner  	select id, kdt * kdcml128v3, kdt / kdcml128v3, kdt % kdcml128v3 from expr_test order by id"""
	//original planner  qt_sql_test_Date_Decimal128V3_notn_1 """
	//original planner  	select id, kdt * kdcml128v3, kdt / kdcml128v3, kdt % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Decimal128V3_2 """
		select id, kdt DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_Date_Decimal128V3_notn_2 """
		select id, kdt DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Decimal128V3_3 """
		select id, kdt & kdcml128v3, kdt | kdcml128v3, kdt ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_Date_Decimal128V3_notn_3 """
		select id, kdt & kdcml128v3, kdt | kdcml128v3, kdt ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_Date_Decimal128V3_4 """
	// 	select id, BITAND(kdt, kdcml128v3), BITOR(kdt, kdcml128v3), BITXOR(kdt, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_Date_Decimal128V3_notn_4 """
	// 	select id, BITAND(kdt, kdcml128v3), BITOR(kdt, kdcml128v3), BITXOR(kdt, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Char_0 """
		select id, kdt + kchr, kdt - kchr from expr_test order by id"""
	qt_sql_test_Date_Char_notn_0 """
		select id, kdt + kchr, kdt - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Char_1 """
		select id, kdt * kchr, kdt / kchr, kdt % kchr from expr_test order by id"""
	qt_sql_test_Date_Char_notn_1 """
		select id, kdt * kchr, kdt / kchr, kdt % kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Char_2 """
		select id, kdt DIV kchr from expr_test order by id"""
	qt_sql_test_Date_Char_notn_2 """
		select id, kdt DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Char_3 """
		select id, kdt & kchr, kdt | kchr, kdt ^ kchr from expr_test order by id"""
	qt_sql_test_Date_Char_notn_3 """
		select id, kdt & kchr, kdt | kchr, kdt ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Date_Char_4 """
	// 	select id, BITAND(kdt, kchr), BITOR(kdt, kchr), BITXOR(kdt, kchr) from expr_test order by id"""
	// qt_sql_test_Date_Char_notn_4 """
	// 	select id, BITAND(kdt, kchr), BITOR(kdt, kchr), BITXOR(kdt, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Varchar_0 """
		select id, kdt + kvchr, kdt - kvchr from expr_test order by id"""
	qt_sql_test_Date_Varchar_notn_0 """
		select id, kdt + kvchr, kdt - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Varchar_1 """
		select id, kdt * kvchr, kdt / kvchr, kdt % kvchr from expr_test order by id"""
	qt_sql_test_Date_Varchar_notn_1 """
		select id, kdt * kvchr, kdt / kvchr, kdt % kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Varchar_2 """
		select id, kdt DIV kvchr from expr_test order by id"""
	qt_sql_test_Date_Varchar_notn_2 """
		select id, kdt DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Varchar_3 """
		select id, kdt & kvchr, kdt | kvchr, kdt ^ kvchr from expr_test order by id"""
	qt_sql_test_Date_Varchar_notn_3 """
		select id, kdt & kvchr, kdt | kvchr, kdt ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_Date_Varchar_4 """
	// 	select id, BITAND(kdt, kvchr), BITOR(kdt, kvchr), BITXOR(kdt, kvchr) from expr_test order by id"""
	// qt_sql_test_Date_Varchar_notn_4 """
	// 	select id, BITAND(kdt, kvchr), BITOR(kdt, kvchr), BITXOR(kdt, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_String_0 """
		select id, kdt + kstr, kdt - kstr from expr_test order by id"""
	qt_sql_test_Date_String_notn_0 """
		select id, kdt + kstr, kdt - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Date_String_1 """
		select id, kdt * kstr, kdt / kstr, kdt % kstr from expr_test order by id"""
	qt_sql_test_Date_String_notn_1 """
		select id, kdt * kstr, kdt / kstr, kdt % kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Date_String_2 """
		select id, kdt DIV kstr from expr_test order by id"""
	qt_sql_test_Date_String_notn_2 """
		select id, kdt DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_Date_String_3 """
		select id, kdt & kstr, kdt | kstr, kdt ^ kstr from expr_test order by id"""
	qt_sql_test_Date_String_notn_3 """
		select id, kdt & kstr, kdt | kstr, kdt ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_Date_String_4 """
	// 	select id, BITAND(kdt, kstr), BITOR(kdt, kstr), BITXOR(kdt, kstr) from expr_test order by id"""
	// qt_sql_test_Date_String_notn_4 """
	// 	select id, BITAND(kdt, kstr), BITOR(kdt, kstr), BITXOR(kdt, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Date_0 """
		select id, kdt + kdt, kdt - kdt from expr_test order by id"""
	qt_sql_test_Date_Date_notn_0 """
		select id, kdt + kdt, kdt - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Date_1 """
		select id, kdt * kdt, kdt / kdt, kdt % kdt from expr_test order by id"""
	qt_sql_test_Date_Date_notn_1 """
		select id, kdt * kdt, kdt / kdt, kdt % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Date_2 """
		select id, kdt DIV kdt from expr_test order by id"""
	qt_sql_test_Date_Date_notn_2 """
		select id, kdt DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Date_3 """
		select id, kdt & kdt, kdt | kdt, kdt ^ kdt from expr_test order by id"""
	qt_sql_test_Date_Date_notn_3 """
		select id, kdt & kdt, kdt | kdt, kdt ^ kdt from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Date_4 """
		select id, BITAND(kdt, kdt), BITOR(kdt, kdt), BITXOR(kdt, kdt) from expr_test order by id"""
	qt_sql_test_Date_Date_notn_4 """
		select id, BITAND(kdt, kdt), BITOR(kdt, kdt), BITXOR(kdt, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateTime_0 """
		select id, kdt + kdtm, kdt - kdtm from expr_test order by id"""
	qt_sql_test_Date_DateTime_notn_0 """
		select id, kdt + kdtm, kdt - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateTime_1 """
		select id, kdt * kdtm, kdt / kdtm, kdt % kdtm from expr_test order by id"""
	qt_sql_test_Date_DateTime_notn_1 """
		select id, kdt * kdtm, kdt / kdtm, kdt % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateTime_2 """
		select id, kdt DIV kdtm from expr_test order by id"""
	qt_sql_test_Date_DateTime_notn_2 """
		select id, kdt DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateTime_3 """
		select id, kdt & kdtm, kdt | kdtm, kdt ^ kdtm from expr_test order by id"""
	qt_sql_test_Date_DateTime_notn_3 """
		select id, kdt & kdtm, kdt | kdtm, kdt ^ kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateTime_4 """
		select id, BITAND(kdt, kdtm), BITOR(kdt, kdtm), BITXOR(kdt, kdtm) from expr_test order by id"""
	qt_sql_test_Date_DateTime_notn_4 """
		select id, BITAND(kdt, kdtm), BITOR(kdt, kdtm), BITXOR(kdt, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateV2_0 """
		select id, kdt + kdtv2, kdt - kdtv2 from expr_test order by id"""
	qt_sql_test_Date_DateV2_notn_0 """
		select id, kdt + kdtv2, kdt - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateV2_1 """
		select id, kdt * kdtv2, kdt / kdtv2, kdt % kdtv2 from expr_test order by id"""
	qt_sql_test_Date_DateV2_notn_1 """
		select id, kdt * kdtv2, kdt / kdtv2, kdt % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateV2_2 """
		select id, kdt DIV kdtv2 from expr_test order by id"""
	qt_sql_test_Date_DateV2_notn_2 """
		select id, kdt DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateV2_3 """
		select id, kdt & kdtv2, kdt | kdtv2, kdt ^ kdtv2 from expr_test order by id"""
	qt_sql_test_Date_DateV2_notn_3 """
		select id, kdt & kdtv2, kdt | kdtv2, kdt ^ kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateV2_4 """
		select id, BITAND(kdt, kdtv2), BITOR(kdt, kdtv2), BITXOR(kdt, kdtv2) from expr_test order by id"""
	qt_sql_test_Date_DateV2_notn_4 """
		select id, BITAND(kdt, kdtv2), BITOR(kdt, kdtv2), BITXOR(kdt, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateTimeV2_0 """
		select id, kdt + kdtmv2, kdt - kdtmv2 from expr_test order by id"""
	qt_sql_test_Date_DateTimeV2_notn_0 """
		select id, kdt + kdtmv2, kdt - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateTimeV2_1 """
		select id, kdt * kdtmv2, kdt / kdtmv2, kdt % kdtmv2 from expr_test order by id"""
	qt_sql_test_Date_DateTimeV2_notn_1 """
		select id, kdt * kdtmv2, kdt / kdtmv2, kdt % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateTimeV2_2 """
		select id, kdt DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_Date_DateTimeV2_notn_2 """
		select id, kdt DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateTimeV2_3 """
		select id, kdt & kdtmv2, kdt | kdtmv2, kdt ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_Date_DateTimeV2_notn_3 """
		select id, kdt & kdtmv2, kdt | kdtmv2, kdt ^ kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_Date_DateTimeV2_4 """
		select id, BITAND(kdt, kdtmv2), BITOR(kdt, kdtmv2), BITXOR(kdt, kdtmv2) from expr_test order by id"""
	qt_sql_test_Date_DateTimeV2_notn_4 """
		select id, BITAND(kdt, kdtmv2), BITOR(kdt, kdtmv2), BITXOR(kdt, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Boolean_0 """
		select id, kdt + kbool, kdt - kbool from expr_test order by id"""
	qt_sql_test_Date_Boolean_notn_0 """
		select id, kdt + kbool, kdt - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Boolean_1 """
		select id, kdt * kbool, kdt / kbool, kdt % kbool from expr_test order by id"""
	qt_sql_test_Date_Boolean_notn_1 """
		select id, kdt * kbool, kdt / kbool, kdt % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Boolean_2 """
		select id, kdt DIV kbool from expr_test order by id"""
	qt_sql_test_Date_Boolean_notn_2 """
		select id, kdt DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Boolean_3 """
		select id, kdt & kbool, kdt | kbool, kdt ^ kbool from expr_test order by id"""
	qt_sql_test_Date_Boolean_notn_3 """
		select id, kdt & kbool, kdt | kbool, kdt ^ kbool from expr_test_not_nullable order by id"""
	qt_sql_test_Date_Boolean_4 """
		select id, BITAND(kdt, kbool), BITOR(kdt, kbool), BITXOR(kdt, kbool) from expr_test order by id"""
	qt_sql_test_Date_Boolean_notn_4 """
		select id, BITAND(kdt, kbool), BITOR(kdt, kbool), BITXOR(kdt, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_TinyInt_0 """
		select id, kdtm + ktint, kdtm - ktint from expr_test order by id"""
	qt_sql_test_DateTime_TinyInt_notn_0 """
		select id, kdtm + ktint, kdtm - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_TinyInt_1 """
		select id, kdtm * ktint, kdtm / ktint, kdtm % ktint from expr_test order by id"""
	qt_sql_test_DateTime_TinyInt_notn_1 """
		select id, kdtm * ktint, kdtm / ktint, kdtm % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_TinyInt_2 """
		select id, kdtm DIV ktint from expr_test order by id"""
	qt_sql_test_DateTime_TinyInt_notn_2 """
		select id, kdtm DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_TinyInt_3 """
		select id, kdtm & ktint, kdtm | ktint, kdtm ^ ktint from expr_test order by id"""
	qt_sql_test_DateTime_TinyInt_notn_3 """
		select id, kdtm & ktint, kdtm | ktint, kdtm ^ ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_TinyInt_4 """
		select id, BITAND(kdtm, ktint), BITOR(kdtm, ktint), BITXOR(kdtm, ktint) from expr_test order by id"""
	qt_sql_test_DateTime_TinyInt_notn_4 """
		select id, BITAND(kdtm, ktint), BITOR(kdtm, ktint), BITXOR(kdtm, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_SmallInt_0 """
		select id, kdtm + ksint, kdtm - ksint from expr_test order by id"""
	qt_sql_test_DateTime_SmallInt_notn_0 """
		select id, kdtm + ksint, kdtm - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_SmallInt_1 """
		select id, kdtm * ksint, kdtm / ksint, kdtm % ksint from expr_test order by id"""
	qt_sql_test_DateTime_SmallInt_notn_1 """
		select id, kdtm * ksint, kdtm / ksint, kdtm % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_SmallInt_2 """
		select id, kdtm DIV ksint from expr_test order by id"""
	qt_sql_test_DateTime_SmallInt_notn_2 """
		select id, kdtm DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_SmallInt_3 """
		select id, kdtm & ksint, kdtm | ksint, kdtm ^ ksint from expr_test order by id"""
	qt_sql_test_DateTime_SmallInt_notn_3 """
		select id, kdtm & ksint, kdtm | ksint, kdtm ^ ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_SmallInt_4 """
		select id, BITAND(kdtm, ksint), BITOR(kdtm, ksint), BITXOR(kdtm, ksint) from expr_test order by id"""
	qt_sql_test_DateTime_SmallInt_notn_4 """
		select id, BITAND(kdtm, ksint), BITOR(kdtm, ksint), BITXOR(kdtm, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Integer_0 """
		select id, kdtm + kint, kdtm - kint from expr_test order by id"""
	qt_sql_test_DateTime_Integer_notn_0 """
		select id, kdtm + kint, kdtm - kint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Integer_1 """
		select id, kdtm * kint, kdtm / kint, kdtm % kint from expr_test order by id"""
	qt_sql_test_DateTime_Integer_notn_1 """
		select id, kdtm * kint, kdtm / kint, kdtm % kint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Integer_2 """
		select id, kdtm DIV kint from expr_test order by id"""
	qt_sql_test_DateTime_Integer_notn_2 """
		select id, kdtm DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Integer_3 """
		select id, kdtm & kint, kdtm | kint, kdtm ^ kint from expr_test order by id"""
	qt_sql_test_DateTime_Integer_notn_3 """
		select id, kdtm & kint, kdtm | kint, kdtm ^ kint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Integer_4 """
		select id, BITAND(kdtm, kint), BITOR(kdtm, kint), BITXOR(kdtm, kint) from expr_test order by id"""
	qt_sql_test_DateTime_Integer_notn_4 """
		select id, BITAND(kdtm, kint), BITOR(kdtm, kint), BITXOR(kdtm, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_BigInt_0 """
		select id, kdtm + kbint, kdtm - kbint from expr_test order by id"""
	qt_sql_test_DateTime_BigInt_notn_0 """
		select id, kdtm + kbint, kdtm - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_BigInt_1 """
		select id, kdtm * kbint, kdtm / kbint, kdtm % kbint from expr_test order by id"""
	qt_sql_test_DateTime_BigInt_notn_1 """
		select id, kdtm * kbint, kdtm / kbint, kdtm % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_BigInt_2 """
		select id, kdtm DIV kbint from expr_test order by id"""
	qt_sql_test_DateTime_BigInt_notn_2 """
		select id, kdtm DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_BigInt_3 """
		select id, kdtm & kbint, kdtm | kbint, kdtm ^ kbint from expr_test order by id"""
	qt_sql_test_DateTime_BigInt_notn_3 """
		select id, kdtm & kbint, kdtm | kbint, kdtm ^ kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_BigInt_4 """
		select id, BITAND(kdtm, kbint), BITOR(kdtm, kbint), BITXOR(kdtm, kbint) from expr_test order by id"""
	qt_sql_test_DateTime_BigInt_notn_4 """
		select id, BITAND(kdtm, kbint), BITOR(kdtm, kbint), BITXOR(kdtm, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_LargeInt_0 """
		select id, kdtm + klint, kdtm - klint from expr_test order by id"""
	qt_sql_test_DateTime_LargeInt_notn_0 """
		select id, kdtm + klint, kdtm - klint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_LargeInt_1 """
		select id, kdtm * klint, kdtm / klint, kdtm % klint from expr_test order by id"""
	qt_sql_test_DateTime_LargeInt_notn_1 """
		select id, kdtm * klint, kdtm / klint, kdtm % klint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DateTime_LargeInt_2 """
	//original planner  	select id, kdtm DIV klint from expr_test order by id"""
	//original planner  qt_sql_test_DateTime_LargeInt_notn_2 """
	//original planner  	select id, kdtm DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_LargeInt_3 """
		select id, kdtm & klint, kdtm | klint, kdtm ^ klint from expr_test order by id"""
	qt_sql_test_DateTime_LargeInt_notn_3 """
		select id, kdtm & klint, kdtm | klint, kdtm ^ klint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_LargeInt_4 """
		select id, BITAND(kdtm, klint), BITOR(kdtm, klint), BITXOR(kdtm, klint) from expr_test order by id"""
	qt_sql_test_DateTime_LargeInt_notn_4 """
		select id, BITAND(kdtm, klint), BITOR(kdtm, klint), BITXOR(kdtm, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Float_0 """
		select id, kdtm + kfloat, kdtm - kfloat from expr_test order by id"""
	qt_sql_test_DateTime_Float_notn_0 """
		select id, kdtm + kfloat, kdtm - kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTime_Float_1 """
	// 	select id, kdtm * kfloat, kdtm / kfloat, kdtm % kfloat from expr_test order by id"""
	// qt_sql_test_DateTime_Float_notn_1 """
	// 	select id, kdtm * kfloat, kdtm / kfloat, kdtm % kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Float_2 """
		select id, kdtm DIV kfloat from expr_test order by id"""
	qt_sql_test_DateTime_Float_notn_2 """
		select id, kdtm DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Float_3 """
		select id, kdtm & kfloat, kdtm | kfloat, kdtm ^ kfloat from expr_test order by id"""
	qt_sql_test_DateTime_Float_notn_3 """
		select id, kdtm & kfloat, kdtm | kfloat, kdtm ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTime_Float_4 """
	// 	select id, BITAND(kdtm, kfloat), BITOR(kdtm, kfloat), BITXOR(kdtm, kfloat) from expr_test order by id"""
	// qt_sql_test_DateTime_Float_notn_4 """
	// 	select id, BITAND(kdtm, kfloat), BITOR(kdtm, kfloat), BITXOR(kdtm, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Double_0 """
		select id, kdtm + kdbl, kdtm - kdbl from expr_test order by id"""
	qt_sql_test_DateTime_Double_notn_0 """
		select id, kdtm + kdbl, kdtm - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Double_1 """
		select id, kdtm * kdbl, kdtm / kdbl, kdtm % kdbl from expr_test order by id"""
	qt_sql_test_DateTime_Double_notn_1 """
		select id, kdtm * kdbl, kdtm / kdbl, kdtm % kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Double_2 """
		select id, kdtm DIV kdbl from expr_test order by id"""
	qt_sql_test_DateTime_Double_notn_2 """
		select id, kdtm DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Double_3 """
		select id, kdtm & kdbl, kdtm | kdbl, kdtm ^ kdbl from expr_test order by id"""
	qt_sql_test_DateTime_Double_notn_3 """
		select id, kdtm & kdbl, kdtm | kdbl, kdtm ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTime_Double_4 """
	// 	select id, BITAND(kdtm, kdbl), BITOR(kdtm, kdbl), BITXOR(kdtm, kdbl) from expr_test order by id"""
	// qt_sql_test_DateTime_Double_notn_4 """
	// 	select id, BITAND(kdtm, kdbl), BITOR(kdtm, kdbl), BITXOR(kdtm, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DecimalV2_0 """
		select id, kdtm + kdcml, kdtm - kdcml from expr_test order by id"""
	qt_sql_test_DateTime_DecimalV2_notn_0 """
		select id, kdtm + kdcml, kdtm - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DecimalV2_1 """
		select id, kdtm * kdcml, kdtm / kdcml, kdtm % kdcml from expr_test order by id"""
	qt_sql_test_DateTime_DecimalV2_notn_1 """
		select id, kdtm * kdcml, kdtm / kdcml, kdtm % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DecimalV2_2 """
		select id, kdtm DIV kdcml from expr_test order by id"""
	qt_sql_test_DateTime_DecimalV2_notn_2 """
		select id, kdtm DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DecimalV2_3 """
		select id, kdtm & kdcml, kdtm | kdcml, kdtm ^ kdcml from expr_test order by id"""
	qt_sql_test_DateTime_DecimalV2_notn_3 """
		select id, kdtm & kdcml, kdtm | kdcml, kdtm ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTime_DecimalV2_4 """
	// 	select id, BITAND(kdtm, kdcml), BITOR(kdtm, kdcml), BITXOR(kdtm, kdcml) from expr_test order by id"""
	// qt_sql_test_DateTime_DecimalV2_notn_4 """
	// 	select id, BITAND(kdtm, kdcml), BITOR(kdtm, kdcml), BITXOR(kdtm, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Decimal32V3_0 """
		select id, kdtm + kdcml32v3, kdtm - kdcml32v3 from expr_test order by id"""
	qt_sql_test_DateTime_Decimal32V3_notn_0 """
		select id, kdtm + kdcml32v3, kdtm - kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DateTime_Decimal32V3_1 """
	//original planner  	select id, kdtm * kdcml32v3, kdtm / kdcml32v3, kdtm % kdcml32v3 from expr_test order by id"""
	//original planner  qt_sql_test_DateTime_Decimal32V3_notn_1 """
	//original planner  	select id, kdtm * kdcml32v3, kdtm / kdcml32v3, kdtm % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Decimal32V3_2 """
		select id, kdtm DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_DateTime_Decimal32V3_notn_2 """
		select id, kdtm DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Decimal32V3_3 """
		select id, kdtm & kdcml32v3, kdtm | kdcml32v3, kdtm ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_DateTime_Decimal32V3_notn_3 """
		select id, kdtm & kdcml32v3, kdtm | kdcml32v3, kdtm ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTime_Decimal32V3_4 """
	// 	select id, BITAND(kdtm, kdcml32v3), BITOR(kdtm, kdcml32v3), BITXOR(kdtm, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_DateTime_Decimal32V3_notn_4 """
	// 	select id, BITAND(kdtm, kdcml32v3), BITOR(kdtm, kdcml32v3), BITXOR(kdtm, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Decimal64V3_0 """
		select id, kdtm + kdcml64v3, kdtm - kdcml64v3 from expr_test order by id"""
	qt_sql_test_DateTime_Decimal64V3_notn_0 """
		select id, kdtm + kdcml64v3, kdtm - kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DateTime_Decimal64V3_1 """
	//original planner  	select id, kdtm * kdcml64v3, kdtm / kdcml64v3, kdtm % kdcml64v3 from expr_test order by id"""
	//original planner  qt_sql_test_DateTime_Decimal64V3_notn_1 """
	//original planner  	select id, kdtm * kdcml64v3, kdtm / kdcml64v3, kdtm % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Decimal64V3_2 """
		select id, kdtm DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_DateTime_Decimal64V3_notn_2 """
		select id, kdtm DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Decimal64V3_3 """
		select id, kdtm & kdcml64v3, kdtm | kdcml64v3, kdtm ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_DateTime_Decimal64V3_notn_3 """
		select id, kdtm & kdcml64v3, kdtm | kdcml64v3, kdtm ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTime_Decimal64V3_4 """
	// 	select id, BITAND(kdtm, kdcml64v3), BITOR(kdtm, kdcml64v3), BITXOR(kdtm, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_DateTime_Decimal64V3_notn_4 """
	// 	select id, BITAND(kdtm, kdcml64v3), BITOR(kdtm, kdcml64v3), BITXOR(kdtm, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Decimal128V3_0 """
		select id, kdtm + kdcml128v3, kdtm - kdcml128v3 from expr_test order by id"""
	qt_sql_test_DateTime_Decimal128V3_notn_0 """
		select id, kdtm + kdcml128v3, kdtm - kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DateTime_Decimal128V3_1 """
	//original planner  	select id, kdtm * kdcml128v3, kdtm / kdcml128v3, kdtm % kdcml128v3 from expr_test order by id"""
	//original planner  qt_sql_test_DateTime_Decimal128V3_notn_1 """
	//original planner  	select id, kdtm * kdcml128v3, kdtm / kdcml128v3, kdtm % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Decimal128V3_2 """
		select id, kdtm DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_DateTime_Decimal128V3_notn_2 """
		select id, kdtm DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Decimal128V3_3 """
		select id, kdtm & kdcml128v3, kdtm | kdcml128v3, kdtm ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_DateTime_Decimal128V3_notn_3 """
		select id, kdtm & kdcml128v3, kdtm | kdcml128v3, kdtm ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTime_Decimal128V3_4 """
	// 	select id, BITAND(kdtm, kdcml128v3), BITOR(kdtm, kdcml128v3), BITXOR(kdtm, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_DateTime_Decimal128V3_notn_4 """
	// 	select id, BITAND(kdtm, kdcml128v3), BITOR(kdtm, kdcml128v3), BITXOR(kdtm, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Char_0 """
		select id, kdtm + kchr, kdtm - kchr from expr_test order by id"""
	qt_sql_test_DateTime_Char_notn_0 """
		select id, kdtm + kchr, kdtm - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Char_1 """
		select id, kdtm * kchr, kdtm / kchr, kdtm % kchr from expr_test order by id"""
	qt_sql_test_DateTime_Char_notn_1 """
		select id, kdtm * kchr, kdtm / kchr, kdtm % kchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Char_2 """
		select id, kdtm DIV kchr from expr_test order by id"""
	qt_sql_test_DateTime_Char_notn_2 """
		select id, kdtm DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Char_3 """
		select id, kdtm & kchr, kdtm | kchr, kdtm ^ kchr from expr_test order by id"""
	qt_sql_test_DateTime_Char_notn_3 """
		select id, kdtm & kchr, kdtm | kchr, kdtm ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTime_Char_4 """
	// 	select id, BITAND(kdtm, kchr), BITOR(kdtm, kchr), BITXOR(kdtm, kchr) from expr_test order by id"""
	// qt_sql_test_DateTime_Char_notn_4 """
	// 	select id, BITAND(kdtm, kchr), BITOR(kdtm, kchr), BITXOR(kdtm, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Varchar_0 """
		select id, kdtm + kvchr, kdtm - kvchr from expr_test order by id"""
	qt_sql_test_DateTime_Varchar_notn_0 """
		select id, kdtm + kvchr, kdtm - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Varchar_1 """
		select id, kdtm * kvchr, kdtm / kvchr, kdtm % kvchr from expr_test order by id"""
	qt_sql_test_DateTime_Varchar_notn_1 """
		select id, kdtm * kvchr, kdtm / kvchr, kdtm % kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Varchar_2 """
		select id, kdtm DIV kvchr from expr_test order by id"""
	qt_sql_test_DateTime_Varchar_notn_2 """
		select id, kdtm DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Varchar_3 """
		select id, kdtm & kvchr, kdtm | kvchr, kdtm ^ kvchr from expr_test order by id"""
	qt_sql_test_DateTime_Varchar_notn_3 """
		select id, kdtm & kvchr, kdtm | kvchr, kdtm ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTime_Varchar_4 """
	// 	select id, BITAND(kdtm, kvchr), BITOR(kdtm, kvchr), BITXOR(kdtm, kvchr) from expr_test order by id"""
	// qt_sql_test_DateTime_Varchar_notn_4 """
	// 	select id, BITAND(kdtm, kvchr), BITOR(kdtm, kvchr), BITXOR(kdtm, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_String_0 """
		select id, kdtm + kstr, kdtm - kstr from expr_test order by id"""
	qt_sql_test_DateTime_String_notn_0 """
		select id, kdtm + kstr, kdtm - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_String_1 """
		select id, kdtm * kstr, kdtm / kstr, kdtm % kstr from expr_test order by id"""
	qt_sql_test_DateTime_String_notn_1 """
		select id, kdtm * kstr, kdtm / kstr, kdtm % kstr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_String_2 """
		select id, kdtm DIV kstr from expr_test order by id"""
	qt_sql_test_DateTime_String_notn_2 """
		select id, kdtm DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_String_3 """
		select id, kdtm & kstr, kdtm | kstr, kdtm ^ kstr from expr_test order by id"""
	qt_sql_test_DateTime_String_notn_3 """
		select id, kdtm & kstr, kdtm | kstr, kdtm ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTime_String_4 """
	// 	select id, BITAND(kdtm, kstr), BITOR(kdtm, kstr), BITXOR(kdtm, kstr) from expr_test order by id"""
	// qt_sql_test_DateTime_String_notn_4 """
	// 	select id, BITAND(kdtm, kstr), BITOR(kdtm, kstr), BITXOR(kdtm, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Date_0 """
		select id, kdtm + kdt, kdtm - kdt from expr_test order by id"""
	qt_sql_test_DateTime_Date_notn_0 """
		select id, kdtm + kdt, kdtm - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Date_1 """
		select id, kdtm * kdt, kdtm / kdt, kdtm % kdt from expr_test order by id"""
	qt_sql_test_DateTime_Date_notn_1 """
		select id, kdtm * kdt, kdtm / kdt, kdtm % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Date_2 """
		select id, kdtm DIV kdt from expr_test order by id"""
	qt_sql_test_DateTime_Date_notn_2 """
		select id, kdtm DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Date_3 """
		select id, kdtm & kdt, kdtm | kdt, kdtm ^ kdt from expr_test order by id"""
	qt_sql_test_DateTime_Date_notn_3 """
		select id, kdtm & kdt, kdtm | kdt, kdtm ^ kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Date_4 """
		select id, BITAND(kdtm, kdt), BITOR(kdtm, kdt), BITXOR(kdtm, kdt) from expr_test order by id"""
	qt_sql_test_DateTime_Date_notn_4 """
		select id, BITAND(kdtm, kdt), BITOR(kdtm, kdt), BITXOR(kdtm, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateTime_0 """
		select id, kdtm + kdtm, kdtm - kdtm from expr_test order by id"""
	qt_sql_test_DateTime_DateTime_notn_0 """
		select id, kdtm + kdtm, kdtm - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateTime_1 """
		select id, kdtm * kdtm, kdtm / kdtm, kdtm % kdtm from expr_test order by id"""
	qt_sql_test_DateTime_DateTime_notn_1 """
		select id, kdtm * kdtm, kdtm / kdtm, kdtm % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateTime_2 """
		select id, kdtm DIV kdtm from expr_test order by id"""
	qt_sql_test_DateTime_DateTime_notn_2 """
		select id, kdtm DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateTime_3 """
		select id, kdtm & kdtm, kdtm | kdtm, kdtm ^ kdtm from expr_test order by id"""
	qt_sql_test_DateTime_DateTime_notn_3 """
		select id, kdtm & kdtm, kdtm | kdtm, kdtm ^ kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateTime_4 """
		select id, BITAND(kdtm, kdtm), BITOR(kdtm, kdtm), BITXOR(kdtm, kdtm) from expr_test order by id"""
	qt_sql_test_DateTime_DateTime_notn_4 """
		select id, BITAND(kdtm, kdtm), BITOR(kdtm, kdtm), BITXOR(kdtm, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateV2_0 """
		select id, kdtm + kdtv2, kdtm - kdtv2 from expr_test order by id"""
	qt_sql_test_DateTime_DateV2_notn_0 """
		select id, kdtm + kdtv2, kdtm - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateV2_1 """
		select id, kdtm * kdtv2, kdtm / kdtv2, kdtm % kdtv2 from expr_test order by id"""
	qt_sql_test_DateTime_DateV2_notn_1 """
		select id, kdtm * kdtv2, kdtm / kdtv2, kdtm % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateV2_2 """
		select id, kdtm DIV kdtv2 from expr_test order by id"""
	qt_sql_test_DateTime_DateV2_notn_2 """
		select id, kdtm DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateV2_3 """
		select id, kdtm & kdtv2, kdtm | kdtv2, kdtm ^ kdtv2 from expr_test order by id"""
	qt_sql_test_DateTime_DateV2_notn_3 """
		select id, kdtm & kdtv2, kdtm | kdtv2, kdtm ^ kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateV2_4 """
		select id, BITAND(kdtm, kdtv2), BITOR(kdtm, kdtv2), BITXOR(kdtm, kdtv2) from expr_test order by id"""
	qt_sql_test_DateTime_DateV2_notn_4 """
		select id, BITAND(kdtm, kdtv2), BITOR(kdtm, kdtv2), BITXOR(kdtm, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateTimeV2_0 """
		select id, kdtm + kdtmv2, kdtm - kdtmv2 from expr_test order by id"""
	qt_sql_test_DateTime_DateTimeV2_notn_0 """
		select id, kdtm + kdtmv2, kdtm - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateTimeV2_1 """
		select id, kdtm * kdtmv2, kdtm / kdtmv2, kdtm % kdtmv2 from expr_test order by id"""
	qt_sql_test_DateTime_DateTimeV2_notn_1 """
		select id, kdtm * kdtmv2, kdtm / kdtmv2, kdtm % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateTimeV2_2 """
		select id, kdtm DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_DateTime_DateTimeV2_notn_2 """
		select id, kdtm DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateTimeV2_3 """
		select id, kdtm & kdtmv2, kdtm | kdtmv2, kdtm ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_DateTime_DateTimeV2_notn_3 """
		select id, kdtm & kdtmv2, kdtm | kdtmv2, kdtm ^ kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_DateTimeV2_4 """
		select id, BITAND(kdtm, kdtmv2), BITOR(kdtm, kdtmv2), BITXOR(kdtm, kdtmv2) from expr_test order by id"""
	qt_sql_test_DateTime_DateTimeV2_notn_4 """
		select id, BITAND(kdtm, kdtmv2), BITOR(kdtm, kdtmv2), BITXOR(kdtm, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Boolean_0 """
		select id, kdtm + kbool, kdtm - kbool from expr_test order by id"""
	qt_sql_test_DateTime_Boolean_notn_0 """
		select id, kdtm + kbool, kdtm - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Boolean_1 """
		select id, kdtm * kbool, kdtm / kbool, kdtm % kbool from expr_test order by id"""
	qt_sql_test_DateTime_Boolean_notn_1 """
		select id, kdtm * kbool, kdtm / kbool, kdtm % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Boolean_2 """
		select id, kdtm DIV kbool from expr_test order by id"""
	qt_sql_test_DateTime_Boolean_notn_2 """
		select id, kdtm DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Boolean_3 """
		select id, kdtm & kbool, kdtm | kbool, kdtm ^ kbool from expr_test order by id"""
	qt_sql_test_DateTime_Boolean_notn_3 """
		select id, kdtm & kbool, kdtm | kbool, kdtm ^ kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DateTime_Boolean_4 """
		select id, BITAND(kdtm, kbool), BITOR(kdtm, kbool), BITXOR(kdtm, kbool) from expr_test order by id"""
	qt_sql_test_DateTime_Boolean_notn_4 """
		select id, BITAND(kdtm, kbool), BITOR(kdtm, kbool), BITXOR(kdtm, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_TinyInt_0 """
		select id, kdtv2 + ktint, kdtv2 - ktint from expr_test order by id"""
	qt_sql_test_DateV2_TinyInt_notn_0 """
		select id, kdtv2 + ktint, kdtv2 - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_TinyInt_1 """
		select id, kdtv2 * ktint, kdtv2 / ktint, kdtv2 % ktint from expr_test order by id"""
	qt_sql_test_DateV2_TinyInt_notn_1 """
		select id, kdtv2 * ktint, kdtv2 / ktint, kdtv2 % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_TinyInt_2 """
		select id, kdtv2 DIV ktint from expr_test order by id"""
	qt_sql_test_DateV2_TinyInt_notn_2 """
		select id, kdtv2 DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_TinyInt_3 """
		select id, kdtv2 & ktint, kdtv2 | ktint, kdtv2 ^ ktint from expr_test order by id"""
	qt_sql_test_DateV2_TinyInt_notn_3 """
		select id, kdtv2 & ktint, kdtv2 | ktint, kdtv2 ^ ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_TinyInt_4 """
		select id, BITAND(kdtv2, ktint), BITOR(kdtv2, ktint), BITXOR(kdtv2, ktint) from expr_test order by id"""
	qt_sql_test_DateV2_TinyInt_notn_4 """
		select id, BITAND(kdtv2, ktint), BITOR(kdtv2, ktint), BITXOR(kdtv2, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_SmallInt_0 """
		select id, kdtv2 + ksint, kdtv2 - ksint from expr_test order by id"""
	qt_sql_test_DateV2_SmallInt_notn_0 """
		select id, kdtv2 + ksint, kdtv2 - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_SmallInt_1 """
		select id, kdtv2 * ksint, kdtv2 / ksint, kdtv2 % ksint from expr_test order by id"""
	qt_sql_test_DateV2_SmallInt_notn_1 """
		select id, kdtv2 * ksint, kdtv2 / ksint, kdtv2 % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_SmallInt_2 """
		select id, kdtv2 DIV ksint from expr_test order by id"""
	qt_sql_test_DateV2_SmallInt_notn_2 """
		select id, kdtv2 DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_SmallInt_3 """
		select id, kdtv2 & ksint, kdtv2 | ksint, kdtv2 ^ ksint from expr_test order by id"""
	qt_sql_test_DateV2_SmallInt_notn_3 """
		select id, kdtv2 & ksint, kdtv2 | ksint, kdtv2 ^ ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_SmallInt_4 """
		select id, BITAND(kdtv2, ksint), BITOR(kdtv2, ksint), BITXOR(kdtv2, ksint) from expr_test order by id"""
	qt_sql_test_DateV2_SmallInt_notn_4 """
		select id, BITAND(kdtv2, ksint), BITOR(kdtv2, ksint), BITXOR(kdtv2, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Integer_0 """
		select id, kdtv2 + kint, kdtv2 - kint from expr_test order by id"""
	qt_sql_test_DateV2_Integer_notn_0 """
		select id, kdtv2 + kint, kdtv2 - kint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Integer_1 """
		select id, kdtv2 * kint, kdtv2 / kint, kdtv2 % kint from expr_test order by id"""
	qt_sql_test_DateV2_Integer_notn_1 """
		select id, kdtv2 * kint, kdtv2 / kint, kdtv2 % kint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Integer_2 """
		select id, kdtv2 DIV kint from expr_test order by id"""
	qt_sql_test_DateV2_Integer_notn_2 """
		select id, kdtv2 DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Integer_3 """
		select id, kdtv2 & kint, kdtv2 | kint, kdtv2 ^ kint from expr_test order by id"""
	qt_sql_test_DateV2_Integer_notn_3 """
		select id, kdtv2 & kint, kdtv2 | kint, kdtv2 ^ kint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Integer_4 """
		select id, BITAND(kdtv2, kint), BITOR(kdtv2, kint), BITXOR(kdtv2, kint) from expr_test order by id"""
	qt_sql_test_DateV2_Integer_notn_4 """
		select id, BITAND(kdtv2, kint), BITOR(kdtv2, kint), BITXOR(kdtv2, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_BigInt_0 """
		select id, kdtv2 + kbint, kdtv2 - kbint from expr_test order by id"""
	qt_sql_test_DateV2_BigInt_notn_0 """
		select id, kdtv2 + kbint, kdtv2 - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_BigInt_1 """
		select id, kdtv2 * kbint, kdtv2 / kbint, kdtv2 % kbint from expr_test order by id"""
	qt_sql_test_DateV2_BigInt_notn_1 """
		select id, kdtv2 * kbint, kdtv2 / kbint, kdtv2 % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_BigInt_2 """
		select id, kdtv2 DIV kbint from expr_test order by id"""
	qt_sql_test_DateV2_BigInt_notn_2 """
		select id, kdtv2 DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_BigInt_3 """
		select id, kdtv2 & kbint, kdtv2 | kbint, kdtv2 ^ kbint from expr_test order by id"""
	qt_sql_test_DateV2_BigInt_notn_3 """
		select id, kdtv2 & kbint, kdtv2 | kbint, kdtv2 ^ kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_BigInt_4 """
		select id, BITAND(kdtv2, kbint), BITOR(kdtv2, kbint), BITXOR(kdtv2, kbint) from expr_test order by id"""
	qt_sql_test_DateV2_BigInt_notn_4 """
		select id, BITAND(kdtv2, kbint), BITOR(kdtv2, kbint), BITXOR(kdtv2, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_LargeInt_0 """
		select id, kdtv2 + klint, kdtv2 - klint from expr_test order by id"""
	qt_sql_test_DateV2_LargeInt_notn_0 """
		select id, kdtv2 + klint, kdtv2 - klint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_LargeInt_1 """
		select id, kdtv2 * klint, kdtv2 / klint, kdtv2 % klint from expr_test order by id"""
	qt_sql_test_DateV2_LargeInt_notn_1 """
		select id, kdtv2 * klint, kdtv2 / klint, kdtv2 % klint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DateV2_LargeInt_2 """
	//original planner  	select id, kdtv2 DIV klint from expr_test order by id"""
	//original planner  qt_sql_test_DateV2_LargeInt_notn_2 """
	//original planner  	select id, kdtv2 DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_LargeInt_3 """
		select id, kdtv2 & klint, kdtv2 | klint, kdtv2 ^ klint from expr_test order by id"""
	qt_sql_test_DateV2_LargeInt_notn_3 """
		select id, kdtv2 & klint, kdtv2 | klint, kdtv2 ^ klint from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_LargeInt_4 """
		select id, BITAND(kdtv2, klint), BITOR(kdtv2, klint), BITXOR(kdtv2, klint) from expr_test order by id"""
	qt_sql_test_DateV2_LargeInt_notn_4 """
		select id, BITAND(kdtv2, klint), BITOR(kdtv2, klint), BITXOR(kdtv2, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Float_0 """
		select id, kdtv2 + kfloat, kdtv2 - kfloat from expr_test order by id"""
	qt_sql_test_DateV2_Float_notn_0 """
		select id, kdtv2 + kfloat, kdtv2 - kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_DateV2_Float_1 """
	// 	select id, kdtv2 * kfloat, kdtv2 / kfloat, kdtv2 % kfloat from expr_test order by id"""
	// qt_sql_test_DateV2_Float_notn_1 """
	// 	select id, kdtv2 * kfloat, kdtv2 / kfloat, kdtv2 % kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Float_2 """
		select id, kdtv2 DIV kfloat from expr_test order by id"""
	qt_sql_test_DateV2_Float_notn_2 """
		select id, kdtv2 DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Float_3 """
		select id, kdtv2 & kfloat, kdtv2 | kfloat, kdtv2 ^ kfloat from expr_test order by id"""
	qt_sql_test_DateV2_Float_notn_3 """
		select id, kdtv2 & kfloat, kdtv2 | kfloat, kdtv2 ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_DateV2_Float_4 """
	// 	select id, BITAND(kdtv2, kfloat), BITOR(kdtv2, kfloat), BITXOR(kdtv2, kfloat) from expr_test order by id"""
	// qt_sql_test_DateV2_Float_notn_4 """
	// 	select id, BITAND(kdtv2, kfloat), BITOR(kdtv2, kfloat), BITXOR(kdtv2, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Double_0 """
		select id, kdtv2 + kdbl, kdtv2 - kdbl from expr_test order by id"""
	qt_sql_test_DateV2_Double_notn_0 """
		select id, kdtv2 + kdbl, kdtv2 - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Double_1 """
		select id, kdtv2 * kdbl, kdtv2 / kdbl, kdtv2 % kdbl from expr_test order by id"""
	qt_sql_test_DateV2_Double_notn_1 """
		select id, kdtv2 * kdbl, kdtv2 / kdbl, kdtv2 % kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Double_2 """
		select id, kdtv2 DIV kdbl from expr_test order by id"""
	qt_sql_test_DateV2_Double_notn_2 """
		select id, kdtv2 DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Double_3 """
		select id, kdtv2 & kdbl, kdtv2 | kdbl, kdtv2 ^ kdbl from expr_test order by id"""
	qt_sql_test_DateV2_Double_notn_3 """
		select id, kdtv2 & kdbl, kdtv2 | kdbl, kdtv2 ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_DateV2_Double_4 """
	// 	select id, BITAND(kdtv2, kdbl), BITOR(kdtv2, kdbl), BITXOR(kdtv2, kdbl) from expr_test order by id"""
	// qt_sql_test_DateV2_Double_notn_4 """
	// 	select id, BITAND(kdtv2, kdbl), BITOR(kdtv2, kdbl), BITXOR(kdtv2, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DecimalV2_0 """
		select id, kdtv2 + kdcml, kdtv2 - kdcml from expr_test order by id"""
	qt_sql_test_DateV2_DecimalV2_notn_0 """
		select id, kdtv2 + kdcml, kdtv2 - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DecimalV2_1 """
		select id, kdtv2 * kdcml, kdtv2 / kdcml, kdtv2 % kdcml from expr_test order by id"""
	qt_sql_test_DateV2_DecimalV2_notn_1 """
		select id, kdtv2 * kdcml, kdtv2 / kdcml, kdtv2 % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DecimalV2_2 """
		select id, kdtv2 DIV kdcml from expr_test order by id"""
	qt_sql_test_DateV2_DecimalV2_notn_2 """
		select id, kdtv2 DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DecimalV2_3 """
		select id, kdtv2 & kdcml, kdtv2 | kdcml, kdtv2 ^ kdcml from expr_test order by id"""
	qt_sql_test_DateV2_DecimalV2_notn_3 """
		select id, kdtv2 & kdcml, kdtv2 | kdcml, kdtv2 ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_DateV2_DecimalV2_4 """
	// 	select id, BITAND(kdtv2, kdcml), BITOR(kdtv2, kdcml), BITXOR(kdtv2, kdcml) from expr_test order by id"""
	// qt_sql_test_DateV2_DecimalV2_notn_4 """
	// 	select id, BITAND(kdtv2, kdcml), BITOR(kdtv2, kdcml), BITXOR(kdtv2, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Decimal32V3_0 """
		select id, kdtv2 + kdcml32v3, kdtv2 - kdcml32v3 from expr_test order by id"""
	qt_sql_test_DateV2_Decimal32V3_notn_0 """
		select id, kdtv2 + kdcml32v3, kdtv2 - kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DateV2_Decimal32V3_1 """
	//original planner  	select id, kdtv2 * kdcml32v3, kdtv2 / kdcml32v3, kdtv2 % kdcml32v3 from expr_test order by id"""
	//original planner  qt_sql_test_DateV2_Decimal32V3_notn_1 """
	//original planner  	select id, kdtv2 * kdcml32v3, kdtv2 / kdcml32v3, kdtv2 % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Decimal32V3_2 """
		select id, kdtv2 DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_DateV2_Decimal32V3_notn_2 """
		select id, kdtv2 DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Decimal32V3_3 """
		select id, kdtv2 & kdcml32v3, kdtv2 | kdcml32v3, kdtv2 ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_DateV2_Decimal32V3_notn_3 """
		select id, kdtv2 & kdcml32v3, kdtv2 | kdcml32v3, kdtv2 ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_DateV2_Decimal32V3_4 """
	// 	select id, BITAND(kdtv2, kdcml32v3), BITOR(kdtv2, kdcml32v3), BITXOR(kdtv2, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_DateV2_Decimal32V3_notn_4 """
	// 	select id, BITAND(kdtv2, kdcml32v3), BITOR(kdtv2, kdcml32v3), BITXOR(kdtv2, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Decimal64V3_0 """
		select id, kdtv2 + kdcml64v3, kdtv2 - kdcml64v3 from expr_test order by id"""
	qt_sql_test_DateV2_Decimal64V3_notn_0 """
		select id, kdtv2 + kdcml64v3, kdtv2 - kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DateV2_Decimal64V3_1 """
	//original planner  	select id, kdtv2 * kdcml64v3, kdtv2 / kdcml64v3, kdtv2 % kdcml64v3 from expr_test order by id"""
	//original planner  qt_sql_test_DateV2_Decimal64V3_notn_1 """
	//original planner  	select id, kdtv2 * kdcml64v3, kdtv2 / kdcml64v3, kdtv2 % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Decimal64V3_2 """
		select id, kdtv2 DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_DateV2_Decimal64V3_notn_2 """
		select id, kdtv2 DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Decimal64V3_3 """
		select id, kdtv2 & kdcml64v3, kdtv2 | kdcml64v3, kdtv2 ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_DateV2_Decimal64V3_notn_3 """
		select id, kdtv2 & kdcml64v3, kdtv2 | kdcml64v3, kdtv2 ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_DateV2_Decimal64V3_4 """
	// 	select id, BITAND(kdtv2, kdcml64v3), BITOR(kdtv2, kdcml64v3), BITXOR(kdtv2, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_DateV2_Decimal64V3_notn_4 """
	// 	select id, BITAND(kdtv2, kdcml64v3), BITOR(kdtv2, kdcml64v3), BITXOR(kdtv2, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Decimal128V3_0 """
		select id, kdtv2 + kdcml128v3, kdtv2 - kdcml128v3 from expr_test order by id"""
	qt_sql_test_DateV2_Decimal128V3_notn_0 """
		select id, kdtv2 + kdcml128v3, kdtv2 - kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DateV2_Decimal128V3_1 """
	//original planner  	select id, kdtv2 * kdcml128v3, kdtv2 / kdcml128v3, kdtv2 % kdcml128v3 from expr_test order by id"""
	//original planner  qt_sql_test_DateV2_Decimal128V3_notn_1 """
	//original planner  	select id, kdtv2 * kdcml128v3, kdtv2 / kdcml128v3, kdtv2 % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Decimal128V3_2 """
		select id, kdtv2 DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_DateV2_Decimal128V3_notn_2 """
		select id, kdtv2 DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Decimal128V3_3 """
		select id, kdtv2 & kdcml128v3, kdtv2 | kdcml128v3, kdtv2 ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_DateV2_Decimal128V3_notn_3 """
		select id, kdtv2 & kdcml128v3, kdtv2 | kdcml128v3, kdtv2 ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_DateV2_Decimal128V3_4 """
	// 	select id, BITAND(kdtv2, kdcml128v3), BITOR(kdtv2, kdcml128v3), BITXOR(kdtv2, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_DateV2_Decimal128V3_notn_4 """
	// 	select id, BITAND(kdtv2, kdcml128v3), BITOR(kdtv2, kdcml128v3), BITXOR(kdtv2, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Char_0 """
		select id, kdtv2 + kchr, kdtv2 - kchr from expr_test order by id"""
	qt_sql_test_DateV2_Char_notn_0 """
		select id, kdtv2 + kchr, kdtv2 - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Char_1 """
		select id, kdtv2 * kchr, kdtv2 / kchr, kdtv2 % kchr from expr_test order by id"""
	qt_sql_test_DateV2_Char_notn_1 """
		select id, kdtv2 * kchr, kdtv2 / kchr, kdtv2 % kchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Char_2 """
		select id, kdtv2 DIV kchr from expr_test order by id"""
	qt_sql_test_DateV2_Char_notn_2 """
		select id, kdtv2 DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Char_3 """
		select id, kdtv2 & kchr, kdtv2 | kchr, kdtv2 ^ kchr from expr_test order by id"""
	qt_sql_test_DateV2_Char_notn_3 """
		select id, kdtv2 & kchr, kdtv2 | kchr, kdtv2 ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_DateV2_Char_4 """
	// 	select id, BITAND(kdtv2, kchr), BITOR(kdtv2, kchr), BITXOR(kdtv2, kchr) from expr_test order by id"""
	// qt_sql_test_DateV2_Char_notn_4 """
	// 	select id, BITAND(kdtv2, kchr), BITOR(kdtv2, kchr), BITXOR(kdtv2, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Varchar_0 """
		select id, kdtv2 + kvchr, kdtv2 - kvchr from expr_test order by id"""
	qt_sql_test_DateV2_Varchar_notn_0 """
		select id, kdtv2 + kvchr, kdtv2 - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Varchar_1 """
		select id, kdtv2 * kvchr, kdtv2 / kvchr, kdtv2 % kvchr from expr_test order by id"""
	qt_sql_test_DateV2_Varchar_notn_1 """
		select id, kdtv2 * kvchr, kdtv2 / kvchr, kdtv2 % kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Varchar_2 """
		select id, kdtv2 DIV kvchr from expr_test order by id"""
	qt_sql_test_DateV2_Varchar_notn_2 """
		select id, kdtv2 DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Varchar_3 """
		select id, kdtv2 & kvchr, kdtv2 | kvchr, kdtv2 ^ kvchr from expr_test order by id"""
	qt_sql_test_DateV2_Varchar_notn_3 """
		select id, kdtv2 & kvchr, kdtv2 | kvchr, kdtv2 ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_DateV2_Varchar_4 """
	// 	select id, BITAND(kdtv2, kvchr), BITOR(kdtv2, kvchr), BITXOR(kdtv2, kvchr) from expr_test order by id"""
	// qt_sql_test_DateV2_Varchar_notn_4 """
	// 	select id, BITAND(kdtv2, kvchr), BITOR(kdtv2, kvchr), BITXOR(kdtv2, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_String_0 """
		select id, kdtv2 + kstr, kdtv2 - kstr from expr_test order by id"""
	qt_sql_test_DateV2_String_notn_0 """
		select id, kdtv2 + kstr, kdtv2 - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_String_1 """
		select id, kdtv2 * kstr, kdtv2 / kstr, kdtv2 % kstr from expr_test order by id"""
	qt_sql_test_DateV2_String_notn_1 """
		select id, kdtv2 * kstr, kdtv2 / kstr, kdtv2 % kstr from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_String_2 """
		select id, kdtv2 DIV kstr from expr_test order by id"""
	qt_sql_test_DateV2_String_notn_2 """
		select id, kdtv2 DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_String_3 """
		select id, kdtv2 & kstr, kdtv2 | kstr, kdtv2 ^ kstr from expr_test order by id"""
	qt_sql_test_DateV2_String_notn_3 """
		select id, kdtv2 & kstr, kdtv2 | kstr, kdtv2 ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_DateV2_String_4 """
	// 	select id, BITAND(kdtv2, kstr), BITOR(kdtv2, kstr), BITXOR(kdtv2, kstr) from expr_test order by id"""
	// qt_sql_test_DateV2_String_notn_4 """
	// 	select id, BITAND(kdtv2, kstr), BITOR(kdtv2, kstr), BITXOR(kdtv2, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Date_0 """
		select id, kdtv2 + kdt, kdtv2 - kdt from expr_test order by id"""
	qt_sql_test_DateV2_Date_notn_0 """
		select id, kdtv2 + kdt, kdtv2 - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Date_1 """
		select id, kdtv2 * kdt, kdtv2 / kdt, kdtv2 % kdt from expr_test order by id"""
	qt_sql_test_DateV2_Date_notn_1 """
		select id, kdtv2 * kdt, kdtv2 / kdt, kdtv2 % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Date_2 """
		select id, kdtv2 DIV kdt from expr_test order by id"""
	qt_sql_test_DateV2_Date_notn_2 """
		select id, kdtv2 DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Date_3 """
		select id, kdtv2 & kdt, kdtv2 | kdt, kdtv2 ^ kdt from expr_test order by id"""
	qt_sql_test_DateV2_Date_notn_3 """
		select id, kdtv2 & kdt, kdtv2 | kdt, kdtv2 ^ kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Date_4 """
		select id, BITAND(kdtv2, kdt), BITOR(kdtv2, kdt), BITXOR(kdtv2, kdt) from expr_test order by id"""
	qt_sql_test_DateV2_Date_notn_4 """
		select id, BITAND(kdtv2, kdt), BITOR(kdtv2, kdt), BITXOR(kdtv2, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateTime_0 """
		select id, kdtv2 + kdtm, kdtv2 - kdtm from expr_test order by id"""
	qt_sql_test_DateV2_DateTime_notn_0 """
		select id, kdtv2 + kdtm, kdtv2 - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateTime_1 """
		select id, kdtv2 * kdtm, kdtv2 / kdtm, kdtv2 % kdtm from expr_test order by id"""
	qt_sql_test_DateV2_DateTime_notn_1 """
		select id, kdtv2 * kdtm, kdtv2 / kdtm, kdtv2 % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateTime_2 """
		select id, kdtv2 DIV kdtm from expr_test order by id"""
	qt_sql_test_DateV2_DateTime_notn_2 """
		select id, kdtv2 DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateTime_3 """
		select id, kdtv2 & kdtm, kdtv2 | kdtm, kdtv2 ^ kdtm from expr_test order by id"""
	qt_sql_test_DateV2_DateTime_notn_3 """
		select id, kdtv2 & kdtm, kdtv2 | kdtm, kdtv2 ^ kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateTime_4 """
		select id, BITAND(kdtv2, kdtm), BITOR(kdtv2, kdtm), BITXOR(kdtv2, kdtm) from expr_test order by id"""
	qt_sql_test_DateV2_DateTime_notn_4 """
		select id, BITAND(kdtv2, kdtm), BITOR(kdtv2, kdtm), BITXOR(kdtv2, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateV2_0 """
		select id, kdtv2 + kdtv2, kdtv2 - kdtv2 from expr_test order by id"""
	qt_sql_test_DateV2_DateV2_notn_0 """
		select id, kdtv2 + kdtv2, kdtv2 - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateV2_1 """
		select id, kdtv2 * kdtv2, kdtv2 / kdtv2, kdtv2 % kdtv2 from expr_test order by id"""
	qt_sql_test_DateV2_DateV2_notn_1 """
		select id, kdtv2 * kdtv2, kdtv2 / kdtv2, kdtv2 % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateV2_2 """
		select id, kdtv2 DIV kdtv2 from expr_test order by id"""
	qt_sql_test_DateV2_DateV2_notn_2 """
		select id, kdtv2 DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateV2_3 """
		select id, kdtv2 & kdtv2, kdtv2 | kdtv2, kdtv2 ^ kdtv2 from expr_test order by id"""
	qt_sql_test_DateV2_DateV2_notn_3 """
		select id, kdtv2 & kdtv2, kdtv2 | kdtv2, kdtv2 ^ kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateV2_4 """
		select id, BITAND(kdtv2, kdtv2), BITOR(kdtv2, kdtv2), BITXOR(kdtv2, kdtv2) from expr_test order by id"""
	qt_sql_test_DateV2_DateV2_notn_4 """
		select id, BITAND(kdtv2, kdtv2), BITOR(kdtv2, kdtv2), BITXOR(kdtv2, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateTimeV2_0 """
		select id, kdtv2 + kdtmv2, kdtv2 - kdtmv2 from expr_test order by id"""
	qt_sql_test_DateV2_DateTimeV2_notn_0 """
		select id, kdtv2 + kdtmv2, kdtv2 - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateTimeV2_1 """
		select id, kdtv2 * kdtmv2, kdtv2 / kdtmv2, kdtv2 % kdtmv2 from expr_test order by id"""
	qt_sql_test_DateV2_DateTimeV2_notn_1 """
		select id, kdtv2 * kdtmv2, kdtv2 / kdtmv2, kdtv2 % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateTimeV2_2 """
		select id, kdtv2 DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_DateV2_DateTimeV2_notn_2 """
		select id, kdtv2 DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateTimeV2_3 """
		select id, kdtv2 & kdtmv2, kdtv2 | kdtmv2, kdtv2 ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_DateV2_DateTimeV2_notn_3 """
		select id, kdtv2 & kdtmv2, kdtv2 | kdtmv2, kdtv2 ^ kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_DateTimeV2_4 """
		select id, BITAND(kdtv2, kdtmv2), BITOR(kdtv2, kdtmv2), BITXOR(kdtv2, kdtmv2) from expr_test order by id"""
	qt_sql_test_DateV2_DateTimeV2_notn_4 """
		select id, BITAND(kdtv2, kdtmv2), BITOR(kdtv2, kdtmv2), BITXOR(kdtv2, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Boolean_0 """
		select id, kdtv2 + kbool, kdtv2 - kbool from expr_test order by id"""
	qt_sql_test_DateV2_Boolean_notn_0 """
		select id, kdtv2 + kbool, kdtv2 - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Boolean_1 """
		select id, kdtv2 * kbool, kdtv2 / kbool, kdtv2 % kbool from expr_test order by id"""
	qt_sql_test_DateV2_Boolean_notn_1 """
		select id, kdtv2 * kbool, kdtv2 / kbool, kdtv2 % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Boolean_2 """
		select id, kdtv2 DIV kbool from expr_test order by id"""
	qt_sql_test_DateV2_Boolean_notn_2 """
		select id, kdtv2 DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Boolean_3 """
		select id, kdtv2 & kbool, kdtv2 | kbool, kdtv2 ^ kbool from expr_test order by id"""
	qt_sql_test_DateV2_Boolean_notn_3 """
		select id, kdtv2 & kbool, kdtv2 | kbool, kdtv2 ^ kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DateV2_Boolean_4 """
		select id, BITAND(kdtv2, kbool), BITOR(kdtv2, kbool), BITXOR(kdtv2, kbool) from expr_test order by id"""
	qt_sql_test_DateV2_Boolean_notn_4 """
		select id, BITAND(kdtv2, kbool), BITOR(kdtv2, kbool), BITXOR(kdtv2, kbool) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_TinyInt_0 """
		select id, kdtmv2 + ktint, kdtmv2 - ktint from expr_test order by id"""
	qt_sql_test_DateTimeV2_TinyInt_notn_0 """
		select id, kdtmv2 + ktint, kdtmv2 - ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_TinyInt_1 """
		select id, kdtmv2 * ktint, kdtmv2 / ktint, kdtmv2 % ktint from expr_test order by id"""
	qt_sql_test_DateTimeV2_TinyInt_notn_1 """
		select id, kdtmv2 * ktint, kdtmv2 / ktint, kdtmv2 % ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_TinyInt_2 """
		select id, kdtmv2 DIV ktint from expr_test order by id"""
	qt_sql_test_DateTimeV2_TinyInt_notn_2 """
		select id, kdtmv2 DIV ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_TinyInt_3 """
		select id, kdtmv2 & ktint, kdtmv2 | ktint, kdtmv2 ^ ktint from expr_test order by id"""
	qt_sql_test_DateTimeV2_TinyInt_notn_3 """
		select id, kdtmv2 & ktint, kdtmv2 | ktint, kdtmv2 ^ ktint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_TinyInt_4 """
		select id, BITAND(kdtmv2, ktint), BITOR(kdtmv2, ktint), BITXOR(kdtmv2, ktint) from expr_test order by id"""
	qt_sql_test_DateTimeV2_TinyInt_notn_4 """
		select id, BITAND(kdtmv2, ktint), BITOR(kdtmv2, ktint), BITXOR(kdtmv2, ktint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_SmallInt_0 """
		select id, kdtmv2 + ksint, kdtmv2 - ksint from expr_test order by id"""
	qt_sql_test_DateTimeV2_SmallInt_notn_0 """
		select id, kdtmv2 + ksint, kdtmv2 - ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_SmallInt_1 """
		select id, kdtmv2 * ksint, kdtmv2 / ksint, kdtmv2 % ksint from expr_test order by id"""
	qt_sql_test_DateTimeV2_SmallInt_notn_1 """
		select id, kdtmv2 * ksint, kdtmv2 / ksint, kdtmv2 % ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_SmallInt_2 """
		select id, kdtmv2 DIV ksint from expr_test order by id"""
	qt_sql_test_DateTimeV2_SmallInt_notn_2 """
		select id, kdtmv2 DIV ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_SmallInt_3 """
		select id, kdtmv2 & ksint, kdtmv2 | ksint, kdtmv2 ^ ksint from expr_test order by id"""
	qt_sql_test_DateTimeV2_SmallInt_notn_3 """
		select id, kdtmv2 & ksint, kdtmv2 | ksint, kdtmv2 ^ ksint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_SmallInt_4 """
		select id, BITAND(kdtmv2, ksint), BITOR(kdtmv2, ksint), BITXOR(kdtmv2, ksint) from expr_test order by id"""
	qt_sql_test_DateTimeV2_SmallInt_notn_4 """
		select id, BITAND(kdtmv2, ksint), BITOR(kdtmv2, ksint), BITXOR(kdtmv2, ksint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Integer_0 """
		select id, kdtmv2 + kint, kdtmv2 - kint from expr_test order by id"""
	qt_sql_test_DateTimeV2_Integer_notn_0 """
		select id, kdtmv2 + kint, kdtmv2 - kint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Integer_1 """
		select id, kdtmv2 * kint, kdtmv2 / kint, kdtmv2 % kint from expr_test order by id"""
	qt_sql_test_DateTimeV2_Integer_notn_1 """
		select id, kdtmv2 * kint, kdtmv2 / kint, kdtmv2 % kint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Integer_2 """
		select id, kdtmv2 DIV kint from expr_test order by id"""
	qt_sql_test_DateTimeV2_Integer_notn_2 """
		select id, kdtmv2 DIV kint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Integer_3 """
		select id, kdtmv2 & kint, kdtmv2 | kint, kdtmv2 ^ kint from expr_test order by id"""
	qt_sql_test_DateTimeV2_Integer_notn_3 """
		select id, kdtmv2 & kint, kdtmv2 | kint, kdtmv2 ^ kint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Integer_4 """
		select id, BITAND(kdtmv2, kint), BITOR(kdtmv2, kint), BITXOR(kdtmv2, kint) from expr_test order by id"""
	qt_sql_test_DateTimeV2_Integer_notn_4 """
		select id, BITAND(kdtmv2, kint), BITOR(kdtmv2, kint), BITXOR(kdtmv2, kint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_BigInt_0 """
		select id, kdtmv2 + kbint, kdtmv2 - kbint from expr_test order by id"""
	qt_sql_test_DateTimeV2_BigInt_notn_0 """
		select id, kdtmv2 + kbint, kdtmv2 - kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_BigInt_1 """
		select id, kdtmv2 * kbint, kdtmv2 / kbint, kdtmv2 % kbint from expr_test order by id"""
	qt_sql_test_DateTimeV2_BigInt_notn_1 """
		select id, kdtmv2 * kbint, kdtmv2 / kbint, kdtmv2 % kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_BigInt_2 """
		select id, kdtmv2 DIV kbint from expr_test order by id"""
	qt_sql_test_DateTimeV2_BigInt_notn_2 """
		select id, kdtmv2 DIV kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_BigInt_3 """
		select id, kdtmv2 & kbint, kdtmv2 | kbint, kdtmv2 ^ kbint from expr_test order by id"""
	qt_sql_test_DateTimeV2_BigInt_notn_3 """
		select id, kdtmv2 & kbint, kdtmv2 | kbint, kdtmv2 ^ kbint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_BigInt_4 """
		select id, BITAND(kdtmv2, kbint), BITOR(kdtmv2, kbint), BITXOR(kdtmv2, kbint) from expr_test order by id"""
	qt_sql_test_DateTimeV2_BigInt_notn_4 """
		select id, BITAND(kdtmv2, kbint), BITOR(kdtmv2, kbint), BITXOR(kdtmv2, kbint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_LargeInt_0 """
		select id, kdtmv2 + klint, kdtmv2 - klint from expr_test order by id"""
	qt_sql_test_DateTimeV2_LargeInt_notn_0 """
		select id, kdtmv2 + klint, kdtmv2 - klint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_LargeInt_1 """
		select id, kdtmv2 * klint, kdtmv2 / klint, kdtmv2 % klint from expr_test order by id"""
	qt_sql_test_DateTimeV2_LargeInt_notn_1 """
		select id, kdtmv2 * klint, kdtmv2 / klint, kdtmv2 % klint from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DateTimeV2_LargeInt_2 """
	//original planner  	select id, kdtmv2 DIV klint from expr_test order by id"""
	//original planner  qt_sql_test_DateTimeV2_LargeInt_notn_2 """
	//original planner  	select id, kdtmv2 DIV klint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_LargeInt_3 """
		select id, kdtmv2 & klint, kdtmv2 | klint, kdtmv2 ^ klint from expr_test order by id"""
	qt_sql_test_DateTimeV2_LargeInt_notn_3 """
		select id, kdtmv2 & klint, kdtmv2 | klint, kdtmv2 ^ klint from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_LargeInt_4 """
		select id, BITAND(kdtmv2, klint), BITOR(kdtmv2, klint), BITXOR(kdtmv2, klint) from expr_test order by id"""
	qt_sql_test_DateTimeV2_LargeInt_notn_4 """
		select id, BITAND(kdtmv2, klint), BITOR(kdtmv2, klint), BITXOR(kdtmv2, klint) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Float_0 """
		select id, kdtmv2 + kfloat, kdtmv2 - kfloat from expr_test order by id"""
	qt_sql_test_DateTimeV2_Float_notn_0 """
		select id, kdtmv2 + kfloat, kdtmv2 - kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTimeV2_Float_1 """
	// 	select id, kdtmv2 * kfloat, kdtmv2 / kfloat, kdtmv2 % kfloat from expr_test order by id"""
	// qt_sql_test_DateTimeV2_Float_notn_1 """
	// 	select id, kdtmv2 * kfloat, kdtmv2 / kfloat, kdtmv2 % kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Float_2 """
		select id, kdtmv2 DIV kfloat from expr_test order by id"""
	qt_sql_test_DateTimeV2_Float_notn_2 """
		select id, kdtmv2 DIV kfloat from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Float_3 """
		select id, kdtmv2 & kfloat, kdtmv2 | kfloat, kdtmv2 ^ kfloat from expr_test order by id"""
	qt_sql_test_DateTimeV2_Float_notn_3 """
		select id, kdtmv2 & kfloat, kdtmv2 | kfloat, kdtmv2 ^ kfloat from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTimeV2_Float_4 """
	// 	select id, BITAND(kdtmv2, kfloat), BITOR(kdtmv2, kfloat), BITXOR(kdtmv2, kfloat) from expr_test order by id"""
	// qt_sql_test_DateTimeV2_Float_notn_4 """
	// 	select id, BITAND(kdtmv2, kfloat), BITOR(kdtmv2, kfloat), BITXOR(kdtmv2, kfloat) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Double_0 """
		select id, kdtmv2 + kdbl, kdtmv2 - kdbl from expr_test order by id"""
	qt_sql_test_DateTimeV2_Double_notn_0 """
		select id, kdtmv2 + kdbl, kdtmv2 - kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Double_1 """
		select id, kdtmv2 * kdbl, kdtmv2 / kdbl, kdtmv2 % kdbl from expr_test order by id"""
	qt_sql_test_DateTimeV2_Double_notn_1 """
		select id, kdtmv2 * kdbl, kdtmv2 / kdbl, kdtmv2 % kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Double_2 """
		select id, kdtmv2 DIV kdbl from expr_test order by id"""
	qt_sql_test_DateTimeV2_Double_notn_2 """
		select id, kdtmv2 DIV kdbl from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Double_3 """
		select id, kdtmv2 & kdbl, kdtmv2 | kdbl, kdtmv2 ^ kdbl from expr_test order by id"""
	qt_sql_test_DateTimeV2_Double_notn_3 """
		select id, kdtmv2 & kdbl, kdtmv2 | kdbl, kdtmv2 ^ kdbl from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTimeV2_Double_4 """
	// 	select id, BITAND(kdtmv2, kdbl), BITOR(kdtmv2, kdbl), BITXOR(kdtmv2, kdbl) from expr_test order by id"""
	// qt_sql_test_DateTimeV2_Double_notn_4 """
	// 	select id, BITAND(kdtmv2, kdbl), BITOR(kdtmv2, kdbl), BITXOR(kdtmv2, kdbl) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DecimalV2_0 """
		select id, kdtmv2 + kdcml, kdtmv2 - kdcml from expr_test order by id"""
	qt_sql_test_DateTimeV2_DecimalV2_notn_0 """
		select id, kdtmv2 + kdcml, kdtmv2 - kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DecimalV2_1 """
		select id, kdtmv2 * kdcml, kdtmv2 / kdcml, kdtmv2 % kdcml from expr_test order by id"""
	qt_sql_test_DateTimeV2_DecimalV2_notn_1 """
		select id, kdtmv2 * kdcml, kdtmv2 / kdcml, kdtmv2 % kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DecimalV2_2 """
		select id, kdtmv2 DIV kdcml from expr_test order by id"""
	qt_sql_test_DateTimeV2_DecimalV2_notn_2 """
		select id, kdtmv2 DIV kdcml from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DecimalV2_3 """
		select id, kdtmv2 & kdcml, kdtmv2 | kdcml, kdtmv2 ^ kdcml from expr_test order by id"""
	qt_sql_test_DateTimeV2_DecimalV2_notn_3 """
		select id, kdtmv2 & kdcml, kdtmv2 | kdcml, kdtmv2 ^ kdcml from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTimeV2_DecimalV2_4 """
	// 	select id, BITAND(kdtmv2, kdcml), BITOR(kdtmv2, kdcml), BITXOR(kdtmv2, kdcml) from expr_test order by id"""
	// qt_sql_test_DateTimeV2_DecimalV2_notn_4 """
	// 	select id, BITAND(kdtmv2, kdcml), BITOR(kdtmv2, kdcml), BITXOR(kdtmv2, kdcml) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Decimal32V3_0 """
		select id, kdtmv2 + kdcml32v3, kdtmv2 - kdcml32v3 from expr_test order by id"""
	qt_sql_test_DateTimeV2_Decimal32V3_notn_0 """
		select id, kdtmv2 + kdcml32v3, kdtmv2 - kdcml32v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DateTimeV2_Decimal32V3_1 """
	//original planner  	select id, kdtmv2 * kdcml32v3, kdtmv2 / kdcml32v3, kdtmv2 % kdcml32v3 from expr_test order by id"""
	//original planner  qt_sql_test_DateTimeV2_Decimal32V3_notn_1 """
	//original planner  	select id, kdtmv2 * kdcml32v3, kdtmv2 / kdcml32v3, kdtmv2 % kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Decimal32V3_2 """
		select id, kdtmv2 DIV kdcml32v3 from expr_test order by id"""
	qt_sql_test_DateTimeV2_Decimal32V3_notn_2 """
		select id, kdtmv2 DIV kdcml32v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Decimal32V3_3 """
		select id, kdtmv2 & kdcml32v3, kdtmv2 | kdcml32v3, kdtmv2 ^ kdcml32v3 from expr_test order by id"""
	qt_sql_test_DateTimeV2_Decimal32V3_notn_3 """
		select id, kdtmv2 & kdcml32v3, kdtmv2 | kdcml32v3, kdtmv2 ^ kdcml32v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTimeV2_Decimal32V3_4 """
	// 	select id, BITAND(kdtmv2, kdcml32v3), BITOR(kdtmv2, kdcml32v3), BITXOR(kdtmv2, kdcml32v3) from expr_test order by id"""
	// qt_sql_test_DateTimeV2_Decimal32V3_notn_4 """
	// 	select id, BITAND(kdtmv2, kdcml32v3), BITOR(kdtmv2, kdcml32v3), BITXOR(kdtmv2, kdcml32v3) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Decimal64V3_0 """
		select id, kdtmv2 + kdcml64v3, kdtmv2 - kdcml64v3 from expr_test order by id"""
	qt_sql_test_DateTimeV2_Decimal64V3_notn_0 """
		select id, kdtmv2 + kdcml64v3, kdtmv2 - kdcml64v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DateTimeV2_Decimal64V3_1 """
	//original planner  	select id, kdtmv2 * kdcml64v3, kdtmv2 / kdcml64v3, kdtmv2 % kdcml64v3 from expr_test order by id"""
	//original planner  qt_sql_test_DateTimeV2_Decimal64V3_notn_1 """
	//original planner  	select id, kdtmv2 * kdcml64v3, kdtmv2 / kdcml64v3, kdtmv2 % kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Decimal64V3_2 """
		select id, kdtmv2 DIV kdcml64v3 from expr_test order by id"""
	qt_sql_test_DateTimeV2_Decimal64V3_notn_2 """
		select id, kdtmv2 DIV kdcml64v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Decimal64V3_3 """
		select id, kdtmv2 & kdcml64v3, kdtmv2 | kdcml64v3, kdtmv2 ^ kdcml64v3 from expr_test order by id"""
	qt_sql_test_DateTimeV2_Decimal64V3_notn_3 """
		select id, kdtmv2 & kdcml64v3, kdtmv2 | kdcml64v3, kdtmv2 ^ kdcml64v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTimeV2_Decimal64V3_4 """
	// 	select id, BITAND(kdtmv2, kdcml64v3), BITOR(kdtmv2, kdcml64v3), BITXOR(kdtmv2, kdcml64v3) from expr_test order by id"""
	// qt_sql_test_DateTimeV2_Decimal64V3_notn_4 """
	// 	select id, BITAND(kdtmv2, kdcml64v3), BITOR(kdtmv2, kdcml64v3), BITXOR(kdtmv2, kdcml64v3) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Decimal128V3_0 """
		select id, kdtmv2 + kdcml128v3, kdtmv2 - kdcml128v3 from expr_test order by id"""
	qt_sql_test_DateTimeV2_Decimal128V3_notn_0 """
		select id, kdtmv2 + kdcml128v3, kdtmv2 - kdcml128v3 from expr_test_not_nullable order by id"""
	//original planner  qt_sql_test_DateTimeV2_Decimal128V3_1 """
	//original planner  	select id, kdtmv2 * kdcml128v3, kdtmv2 / kdcml128v3, kdtmv2 % kdcml128v3 from expr_test order by id"""
	//original planner  qt_sql_test_DateTimeV2_Decimal128V3_notn_1 """
	//original planner  	select id, kdtmv2 * kdcml128v3, kdtmv2 / kdcml128v3, kdtmv2 % kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Decimal128V3_2 """
		select id, kdtmv2 DIV kdcml128v3 from expr_test order by id"""
	qt_sql_test_DateTimeV2_Decimal128V3_notn_2 """
		select id, kdtmv2 DIV kdcml128v3 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Decimal128V3_3 """
		select id, kdtmv2 & kdcml128v3, kdtmv2 | kdcml128v3, kdtmv2 ^ kdcml128v3 from expr_test order by id"""
	qt_sql_test_DateTimeV2_Decimal128V3_notn_3 """
		select id, kdtmv2 & kdcml128v3, kdtmv2 | kdcml128v3, kdtmv2 ^ kdcml128v3 from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTimeV2_Decimal128V3_4 """
	// 	select id, BITAND(kdtmv2, kdcml128v3), BITOR(kdtmv2, kdcml128v3), BITXOR(kdtmv2, kdcml128v3) from expr_test order by id"""
	// qt_sql_test_DateTimeV2_Decimal128V3_notn_4 """
	// 	select id, BITAND(kdtmv2, kdcml128v3), BITOR(kdtmv2, kdcml128v3), BITXOR(kdtmv2, kdcml128v3) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Char_0 """
		select id, kdtmv2 + kchr, kdtmv2 - kchr from expr_test order by id"""
	qt_sql_test_DateTimeV2_Char_notn_0 """
		select id, kdtmv2 + kchr, kdtmv2 - kchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Char_1 """
		select id, kdtmv2 * kchr, kdtmv2 / kchr, kdtmv2 % kchr from expr_test order by id"""
	qt_sql_test_DateTimeV2_Char_notn_1 """
		select id, kdtmv2 * kchr, kdtmv2 / kchr, kdtmv2 % kchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Char_2 """
		select id, kdtmv2 DIV kchr from expr_test order by id"""
	qt_sql_test_DateTimeV2_Char_notn_2 """
		select id, kdtmv2 DIV kchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Char_3 """
		select id, kdtmv2 & kchr, kdtmv2 | kchr, kdtmv2 ^ kchr from expr_test order by id"""
	qt_sql_test_DateTimeV2_Char_notn_3 """
		select id, kdtmv2 & kchr, kdtmv2 | kchr, kdtmv2 ^ kchr from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTimeV2_Char_4 """
	// 	select id, BITAND(kdtmv2, kchr), BITOR(kdtmv2, kchr), BITXOR(kdtmv2, kchr) from expr_test order by id"""
	// qt_sql_test_DateTimeV2_Char_notn_4 """
	// 	select id, BITAND(kdtmv2, kchr), BITOR(kdtmv2, kchr), BITXOR(kdtmv2, kchr) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Varchar_0 """
		select id, kdtmv2 + kvchr, kdtmv2 - kvchr from expr_test order by id"""
	qt_sql_test_DateTimeV2_Varchar_notn_0 """
		select id, kdtmv2 + kvchr, kdtmv2 - kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Varchar_1 """
		select id, kdtmv2 * kvchr, kdtmv2 / kvchr, kdtmv2 % kvchr from expr_test order by id"""
	qt_sql_test_DateTimeV2_Varchar_notn_1 """
		select id, kdtmv2 * kvchr, kdtmv2 / kvchr, kdtmv2 % kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Varchar_2 """
		select id, kdtmv2 DIV kvchr from expr_test order by id"""
	qt_sql_test_DateTimeV2_Varchar_notn_2 """
		select id, kdtmv2 DIV kvchr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Varchar_3 """
		select id, kdtmv2 & kvchr, kdtmv2 | kvchr, kdtmv2 ^ kvchr from expr_test order by id"""
	qt_sql_test_DateTimeV2_Varchar_notn_3 """
		select id, kdtmv2 & kvchr, kdtmv2 | kvchr, kdtmv2 ^ kvchr from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTimeV2_Varchar_4 """
	// 	select id, BITAND(kdtmv2, kvchr), BITOR(kdtmv2, kvchr), BITXOR(kdtmv2, kvchr) from expr_test order by id"""
	// qt_sql_test_DateTimeV2_Varchar_notn_4 """
	// 	select id, BITAND(kdtmv2, kvchr), BITOR(kdtmv2, kvchr), BITXOR(kdtmv2, kvchr) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_String_0 """
		select id, kdtmv2 + kstr, kdtmv2 - kstr from expr_test order by id"""
	qt_sql_test_DateTimeV2_String_notn_0 """
		select id, kdtmv2 + kstr, kdtmv2 - kstr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_String_1 """
		select id, kdtmv2 * kstr, kdtmv2 / kstr, kdtmv2 % kstr from expr_test order by id"""
	qt_sql_test_DateTimeV2_String_notn_1 """
		select id, kdtmv2 * kstr, kdtmv2 / kstr, kdtmv2 % kstr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_String_2 """
		select id, kdtmv2 DIV kstr from expr_test order by id"""
	qt_sql_test_DateTimeV2_String_notn_2 """
		select id, kdtmv2 DIV kstr from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_String_3 """
		select id, kdtmv2 & kstr, kdtmv2 | kstr, kdtmv2 ^ kstr from expr_test order by id"""
	qt_sql_test_DateTimeV2_String_notn_3 """
		select id, kdtmv2 & kstr, kdtmv2 | kstr, kdtmv2 ^ kstr from expr_test_not_nullable order by id"""
	// qt_sql_test_DateTimeV2_String_4 """
	// 	select id, BITAND(kdtmv2, kstr), BITOR(kdtmv2, kstr), BITXOR(kdtmv2, kstr) from expr_test order by id"""
	// qt_sql_test_DateTimeV2_String_notn_4 """
	// 	select id, BITAND(kdtmv2, kstr), BITOR(kdtmv2, kstr), BITXOR(kdtmv2, kstr) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Date_0 """
		select id, kdtmv2 + kdt, kdtmv2 - kdt from expr_test order by id"""
	qt_sql_test_DateTimeV2_Date_notn_0 """
		select id, kdtmv2 + kdt, kdtmv2 - kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Date_1 """
		select id, kdtmv2 * kdt, kdtmv2 / kdt, kdtmv2 % kdt from expr_test order by id"""
	qt_sql_test_DateTimeV2_Date_notn_1 """
		select id, kdtmv2 * kdt, kdtmv2 / kdt, kdtmv2 % kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Date_2 """
		select id, kdtmv2 DIV kdt from expr_test order by id"""
	qt_sql_test_DateTimeV2_Date_notn_2 """
		select id, kdtmv2 DIV kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Date_3 """
		select id, kdtmv2 & kdt, kdtmv2 | kdt, kdtmv2 ^ kdt from expr_test order by id"""
	qt_sql_test_DateTimeV2_Date_notn_3 """
		select id, kdtmv2 & kdt, kdtmv2 | kdt, kdtmv2 ^ kdt from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Date_4 """
		select id, BITAND(kdtmv2, kdt), BITOR(kdtmv2, kdt), BITXOR(kdtmv2, kdt) from expr_test order by id"""
	qt_sql_test_DateTimeV2_Date_notn_4 """
		select id, BITAND(kdtmv2, kdt), BITOR(kdtmv2, kdt), BITXOR(kdtmv2, kdt) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateTime_0 """
		select id, kdtmv2 + kdtm, kdtmv2 - kdtm from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateTime_notn_0 """
		select id, kdtmv2 + kdtm, kdtmv2 - kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateTime_1 """
		select id, kdtmv2 * kdtm, kdtmv2 / kdtm, kdtmv2 % kdtm from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateTime_notn_1 """
		select id, kdtmv2 * kdtm, kdtmv2 / kdtm, kdtmv2 % kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateTime_2 """
		select id, kdtmv2 DIV kdtm from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateTime_notn_2 """
		select id, kdtmv2 DIV kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateTime_3 """
		select id, kdtmv2 & kdtm, kdtmv2 | kdtm, kdtmv2 ^ kdtm from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateTime_notn_3 """
		select id, kdtmv2 & kdtm, kdtmv2 | kdtm, kdtmv2 ^ kdtm from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateTime_4 """
		select id, BITAND(kdtmv2, kdtm), BITOR(kdtmv2, kdtm), BITXOR(kdtmv2, kdtm) from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateTime_notn_4 """
		select id, BITAND(kdtmv2, kdtm), BITOR(kdtmv2, kdtm), BITXOR(kdtmv2, kdtm) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateV2_0 """
		select id, kdtmv2 + kdtv2, kdtmv2 - kdtv2 from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateV2_notn_0 """
		select id, kdtmv2 + kdtv2, kdtmv2 - kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateV2_1 """
		select id, kdtmv2 * kdtv2, kdtmv2 / kdtv2, kdtmv2 % kdtv2 from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateV2_notn_1 """
		select id, kdtmv2 * kdtv2, kdtmv2 / kdtv2, kdtmv2 % kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateV2_2 """
		select id, kdtmv2 DIV kdtv2 from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateV2_notn_2 """
		select id, kdtmv2 DIV kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateV2_3 """
		select id, kdtmv2 & kdtv2, kdtmv2 | kdtv2, kdtmv2 ^ kdtv2 from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateV2_notn_3 """
		select id, kdtmv2 & kdtv2, kdtmv2 | kdtv2, kdtmv2 ^ kdtv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateV2_4 """
		select id, BITAND(kdtmv2, kdtv2), BITOR(kdtmv2, kdtv2), BITXOR(kdtmv2, kdtv2) from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateV2_notn_4 """
		select id, BITAND(kdtmv2, kdtv2), BITOR(kdtmv2, kdtv2), BITXOR(kdtmv2, kdtv2) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateTimeV2_0 """
		select id, kdtmv2 + kdtmv2, kdtmv2 - kdtmv2 from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateTimeV2_notn_0 """
		select id, kdtmv2 + kdtmv2, kdtmv2 - kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateTimeV2_1 """
		select id, kdtmv2 * kdtmv2, kdtmv2 / kdtmv2, kdtmv2 % kdtmv2 from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateTimeV2_notn_1 """
		select id, kdtmv2 * kdtmv2, kdtmv2 / kdtmv2, kdtmv2 % kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateTimeV2_2 """
		select id, kdtmv2 DIV kdtmv2 from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateTimeV2_notn_2 """
		select id, kdtmv2 DIV kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateTimeV2_3 """
		select id, kdtmv2 & kdtmv2, kdtmv2 | kdtmv2, kdtmv2 ^ kdtmv2 from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateTimeV2_notn_3 """
		select id, kdtmv2 & kdtmv2, kdtmv2 | kdtmv2, kdtmv2 ^ kdtmv2 from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_DateTimeV2_4 """
		select id, BITAND(kdtmv2, kdtmv2), BITOR(kdtmv2, kdtmv2), BITXOR(kdtmv2, kdtmv2) from expr_test order by id"""
	qt_sql_test_DateTimeV2_DateTimeV2_notn_4 """
		select id, BITAND(kdtmv2, kdtmv2), BITOR(kdtmv2, kdtmv2), BITXOR(kdtmv2, kdtmv2) from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Boolean_0 """
		select id, kdtmv2 + kbool, kdtmv2 - kbool from expr_test order by id"""
	qt_sql_test_DateTimeV2_Boolean_notn_0 """
		select id, kdtmv2 + kbool, kdtmv2 - kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Boolean_1 """
		select id, kdtmv2 * kbool, kdtmv2 / kbool, kdtmv2 % kbool from expr_test order by id"""
	qt_sql_test_DateTimeV2_Boolean_notn_1 """
		select id, kdtmv2 * kbool, kdtmv2 / kbool, kdtmv2 % kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Boolean_2 """
		select id, kdtmv2 DIV kbool from expr_test order by id"""
	qt_sql_test_DateTimeV2_Boolean_notn_2 """
		select id, kdtmv2 DIV kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Boolean_3 """
		select id, kdtmv2 & kbool, kdtmv2 | kbool, kdtmv2 ^ kbool from expr_test order by id"""
	qt_sql_test_DateTimeV2_Boolean_notn_3 """
		select id, kdtmv2 & kbool, kdtmv2 | kbool, kdtmv2 ^ kbool from expr_test_not_nullable order by id"""
	qt_sql_test_DateTimeV2_Boolean_4 """
		select id, BITAND(kdtmv2, kbool), BITOR(kdtmv2, kbool), BITXOR(kdtmv2, kbool) from expr_test order by id"""
	qt_sql_test_DateTimeV2_Boolean_notn_4 """
		select id, BITAND(kdtmv2, kbool), BITOR(kdtmv2, kbool), BITXOR(kdtmv2, kbool) from expr_test_not_nullable order by id"""
}