/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.torque.map.ColumnMap;
import org.apache.torque.map.TableMap;

public class ForeignKeyMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TableMap table;
    private TableMap foreignTable;
    private String foreignTableName;
    private final List<ColumnPair> columns = new ArrayList<ColumnPair>();

    public ForeignKeyMap(TableMap table, TableMap foreignTable) {
        if (table == null) {
            throw new NullPointerException("table is null");
        }
        if (foreignTable == null) {
            throw new NullPointerException("foreignTable is null");
        }
        this.table = table;
        this.foreignTable = foreignTable;
    }

    public ForeignKeyMap(TableMap table, String foreignTableName) {
        if (table == null) {
            throw new NullPointerException("table is null");
        }
        if (foreignTableName == null) {
            throw new NullPointerException("foreignTableName is null");
        }
        this.table = table;
        this.foreignTableName = foreignTableName;
    }

    public void addColumns(ColumnPair columnPair) {
        if (columnPair == null) {
            throw new NullPointerException("columnPair is null");
        }
        this.columns.add(columnPair);
    }

    public TableMap getTable() {
        return this.table;
    }

    public TableMap getForeignTable() {
        if (this.foreignTable == null) {
            this.foreignTable = this.table.getDatabaseMap().getTable(this.foreignTableName);
            if (this.foreignTable == null) {
                throw new IllegalStateException("Map builder for " + this.foreignTableName + " was not yet built.");
            }
            this.foreignTableName = null;
        }
        return this.foreignTable;
    }

    public String getForeignTableName() {
        if (this.foreignTable == null) {
            return this.foreignTableName;
        }
        return this.foreignTable.getName();
    }

    public List<ColumnPair> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public static class ColumnPair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ForeignKeyMap foreignKeyMap;
        private final ColumnMap local;
        private ColumnMap foreign;
        private String foreignName;

        public ColumnPair(ForeignKeyMap foreignKeyMap, ColumnMap local, ColumnMap foreign) {
            if (foreignKeyMap == null) {
                throw new NullPointerException("foreignKeyMap is null");
            }
            if (local == null) {
                throw new NullPointerException("local is null");
            }
            if (foreign == null) {
                throw new NullPointerException("foreign is null");
            }
            this.foreignKeyMap = foreignKeyMap;
            this.local = local;
            this.foreign = foreign;
        }

        public ColumnPair(ForeignKeyMap foreignKeyMap, ColumnMap local, String foreignName) {
            if (foreignKeyMap == null) {
                throw new NullPointerException("foreignKeyMap is null");
            }
            if (local == null) {
                throw new NullPointerException("local is null");
            }
            if (foreignName == null) {
                throw new NullPointerException("foreignName is null");
            }
            this.foreignKeyMap = foreignKeyMap;
            this.local = local;
            this.foreignName = foreignName;
        }

        public ForeignKeyMap getForeignKeyMap() {
            return this.foreignKeyMap;
        }

        public ColumnMap getLocal() {
            return this.local;
        }

        public ColumnMap getForeign() {
            if (this.foreign == null) {
                TableMap foreignTable = this.foreignKeyMap.getForeignTable();
                this.foreign = foreignTable.getColumn(this.foreignName);
                if (this.foreign == null) {
                    throw new IllegalStateException("Table " + this.foreignKeyMap.getForeignTableName() + " has no column named " + this.foreignName);
                }
            }
            return this.foreign;
        }
    }
}

