/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.sql.Connection;
import java.util.List;
import org.apache.torque.Column;
import org.apache.torque.ColumnImpl;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.mapper.IntegerMapper;
import org.apache.torque.util.BasePeerImpl;
import org.apache.torque.util.UniqueList;
import org.apache.torque.util.functions.Count;

public class CountHelper {
    public int count(Criteria c) throws TorqueException {
        return this.count(c, null, "*", null);
    }

    public int count(Criteria c, Connection conn) throws TorqueException {
        return this.count(c, conn, "*", null);
    }

    public int count(Criteria c, String columnName) throws TorqueException {
        return this.count(c, null, columnName, null);
    }

    public int count(Criteria c, Column column) throws TorqueException {
        return this.count(c, column.getSqlExpression());
    }

    public int count(Criteria c, Connection conn, Column column) throws TorqueException {
        return this.count(c, conn, column.getSqlExpression(), null);
    }

    public int count(TableMap tableMap) throws TorqueException {
        return this.count(new Criteria(), null, "*", tableMap);
    }

    public int count(TableMap tableMap, Connection conn) throws TorqueException {
        return this.count(new Criteria(), conn, "*", tableMap);
    }

    public int count(Criteria c, Connection conn, String columnName, TableMap tableMap) throws TorqueException {
        c.getSelectColumns().clear();
        c.getOrderByColumns().clear();
        c.getGroupByColumns().clear();
        UniqueList<String> criteriaSelectModifiers = c.getSelectModifiers();
        boolean distinct = false;
        if (criteriaSelectModifiers != null && criteriaSelectModifiers.size() > 0 && criteriaSelectModifiers.contains(SqlEnum.DISTINCT.toString())) {
            criteriaSelectModifiers.remove(SqlEnum.DISTINCT.toString());
            distinct = true;
        }
        c.addSelectColumn(new Count(new ColumnImpl(columnName), distinct));
        String databaseName = c.getDbName() == null ? Torque.getDefaultDB() : c.getDbName();
        BasePeerImpl<Integer> peer = new BasePeerImpl<Integer>(new IntegerMapper(), tableMap, databaseName);
        List<Integer> result = conn == null ? peer.doSelect(c) : peer.doSelect(c, conn);
        return result.get(0);
    }
}

