/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.manager;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.access.GroupCacheAccess;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.torque.Column;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.manager.CacheListener;
import org.apache.torque.manager.MethodCacheKey;
import org.apache.torque.manager.MethodResultCache;
import org.apache.torque.manager.NoOpMethodResultCache;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;

public abstract class AbstractBaseManager<T extends Persistent>
implements Serializable {
    private static final long serialVersionUID = 509798299473481305L;
    protected static final Logger log = LogManager.getLogger(AbstractBaseManager.class);
    protected transient CacheAccess<ObjectKey<?>, T> cache;
    protected transient GroupCacheAccess<MethodCacheKey, Object> groupCache;
    protected transient MethodResultCache mrCache;
    private Class<T> omClass;
    private String className;
    private String region;
    private boolean isNew = true;
    private CopyOnWriteArraySet<Column> validFields = new CopyOnWriteArraySet();
    private ConcurrentMap<Column, CopyOnWriteArrayList<CacheListener<?>>> listenersMap = new ConcurrentHashMap();

    protected Class<T> getOMClass() {
        return this.omClass;
    }

    protected void setOMClass(Class<T> omClass) {
        this.omClass = omClass;
    }

    protected void addValidField(Column ... columns) {
        this.validFields.addAll(Arrays.asList(columns));
    }

    protected T getOMInstance() throws TorqueException {
        try {
            return (T)((Persistent)this.omClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new TorqueException("Could not instantiate " + this.getClassName(), e);
        }
        catch (IllegalAccessException e) {
            throw new TorqueException("Could not access " + this.getClassName(), e);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String v) throws TorqueException {
        this.className = v;
        try {
            Class<?> clazz = Class.forName(this.getClassName());
            if (!Persistent.class.isAssignableFrom(clazz)) {
                throw new TorqueException(this.getClassName() + " does not implement the interface Persistent");
            }
            this.setOMClass(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TorqueException("Could not load " + this.getClassName(), cnfe);
        }
    }

    protected T getOMInstance(ObjectKey<?> id) throws TorqueException {
        return this.getOMInstance(id, true);
    }

    protected T getOMInstance(ObjectKey<?> key, boolean fromCache) throws TorqueException {
        T om = null;
        if (fromCache) {
            om = this.cacheGet(key);
        }
        if (om == null) {
            om = this.retrieveStoredOM(key);
            if (fromCache) {
                this.putInstanceImpl(om);
            }
        }
        return om;
    }

    protected T cacheGet(ObjectKey<?> key) {
        Persistent om = null;
        if (this.cache != null) {
            om = (Persistent)this.cache.get(key);
        }
        return (T)om;
    }

    protected void clearImpl() throws TorqueException {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (CacheException ce) {
                throw new TorqueException("Could not clear cache due to internal JCS error.", ce);
            }
        }
    }

    public void dispose() {
        if (this.cache != null) {
            this.cache.dispose();
            this.cache = null;
        }
        if (this.groupCache != null) {
            this.groupCache.dispose();
            this.groupCache = null;
        }
        this.validFields.clear();
        this.listenersMap.clear();
    }

    protected T removeInstanceImpl(ObjectKey<?> key) throws TorqueException {
        Persistent oldOm = null;
        if (this.cache != null) {
            oldOm = (Persistent)this.cache.get(key);
            this.cache.remove(key);
        }
        return (T)oldOm;
    }

    protected T putInstanceImpl(T om) throws TorqueException {
        ObjectKey<?> key = om.getPrimaryKey();
        return this.putInstanceImpl(key, om);
    }

    protected T putInstanceImpl(ObjectKey<?> key, T om) throws TorqueException {
        if (this.getOMClass() != null && !this.getOMClass().isInstance(om)) {
            throw new TorqueException(om + "; class=" + om.getClass().getName() + "; id=" + om.getPrimaryKey() + " cannot be cached with " + this.getOMClass().getName() + " objects");
        }
        Persistent oldOm = null;
        if (this.cache != null) {
            oldOm = (Persistent)this.cache.get(key);
            this.cache.put(key, om);
        }
        return (T)oldOm;
    }

    protected abstract T retrieveStoredOM(ObjectKey<?> var1) throws TorqueException;

    protected List<T> getOMs(ObjectKey<?> ... ids) throws TorqueException {
        return this.getOMs(Arrays.asList(ids));
    }

    protected List<T> getOMs(List<? extends ObjectKey<?>> ids) throws TorqueException {
        return this.getOMs(ids, true);
    }

    protected List<T> getOMs(List<? extends ObjectKey<?>> ids, boolean fromCache) throws TorqueException {
        if (ids != null && ids.size() > 0) {
            HashMap omsMap = new HashMap();
            ArrayList newIds = new ArrayList(ids);
            if (fromCache) {
                ids.stream().map(this::cacheGet).filter(om -> om != null).forEach(om -> omsMap.put(om.getPrimaryKey(), (Persistent)om));
                newIds.removeAll(omsMap.keySet());
            }
            if (!newIds.isEmpty()) {
                List<T> newOms = this.retrieveStoredOMs(newIds);
                for (Persistent om2 : newOms) {
                    omsMap.put(om2.getPrimaryKey(), om2);
                    if (!fromCache) continue;
                    this.putInstanceImpl(om2);
                }
            }
            return ids.stream().map(omsMap::get).collect(Collectors.toList());
        }
        return new ArrayList();
    }

    protected abstract List<T> retrieveStoredOMs(List<? extends ObjectKey<?>> var1) throws TorqueException;

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String v) throws TorqueException {
        this.region = v;
        try {
            if (Torque.getConfiguration().getBoolean("manager.useCache", false)) {
                if (this.cache != null) {
                    this.cache.dispose();
                }
                if (this.groupCache != null) {
                    this.groupCache.dispose();
                }
                this.cache = JCS.getInstance((String)this.getRegion());
                this.groupCache = JCS.getGroupCacheInstance((String)this.getRegion());
                this.mrCache = new MethodResultCache(this.groupCache);
            } else {
                this.mrCache = new NoOpMethodResultCache(null);
            }
        }
        catch (CacheException e) {
            throw new TorqueException("Cache could not be initialized", e);
        }
        if (this.cache == null) {
            log.info("Cache could not be initialized for region: {}", (Object)v);
        }
    }

    public synchronized MethodResultCache getMethodResultCache() {
        if (this.isNew) {
            this.registerAsListener();
            this.isNew = false;
        }
        return this.mrCache;
    }

    protected void registerAsListener() {
    }

    public void addCacheListenerImpl(CacheListener<?> listener) {
        listener.getInterestedFields().forEach(key -> {
            if (this.validFields.contains(key)) {
                CopyOnWriteArrayList listeners = this.listenersMap.computeIfAbsent((Column)key, key1 -> new CopyOnWriteArrayList());
                listeners.addIfAbsent(listener);
            }
        });
    }

    protected <TT extends Persistent> void notifyListeners(Column column, TT oldOm, TT om) {
        List listeners = (List)this.listenersMap.get(column);
        if (listeners != null) {
            listeners.forEach(cl -> {
                CacheListener listener = cl;
                if (oldOm == null) {
                    listener.addedObject(om);
                } else if (om == null) {
                    listener.removedObject(oldOm);
                } else {
                    listener.refreshedObject(om);
                }
            });
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            if (this.region != null) {
                this.setRegion(this.region);
            }
        }
        catch (TorqueException e) {
            log.error("Cache could not be initialized for region '{}' after deserialization", (Object)this.region);
        }
    }
}

