/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.controller;

import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.controller.OutletReferenceSaxHandler;
import org.apache.torque.generator.configuration.controller.Output;
import org.apache.torque.generator.configuration.outlet.OutletConfigurationSaxHandler;
import org.apache.torque.generator.configuration.outlet.OutletSaxHandler;
import org.apache.torque.generator.configuration.source.ConfigurableClassSaxHandler;
import org.apache.torque.generator.configuration.source.SourceSaxHandler;
import org.apache.torque.generator.configuration.source.SourceSaxHandlerFactories;
import org.apache.torque.generator.configuration.source.SourceSaxHandlerFactory;
import org.apache.torque.generator.processor.string.StringProcessor;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.source.PostprocessorDefinition;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OutputSaxHandler
extends DefaultHandler {
    private static final QualifiedName FILENAME_OUTLET_NAME = new QualifiedName("org.apache.torque.generator.configuration.filenameOutlet");
    private final ConfigurationProvider configurationProvider;
    private final UnitDescriptor unitDescriptor;
    private final ConfigurationHandlers configurationHandlers;
    private Output output;
    private OutletReferenceSaxHandler contentOutletSaxHandler;
    private SourceSaxHandler sourceSaxHandler;
    private ConfigurableClassSaxHandler<StringProcessor> postprocessorSaxHandler;
    private OutletSaxHandler filenameOutletSaxHandler;

    public OutputSaxHandler(ConfigurationProvider configurationProvider, UnitDescriptor unitDescriptor, ConfigurationHandlers configurationHandlers) {
        if (configurationProvider == null) {
            throw new NullPointerException("configurationProvider must not be null");
        }
        if (unitDescriptor == null) {
            throw new NullPointerException("unitDescriptor must not be null");
        }
        if (configurationHandlers == null) {
            throw new NullPointerException("configurationHandlers must not be null");
        }
        this.configurationProvider = configurationProvider;
        this.configurationHandlers = configurationHandlers;
        this.unitDescriptor = unitDescriptor;
    }

    public Output getOutputFile() {
        return this.output;
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        if (this.contentOutletSaxHandler != null) {
            this.contentOutletSaxHandler.startElement(uri, localName, rawName, attributes);
        } else if (this.filenameOutletSaxHandler != null) {
            this.filenameOutletSaxHandler.startElement(uri, localName, rawName, attributes);
        } else if (this.sourceSaxHandler != null) {
            this.sourceSaxHandler.startElement(uri, localName, rawName, attributes);
        } else if (this.postprocessorSaxHandler != null) {
            this.postprocessorSaxHandler.startElement(uri, localName, rawName, attributes);
        } else if ("output".equals(rawName)) {
            String name = attributes.getValue("name");
            if (name == null) {
                throw new SAXException("The attribute name must be set for the tag output");
            }
            this.output = new Output(new QualifiedName(name));
            if (attributes.getValue("file") != null) {
                this.output.setFilename(attributes.getValue("file"));
            }
            if (attributes.getValue("existingTargetStrategy") != null) {
                this.output.setExistingTargetStrategy(attributes.getValue("existingTargetStrategy"));
            }
            if (attributes.getValue("outputDirKey") != null) {
                this.output.setOutputDirKey(attributes.getValue("outputDirKey"));
            }
            if (attributes.getValue("encoding") != null) {
                this.output.setEncoding(attributes.getValue("encoding"));
            }
            if (attributes.getValue("type") != null) {
                this.output.setType(attributes.getValue("type"));
            } else {
                this.output.setType("unknown");
            }
        } else if ("source".equals(rawName)) {
            String type = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            SourceSaxHandlerFactories sourceSaxHandlerFactories = this.configurationHandlers.getSourceSaxHandlerFactories();
            SourceSaxHandlerFactory sourceSaxHandlerFactory = sourceSaxHandlerFactories.getSourceSaxHandlerFactory(type);
            if (sourceSaxHandlerFactory == null) {
                throw new SAXException("Unknown source type " + type + ". Known source types are " + sourceSaxHandlerFactories.getSourceTypes());
            }
            this.sourceSaxHandler = sourceSaxHandlerFactory.getSourceSaxHandler(this.configurationProvider, this.unitDescriptor, this.configurationHandlers);
            this.sourceSaxHandler.startElement(uri, localName, rawName, attributes);
        } else if ("outlet".equals(rawName)) {
            this.contentOutletSaxHandler = new OutletReferenceSaxHandler();
            this.contentOutletSaxHandler.startElement(uri, localName, rawName, attributes);
        } else if ("postprocessor".equals(rawName)) {
            this.postprocessorSaxHandler = new ConfigurableClassSaxHandler(this.configurationProvider, this.unitDescriptor, "postprocessor");
            this.postprocessorSaxHandler.startElement(uri, localName, rawName, attributes);
        } else if ("filenameOutlet".equals(rawName)) {
            OutletConfigurationSaxHandler outletConfigurationSaxHandler = new OutletConfigurationSaxHandler(this.configurationProvider, this.unitDescriptor, this.configurationHandlers);
            String outletType = OutletConfigurationSaxHandler.getOutletType(attributes);
            this.filenameOutletSaxHandler = outletConfigurationSaxHandler.getOutletHandler(FILENAME_OUTLET_NAME, outletType);
            this.filenameOutletSaxHandler.startElement(uri, localName, rawName, attributes);
        } else {
            throw new SAXException("Unknown element " + rawName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String rawName) throws SAXException {
        if (this.contentOutletSaxHandler != null) {
            this.contentOutletSaxHandler.endElement(uri, localName, rawName);
            if (this.contentOutletSaxHandler.isFinished()) {
                this.output.setContentOutlet(this.contentOutletSaxHandler.getOutletReference());
                this.contentOutletSaxHandler = null;
            }
        } else if (this.sourceSaxHandler != null) {
            this.sourceSaxHandler.endElement(uri, localName, rawName);
            if (this.sourceSaxHandler.isFinished()) {
                this.output.setSourceProvider(this.sourceSaxHandler.getSourceProvider());
                this.output.setSourceProcessConfiguration(this.sourceSaxHandler.getSourceProcessConfiguration());
                this.sourceSaxHandler = null;
            }
        } else if (this.postprocessorSaxHandler != null) {
            this.postprocessorSaxHandler.endElement(uri, localName, rawName);
            if (this.postprocessorSaxHandler.isFinished()) {
                this.output.getPostprocessorDefinitions().add(new PostprocessorDefinition(this.postprocessorSaxHandler.getConfiguredClass()));
                this.postprocessorSaxHandler = null;
            }
        } else if (this.filenameOutletSaxHandler != null) {
            this.filenameOutletSaxHandler.endElement(uri, localName, rawName);
            if (this.filenameOutletSaxHandler.isFinished()) {
                this.output.setFilenameOutlet(this.filenameOutletSaxHandler.getOutlet());
                this.filenameOutletSaxHandler = null;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.contentOutletSaxHandler != null) {
            this.contentOutletSaxHandler.characters(ch, start, length);
        } else if (this.sourceSaxHandler != null) {
            this.sourceSaxHandler.characters(ch, start, length);
        } else if (this.filenameOutletSaxHandler != null) {
            this.filenameOutletSaxHandler.characters(ch, start, length);
        } else if (this.postprocessorSaxHandler != null) {
            this.postprocessorSaxHandler.characters(ch, start, length);
        }
    }
}

