/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import java.io.InputStream;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.paths.TorqueGeneratorPaths;

public abstract class AbstractConfigurationProvider
implements ConfigurationProvider {
    private final TorqueGeneratorPaths configurationPaths;

    public AbstractConfigurationProvider(TorqueGeneratorPaths configurationPaths) {
        if (configurationPaths == null) {
            throw new NullPointerException("configurationPaths is null");
        }
        this.configurationPaths = configurationPaths;
    }

    @Override
    public InputStream getControlConfigurationInputStream() throws ConfigurationException {
        return this.getInputStream(this.configurationPaths.getControlConfigurationFile(), this.configurationPaths.getConfigurationDirectory(), "control file");
    }

    @Override
    public InputStream getTemplateInputStream(String name) throws ConfigurationException {
        return this.getInputStream(name, this.configurationPaths.getTemplateDirectory(), "template");
    }

    @Override
    public InputStream getOutletConfigurationInputStream(String name) throws ConfigurationException {
        return this.getInputStream(name, this.configurationPaths.getOutletDirectory(), "outlet configuration");
    }

    @Override
    public InputStream getResourceInputStream(String name) throws ConfigurationException {
        return this.getInputStream(name, this.configurationPaths.getResourceDirectory(), "resource");
    }

    @Override
    public InputStream getOptionsInputStream(String name) throws ConfigurationException {
        return this.getInputStream(name, this.configurationPaths.getConfigurationDirectory(), "option");
    }

    protected abstract InputStream getInputStream(String var1, String var2, String var3) throws ConfigurationException;
}

