/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.AbstractCoupons;
import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.AuxHashMap;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllArray;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;

final class ToByteArrayImpl {
    ToByteArrayImpl() {
    }

    static byte[] toHllByteArray(AbstractHllArray impl, boolean compact) {
        int auxBytes = 0;
        if (impl.tgtHllType == TgtHllType.HLL_4) {
            AuxHashMap auxHashMap = impl.getAuxHashMap();
            auxBytes = auxHashMap != null ? (compact ? auxHashMap.getCompactSizeBytes() : auxHashMap.getUpdatableSizeBytes()) : (compact ? 0 : 4 << HllUtil.LG_AUX_ARR_INTS[impl.lgConfigK]);
        }
        int totBytes = PreambleUtil.HLL_BYTE_ARR_START + impl.getHllByteArrBytes() + auxBytes;
        byte[] byteArr = new byte[totBytes];
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        ToByteArrayImpl.insertHll(impl, wseg, compact);
        return byteArr;
    }

    private static void insertHll(AbstractHllArray impl, MemorySegment wseg, boolean compact) {
        ToByteArrayImpl.insertCommonHll(impl, wseg, compact);
        byte[] hllByteArr = ((HllArray)impl).hllByteArr;
        MemorySegment.copy(hllByteArr, 0, wseg, ValueLayout.JAVA_BYTE, (long)PreambleUtil.HLL_BYTE_ARR_START, hllByteArr.length);
        if (impl.getAuxHashMap() != null) {
            ToByteArrayImpl.insertAux(impl, wseg, compact);
        } else {
            wseg.set(ValueLayout.JAVA_INT_UNALIGNED, (long)PreambleUtil.AUX_COUNT_INT, 0);
        }
    }

    private static void insertCommonHll(AbstractHllArray srcImpl, MemorySegment tgtWseg, boolean compact) {
        PreambleUtil.insertPreInts(tgtWseg, srcImpl.getPreInts());
        PreambleUtil.insertSerVer(tgtWseg);
        PreambleUtil.insertFamilyId(tgtWseg);
        PreambleUtil.insertLgK(tgtWseg, srcImpl.getLgConfigK());
        PreambleUtil.insertEmptyFlag(tgtWseg, srcImpl.isEmpty());
        PreambleUtil.insertCompactFlag(tgtWseg, compact);
        PreambleUtil.insertOooFlag(tgtWseg, srcImpl.isOutOfOrder());
        PreambleUtil.insertCurMin(tgtWseg, srcImpl.getCurMin());
        PreambleUtil.insertCurMode(tgtWseg, srcImpl.getCurMode());
        PreambleUtil.insertTgtHllType(tgtWseg, srcImpl.getTgtHllType());
        PreambleUtil.insertHipAccum(tgtWseg, srcImpl.getHipAccum());
        PreambleUtil.insertKxQ0(tgtWseg, srcImpl.getKxQ0());
        PreambleUtil.insertKxQ1(tgtWseg, srcImpl.getKxQ1());
        PreambleUtil.insertNumAtCurMin(tgtWseg, srcImpl.getNumAtCurMin());
        PreambleUtil.insertRebuildCurMinNumKxQFlag(tgtWseg, srcImpl.isRebuildCurMinNumKxQFlag());
    }

    private static void insertAux(AbstractHllArray srcImpl, MemorySegment tgtWseg, boolean tgtCompact) {
        AuxHashMap auxHashMap = srcImpl.getAuxHashMap();
        int auxCount = auxHashMap.getAuxCount();
        PreambleUtil.insertAuxCount(tgtWseg, auxCount);
        PreambleUtil.insertLgArr(tgtWseg, auxHashMap.getLgAuxArrInts());
        long auxStart = srcImpl.auxStart;
        if (tgtCompact) {
            PairIterator itr = auxHashMap.getIterator();
            int cnt = 0;
            while (itr.nextValid()) {
                PreambleUtil.insertInt(tgtWseg, auxStart + (long)(cnt++ << 2), itr.getPair());
            }
            assert (cnt == auxCount);
        } else {
            int auxInts = 1 << auxHashMap.getLgAuxArrInts();
            int[] auxArr = auxHashMap.getAuxIntArr();
            MemorySegment.copy(auxArr, 0, tgtWseg, ValueLayout.JAVA_INT_UNALIGNED, auxStart, auxInts);
        }
    }

    static byte[] toCouponByteArray(AbstractCoupons impl, boolean dstCompact) {
        byte[] byteArrOut;
        int srcCouponCount = impl.getCouponCount();
        int srcLgCouponArrInts = impl.getLgCouponArrInts();
        int srcCouponArrInts = 1 << srcLgCouponArrInts;
        boolean list = impl.getCurMode() == CurMode.LIST;
        int sw = (impl.hasMemorySegment() ? 0 : 4) | (impl.isCompact() ? 0 : 2) | (dstCompact ? 0 : 1);
        switch (sw) {
            case 0: {
                MemorySegment srcSeg = impl.getMemorySegment();
                int bytesOut = impl.getSegDataStart() + (srcCouponCount << 2);
                byteArrOut = new byte[bytesOut];
                MemorySegment.copy(srcSeg, ValueLayout.JAVA_BYTE, 0L, byteArrOut, 0, bytesOut);
                break;
            }
            case 1: {
                int dataStart = impl.getSegDataStart();
                int bytesOut = dataStart + (srcCouponArrInts << 2);
                byteArrOut = new byte[bytesOut];
                MemorySegment segOut = MemorySegment.ofArray(byteArrOut);
                ToByteArrayImpl.copyCommonListAndSet(impl, segOut);
                PreambleUtil.insertCompactFlag(segOut, dstCompact);
                int[] tgtCouponIntArr = new int[srcCouponArrInts];
                PairIterator itr = impl.iterator();
                while (itr.nextValid()) {
                    int pair = itr.getPair();
                    int idx = AbstractCoupons.find(tgtCouponIntArr, srcLgCouponArrInts, pair);
                    if (idx < 0) {
                        tgtCouponIntArr[idx ^ 0xFFFFFFFF] = pair;
                        continue;
                    }
                    throw new SketchesStateException("Error: found duplicate.");
                }
                MemorySegment.copy(tgtCouponIntArr, 0, segOut, ValueLayout.JAVA_INT_UNALIGNED, (long)dataStart, srcCouponArrInts);
                if (list) {
                    PreambleUtil.insertListCount(segOut, srcCouponCount);
                    break;
                }
                PreambleUtil.insertHashSetCount(segOut, srcCouponCount);
                break;
            }
            case 2: 
            case 6: {
                int dataStart = impl.getSegDataStart();
                int bytesOut = dataStart + (srcCouponCount << 2);
                byteArrOut = new byte[bytesOut];
                MemorySegment segOut = MemorySegment.ofArray(byteArrOut);
                ToByteArrayImpl.copyCommonListAndSet(impl, segOut);
                PreambleUtil.insertCompactFlag(segOut, dstCompact);
                PairIterator itr = impl.iterator();
                int cnt = 0;
                while (itr.nextValid()) {
                    PreambleUtil.insertInt(segOut, dataStart + (cnt++ << 2), itr.getPair());
                }
                if (list) {
                    PreambleUtil.insertListCount(segOut, srcCouponCount);
                    break;
                }
                PreambleUtil.insertHashSetCount(segOut, srcCouponCount);
                break;
            }
            case 3: {
                MemorySegment srcSeg = impl.getMemorySegment();
                int bytesOut = impl.getSegDataStart() + (srcCouponArrInts << 2);
                byteArrOut = new byte[bytesOut];
                MemorySegment.copy(srcSeg, ValueLayout.JAVA_BYTE, 0L, byteArrOut, 0, bytesOut);
                break;
            }
            case 7: {
                int dataStart = impl.getSegDataStart();
                int bytesOut = dataStart + (srcCouponArrInts << 2);
                byteArrOut = new byte[bytesOut];
                MemorySegment segOut = MemorySegment.ofArray(byteArrOut);
                ToByteArrayImpl.copyCommonListAndSet(impl, segOut);
                MemorySegment.copy(impl.getCouponIntArr(), 0, segOut, ValueLayout.JAVA_INT_UNALIGNED, (long)dataStart, srcCouponArrInts);
                if (list) {
                    PreambleUtil.insertListCount(segOut, srcCouponCount);
                    break;
                }
                PreambleUtil.insertHashSetCount(segOut, srcCouponCount);
                break;
            }
            default: {
                throw new SketchesStateException("Corruption, should not happen: " + sw);
            }
        }
        return byteArrOut;
    }

    private static void copyCommonListAndSet(AbstractCoupons impl, MemorySegment wseg) {
        PreambleUtil.insertPreInts(wseg, impl.getPreInts());
        PreambleUtil.insertSerVer(wseg);
        PreambleUtil.insertFamilyId(wseg);
        PreambleUtil.insertLgK(wseg, impl.getLgConfigK());
        PreambleUtil.insertLgArr(wseg, impl.getLgCouponArrInts());
        PreambleUtil.insertEmptyFlag(wseg, impl.isEmpty());
        PreambleUtil.insertOooFlag(wseg, impl.isOutOfOrder());
        PreambleUtil.insertCurMode(wseg, impl.getCurMode());
        PreambleUtil.insertTgtHllType(wseg, impl.getTgtHllType());
    }
}

