/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io.processors.charset;

import java.nio.CharBuffer;
import java.nio.LongBuffer;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoderMalformedException;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.EncodingErrorPolicy;
import org.apache.daffodil.lib.schema.annotation.props.gen.EncodingErrorPolicy$Error$;
import org.apache.daffodil.lib.schema.annotation.props.gen.EncodingErrorPolicy$Replace$;
import org.apache.daffodil.lib.util.MaybeChar$;
import scala.MatchError;

public abstract class BitsCharsetDecoder {
    public abstract char decodeOneChar(InputSourceDataInputStream var1, FormatInfo var2);

    public final int decode(InputSourceDataInputStream dis, FormatInfo finfo, CharBuffer chars, LongBuffer bitPositions) {
        if (bitPositions != null && chars.remaining() > bitPositions.remaining()) {
            throw Assert$.MODULE$.abort("Invariant broken: bitPositions.==(null).||(chars.remaining().<=(bitPositions.remaining()))");
        }
        boolean keepDecoding = true;
        int charsToDecode = chars.remaining();
        int numDecoded = 0;
        while (keepDecoding && numDecoded < charsToDecode) {
            int maybeChar = this.decodeOneHandleMalformed(dis, finfo);
            if (MaybeChar$.MODULE$.isDefined$extension(maybeChar)) {
                chars.put(MaybeChar$.MODULE$.get$extension(maybeChar));
                if (bitPositions != null) {
                    bitPositions.put(dis.bitPos0b());
                }
                ++numDecoded;
                continue;
            }
            keepDecoding = false;
        }
        return numDecoded;
    }

    public LongBuffer decode$default$4() {
        return null;
    }

    private int decodeOneHandleMalformed(InputSourceDataInputStream dis, FormatInfo finfo) {
        int n;
        try {
            char c = this.decodeOneChar(dis, finfo);
            n = MaybeChar$.MODULE$.apply(c);
        }
        catch (BitsCharsetDecoderMalformedException e) {
            if (e.malformedBits() == 0) {
                n = MaybeChar$.MODULE$.Nope();
            }
            EncodingErrorPolicy encodingErrorPolicy = finfo.encodingErrorPolicy();
            if (EncodingErrorPolicy$Replace$.MODULE$.equals(encodingErrorPolicy)) {
                n = MaybeChar$.MODULE$.apply((char)65533);
            }
            if (EncodingErrorPolicy$Error$.MODULE$.equals(encodingErrorPolicy)) {
                throw Assert$.MODULE$.nyi("dfdl:encodingErrorPolicy=\"error\"");
            }
            throw new MatchError((Object)encodingErrorPolicy);
        }
        return n;
    }

    public abstract void reset();
}

