/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MutableObjectTest
extends AbstractLangTest {
    MutableObjectTest() {
    }

    @Test
    void testConstructors() {
        Assertions.assertNull((Object)new MutableObject().get());
        Integer i = 6;
        Assertions.assertSame((Object)i, (Object)new MutableObject((Object)i).get());
        Assertions.assertSame((Object)"HI", (Object)new MutableObject((Object)"HI").get());
        Assertions.assertSame(null, (Object)new MutableObject(null).get());
    }

    @Test
    void testEquals() {
        MutableObject mutNumA = new MutableObject((Object)"ALPHA");
        MutableObject mutNumB = new MutableObject((Object)"ALPHA");
        MutableObject mutNumC = new MutableObject((Object)"BETA");
        MutableObject mutNumNull1 = new MutableObject(null);
        MutableObject mutNumNull2 = new MutableObject(null);
        Assertions.assertFalse((boolean)mutNumA.equals(null));
        Assertions.assertEquals((Object)mutNumA, (Object)mutNumA);
        Assertions.assertEquals((Object)mutNumA, (Object)mutNumB);
        Assertions.assertEquals((Object)mutNumB, (Object)mutNumA);
        Assertions.assertEquals((Object)mutNumB, (Object)mutNumB);
        Assertions.assertNotEquals((Object)mutNumA, (Object)mutNumC);
        Assertions.assertNotEquals((Object)mutNumB, (Object)mutNumC);
        Assertions.assertEquals((Object)mutNumC, (Object)mutNumC);
        Assertions.assertNotEquals((Object)mutNumA, (Object)mutNumNull1);
        Assertions.assertEquals((Object)mutNumNull1, (Object)mutNumNull1);
        Assertions.assertEquals((Object)mutNumNull1, (Object)mutNumNull2);
        Assertions.assertEquals((Object)mutNumNull2, (Object)mutNumNull1);
        Assertions.assertNotEquals(null, (Object)mutNumA);
        Assertions.assertNotEquals((Object)mutNumA, (Object)new Object());
        Assertions.assertNotEquals((Object)"0", (Object)mutNumA);
    }

    @Test
    void testGetSet() {
        MutableObject mutNum = new MutableObject();
        Assertions.assertNull((Object)new MutableObject().get());
        Assertions.assertNull((Object)new MutableObject().getValue());
        mutNum.setValue((Object)"HELLO");
        Assertions.assertSame((Object)"HELLO", (Object)mutNum.get());
        Assertions.assertSame((Object)"HELLO", (Object)mutNum.getValue());
        mutNum.setValue(null);
        Assertions.assertSame(null, (Object)mutNum.get());
        Assertions.assertSame(null, (Object)mutNum.getValue());
    }

    @Test
    void testHashCode() {
        MutableObject mutNumA = new MutableObject((Object)"ALPHA");
        MutableObject mutNumB = new MutableObject((Object)"ALPHA");
        MutableObject mutNumC = new MutableObject((Object)"BETA");
        MutableObject mutNumD = new MutableObject(null);
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumA.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumB.hashCode());
        Assertions.assertNotEquals((int)mutNumA.hashCode(), (int)mutNumC.hashCode());
        Assertions.assertNotEquals((int)mutNumA.hashCode(), (int)mutNumD.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)"ALPHA".hashCode());
        Assertions.assertEquals((int)0, (int)mutNumD.hashCode());
    }

    @Test
    void testToString() {
        Assertions.assertEquals((Object)"HI", (Object)new MutableObject((Object)"HI").toString());
        Assertions.assertEquals((Object)"10.0", (Object)new MutableObject((Object)10.0).toString());
        Assertions.assertEquals((Object)"null", (Object)new MutableObject(null).toString());
    }
}

