/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.TimeZones;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.DefaultLocale;
import org.junitpioneer.jupiter.DefaultTimeZone;
import org.junitpioneer.jupiter.ReadsDefaultLocale;
import org.junitpioneer.jupiter.WritesDefaultLocale;

@ReadsDefaultLocale
@WritesDefaultLocale
class DateUtilsTest
extends AbstractLangTest {
    private static final TimeZone TIME_ZONE_NY = TimeZone.getTimeZone("America/New_York");
    private static final TimeZone TIME_ZONE_DEFAULT = TimeZone.getDefault();
    private static final TimeZone TIME_ZONE_MET = TimeZone.getTimeZone("MET");
    private static Date BASE_DATE;
    private DateFormat dateParser;
    private DateFormat dateTimeParser;
    private Date dateAmPm1;
    private Date dateAmPm2;
    private Date dateAmPm3;
    private Date dateAmPm4;
    private Date date0;
    private Date date1;
    private Date date2;
    private Date date3;
    private Date date4;
    private Date date5;
    private Date date6;
    private Date date7;
    private Date date8;
    private Calendar calAmPm1;
    private Calendar calAmPm2;
    private Calendar calAmPm3;
    private Calendar calAmPm4;
    private Calendar cal1;
    private Calendar cal2;
    private Calendar cal3;
    private Calendar cal4;
    private Calendar cal5;
    private Calendar cal6;
    private Calendar cal7;
    private Calendar cal8;

    DateUtilsTest() {
    }

    private static void assertCalendarsEquals(String message, Calendar cal1, Calendar cal2, long delta) {
        Assertions.assertFalse((Math.abs(cal1.getTime().getTime() - cal2.getTime().getTime()) > delta ? 1 : 0) != 0, (String)(message + " expected " + cal1.getTime() + " but got " + cal2.getTime()));
    }

    private static void assertWeekIterator(Iterator<?> it, Calendar start) {
        Calendar end = (Calendar)start.clone();
        end.add(5, 6);
        DateUtilsTest.assertWeekIterator(it, start, end);
    }

    private static void assertWeekIterator(Iterator<?> it, Calendar start, Calendar end) {
        Calendar cal = (Calendar)it.next();
        DateUtilsTest.assertCalendarsEquals("", start, cal, 0L);
        int count = 1;
        while (it.hasNext()) {
            DateUtilsTest.assertCalendarsEquals("", cal, DateUtils.truncate((Calendar)cal, (int)5), 0L);
            Calendar last = cal;
            cal = (Calendar)it.next();
            ++count;
            last.add(5, 1);
            DateUtilsTest.assertCalendarsEquals("", last, cal, 0L);
        }
        Assertions.assertFalse((count % 7 != 0 ? 1 : 0) != 0, (String)("There were " + count + " days in this iterator"));
        DateUtilsTest.assertCalendarsEquals("", end, cal, 0L);
    }

    private static void assertWeekIterator(Iterator<?> it, Date start, Date end) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(start);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(end);
        DateUtilsTest.assertWeekIterator(it, calStart, calEnd);
    }

    @BeforeAll
    public static void classSetup() {
        GregorianCalendar cal = new GregorianCalendar(2000, 6, 5, 4, 3, 2);
        cal.set(14, 1);
        BASE_DATE = cal.getTime();
    }

    private static Stream<Arguments> testToLocalDateTimeTimeZone() {
        return Stream.of(Arguments.of((Object[])new Object[]{LocalDateTime.of(-292275055, 5, 16, 16, 47, 4, 192000000), new Date(Long.MIN_VALUE), TimeZones.GMT}), Arguments.of((Object[])new Object[]{LocalDateTime.of(292278994, 8, 17, 7, 12, 55, 807000000), new Date(Long.MAX_VALUE), TimeZones.GMT}), Arguments.of((Object[])new Object[]{LocalDateTime.ofInstant(Instant.EPOCH, TimeZones.GMT.toZoneId()), Date.from(LocalDateTime.of(1970, 1, 1, 0, 0).atOffset(ZoneOffset.UTC).toInstant()), TimeZones.GMT}), Arguments.of((Object[])new Object[]{LocalDateTime.ofInstant(Instant.EPOCH.minus(1L, ChronoUnit.DAYS), TimeZones.GMT.toZoneId()), Date.from(LocalDateTime.of(1969, 12, 31, 0, 0).atOffset(ZoneOffset.UTC).toInstant()), TimeZones.GMT}), Arguments.of((Object[])new Object[]{LocalDateTime.ofInstant(Timestamp.valueOf("2000-01-01 12:30:45").toInstant(), TIME_ZONE_NY.toZoneId()), Timestamp.valueOf("2000-01-01 12:30:45"), TIME_ZONE_NY}), Arguments.of((Object[])new Object[]{LocalDateTime.ofInstant(Timestamp.valueOf("2023-03-12 02:30:00").toInstant(), TIME_ZONE_NY.toZoneId()), Timestamp.valueOf("2023-03-12 02:30:00"), TIME_ZONE_NY}), Arguments.of((Object[])new Object[]{LocalDateTime.ofInstant(Timestamp.valueOf("2023-03-12 02:30:00").toInstant(), TimeZone.getDefault().toZoneId()), Timestamp.valueOf("2023-03-12 02:30:00"), null}), Arguments.of((Object[])new Object[]{LocalDateTime.of(2022, 12, 31, 19, 0), Date.from(LocalDateTime.of(2023, 1, 1, 0, 0).atOffset(ZoneOffset.UTC).toInstant()), TIME_ZONE_NY}), Arguments.of((Object[])new Object[]{LocalDateTime.of(2023, 3, 12, 3, 0), Date.from(LocalDateTime.of(2023, 3, 12, 7, 0).atOffset(ZoneOffset.UTC).toInstant()), TIME_ZONE_NY}), Arguments.of((Object[])new Object[]{LocalDateTime.of(2023, 1, 1, 14, 0), Date.from(LocalDateTime.of(2023, 1, 1, 0, 0).atOffset(ZoneOffset.UTC).toInstant()), TimeZone.getTimeZone("Pacific/Kiritimati")}));
    }

    @AfterEach
    public void afterEachResetTimeZones() {
        TimeZone.setDefault(TIME_ZONE_DEFAULT);
        this.dateTimeParser.setTimeZone(TIME_ZONE_DEFAULT);
    }

    private void assertDate(Date date, int year, int month, int day, int hour, int min, int sec, int mil) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        Assertions.assertEquals((int)year, (int)cal.get(1));
        Assertions.assertEquals((int)month, (int)cal.get(2));
        Assertions.assertEquals((int)day, (int)cal.get(5));
        Assertions.assertEquals((int)hour, (int)cal.get(11));
        Assertions.assertEquals((int)min, (int)cal.get(12));
        Assertions.assertEquals((int)sec, (int)cal.get(13));
        Assertions.assertEquals((int)mil, (int)cal.get(14));
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.dateParser = new SimpleDateFormat("MMM dd, yyyy", Locale.ENGLISH);
        this.dateTimeParser = new SimpleDateFormat("MMM dd, yyyy H:mm:ss.SSS", Locale.ENGLISH);
        this.dateAmPm1 = this.dateTimeParser.parse("February 3, 2002 01:10:00.000");
        this.dateAmPm2 = this.dateTimeParser.parse("February 3, 2002 11:10:00.000");
        this.dateAmPm3 = this.dateTimeParser.parse("February 3, 2002 13:10:00.000");
        this.dateAmPm4 = this.dateTimeParser.parse("February 3, 2002 19:10:00.000");
        this.date0 = this.dateTimeParser.parse("February 3, 2002 12:34:56.789");
        this.date1 = this.dateTimeParser.parse("February 12, 2002 12:34:56.789");
        this.date2 = this.dateTimeParser.parse("November 18, 2001 1:23:11.321");
        try {
            TimeZone.setDefault(TIME_ZONE_MET);
            this.dateTimeParser.setTimeZone(TIME_ZONE_MET);
            this.date3 = this.dateTimeParser.parse("March 30, 2003 05:30:45.000");
            this.date4 = this.dateTimeParser.parse("March 30, 2003 01:10:00.000");
            this.date5 = this.dateTimeParser.parse("March 30, 2003 01:40:00.000");
            this.date6 = this.dateTimeParser.parse("March 30, 2003 02:10:00.000");
            this.date7 = this.dateTimeParser.parse("March 30, 2003 02:40:00.000");
            this.date8 = this.dateTimeParser.parse("October 26, 2003 05:30:45.000");
        }
        finally {
            this.dateTimeParser.setTimeZone(TIME_ZONE_DEFAULT);
            TimeZone.setDefault(TIME_ZONE_DEFAULT);
        }
        this.calAmPm1 = Calendar.getInstance();
        this.calAmPm1.setTime(this.dateAmPm1);
        this.calAmPm2 = Calendar.getInstance();
        this.calAmPm2.setTime(this.dateAmPm2);
        this.calAmPm3 = Calendar.getInstance();
        this.calAmPm3.setTime(this.dateAmPm3);
        this.calAmPm4 = Calendar.getInstance();
        this.calAmPm4.setTime(this.dateAmPm4);
        this.cal1 = Calendar.getInstance();
        this.cal1.setTime(this.date1);
        this.cal2 = Calendar.getInstance();
        this.cal2.setTime(this.date2);
        try {
            TimeZone.setDefault(TIME_ZONE_MET);
            this.cal3 = Calendar.getInstance();
            this.cal3.setTime(this.date3);
            this.cal4 = Calendar.getInstance();
            this.cal4.setTime(this.date4);
            this.cal5 = Calendar.getInstance();
            this.cal5.setTime(this.date5);
            this.cal6 = Calendar.getInstance();
            this.cal6.setTime(this.date6);
            this.cal7 = Calendar.getInstance();
            this.cal7.setTime(this.date7);
            this.cal8 = Calendar.getInstance();
            this.cal8.setTime(this.date8);
        }
        finally {
            TimeZone.setDefault(TIME_ZONE_DEFAULT);
        }
    }

    @Test
    void testAddDays() throws Exception {
        Date result = DateUtils.addDays((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addDays((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 6, 4, 3, 2, 1);
        result = DateUtils.addDays((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 4, 4, 3, 2, 1);
        LangAssertions.assertNullPointerException(() -> DateUtils.addDays(null, (int)0));
    }

    @Test
    void testAddHours() throws Exception {
        Date result = DateUtils.addHours((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addHours((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 5, 3, 2, 1);
        result = DateUtils.addHours((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 3, 3, 2, 1);
        LangAssertions.assertNullPointerException(() -> DateUtils.addHours(null, (int)0));
    }

    @Test
    void testAddMilliseconds() throws Exception {
        Date result = DateUtils.addMilliseconds((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addMilliseconds((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 2);
        result = DateUtils.addMilliseconds((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 0);
        LangAssertions.assertNullPointerException(() -> DateUtils.addMilliseconds(null, (int)0));
    }

    @Test
    void testAddMinutes() throws Exception {
        Date result = DateUtils.addMinutes((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addMinutes((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 4, 2, 1);
        result = DateUtils.addMinutes((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 2, 2, 1);
        LangAssertions.assertNullPointerException(() -> DateUtils.addMinutes(null, (int)0));
    }

    @Test
    void testAddMonths() throws Exception {
        Date result = DateUtils.addMonths((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addMonths((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 7, 5, 4, 3, 2, 1);
        result = DateUtils.addMonths((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 5, 5, 4, 3, 2, 1);
        LangAssertions.assertNullPointerException(() -> DateUtils.addMonths(null, (int)0));
    }

    @Test
    void testAddSeconds() throws Exception {
        Date result = DateUtils.addSeconds((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addSeconds((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 3, 1);
        result = DateUtils.addSeconds((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 1, 1);
        LangAssertions.assertNullPointerException(() -> DateUtils.addSeconds(null, (int)0));
    }

    @Test
    void testAddWeeks() throws Exception {
        Date result = DateUtils.addWeeks((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addWeeks((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 12, 4, 3, 2, 1);
        result = DateUtils.addWeeks((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 5, 28, 4, 3, 2, 1);
        LangAssertions.assertNullPointerException(() -> DateUtils.addMonths(null, (int)0));
    }

    @Test
    void testAddYears() throws Exception {
        Date result = DateUtils.addYears((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addYears((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2001, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addYears((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 1999, 6, 5, 4, 3, 2, 1);
        LangAssertions.assertNullPointerException(() -> DateUtils.addYears(null, (int)0));
    }

    @Test
    void testCeiling() throws Exception {
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 28, 2002 14:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateTimeParser.parse("March 28, 2002 13:45:01.231"), (int)10), (String)"ceiling javadoc-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("April 1, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateTimeParser.parse("March 28, 2002 13:45:01.231"), (int)2), (String)"ceiling javadoc-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2003"), (Object)DateUtils.ceiling((Date)this.date1, (int)1), (String)"ceiling year-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.ceiling((Date)this.date2, (int)1), (String)"ceiling year-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("March 1, 2002"), (Object)DateUtils.ceiling((Date)this.date1, (int)2), (String)"ceiling month-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.ceiling((Date)this.date2, (int)2), (String)"ceiling month-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 16, 2002"), (Object)DateUtils.ceiling((Date)this.date1, (int)1001), (String)"ceiling semimonth-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.ceiling((Date)this.date2, (int)1001), (String)"ceiling semimonth-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 13, 2002"), (Object)DateUtils.ceiling((Date)this.date1, (int)5), (String)"ceiling date-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 19, 2001"), (Object)DateUtils.ceiling((Date)this.date2, (int)5), (String)"ceiling date-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 13:00:00.000"), (Object)DateUtils.ceiling((Date)this.date1, (int)10), (String)"ceiling hour-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 2:00:00.000"), (Object)DateUtils.ceiling((Date)this.date2, (int)10), (String)"ceiling hour-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:35:00.000"), (Object)DateUtils.ceiling((Date)this.date1, (int)12), (String)"ceiling minute-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:24:00.000"), (Object)DateUtils.ceiling((Date)this.date2, (int)12), (String)"ceiling minute-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.ceiling((Date)this.date1, (int)13), (String)"ceiling second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:12.000"), (Object)DateUtils.ceiling((Date)this.date2, (int)13), (String)"ceiling second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateAmPm1, (int)9), (String)"ceiling ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateAmPm2, (int)9), (String)"ceiling ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateAmPm3, (int)9), (String)"ceiling ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateAmPm4, (int)9), (String)"ceiling ampm-4 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2003"), (Object)DateUtils.ceiling((Object)this.date1, (int)1), (String)"ceiling year-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.ceiling((Object)this.date2, (int)1), (String)"ceiling year-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("March 1, 2002"), (Object)DateUtils.ceiling((Object)this.date1, (int)2), (String)"ceiling month-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.ceiling((Object)this.date2, (int)2), (String)"ceiling month-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 16, 2002"), (Object)DateUtils.ceiling((Object)this.date1, (int)1001), (String)"ceiling semimonth-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.ceiling((Object)this.date2, (int)1001), (String)"ceiling semimonth-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 13, 2002"), (Object)DateUtils.ceiling((Object)this.date1, (int)5), (String)"ceiling date-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 19, 2001"), (Object)DateUtils.ceiling((Object)this.date2, (int)5), (String)"ceiling date-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 13:00:00.000"), (Object)DateUtils.ceiling((Object)this.date1, (int)10), (String)"ceiling hour-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 2:00:00.000"), (Object)DateUtils.ceiling((Object)this.date2, (int)10), (String)"ceiling hour-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:35:00.000"), (Object)DateUtils.ceiling((Object)this.date1, (int)12), (String)"ceiling minute-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:24:00.000"), (Object)DateUtils.ceiling((Object)this.date2, (int)12), (String)"ceiling minute-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.ceiling((Object)this.date1, (int)13), (String)"ceiling second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:12.000"), (Object)DateUtils.ceiling((Object)this.date2, (int)13), (String)"ceiling second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Object)this.dateAmPm1, (int)9), (String)"ceiling ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Object)this.dateAmPm2, (int)9), (String)"ceiling ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.dateAmPm3, (int)9), (String)"ceiling ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.dateAmPm4, (int)9), (String)"ceiling ampm-4 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.ceiling((Object)this.cal1, (int)13), (String)"ceiling calendar second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:12.000"), (Object)DateUtils.ceiling((Object)this.cal2, (int)13), (String)"ceiling calendar second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Object)this.calAmPm1, (int)9), (String)"ceiling ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Object)this.calAmPm2, (int)9), (String)"ceiling ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.calAmPm3, (int)9), (String)"ceiling ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.calAmPm4, (int)9), (String)"ceiling ampm-4 failed");
        LangAssertions.assertNullPointerException(() -> DateUtils.ceiling((Date)null, (int)13));
        LangAssertions.assertNullPointerException(() -> DateUtils.ceiling((Calendar)null, (int)13));
        LangAssertions.assertNullPointerException(() -> DateUtils.ceiling(null, (int)13));
        Assertions.assertThrows(ClassCastException.class, () -> DateUtils.ceiling((Object)"", (int)13));
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.ceiling((Date)this.date1, (int)-9999));
    }

    @Test
    void testCeiling_Bugzilla_31395() throws Exception {
        Date endOfTime = new Date(Long.MAX_VALUE);
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(endOfTime);
        Assertions.assertThrows(ArithmeticException.class, () -> DateUtils.ceiling((Calendar)endCal, (int)5));
        endCal.set(1, 280000001);
        Assertions.assertThrows(ArithmeticException.class, () -> DateUtils.ceiling((Calendar)endCal, (int)5));
        endCal.set(1, 280000000);
        Calendar cal = DateUtils.ceiling((Calendar)endCal, (int)5);
        Assertions.assertEquals((int)0, (int)cal.get(10));
    }

    @Test
    void testCeiling_MET() throws Exception {
        TimeZone.setDefault(TIME_ZONE_MET);
        this.dateTimeParser.setTimeZone(TIME_ZONE_MET);
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.date4, (int)5), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal4, (int)5), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.date5, (int)5), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal5, (int)5), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.date6, (int)5), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal6, (int)5), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.date7, (int)5), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal7, (int)5), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.ceiling((Date)this.date4, (int)11), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal4, (int)11), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.ceiling((Date)this.date5, (int)11), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal5, (int)11), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.ceiling((Date)this.date6, (int)11), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal6, (int)11), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.ceiling((Date)this.date7, (int)11), (String)"ceiling MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal7, (int)11), (String)"ceiling MET date across DST change-over");
    }

    @Test
    void testConstructor() {
        Assertions.assertNotNull((Object)new DateUtils());
        Constructor<?>[] cons = DateUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(DateUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(DateUtils.class.getModifiers()));
    }

    @Test
    void testIsSameDay_Cal() {
        GregorianCalendar cala = new GregorianCalendar(2004, 6, 9, 13, 45);
        GregorianCalendar calb = new GregorianCalendar(2004, 6, 9, 13, 45);
        Assertions.assertTrue((boolean)DateUtils.isSameDay((Calendar)cala, (Calendar)calb));
        calb.add(6, 1);
        Assertions.assertFalse((boolean)DateUtils.isSameDay((Calendar)cala, (Calendar)calb));
        cala.add(6, 1);
        Assertions.assertTrue((boolean)DateUtils.isSameDay((Calendar)cala, (Calendar)calb));
        calb.add(1, 1);
        Assertions.assertFalse((boolean)DateUtils.isSameDay((Calendar)cala, (Calendar)calb));
    }

    @Test
    void testIsSameDay_CalNotNullNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameDay((Calendar)Calendar.getInstance(), null));
    }

    @Test
    void testIsSameDay_CalNullNotNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameDay(null, (Calendar)Calendar.getInstance()));
    }

    @Test
    void testIsSameDay_CalNullNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameDay((Calendar)null, null));
    }

    @Test
    void testIsSameDay_Date() {
        Date datea = new GregorianCalendar(2004, 6, 9, 13, 45).getTime();
        Date dateb = new GregorianCalendar(2004, 6, 9, 13, 45).getTime();
        Assertions.assertTrue((boolean)DateUtils.isSameDay((Date)datea, (Date)dateb));
        dateb = new GregorianCalendar(2004, 6, 10, 13, 45).getTime();
        Assertions.assertFalse((boolean)DateUtils.isSameDay((Date)datea, (Date)dateb));
        datea = new GregorianCalendar(2004, 6, 10, 13, 45).getTime();
        Assertions.assertTrue((boolean)DateUtils.isSameDay((Date)datea, (Date)dateb));
        dateb = new GregorianCalendar(2005, 6, 10, 13, 45).getTime();
        Assertions.assertFalse((boolean)DateUtils.isSameDay((Date)datea, (Date)dateb));
    }

    @Test
    void testIsSameDay_DateNotNullNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameDay((Date)new Date(), null));
    }

    @Test
    void testIsSameDay_DateNullNotNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameDay(null, (Date)new Date()));
    }

    @Test
    void testIsSameDay_DateNullNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameDay((Date)null, null));
    }

    @Test
    void testIsSameInstant_Cal() {
        GregorianCalendar cala = new GregorianCalendar(TimeZone.getTimeZone("GMT+1"));
        GregorianCalendar calb = new GregorianCalendar(TimeZone.getTimeZone("GMT-1"));
        cala.set(2004, 6, 9, 13, 45, 0);
        cala.set(14, 0);
        calb.set(2004, 6, 9, 13, 45, 0);
        calb.set(14, 0);
        Assertions.assertFalse((boolean)DateUtils.isSameInstant((Calendar)cala, (Calendar)calb));
        calb.set(2004, 6, 9, 11, 45, 0);
        Assertions.assertTrue((boolean)DateUtils.isSameInstant((Calendar)cala, (Calendar)calb));
    }

    @Test
    void testIsSameInstant_CalNotNullNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameInstant((Calendar)Calendar.getInstance(), null));
    }

    @Test
    void testIsSameInstant_CalNullNotNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameInstant(null, (Calendar)Calendar.getInstance()));
    }

    @Test
    void testIsSameInstant_CalNullNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameInstant((Calendar)null, null));
    }

    @Test
    void testIsSameInstant_Date() {
        Date datea = new GregorianCalendar(2004, 6, 9, 13, 45).getTime();
        Date dateb = new GregorianCalendar(2004, 6, 9, 13, 45).getTime();
        Assertions.assertTrue((boolean)DateUtils.isSameInstant((Date)datea, (Date)dateb));
        dateb = new GregorianCalendar(2004, 6, 10, 13, 45).getTime();
        Assertions.assertFalse((boolean)DateUtils.isSameInstant((Date)datea, (Date)dateb));
        datea = new GregorianCalendar(2004, 6, 10, 13, 45).getTime();
        Assertions.assertTrue((boolean)DateUtils.isSameInstant((Date)datea, (Date)dateb));
        dateb = new GregorianCalendar(2005, 6, 10, 13, 45).getTime();
        Assertions.assertFalse((boolean)DateUtils.isSameInstant((Date)datea, (Date)dateb));
    }

    @Test
    void testIsSameInstant_DateNotNullNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameInstant((Date)new Date(), null));
    }

    @Test
    void testIsSameInstant_DateNullNotNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameInstant(null, (Date)new Date()));
    }

    @Test
    void testIsSameInstant_DateNullNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameInstant((Date)null, null));
    }

    @Test
    void testIsSameLocalTime_Cal() {
        GregorianCalendar cala = new GregorianCalendar(TimeZone.getTimeZone("GMT+1"));
        GregorianCalendar calb = new GregorianCalendar(TimeZone.getTimeZone("GMT-1"));
        cala.set(2004, 6, 9, 13, 45, 0);
        cala.set(14, 0);
        calb.set(2004, 6, 9, 13, 45, 0);
        calb.set(14, 0);
        Assertions.assertTrue((boolean)DateUtils.isSameLocalTime((Calendar)cala, (Calendar)calb));
        Calendar calc = Calendar.getInstance();
        Calendar cald = Calendar.getInstance();
        calc.set(2004, 6, 9, 4, 0, 0);
        cald.set(2004, 6, 9, 16, 0, 0);
        calc.set(14, 0);
        cald.set(14, 0);
        Assertions.assertFalse((boolean)DateUtils.isSameLocalTime((Calendar)calc, (Calendar)cald), (String)"LANG-677");
        calb.set(2004, 6, 9, 11, 45, 0);
        Assertions.assertFalse((boolean)DateUtils.isSameLocalTime((Calendar)cala, (Calendar)calb));
    }

    @Test
    void testIsSameLocalTime_CalNotNullNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameLocalTime((Calendar)Calendar.getInstance(), null));
    }

    @Test
    void testIsSameLocalTime_CalNullNotNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameLocalTime(null, (Calendar)Calendar.getInstance()));
    }

    @Test
    void testIsSameLocalTime_CalNullNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.isSameLocalTime(null, null));
    }

    @Test
    void testIteratorEx() {
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.iterator((Calendar)Calendar.getInstance(), (int)-9999));
        LangAssertions.assertNullPointerException(() -> DateUtils.iterator((Date)null, (int)4));
        LangAssertions.assertNullPointerException(() -> DateUtils.iterator((Calendar)null, (int)4));
        LangAssertions.assertNullPointerException(() -> DateUtils.iterator(null, (int)4));
        Assertions.assertThrows(ClassCastException.class, () -> DateUtils.iterator((Object)"", (int)4));
    }

    @Test
    void testLang530() throws ParseException {
        Date d = new Date();
        String isoDateStr = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(d);
        Date d2 = DateUtils.parseDate((String)isoDateStr, (String[])new String[]{DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern()});
        Assertions.assertEquals((long)d.getTime(), (long)(d2.getTime() + d.getTime() % 1000L), (String)"Date not equal to itself ISO formatted and parsed");
    }

    @Test
    void testLANG799() throws ParseException {
        DateUtils.parseDateStrictly((String)"09 abril 2008 23:55:38 GMT", (Locale)new Locale("es"), (String[])new String[]{"dd MMM yyyy HH:mm:ss zzz"});
    }

    @DefaultLocale(language="de")
    @Test
    void testLANG799_DE_FAIL() {
        Assertions.assertThrows(ParseException.class, () -> DateUtils.parseDate((String)"Wed, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"}));
    }

    @DefaultLocale(language="de")
    @Test
    void testLANG799_DE_OK() throws ParseException {
        DateUtils.parseDate((String)"Mi, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
        DateUtils.parseDateStrictly((String)"Mi, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
    }

    @DefaultLocale(language="en")
    @Test
    void testLANG799_EN_FAIL() {
        Assertions.assertThrows(ParseException.class, () -> DateUtils.parseDate((String)"Mi, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"}));
    }

    @DefaultLocale(language="en")
    @Test
    void testLANG799_EN_OK() throws ParseException {
        DateUtils.parseDate((String)"Wed, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
        DateUtils.parseDateStrictly((String)"Wed, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
    }

    @DefaultLocale(language="en")
    @Test
    void testLANG799_EN_WITH_DE_LOCALE() throws ParseException {
        DateUtils.parseDate((String)"Mi, 09 Apr 2008 23:55:38 GMT", (Locale)Locale.GERMAN, (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
    }

    @Test
    void testMonthIterator() throws Exception {
        Iterator it = DateUtils.iterator((Date)this.date1, (int)5);
        DateUtilsTest.assertWeekIterator(it, this.dateParser.parse("January 27, 2002"), this.dateParser.parse("March 2, 2002"));
        it = DateUtils.iterator((Date)this.date1, (int)6);
        DateUtilsTest.assertWeekIterator(it, this.dateParser.parse("January 28, 2002"), this.dateParser.parse("March 3, 2002"));
        it = DateUtils.iterator((Date)this.date2, (int)5);
        DateUtilsTest.assertWeekIterator(it, this.dateParser.parse("October 28, 2001"), this.dateParser.parse("December 1, 2001"));
        it = DateUtils.iterator((Date)this.date2, (int)6);
        DateUtilsTest.assertWeekIterator(it, this.dateParser.parse("October 29, 2001"), this.dateParser.parse("December 2, 2001"));
    }

    @Test
    void testParse_EmptyParsers() {
        Assertions.assertThrows(ParseException.class, () -> DateUtils.parseDate((String)"19721203", (String[])new String[0]));
    }

    @Test
    void testParse_NullParsers() {
        LangAssertions.assertNullPointerException(() -> DateUtils.parseDate((String)"19721203", (String[])null));
    }

    @Test
    void testParseDate() throws Exception {
        GregorianCalendar cal = new GregorianCalendar(1972, 11, 3);
        String dateStr = "1972-12-03";
        String[] parsers = new String[]{"yyyy'-'DDD", "yyyy'-'MM'-'dd", "yyyyMMdd"};
        Date date = DateUtils.parseDate((String)dateStr, (String[])parsers);
        Assertions.assertEquals((Object)cal.getTime(), (Object)date);
        dateStr = "1972-338";
        date = DateUtils.parseDate((String)dateStr, (String[])parsers);
        Assertions.assertEquals((Object)cal.getTime(), (Object)date);
        dateStr = "19721203";
        date = DateUtils.parseDate((String)dateStr, (String[])parsers);
        Assertions.assertEquals((Object)cal.getTime(), (Object)date);
    }

    @Test
    void testParseDate_InvalidDateString() {
        String[] parsers = new String[]{"yyyy'-'DDD", "yyyy'-'MM'-'dd", "yyyyMMdd"};
        Assertions.assertThrows(ParseException.class, () -> DateUtils.parseDate((String)"197212AB", (String[])parsers));
    }

    @Test
    void testParseDate_NoDateString() {
        String[] parsers = new String[]{"yyyy'-'DDD", "yyyy'-'MM'-'dd", "yyyyMMdd"};
        Assertions.assertThrows(ParseException.class, () -> DateUtils.parseDate((String)"PURPLE", (String[])parsers));
    }

    @Test
    void testParseDate_Null() {
        String[] parsers = new String[]{"yyyy'-'DDD", "yyyy'-'MM'-'dd", "yyyyMMdd"};
        LangAssertions.assertNullPointerException(() -> DateUtils.parseDate(null, (String[])parsers));
    }

    @Test
    void testParseDateWithLeniency() throws ParseException {
        GregorianCalendar cal = new GregorianCalendar(1998, 6, 30);
        String dateStr = "02 942, 1996";
        String[] parsers = new String[]{"MM DDD, yyyy"};
        Date date = DateUtils.parseDate((String)"02 942, 1996", (String[])parsers);
        Assertions.assertEquals((Object)cal.getTime(), (Object)date);
        Assertions.assertThrows(ParseException.class, () -> DateUtils.parseDateStrictly((String)"02 942, 1996", (String[])parsers));
    }

    @Test
    void testRound() throws Exception {
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.round((Date)this.date1, (int)1), (String)"round year-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.round((Date)this.date2, (int)1), (String)"round year-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.round((Date)this.date1, (int)2), (String)"round month-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.round((Date)this.date2, (int)2), (String)"round month-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.round((Date)this.date0, (int)1001), (String)"round semimonth-0 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 16, 2002"), (Object)DateUtils.round((Date)this.date1, (int)1001), (String)"round semimonth-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 16, 2001"), (Object)DateUtils.round((Date)this.date2, (int)1001), (String)"round semimonth-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 13, 2002"), (Object)DateUtils.round((Date)this.date1, (int)5), (String)"round date-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 18, 2001"), (Object)DateUtils.round((Date)this.date2, (int)5), (String)"round date-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 13:00:00.000"), (Object)DateUtils.round((Date)this.date1, (int)10), (String)"round hour-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:00:00.000"), (Object)DateUtils.round((Date)this.date2, (int)10), (String)"round hour-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:35:00.000"), (Object)DateUtils.round((Date)this.date1, (int)12), (String)"round minute-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:00.000"), (Object)DateUtils.round((Date)this.date2, (int)12), (String)"round minute-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.round((Date)this.date1, (int)13), (String)"round second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.round((Date)this.date2, (int)13), (String)"round second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.round((Date)this.dateAmPm1, (int)9), (String)"round ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Date)this.dateAmPm2, (int)9), (String)"round ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Date)this.dateAmPm3, (int)9), (String)"round ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.round((Date)this.dateAmPm4, (int)9), (String)"round ampm-4 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.round((Object)this.date1, (int)1), (String)"round year-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.round((Object)this.date2, (int)1), (String)"round year-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.round((Object)this.date1, (int)2), (String)"round month-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.round((Object)this.date2, (int)2), (String)"round month-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 16, 2002"), (Object)DateUtils.round((Object)this.date1, (int)1001), (String)"round semimonth-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 16, 2001"), (Object)DateUtils.round((Object)this.date2, (int)1001), (String)"round semimonth-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 13, 2002"), (Object)DateUtils.round((Object)this.date1, (int)5), (String)"round date-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 18, 2001"), (Object)DateUtils.round((Object)this.date2, (int)5), (String)"round date-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 13:00:00.000"), (Object)DateUtils.round((Object)this.date1, (int)10), (String)"round hour-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:00:00.000"), (Object)DateUtils.round((Object)this.date2, (int)10), (String)"round hour-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:35:00.000"), (Object)DateUtils.round((Object)this.date1, (int)12), (String)"round minute-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:00.000"), (Object)DateUtils.round((Object)this.date2, (int)12), (String)"round minute-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.round((Object)this.date1, (int)13), (String)"round second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.round((Object)this.date2, (int)13), (String)"round second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.round((Object)this.cal1, (int)13), (String)"round calendar second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.round((Object)this.cal2, (int)13), (String)"round calendar second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.round((Object)this.dateAmPm1, (int)9), (String)"round ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Object)this.dateAmPm2, (int)9), (String)"round ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Object)this.dateAmPm3, (int)9), (String)"round ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.round((Object)this.dateAmPm4, (int)9), (String)"round ampm-4 failed");
        LangAssertions.assertNullPointerException(() -> DateUtils.round((Date)null, (int)13));
        LangAssertions.assertNullPointerException(() -> DateUtils.round((Calendar)null, (int)13));
        LangAssertions.assertNullPointerException(() -> DateUtils.round(null, (int)13));
        Assertions.assertThrows(ClassCastException.class, () -> DateUtils.round((Object)"", (int)13));
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.round((Date)this.date1, (int)-9999));
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.round((Object)this.calAmPm1, (int)9), (String)"round ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Object)this.calAmPm2, (int)9), (String)"round ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Object)this.calAmPm3, (int)9), (String)"round ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.round((Object)this.calAmPm4, (int)9), (String)"round ampm-4 failed");
    }

    @Test
    void testRound_MET() throws Exception {
        TimeZone.setDefault(TIME_ZONE_MET);
        this.dateTimeParser.setTimeZone(TIME_ZONE_MET);
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Date)this.date4, (int)5), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Object)this.cal4, (int)5), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Date)this.date5, (int)5), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Object)this.cal5, (int)5), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Date)this.date6, (int)5), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Object)this.cal6, (int)5), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Date)this.date7, (int)5), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Object)this.cal7, (int)5), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 01:00:00.000"), (Object)DateUtils.round((Date)this.date4, (int)11), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 01:00:00.000"), (Object)DateUtils.round((Object)this.cal4, (int)11), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.round((Date)this.date5, (int)11), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.round((Object)this.cal5, (int)11), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.round((Date)this.date6, (int)11), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.round((Object)this.cal6, (int)11), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.round((Date)this.date7, (int)11), (String)"round MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.round((Object)this.cal7, (int)11), (String)"round MET date across DST change-over");
    }

    @Test
    void testRoundLang346() throws Exception {
        Calendar testCalendar = Calendar.getInstance();
        testCalendar.set(2007, 6, 2, 8, 8, 50);
        Date date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 08:09:00.000"), (Object)DateUtils.round((Date)date, (int)12), (String)"Minute Round Up Failed");
        testCalendar.set(2007, 6, 2, 8, 8, 20);
        date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 08:08:00.000"), (Object)DateUtils.round((Date)date, (int)12), (String)"Minute No Round Failed");
        testCalendar.set(2007, 6, 2, 8, 8, 50);
        testCalendar.set(14, 600);
        date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 08:08:51.000"), (Object)DateUtils.round((Date)date, (int)13), (String)"Second Round Up with 600 Milli Seconds Failed");
        testCalendar.set(2007, 6, 2, 8, 8, 50);
        testCalendar.set(14, 200);
        date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 08:08:50.000"), (Object)DateUtils.round((Date)date, (int)13), (String)"Second Round Down with 200 Milli Seconds Failed");
        testCalendar.set(2007, 6, 2, 8, 8, 20);
        testCalendar.set(14, 600);
        date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 08:08:21.000"), (Object)DateUtils.round((Date)date, (int)13), (String)"Second Round Up with 200 Milli Seconds Failed");
        testCalendar.set(2007, 6, 2, 8, 8, 20);
        testCalendar.set(14, 200);
        date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 08:08:20.000"), (Object)DateUtils.round((Date)date, (int)13), (String)"Second Round Down with 200 Milli Seconds Failed");
        testCalendar.set(2007, 6, 2, 8, 8, 50);
        date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 08:00:00.000"), (Object)DateUtils.round((Date)date, (int)10), (String)"Hour Round Down Failed");
        testCalendar.set(2007, 6, 2, 8, 31, 50);
        date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 09:00:00.000"), (Object)DateUtils.round((Date)date, (int)10), (String)"Hour Round Up Failed");
    }

    @Test
    void testSetDays() throws Exception {
        Date result = DateUtils.setDays((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 1, 4, 3, 2, 1);
        result = DateUtils.setDays((Date)BASE_DATE, (int)29);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 29, 4, 3, 2, 1);
        String outsideOfRangeAssertionMessage = "DateUtils.setDays did not throw an expected IllegalArgumentException for amount outside of range 1 to 31.";
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.setDays((Date)BASE_DATE, (int)32), "DateUtils.setDays did not throw an expected IllegalArgumentException for amount outside of range 1 to 31.");
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.setDays((Date)BASE_DATE, (int)0), "DateUtils.setDays did not throw an expected IllegalArgumentException for amount outside of range 1 to 31.");
        LangAssertions.assertNullPointerException(() -> DateUtils.setDays(null, (int)1));
    }

    @Test
    void testSetHours() throws Exception {
        Date result = DateUtils.setHours((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 0, 3, 2, 1);
        result = DateUtils.setHours((Date)BASE_DATE, (int)23);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 23, 3, 2, 1);
        String outsideOfRangeAssertionMessage = "DateUtils.setHours did not throw an expected IllegalArgumentException for amount outside of range 0 to 23.";
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.setHours((Date)BASE_DATE, (int)24), "DateUtils.setHours did not throw an expected IllegalArgumentException for amount outside of range 0 to 23.");
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.setHours((Date)BASE_DATE, (int)-1), "DateUtils.setHours did not throw an expected IllegalArgumentException for amount outside of range 0 to 23.");
        LangAssertions.assertNullPointerException(() -> DateUtils.setHours(null, (int)0));
    }

    @Test
    void testSetMilliseconds() throws Exception {
        Date result = DateUtils.setMilliseconds((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 0);
        result = DateUtils.setMilliseconds((Date)BASE_DATE, (int)999);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 999);
        String outsideOfRangeAssertionMessage = "DateUtils.setMilliseconds did not throw an expected IllegalArgumentException for range outside of 0 to 999.";
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.setMilliseconds((Date)BASE_DATE, (int)1000), "DateUtils.setMilliseconds did not throw an expected IllegalArgumentException for range outside of 0 to 999.");
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.setMilliseconds((Date)BASE_DATE, (int)-1), "DateUtils.setMilliseconds did not throw an expected IllegalArgumentException for range outside of 0 to 999.");
        LangAssertions.assertNullPointerException(() -> DateUtils.setMilliseconds(null, (int)0));
    }

    @Test
    void testSetMinutes() throws Exception {
        Date result = DateUtils.setMinutes((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 0, 2, 1);
        result = DateUtils.setMinutes((Date)BASE_DATE, (int)59);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 59, 2, 1);
        String outsideOfRangeAssertionMessage = "DateUtils.setMinutes did not throw an expected IllegalArgumentException for amount outside of range 0 to 59.";
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.setMinutes((Date)BASE_DATE, (int)60), "DateUtils.setMinutes did not throw an expected IllegalArgumentException for amount outside of range 0 to 59.");
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.setMinutes((Date)BASE_DATE, (int)-1), "DateUtils.setMinutes did not throw an expected IllegalArgumentException for amount outside of range 0 to 59.");
        LangAssertions.assertNullPointerException(() -> DateUtils.setMinutes(null, (int)0));
    }

    @Test
    void testSetMonths() throws Exception {
        Date result = DateUtils.setMonths((Date)BASE_DATE, (int)5);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 5, 5, 4, 3, 2, 1);
        result = DateUtils.setMonths((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 1, 5, 4, 3, 2, 1);
        result = DateUtils.setMonths((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 0, 5, 4, 3, 2, 1);
        String outsideOfRangeAssertionMessage = "DateUtils.setMonths did not throw an expected IllegalArgumentException for amount outside of range 0 to 11.";
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.setMonths((Date)BASE_DATE, (int)12), "DateUtils.setMonths did not throw an expected IllegalArgumentException for amount outside of range 0 to 11.");
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.setMonths((Date)BASE_DATE, (int)-1), "DateUtils.setMonths did not throw an expected IllegalArgumentException for amount outside of range 0 to 11.");
        LangAssertions.assertNullPointerException(() -> DateUtils.setMonths(null, (int)0));
    }

    @Test
    void testSetSeconds() throws Exception {
        Date result = DateUtils.setSeconds((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 0, 1);
        result = DateUtils.setSeconds((Date)BASE_DATE, (int)59);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 59, 1);
        String outsideOfRangeAssertionMessage = "DateUtils.setSeconds did not throw an expected IllegalArgumentException for amount outside of range 0 to 59.";
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.setSeconds((Date)BASE_DATE, (int)60), "DateUtils.setSeconds did not throw an expected IllegalArgumentException for amount outside of range 0 to 59.");
        LangAssertions.assertIllegalArgumentException(() -> DateUtils.setSeconds((Date)BASE_DATE, (int)-1), "DateUtils.setSeconds did not throw an expected IllegalArgumentException for amount outside of range 0 to 59.");
        LangAssertions.assertNullPointerException(() -> DateUtils.setSeconds(null, (int)0));
    }

    @Test
    void testSetYears() throws Exception {
        Date result = DateUtils.setYears((Date)BASE_DATE, (int)2000);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.setYears((Date)BASE_DATE, (int)2008);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2008, 6, 5, 4, 3, 2, 1);
        result = DateUtils.setYears((Date)BASE_DATE, (int)2005);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2005, 6, 5, 4, 3, 2, 1);
        LangAssertions.assertNullPointerException(() -> DateUtils.setYears(null, (int)0));
    }

    @Test
    void testToCalendar() {
        Assertions.assertEquals((Object)this.date1, (Object)DateUtils.toCalendar((Date)this.date1).getTime(), (String)"Failed to convert to a Calendar and back");
        LangAssertions.assertNullPointerException(() -> DateUtils.toCalendar(null));
    }

    @Test
    void testToCalendarWithDateAndTimeZoneNotNull() {
        Calendar c = DateUtils.toCalendar((Date)this.date2, (TimeZone)TIME_ZONE_DEFAULT);
        Assertions.assertEquals((Object)this.date2, (Object)c.getTime(), (String)"Convert Date and TimeZone to a Calendar, but failed to get the Date back");
        Assertions.assertEquals((Object)TIME_ZONE_DEFAULT, (Object)c.getTimeZone(), (String)"Convert Date and TimeZone to a Calendar, but failed to get the TimeZone back");
    }

    @Test
    void testToCalendarWithDateAndTimeZoneNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.toCalendar(null, null));
    }

    @Test
    void testToCalendarWithDateNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.toCalendar(null, (TimeZone)TIME_ZONE_MET));
    }

    @Test
    void testToCalendarWithTimeZoneNull() {
        LangAssertions.assertNullPointerException(() -> DateUtils.toCalendar((Date)this.date1, null));
    }

    @ParameterizedTest
    @MethodSource(value={"testToLocalDateTimeTimeZone"})
    @DefaultLocale(language="en", country="US")
    @DefaultTimeZone(value="GMT")
    void testToLocalDateTime(LocalDateTime expected, Date date, TimeZone timeZone) {
        Assertions.assertEquals((Object)LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()), (Object)DateUtils.toLocalDateTime((Date)date), () -> String.format("expected = %s, date = %s, timeZone = %s, TimeZone.getDefault() = %s", expected, date, timeZone, TimeZone.getDefault()));
    }

    @ParameterizedTest
    @MethodSource(value={"testToLocalDateTimeTimeZone"})
    @DefaultLocale(language="en", country="US")
    @DefaultTimeZone(value="GMT")
    void testToLocalDateTimeTimeZone(LocalDateTime expected, Date date, TimeZone timeZone) {
        Assertions.assertEquals((Object)expected, (Object)DateUtils.toLocalDateTime((Date)date, (TimeZone)timeZone), () -> String.format("expected = %s, date = %s, timeZone = %s, TimeZone.getDefault() = %s", expected, date, timeZone, TimeZone.getDefault()));
    }

    @ParameterizedTest
    @MethodSource(value={"testToLocalDateTimeTimeZone"})
    @DefaultLocale(language="en", country="US")
    @DefaultTimeZone(value="GMT")
    void testToOffsetDateTime(LocalDateTime expected, Date date, TimeZone timeZone) {
        OffsetDateTime offsetDateTime = DateUtils.toOffsetDateTime((Date)date);
        Assertions.assertEquals((Object)OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()), (Object)offsetDateTime, () -> String.format("expected = %s, date = %s, timeZone = %s, TimeZone.getDefault() = %s", expected, date, timeZone, TimeZone.getDefault()));
    }

    @ParameterizedTest
    @MethodSource(value={"testToLocalDateTimeTimeZone"})
    @DefaultLocale(language="en", country="US")
    @DefaultTimeZone(value="GMT")
    void testToOffsetDateTimeTimeZone(LocalDateTime expected, Date date, TimeZone timeZone) {
        Assertions.assertEquals((Object)expected, (Object)DateUtils.toOffsetDateTime((Date)date, (TimeZone)timeZone).toLocalDateTime(), () -> String.format("expected = %s, date = %s, timeZone = %s, TimeZone.getDefault() = %s", expected, date, timeZone, TimeZone.getDefault()));
    }

    @ParameterizedTest
    @MethodSource(value={"testToLocalDateTimeTimeZone"})
    @DefaultLocale(language="en", country="US")
    @DefaultTimeZone(value="GMT")
    void testToZonedDateTime(LocalDateTime expected, Date date, TimeZone timeZone) {
        ZonedDateTime zonedDateTime = DateUtils.toZonedDateTime((Date)date);
        Assertions.assertEquals((Object)ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()), (Object)zonedDateTime, () -> String.format("expected = %s, date = %s, timeZone = %s, TimeZone.getDefault() = %s", expected, date, timeZone, TimeZone.getDefault()));
        Assertions.assertEquals((Object)date.toInstant().atZone(ZoneId.systemDefault()), (Object)zonedDateTime, () -> String.format("expected = %s, date = %s, timeZone = %s, TimeZone.getDefault() = %s", expected, date, timeZone, TimeZone.getDefault()));
    }

    @ParameterizedTest
    @MethodSource(value={"testToLocalDateTimeTimeZone"})
    @DefaultLocale(language="en", country="US")
    @DefaultTimeZone(value="GMT")
    void testToZonedDateTimeTimeZone(LocalDateTime expected, Date date, TimeZone timeZone) {
        ZonedDateTime zonedDateTime = DateUtils.toZonedDateTime((Date)date, (TimeZone)timeZone);
        Assertions.assertEquals((Object)expected, (Object)zonedDateTime.toOffsetDateTime().toLocalDateTime(), () -> String.format("expected = %s, date = %s, timeZone = %s, TimeZone.getDefault() = %s", expected, date, timeZone, TimeZone.getDefault()));
        Assertions.assertEquals((Object)date.toInstant().atZone(TimeZones.toTimeZone((TimeZone)timeZone).toZoneId()), (Object)zonedDateTime, () -> String.format("expected = %s, date = %s, timeZone = %s, TimeZone.getDefault() = %s", expected, date, timeZone, TimeZone.getDefault()));
    }

    @Test
    void testTruncate() throws Exception {
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.truncate((Date)this.date1, (int)1), (String)"truncate year-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2001"), (Object)DateUtils.truncate((Date)this.date2, (int)1), (String)"truncate year-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.truncate((Date)this.date1, (int)2), (String)"truncate month-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 1, 2001"), (Object)DateUtils.truncate((Date)this.date2, (int)2), (String)"truncate month-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.truncate((Date)this.date1, (int)1001), (String)"truncate semimonth-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 16, 2001"), (Object)DateUtils.truncate((Date)this.date2, (int)1001), (String)"truncate semimonth-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 12, 2002"), (Object)DateUtils.truncate((Date)this.date1, (int)5), (String)"truncate date-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 18, 2001"), (Object)DateUtils.truncate((Date)this.date2, (int)5), (String)"truncate date-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:00:00.000"), (Object)DateUtils.truncate((Date)this.date1, (int)10), (String)"truncate hour-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:00:00.000"), (Object)DateUtils.truncate((Date)this.date2, (int)10), (String)"truncate hour-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:00.000"), (Object)DateUtils.truncate((Date)this.date1, (int)12), (String)"truncate minute-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:00.000"), (Object)DateUtils.truncate((Date)this.date2, (int)12), (String)"truncate minute-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:56.000"), (Object)DateUtils.truncate((Date)this.date1, (int)13), (String)"truncate second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.truncate((Date)this.date2, (int)13), (String)"truncate second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Date)this.dateAmPm1, (int)9), (String)"truncate ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Date)this.dateAmPm2, (int)9), (String)"truncate ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Date)this.dateAmPm3, (int)9), (String)"truncate ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Date)this.dateAmPm4, (int)9), (String)"truncate ampm-4 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.truncate((Object)this.date1, (int)1), (String)"truncate year-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2001"), (Object)DateUtils.truncate((Object)this.date2, (int)1), (String)"truncate year-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.truncate((Object)this.date1, (int)2), (String)"truncate month-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 1, 2001"), (Object)DateUtils.truncate((Object)this.date2, (int)2), (String)"truncate month-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.truncate((Object)this.date1, (int)1001), (String)"truncate semimonth-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 16, 2001"), (Object)DateUtils.truncate((Object)this.date2, (int)1001), (String)"truncate semimonth-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 12, 2002"), (Object)DateUtils.truncate((Object)this.date1, (int)5), (String)"truncate date-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 18, 2001"), (Object)DateUtils.truncate((Object)this.date2, (int)5), (String)"truncate date-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.date1, (int)10), (String)"truncate hour-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:00:00.000"), (Object)DateUtils.truncate((Object)this.date2, (int)10), (String)"truncate hour-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:00.000"), (Object)DateUtils.truncate((Object)this.date1, (int)12), (String)"truncate minute-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:00.000"), (Object)DateUtils.truncate((Object)this.date2, (int)12), (String)"truncate minute-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:56.000"), (Object)DateUtils.truncate((Object)this.date1, (int)13), (String)"truncate second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.truncate((Object)this.date2, (int)13), (String)"truncate second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Object)this.dateAmPm1, (int)9), (String)"truncate ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Object)this.dateAmPm2, (int)9), (String)"truncate ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.dateAmPm3, (int)9), (String)"truncate ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.dateAmPm4, (int)9), (String)"truncate ampm-4 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:56.000"), (Object)DateUtils.truncate((Object)this.cal1, (int)13), (String)"truncate calendar second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.truncate((Object)this.cal2, (int)13), (String)"truncate calendar second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Object)this.calAmPm1, (int)9), (String)"truncate ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Object)this.calAmPm2, (int)9), (String)"truncate ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.calAmPm3, (int)9), (String)"truncate ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.calAmPm4, (int)9), (String)"truncate ampm-4 failed");
        LangAssertions.assertNullPointerException(() -> DateUtils.truncate((Date)null, (int)13));
        LangAssertions.assertNullPointerException(() -> DateUtils.truncate((Calendar)null, (int)13));
        LangAssertions.assertNullPointerException(() -> DateUtils.truncate(null, (int)13));
        Assertions.assertThrows(ClassCastException.class, () -> DateUtils.truncate((Object)"", (int)13));
    }

    @Test
    void testTruncate_Bugzilla_25560() throws Exception {
        TimeZone.setDefault(TIME_ZONE_MET);
        this.dateTimeParser.setTimeZone(TIME_ZONE_MET);
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.truncate((Date)this.date3, (int)5), (String)"truncate MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.truncate((Object)this.cal3, (int)5), (String)"truncate MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("October 26, 2003 00:00:00.000"), (Object)DateUtils.truncate((Date)this.date8, (int)5), (String)"truncate MET date across DST change-over");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("October 26, 2003 00:00:00.000"), (Object)DateUtils.truncate((Object)this.cal8, (int)5), (String)"truncate MET date across DST change-over");
    }

    @Test
    void testTruncate_Bugzilla_31395() throws Exception {
        Date endOfTime = new Date(Long.MAX_VALUE);
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(endOfTime);
        Assertions.assertThrows(ArithmeticException.class, () -> DateUtils.truncate((Calendar)endCal, (int)5));
        endCal.set(1, 280000001);
        Assertions.assertThrows(ArithmeticException.class, () -> DateUtils.truncate((Calendar)endCal, (int)5));
        endCal.set(1, 280000000);
        Calendar cal = DateUtils.truncate((Calendar)endCal, (int)5);
        Assertions.assertEquals((int)0, (int)cal.get(10));
    }

    @Test
    void testTruncateLang59() {
        TimeZone denverZone = TimeZone.getTimeZone("America/Denver");
        TimeZone.setDefault(denverZone);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS XXX");
        format.setTimeZone(denverZone);
        Date oct31_01MDT = new Date(1099206000000L);
        Date oct31MDT = new Date(oct31_01MDT.getTime() - 3600000L);
        Date oct31_01_02MDT = new Date(oct31_01MDT.getTime() + 120000L);
        Date oct31_01_02_03MDT = new Date(oct31_01_02MDT.getTime() + 3000L);
        Date oct31_01_02_03_04MDT = new Date(oct31_01_02_03MDT.getTime() + 4L);
        Assertions.assertEquals((Object)"2004-10-31 00:00:00.000 -06:00", (Object)format.format(oct31MDT), (String)"Check 00:00:00.000");
        Assertions.assertEquals((Object)"2004-10-31 01:00:00.000 -06:00", (Object)format.format(oct31_01MDT), (String)"Check 01:00:00.000");
        Assertions.assertEquals((Object)"2004-10-31 01:02:00.000 -06:00", (Object)format.format(oct31_01_02MDT), (String)"Check 01:02:00.000");
        Assertions.assertEquals((Object)"2004-10-31 01:02:03.000 -06:00", (Object)format.format(oct31_01_02_03MDT), (String)"Check 01:02:03.000");
        Assertions.assertEquals((Object)"2004-10-31 01:02:03.004 -06:00", (Object)format.format(oct31_01_02_03_04MDT), (String)"Check 01:02:03.004");
        Calendar gval = Calendar.getInstance();
        gval.setTime(new Date(oct31_01MDT.getTime()));
        gval.set(12, gval.get(12));
        Assertions.assertEquals((long)gval.getTime().getTime(), (long)(oct31_01MDT.getTime() + 3600000L), (String)"Demonstrate Problem");
        Assertions.assertEquals((Object)oct31_01_02_03_04MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)14), (String)"Truncate Calendar.MILLISECOND");
        Assertions.assertEquals((Object)oct31_01_02_03MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)13), (String)"Truncate Calendar.SECOND");
        Assertions.assertEquals((Object)oct31_01_02MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)12), (String)"Truncate Calendar.MINUTE");
        Assertions.assertEquals((Object)oct31_01MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)11), (String)"Truncate Calendar.HOUR_OF_DAY");
        Assertions.assertEquals((Object)oct31_01MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)10), (String)"Truncate Calendar.HOUR");
        Assertions.assertEquals((Object)oct31MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)5), (String)"Truncate Calendar.DATE");
        Assertions.assertEquals((Object)oct31_01_02_03_04MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)14), (String)"Round Calendar.MILLISECOND");
        Assertions.assertEquals((Object)oct31_01_02_03MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)13), (String)"Round Calendar.SECOND");
        Assertions.assertEquals((Object)oct31_01_02MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)12), (String)"Round Calendar.MINUTE");
        Assertions.assertEquals((Object)oct31_01MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)11), (String)"Round Calendar.HOUR_OF_DAY");
        Assertions.assertEquals((Object)oct31_01MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)10), (String)"Round Calendar.HOUR");
        Assertions.assertEquals((Object)oct31MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)5), (String)"Round Calendar.DATE");
    }

    @Test
    void testWeekIterator() {
        Calendar now = Calendar.getInstance();
        for (int i = 0; i < 7; ++i) {
            Calendar today = DateUtils.truncate((Calendar)now, (int)5);
            Calendar sunday = DateUtils.truncate((Calendar)now, (int)5);
            sunday.add(5, 1 - sunday.get(7));
            Calendar monday = DateUtils.truncate((Calendar)now, (int)5);
            if (monday.get(7) == 1) {
                monday.add(5, -6);
            } else {
                monday.add(5, 2 - monday.get(7));
            }
            Calendar centered = DateUtils.truncate((Calendar)now, (int)5);
            centered.add(5, -3);
            Iterator it = DateUtils.iterator((Calendar)now, (int)1);
            DateUtilsTest.assertWeekIterator(it, sunday);
            it = DateUtils.iterator((Calendar)now, (int)2);
            DateUtilsTest.assertWeekIterator(it, monday);
            it = DateUtils.iterator((Calendar)now, (int)3);
            DateUtilsTest.assertWeekIterator(it, today);
            it = DateUtils.iterator((Calendar)now, (int)4);
            DateUtilsTest.assertWeekIterator(it, centered);
            it = DateUtils.iterator((Object)now, (int)4);
            DateUtilsTest.assertWeekIterator(it, centered);
            Iterator it2 = DateUtils.iterator((Object)now.getTime(), (int)4);
            DateUtilsTest.assertWeekIterator(it2, centered);
            Assertions.assertThrows(NoSuchElementException.class, it2::next);
            Iterator it3 = DateUtils.iterator((Calendar)now, (int)4);
            it3.next();
            Assertions.assertThrows(UnsupportedOperationException.class, it3::remove);
            now.add(5, 1);
        }
    }
}

