/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Duration;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.TypesMapping;

public class DurationType
implements ExtendedType<Duration> {
    @Override
    public String getClassName() {
        return Duration.class.getName();
    }

    protected Object convertToJdbcObject(Duration val, int type) {
        if (type == 4) {
            return new Long(val.toMillis()).intValue();
        }
        if (type == 2) {
            return val.toMillis();
        }
        if (type == 3) {
            return val.toMillis();
        }
        if (type == -5) {
            return val.toMillis();
        }
        if (type == 12) {
            return val.toString();
        }
        if (type == -1) {
            return val.toString();
        }
        throw new IllegalArgumentException("Only INTEGER, NUMERIC, DECIMAL, BIGINT, VARCHAR, LONGVARCHAR can be mapped as '" + this.getClassName() + "', got " + TypesMapping.getSqlNameByType(type));
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Duration value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else {
            statement.setObject(pos, this.convertToJdbcObject(value, type), type);
        }
    }

    @Override
    public Duration materializeObject(ResultSet rs, int index, int type) throws Exception {
        Duration val = null;
        switch (type) {
            case 4: {
                val = Duration.ofMillis(rs.getInt(index));
                break;
            }
            case 2: {
                val = Duration.ofMillis(rs.getBigDecimal(index).longValue());
                break;
            }
            case 3: {
                val = Duration.ofMillis(rs.getBigDecimal(index).longValue());
                break;
            }
            case -5: {
                val = Duration.ofMillis(rs.getLong(index));
                break;
            }
            case 12: {
                val = Duration.parse(rs.getString(index));
                break;
            }
            case -1: {
                val = Duration.parse(rs.getString(index));
            }
        }
        if (rs.wasNull()) {
            return null;
        }
        if (val != null) {
            return val;
        }
        throw new CayenneRuntimeException("Can't materialize " + rs.getObject(index) + " of type: " + type, new Object[0]);
    }

    @Override
    public Duration materializeObject(CallableStatement rs, int index, int type) throws Exception {
        Duration val = null;
        switch (type) {
            case 4: {
                val = Duration.ofMillis(rs.getInt(index));
                break;
            }
            case 2: {
                val = Duration.ofMillis(rs.getBigDecimal(index).longValue());
                break;
            }
            case 3: {
                val = Duration.ofMillis(rs.getBigDecimal(index).longValue());
                break;
            }
            case -5: {
                val = Duration.ofMillis(rs.getLong(index));
                break;
            }
            case 12: {
                val = Duration.parse(rs.getString(index));
                break;
            }
            case -1: {
                val = Duration.parse(rs.getString(index));
            }
        }
        if (rs.wasNull()) {
            return null;
        }
        if (val != null) {
            return val;
        }
        throw new CayenneRuntimeException("Can't materialize " + rs.getObject(index) + " of type: " + type, new Object[0]);
    }

    @Override
    public String toString(Duration value) {
        if (value == null) {
            return "NULL";
        }
        return "'" + value.toString() + "'";
    }
}

