/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph.action;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.FindAction;
import org.apache.cayenne.modeler.graph.GraphBuilder;
import org.apache.cayenne.modeler.util.CayenneAction;

public class EntityDisplayAction
extends CayenneAction {
    private CayenneAction delegate;
    private GraphBuilder builder;

    public EntityDisplayAction(GraphBuilder builder) {
        super("Show", Application.getInstance());
        this.builder = builder;
        this.init();
    }

    public EntityDisplayAction(GraphBuilder builder, CayenneAction delegate) {
        super((String)delegate.getValue("Name"), Application.getInstance());
        this.delegate = delegate;
        this.builder = builder;
        this.init();
    }

    private void init() {
        this.setEnabled(true);
        Icon icon = this.createIcon();
        if (icon != null) {
            super.putValue("SmallIcon", icon);
        }
    }

    @Override
    public void performAction(ActionEvent e) {
        if (this.display() && this.delegate != null) {
            this.delegate.performAction(e);
        }
    }

    private boolean display() {
        Entity entity = this.builder.getSelectedEntity();
        if (entity == null) {
            return false;
        }
        FindAction.jumpToResult(new FindAction.SearchResultEntry(entity, entity.getName()));
        return true;
    }

    @Override
    public String getIconName() {
        if (this.delegate != null) {
            return this.delegate.getIconName();
        }
        return null;
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        return this.builder.getSelectedEntity() != null;
    }
}

