/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.sjavac.comp;

import java.util.List;
import java.util.stream.Collectors;
import org.openjdk.javax.lang.model.element.Element;
import org.openjdk.javax.lang.model.element.ExecutableElement;
import org.openjdk.javax.lang.model.element.Modifier;
import org.openjdk.javax.lang.model.element.TypeElement;
import org.openjdk.javax.lang.model.element.TypeParameterElement;
import org.openjdk.javax.lang.model.element.VariableElement;
import org.openjdk.javax.lang.model.type.TypeMirror;
import org.openjdk.javax.lang.model.util.ElementScanner9;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.sjavac.pubapi.PubApi;
import org.openjdk.tools.sjavac.pubapi.PubApiTypeParam;
import org.openjdk.tools.sjavac.pubapi.PubMethod;
import org.openjdk.tools.sjavac.pubapi.PubType;
import org.openjdk.tools.sjavac.pubapi.PubVar;
import org.openjdk.tools.sjavac.pubapi.TypeDesc;

public class PubapiVisitor
extends ElementScanner9<Void, Void> {
    private PubApi collectedApi = new PubApi();

    private boolean isNonPrivate(Element element) {
        return !element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    @Override
    public Void visitType(TypeElement typeElement, Void void_) {
        if (this.isNonPrivate(typeElement)) {
            PubApi pubApi = this.collectedApi;
            this.collectedApi = new PubApi();
            super.visitType(typeElement, void_);
            if (!this.isAnonymous(typeElement)) {
                String string = ((Symbol.ClassSymbol)typeElement).flatname.toString();
                PubType pubType = new PubType(typeElement.getModifiers(), string, this.collectedApi);
                pubApi.types.put(pubType.fqName, pubType);
            }
            this.collectedApi = pubApi;
        }
        return null;
    }

    private boolean isAnonymous(TypeElement typeElement) {
        return typeElement.getQualifiedName().length() == 0;
    }

    private static String encodeChar(int n) {
        return String.format("\\u%04x", n);
    }

    @Override
    public Void visitVariable(VariableElement variableElement, Void void_) {
        if (this.isNonPrivate(variableElement)) {
            Object object = variableElement.getConstantValue();
            String string = null;
            if (object != null) {
                if (variableElement.asType().toString().equals("char")) {
                    char c = object.toString().charAt(0);
                    string = "'" + PubapiVisitor.encodeChar(c) + "'";
                } else {
                    string = object.toString().chars().mapToObj(PubapiVisitor::encodeChar).collect(Collectors.joining("", "\"", "\""));
                }
            }
            PubVar pubVar = new PubVar(variableElement.getModifiers(), TypeDesc.fromType(variableElement.asType()), variableElement.toString(), string);
            this.collectedApi.variables.put(pubVar.identifier, pubVar);
        }
        return null;
    }

    @Override
    public Void visitExecutable(ExecutableElement executableElement, Void void_) {
        if (this.isNonPrivate(executableElement)) {
            PubMethod pubMethod = new PubMethod(executableElement.getModifiers(), this.getTypeParameters(executableElement.getTypeParameters()), TypeDesc.fromType(executableElement.getReturnType()), executableElement.getSimpleName().toString(), this.getTypeDescs(this.getParamTypes(executableElement)), this.getTypeDescs(executableElement.getThrownTypes()));
            this.collectedApi.methods.put(pubMethod.asSignatureString(), pubMethod);
        }
        return null;
    }

    private List<PubApiTypeParam> getTypeParameters(List<? extends TypeParameterElement> list) {
        return list.stream().map(typeParameterElement -> new PubApiTypeParam(typeParameterElement.getSimpleName().toString(), this.getTypeDescs(typeParameterElement.getBounds()))).collect(Collectors.toList());
    }

    private List<TypeMirror> getParamTypes(ExecutableElement executableElement) {
        return executableElement.getParameters().stream().map(Element::asType).collect(Collectors.toList());
    }

    private List<TypeDesc> getTypeDescs(List<? extends TypeMirror> list) {
        return list.stream().map(TypeDesc::fromType).collect(Collectors.toList());
    }

    public PubApi getCollectedPubApi() {
        return this.collectedApi;
    }
}

