/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.comp;

import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;
import org.openjdk.source.tree.LambdaExpressionTree;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Lint;
import org.openjdk.tools.javac.code.Scope;
import org.openjdk.tools.javac.code.Source;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.TypeTag;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.comp.AttrContext;
import org.openjdk.tools.javac.comp.Check;
import org.openjdk.tools.javac.comp.Env;
import org.openjdk.tools.javac.comp.Resolve;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.tree.TreeInfo;
import org.openjdk.tools.javac.tree.TreeMaker;
import org.openjdk.tools.javac.tree.TreeScanner;
import org.openjdk.tools.javac.util.ArrayUtils;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Bits;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Names;

public class Flow {
    protected static final Context.Key<Flow> flowKey = new Context.Key();
    private final Names names;
    private final Log log;
    private final Symtab syms;
    private final Types types;
    private final Check chk;
    private TreeMaker make;
    private final Resolve rs;
    private final JCDiagnostic.Factory diags;
    private Env<AttrContext> attrEnv;
    private Lint lint;
    private final boolean allowImprovedRethrowAnalysis;
    private final boolean allowImprovedCatchAnalysis;
    private final boolean allowEffectivelyFinalInInnerClasses;
    private final boolean enforceThisDotInit;

    public static Flow instance(Context context) {
        Flow flow = context.get(flowKey);
        if (flow == null) {
            flow = new Flow(context);
        }
        return flow;
    }

    public void analyzeTree(Env<AttrContext> env, TreeMaker treeMaker) {
        new AliveAnalyzer().analyzeTree(env, treeMaker);
        new AssignAnalyzer().analyzeTree(env);
        new FlowAnalyzer().analyzeTree(env, treeMaker);
        new CaptureAnalyzer().analyzeTree(env, treeMaker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeLambda(Env<AttrContext> env, JCTree.JCLambda jCLambda, TreeMaker treeMaker, boolean bl) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = null;
        if (!bl) {
            discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        }
        try {
            new LambdaAliveAnalyzer().analyzeTree(env, jCLambda, treeMaker);
        }
        finally {
            if (!bl) {
                this.log.popDiagnosticHandler(discardDiagnosticHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Type> analyzeLambdaThrownTypes(Env<AttrContext> env, JCTree.JCLambda jCLambda, TreeMaker treeMaker) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            new LambdaAssignAnalyzer(env).analyzeTree(env, jCLambda);
            LambdaFlowAnalyzer lambdaFlowAnalyzer = new LambdaFlowAnalyzer();
            lambdaFlowAnalyzer.analyzeTree(env, jCLambda, treeMaker);
            List<Type> list = lambdaFlowAnalyzer.inferredThrownTypes;
            return list;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    protected Flow(Context context) {
        context.put(flowKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.chk = Check.instance(context);
        this.lint = Lint.instance(context);
        this.rs = Resolve.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        Source source = Source.instance(context);
        this.allowImprovedRethrowAnalysis = source.allowImprovedRethrowAnalysis();
        this.allowImprovedCatchAnalysis = source.allowImprovedCatchAnalysis();
        this.allowEffectivelyFinalInInnerClasses = source.allowEffectivelyFinalInInnerClasses();
        this.enforceThisDotInit = source.enforceThisDotInit();
    }

    class CaptureAnalyzer
    extends BaseAnalyzer<BaseAnalyzer.PendingExit> {
        JCTree currentTree;

        CaptureAnalyzer() {
        }

        @Override
        void markDead() {
        }

        void checkEffectivelyFinal(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol) {
            if (this.currentTree != null && varSymbol.owner.kind == Kinds.Kind.MTH && varSymbol.pos < this.currentTree.getStartPosition()) {
                switch (this.currentTree.getTag()) {
                    case CLASSDEF: {
                        if (!Flow.this.allowEffectivelyFinalInInnerClasses) {
                            if ((varSymbol.flags() & 0x10L) != 0L) break;
                            this.reportInnerClsNeedsFinalError(diagnosticPosition, varSymbol);
                            break;
                        }
                    }
                    case LAMBDA: {
                        if ((varSymbol.flags() & 0x20000000010L) != 0L) break;
                        this.reportEffectivelyFinalError(diagnosticPosition, varSymbol);
                    }
                }
            }
        }

        void letInit(JCTree jCTree) {
            if ((jCTree = TreeInfo.skipParens(jCTree)).hasTag(JCTree.Tag.IDENT) || jCTree.hasTag(JCTree.Tag.SELECT)) {
                Symbol symbol = TreeInfo.symbol(jCTree);
                if (this.currentTree != null && symbol.kind == Kinds.Kind.VAR && symbol.owner.kind == Kinds.Kind.MTH && ((Symbol.VarSymbol)symbol).pos < this.currentTree.getStartPosition()) {
                    switch (this.currentTree.getTag()) {
                        case CLASSDEF: {
                            if (!Flow.this.allowEffectivelyFinalInInnerClasses) {
                                this.reportInnerClsNeedsFinalError(jCTree, symbol);
                                break;
                            }
                        }
                        case LAMBDA: {
                            this.reportEffectivelyFinalError(jCTree, symbol);
                        }
                    }
                }
            }
        }

        void reportEffectivelyFinalError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
            String string = this.currentTree.hasTag(JCTree.Tag.LAMBDA) ? "lambda" : "inner.cls";
            Flow.this.log.error(diagnosticPosition, "cant.ref.non.effectively.final.var", symbol, Flow.this.diags.fragment(string, new Object[0]));
        }

        void reportInnerClsNeedsFinalError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
            Flow.this.log.error(diagnosticPosition, "local.var.accessed.from.icls.needs.final", symbol);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            JCTree jCTree = this.currentTree;
            try {
                this.currentTree = jCClassDecl.sym.isLocal() ? jCClassDecl : null;
                super.visitClassDef(jCClassDecl);
            }
            finally {
                this.currentTree = jCTree;
            }
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            JCTree jCTree = this.currentTree;
            try {
                this.currentTree = jCLambda;
                super.visitLambda(jCLambda);
            }
            finally {
                this.currentTree = jCTree;
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            if (jCIdent.sym.kind == Kinds.Kind.VAR) {
                this.checkEffectivelyFinal(jCIdent, (Symbol.VarSymbol)jCIdent.sym);
            }
        }

        @Override
        public void visitAssign(JCTree.JCAssign jCAssign) {
            JCTree.JCExpression jCExpression = TreeInfo.skipParens(jCAssign.lhs);
            if (!(jCExpression instanceof JCTree.JCIdent)) {
                this.scan(jCExpression);
            }
            this.scan(jCAssign.rhs);
            this.letInit(jCExpression);
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
            this.scan(jCAssignOp.lhs);
            this.scan(jCAssignOp.rhs);
            this.letInit(jCAssignOp.lhs);
        }

        @Override
        public void visitUnary(JCTree.JCUnary jCUnary) {
            switch (jCUnary.getTag()) {
                case PREINC: 
                case POSTINC: 
                case PREDEC: 
                case POSTDEC: {
                    this.scan(jCUnary.arg);
                    this.letInit(jCUnary.arg);
                    break;
                }
                default: {
                    this.scan(jCUnary.arg);
                }
            }
        }

        @Override
        public void visitTry(JCTree.JCTry jCTry) {
            for (JCTree jCTree : jCTry.resources) {
                Symbol symbol;
                if (jCTree.hasTag(JCTree.Tag.VARDEF) || (symbol = TreeInfo.symbol(jCTree)) == null || (symbol.flags() & 0x20000000010L) != 0L) continue;
                Flow.this.log.error(jCTree.pos(), "try.with.resources.expr.effectively.final.var", symbol);
            }
            super.visitTry(jCTry);
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker treeMaker) {
            this.analyzeTree(env, env.tree, treeMaker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree jCTree, TreeMaker treeMaker) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = treeMaker;
                this.pendingExits = new ListBuffer();
                this.scan(jCTree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
            }
        }
    }

    public class AssignAnalyzer
    extends BaseAnalyzer<AssignPendingExit> {
        final Bits inits;
        final Bits uninits;
        final Bits uninitsTry;
        final Bits initsWhenTrue;
        final Bits initsWhenFalse;
        final Bits uninitsWhenTrue;
        final Bits uninitsWhenFalse;
        protected JCTree.JCVariableDecl[] vardecls;
        JCTree.JCClassDecl classDef;
        int firstadr;
        protected int nextadr;
        protected int returnadr;
        Scope.WriteableScope unrefdResources;
        FlowKind flowKind = FlowKind.NORMAL;
        int startPos;
        private boolean isInitialConstructor = false;

        public AssignAnalyzer() {
            this.inits = new Bits();
            this.uninits = new Bits();
            this.uninitsTry = new Bits();
            this.initsWhenTrue = new Bits(true);
            this.initsWhenFalse = new Bits(true);
            this.uninitsWhenTrue = new Bits(true);
            this.uninitsWhenFalse = new Bits(true);
        }

        @Override
        protected void markDead() {
            if (!this.isInitialConstructor) {
                this.inits.inclRange(this.returnadr, this.nextadr);
            } else {
                for (int i = this.returnadr; i < this.nextadr; ++i) {
                    if (this.isFinalUninitializedStaticField(this.vardecls[i].sym)) continue;
                    this.inits.incl(i);
                }
            }
            this.uninits.inclRange(this.returnadr, this.nextadr);
        }

        protected boolean trackable(Symbol.VarSymbol varSymbol) {
            return varSymbol.pos >= this.startPos && (varSymbol.owner.kind == Kinds.Kind.MTH || this.isFinalUninitializedField(varSymbol));
        }

        boolean isFinalUninitializedField(Symbol.VarSymbol varSymbol) {
            return varSymbol.owner.kind == Kinds.Kind.TYP && (varSymbol.flags() & 0x200040010L) == 16L && this.classDef.sym.isEnclosedBy((Symbol.ClassSymbol)varSymbol.owner);
        }

        boolean isFinalUninitializedStaticField(Symbol.VarSymbol varSymbol) {
            return this.isFinalUninitializedField(varSymbol) && varSymbol.isStatic();
        }

        void newVar(JCTree.JCVariableDecl jCVariableDecl) {
            Symbol.VarSymbol varSymbol = jCVariableDecl.sym;
            this.vardecls = ArrayUtils.ensureCapacity(this.vardecls, this.nextadr);
            if ((varSymbol.flags() & 0x10L) == 0L) {
                varSymbol.flags_field |= 0x20000000000L;
            }
            varSymbol.adr = this.nextadr;
            this.vardecls[this.nextadr] = jCVariableDecl;
            this.inits.excl(this.nextadr);
            this.uninits.incl(this.nextadr);
            ++this.nextadr;
        }

        void letInit(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol) {
            if (varSymbol.adr >= this.firstadr && this.trackable(varSymbol)) {
                if ((varSymbol.flags() & 0x20000000000L) != 0L) {
                    if (!this.uninits.isMember(varSymbol.adr)) {
                        varSymbol.flags_field &= 0xFFFFFDFFFFFFFFFFL;
                    } else {
                        this.uninit(varSymbol);
                    }
                } else if ((varSymbol.flags() & 0x10L) != 0L) {
                    if ((varSymbol.flags() & 0x200000000L) != 0L) {
                        if ((varSymbol.flags() & 0x8000000000L) != 0L) {
                            Flow.this.log.error(diagnosticPosition, "multicatch.parameter.may.not.be.assigned", varSymbol);
                        } else {
                            Flow.this.log.error(diagnosticPosition, "final.parameter.may.not.be.assigned", varSymbol);
                        }
                    } else if (!this.uninits.isMember(varSymbol.adr)) {
                        Flow.this.log.error(diagnosticPosition, this.flowKind.errKey, varSymbol);
                    } else {
                        this.uninit(varSymbol);
                    }
                }
                this.inits.incl(varSymbol.adr);
            } else if ((varSymbol.flags() & 0x10L) != 0L) {
                Flow.this.log.error(diagnosticPosition, "var.might.already.be.assigned", varSymbol);
            }
        }

        void uninit(Symbol.VarSymbol varSymbol) {
            if (!this.inits.isMember(varSymbol.adr)) {
                this.uninits.excl(varSymbol.adr);
                this.uninitsTry.excl(varSymbol.adr);
            } else {
                this.uninits.excl(varSymbol.adr);
            }
        }

        void letInit(JCTree jCTree) {
            if ((jCTree = TreeInfo.skipParens(jCTree)).hasTag(JCTree.Tag.IDENT) || jCTree.hasTag(JCTree.Tag.SELECT)) {
                Symbol symbol = TreeInfo.symbol(jCTree);
                if (symbol.kind == Kinds.Kind.VAR) {
                    this.letInit(jCTree.pos(), (Symbol.VarSymbol)symbol);
                }
            }
        }

        void checkInit(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol) {
            this.checkInit(diagnosticPosition, varSymbol, "var.might.not.have.been.initialized");
        }

        void checkInit(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol, String string) {
            if ((varSymbol.adr >= this.firstadr || varSymbol.owner.kind != Kinds.Kind.TYP) && this.trackable(varSymbol) && !this.inits.isMember(varSymbol.adr)) {
                Flow.this.log.error(diagnosticPosition, string, varSymbol);
                this.inits.incl(varSymbol.adr);
            }
        }

        private void resetBits(Bits ... bitsArray) {
            for (Bits bits : bitsArray) {
                bits.reset();
            }
        }

        void split(boolean bl) {
            this.initsWhenFalse.assign(this.inits);
            this.uninitsWhenFalse.assign(this.uninits);
            this.initsWhenTrue.assign(this.inits);
            this.uninitsWhenTrue.assign(this.uninits);
            if (bl) {
                this.resetBits(this.inits, this.uninits);
            }
        }

        protected void merge() {
            this.inits.assign(this.initsWhenFalse.andSet(this.initsWhenTrue));
            this.uninits.assign(this.uninitsWhenFalse.andSet(this.uninitsWhenTrue));
        }

        void scanExpr(JCTree jCTree) {
            if (jCTree != null) {
                this.scan(jCTree);
                if (this.inits.isReset()) {
                    this.merge();
                }
            }
        }

        void scanExprs(List<? extends JCTree.JCExpression> list) {
            if (list != null) {
                List<JCTree.JCExpression> list2 = list;
                while (list2.nonEmpty()) {
                    this.scanExpr((JCTree)list2.head);
                    list2 = list2.tail;
                }
            }
        }

        void scanCond(JCTree jCTree) {
            if (jCTree.type.isFalse()) {
                if (this.inits.isReset()) {
                    this.merge();
                }
                this.initsWhenTrue.assign(this.inits);
                this.initsWhenTrue.inclRange(this.firstadr, this.nextadr);
                this.uninitsWhenTrue.assign(this.uninits);
                this.uninitsWhenTrue.inclRange(this.firstadr, this.nextadr);
                this.initsWhenFalse.assign(this.inits);
                this.uninitsWhenFalse.assign(this.uninits);
            } else if (jCTree.type.isTrue()) {
                if (this.inits.isReset()) {
                    this.merge();
                }
                this.initsWhenFalse.assign(this.inits);
                this.initsWhenFalse.inclRange(this.firstadr, this.nextadr);
                this.uninitsWhenFalse.assign(this.uninits);
                this.uninitsWhenFalse.inclRange(this.firstadr, this.nextadr);
                this.initsWhenTrue.assign(this.inits);
                this.uninitsWhenTrue.assign(this.uninits);
            } else {
                this.scan(jCTree);
                if (!this.inits.isReset()) {
                    this.split(jCTree.type != ((Flow)Flow.this).syms.unknownType);
                }
            }
            if (jCTree.type != ((Flow)Flow.this).syms.unknownType) {
                this.resetBits(this.inits, this.uninits);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            if (jCClassDecl.sym == null) {
                return;
            }
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCClassDecl.sym);
            try {
                if (jCClassDecl.sym == null) {
                    return;
                }
                JCTree.JCClassDecl jCClassDecl2 = this.classDef;
                int n = this.firstadr;
                int n2 = this.nextadr;
                ListBuffer listBuffer = this.pendingExits;
                this.pendingExits = new ListBuffer();
                if (jCClassDecl.name != ((Flow)Flow.this).names.empty) {
                    this.firstadr = this.nextadr;
                }
                this.classDef = jCClassDecl;
                try {
                    Symbol.VarSymbol varSymbol;
                    JCTree.JCVariableDecl jCVariableDecl;
                    List<JCTree> list = jCClassDecl.defs;
                    while (list.nonEmpty()) {
                        if (((JCTree)list.head).hasTag(JCTree.Tag.VARDEF)) {
                            jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                            if ((jCVariableDecl.mods.flags & 8L) != 0L && this.trackable(varSymbol = jCVariableDecl.sym)) {
                                this.newVar(jCVariableDecl);
                            }
                        }
                        list = list.tail;
                    }
                    list = jCClassDecl.defs;
                    while (list.nonEmpty()) {
                        if (!((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)list.head) & 8L) != 0L) {
                            this.scan((JCTree)list.head);
                        }
                        list = list.tail;
                    }
                    list = jCClassDecl.defs;
                    while (list.nonEmpty()) {
                        if (((JCTree)list.head).hasTag(JCTree.Tag.VARDEF)) {
                            jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                            if ((jCVariableDecl.mods.flags & 8L) == 0L && this.trackable(varSymbol = jCVariableDecl.sym)) {
                                this.newVar(jCVariableDecl);
                            }
                        }
                        list = list.tail;
                    }
                    list = jCClassDecl.defs;
                    while (list.nonEmpty()) {
                        if (!((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)list.head) & 8L) == 0L) {
                            this.scan((JCTree)list.head);
                        }
                        list = list.tail;
                    }
                    list = jCClassDecl.defs;
                    while (list.nonEmpty()) {
                        if (((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF)) {
                            this.scan((JCTree)list.head);
                        }
                        list = list.tail;
                    }
                }
                finally {
                    this.pendingExits = listBuffer;
                    this.nextadr = n2;
                    this.firstadr = n;
                    this.classDef = jCClassDecl2;
                }
            }
            finally {
                Flow.this.lint = lint;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            if (jCMethodDecl.body == null) {
                return;
            }
            if ((jCMethodDecl.sym.flags() & 0x1000L) != 0L) {
                return;
            }
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCMethodDecl.sym);
            try {
                if (jCMethodDecl.body == null) {
                    return;
                }
                if ((jCMethodDecl.sym.flags() & 0x2000000001000L) == 4096L) {
                    return;
                }
                Bits bits = new Bits(this.inits);
                Bits bits2 = new Bits(this.uninits);
                int n = this.nextadr;
                int n2 = this.firstadr;
                int n3 = this.returnadr;
                Assert.check(this.pendingExits.isEmpty());
                boolean bl = this.isInitialConstructor;
                try {
                    this.isInitialConstructor = TreeInfo.isInitialConstructor(jCMethodDecl);
                    if (!this.isInitialConstructor) {
                        this.firstadr = this.nextadr;
                    }
                    List<JCTree.JCVariableDecl> list = jCMethodDecl.params;
                    while (list.nonEmpty()) {
                        JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                        this.scan(jCVariableDecl);
                        Assert.check((jCVariableDecl.sym.flags() & 0x200000000L) != 0L, "Method parameter without PARAMETER flag");
                        this.initParam(jCVariableDecl);
                        list = list.tail;
                    }
                    this.scan(jCMethodDecl.body);
                    if (this.isInitialConstructor) {
                        boolean bl2 = (jCMethodDecl.sym.flags() & 0x1000000000L) != 0L;
                        for (int i = this.firstadr; i < this.nextadr; ++i) {
                            JCTree.JCVariableDecl jCVariableDecl = this.vardecls[i];
                            Symbol.VarSymbol varSymbol = jCVariableDecl.sym;
                            if (varSymbol.owner != this.classDef.sym) continue;
                            if (bl2) {
                                this.checkInit(TreeInfo.diagnosticPositionFor(varSymbol, jCVariableDecl), varSymbol, "var.not.initialized.in.default.constructor");
                                continue;
                            }
                            this.checkInit(TreeInfo.diagEndPos(jCMethodDecl.body), varSymbol);
                        }
                    }
                    list = this.pendingExits.toList();
                    this.pendingExits = new ListBuffer();
                    while (list.nonEmpty()) {
                        AssignPendingExit assignPendingExit = (AssignPendingExit)list.head;
                        list = list.tail;
                        Assert.check(assignPendingExit.tree.hasTag(JCTree.Tag.RETURN), assignPendingExit.tree);
                        if (!this.isInitialConstructor) continue;
                        this.inits.assign(assignPendingExit.exit_inits);
                        for (int i = this.firstadr; i < this.nextadr; ++i) {
                            this.checkInit(assignPendingExit.tree.pos(), this.vardecls[i].sym);
                        }
                    }
                }
                finally {
                    this.inits.assign(bits);
                    this.uninits.assign(bits2);
                    this.nextadr = n;
                    this.firstadr = n2;
                    this.returnadr = n3;
                    this.isInitialConstructor = bl;
                }
            }
            finally {
                Flow.this.lint = lint;
            }
        }

        protected void initParam(JCTree.JCVariableDecl jCVariableDecl) {
            this.inits.incl(jCVariableDecl.sym.adr);
            this.uninits.excl(jCVariableDecl.sym.adr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCVariableDecl.sym);
            try {
                boolean bl = this.trackable(jCVariableDecl.sym);
                if (bl && jCVariableDecl.sym.owner.kind == Kinds.Kind.MTH) {
                    this.newVar(jCVariableDecl);
                }
                if (jCVariableDecl.init != null) {
                    this.scanExpr(jCVariableDecl.init);
                    if (bl) {
                        this.letInit(jCVariableDecl.pos(), jCVariableDecl.sym);
                    }
                }
            }
            finally {
                Flow.this.lint = lint;
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
            int n = this.nextadr;
            this.scan(jCBlock.stats);
            this.nextadr = n;
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            FlowKind flowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            Bits bits = new Bits(true);
            Bits bits2 = new Bits(true);
            this.pendingExits = new ListBuffer();
            int n = ((Flow)Flow.this).log.nerrors;
            while (true) {
                Bits bits3 = new Bits(this.uninits);
                bits3.excludeFrom(this.nextadr);
                this.scan(jCDoWhileLoop.body);
                this.resolveContinues(jCDoWhileLoop);
                this.scanCond(jCDoWhileLoop.cond);
                if (!this.flowKind.isFinal()) {
                    bits.assign(this.initsWhenFalse);
                    bits2.assign(this.uninitsWhenFalse);
                }
                if (((Flow)Flow.this).log.nerrors != n || this.flowKind.isFinal() || new Bits(bits3).diffSet(this.uninitsWhenTrue).nextBit(this.firstadr) == -1) break;
                this.inits.assign(this.initsWhenTrue);
                this.uninits.assign(bits3.andSet(this.uninitsWhenTrue));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = flowKind;
            this.inits.assign(bits);
            this.uninits.assign(bits2);
            this.resolveBreaks(jCDoWhileLoop, listBuffer);
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            FlowKind flowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            Bits bits = new Bits(true);
            Bits bits2 = new Bits(true);
            this.pendingExits = new ListBuffer();
            int n = ((Flow)Flow.this).log.nerrors;
            Bits bits3 = new Bits(this.uninits);
            bits3.excludeFrom(this.nextadr);
            while (true) {
                this.scanCond(jCWhileLoop.cond);
                if (!this.flowKind.isFinal()) {
                    bits.assign(this.initsWhenFalse);
                    bits2.assign(this.uninitsWhenFalse);
                }
                this.inits.assign(this.initsWhenTrue);
                this.uninits.assign(this.uninitsWhenTrue);
                this.scan(jCWhileLoop.body);
                this.resolveContinues(jCWhileLoop);
                if (((Flow)Flow.this).log.nerrors != n || this.flowKind.isFinal() || new Bits(bits3).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(bits3.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = flowKind;
            this.inits.assign(bits);
            this.uninits.assign(bits2);
            this.resolveBreaks(jCWhileLoop, listBuffer);
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop jCForLoop) {
            ListBuffer listBuffer = this.pendingExits;
            FlowKind flowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            int n = this.nextadr;
            this.scan(jCForLoop.init);
            Bits bits = new Bits(true);
            Bits bits2 = new Bits(true);
            this.pendingExits = new ListBuffer();
            int n2 = ((Flow)Flow.this).log.nerrors;
            while (true) {
                Bits bits3 = new Bits(this.uninits);
                bits3.excludeFrom(this.nextadr);
                if (jCForLoop.cond != null) {
                    this.scanCond(jCForLoop.cond);
                    if (!this.flowKind.isFinal()) {
                        bits.assign(this.initsWhenFalse);
                        bits2.assign(this.uninitsWhenFalse);
                    }
                    this.inits.assign(this.initsWhenTrue);
                    this.uninits.assign(this.uninitsWhenTrue);
                } else if (!this.flowKind.isFinal()) {
                    bits.assign(this.inits);
                    bits.inclRange(this.firstadr, this.nextadr);
                    bits2.assign(this.uninits);
                    bits2.inclRange(this.firstadr, this.nextadr);
                }
                this.scan(jCForLoop.body);
                this.resolveContinues(jCForLoop);
                this.scan(jCForLoop.step);
                if (((Flow)Flow.this).log.nerrors != n2 || this.flowKind.isFinal() || new Bits(bits3).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(bits3.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = flowKind;
            this.inits.assign(bits);
            this.uninits.assign(bits2);
            this.resolveBreaks(jCForLoop, listBuffer);
            this.nextadr = n;
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            this.visitVarDef(jCEnhancedForLoop.var);
            ListBuffer listBuffer = this.pendingExits;
            FlowKind flowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            int n = this.nextadr;
            this.scan(jCEnhancedForLoop.expr);
            Bits bits = new Bits(this.inits);
            Bits bits2 = new Bits(this.uninits);
            this.letInit(jCEnhancedForLoop.pos(), jCEnhancedForLoop.var.sym);
            this.pendingExits = new ListBuffer();
            int n2 = ((Flow)Flow.this).log.nerrors;
            while (true) {
                Bits bits3 = new Bits(this.uninits);
                bits3.excludeFrom(this.nextadr);
                this.scan(jCEnhancedForLoop.body);
                this.resolveContinues(jCEnhancedForLoop);
                if (((Flow)Flow.this).log.nerrors != n2 || this.flowKind.isFinal() || new Bits(bits3).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(bits3.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = flowKind;
            this.inits.assign(bits);
            this.uninits.assign(bits2.andSet(this.uninits));
            this.resolveBreaks(jCEnhancedForLoop, listBuffer);
            this.nextadr = n;
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCLabeledStatement.body);
            this.resolveBreaks(jCLabeledStatement, listBuffer);
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch jCSwitch) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            int n = this.nextadr;
            this.scanExpr(jCSwitch.selector);
            Bits bits = new Bits(this.inits);
            Bits bits2 = new Bits(this.uninits);
            boolean bl = false;
            List<JCTree.JCCase> list = jCSwitch.cases;
            while (list.nonEmpty()) {
                this.inits.assign(bits);
                this.uninits.assign(this.uninits.andSet(bits2));
                JCTree.JCCase jCCase = (JCTree.JCCase)list.head;
                if (jCCase.pat == null) {
                    bl = true;
                } else {
                    this.scanExpr(jCCase.pat);
                }
                if (bl) {
                    this.inits.assign(bits);
                    this.uninits.assign(this.uninits.andSet(bits2));
                }
                this.scan(jCCase.stats);
                this.addVars(jCCase.stats, bits, bits2);
                if (!bl) {
                    this.inits.assign(bits);
                    this.uninits.assign(this.uninits.andSet(bits2));
                }
                list = list.tail;
            }
            if (!bl) {
                this.inits.andSet(bits);
            }
            this.resolveBreaks(jCSwitch, listBuffer);
            this.nextadr = n;
        }

        private void addVars(List<JCTree.JCStatement> list, Bits bits, Bits bits2) {
            while (list.nonEmpty()) {
                JCTree jCTree = (JCTree)list.head;
                if (jCTree.hasTag(JCTree.Tag.VARDEF)) {
                    int n = ((JCTree.JCVariableDecl)jCTree).sym.adr;
                    bits.excl(n);
                    bits2.incl(n);
                }
                list = list.tail;
            }
        }

        @Override
        public void visitTry(JCTree.JCTry jCTry) {
            Object object;
            ListBuffer<JCTree.JCVariableDecl> listBuffer = new ListBuffer<JCTree.JCVariableDecl>();
            Bits bits = new Bits(this.uninitsTry);
            ListBuffer listBuffer2 = this.pendingExits;
            this.pendingExits = new ListBuffer();
            Bits bits2 = new Bits(this.inits);
            this.uninitsTry.assign(this.uninits);
            for (JCTree object32 : jCTry.resources) {
                if (object32 instanceof JCTree.JCVariableDecl) {
                    JCTree.JCVariableDecl n = (JCTree.JCVariableDecl)object32;
                    this.visitVarDef(n);
                    this.unrefdResources.enter(n.sym);
                    listBuffer.append(n);
                    continue;
                }
                if (object32 instanceof JCTree.JCExpression) {
                    this.scanExpr((JCTree.JCExpression)object32);
                    continue;
                }
                throw new AssertionError(jCTry);
            }
            this.scan(jCTry.body);
            this.uninitsTry.andSet(this.uninits);
            Bits bits3 = new Bits(this.inits);
            Bits bits4 = new Bits(this.uninits);
            int n = this.nextadr;
            if (!listBuffer.isEmpty() && Flow.this.lint.isEnabled(Lint.LintCategory.TRY)) {
                for (JCTree.JCVariableDecl jCVariableDecl : listBuffer) {
                    if (!this.unrefdResources.includes(jCVariableDecl.sym)) continue;
                    Flow.this.log.warning(Lint.LintCategory.TRY, jCVariableDecl.pos(), "try.resource.not.referenced", jCVariableDecl.sym);
                    this.unrefdResources.remove(jCVariableDecl.sym);
                }
            }
            Bits bits5 = new Bits(bits2);
            Bits bits6 = new Bits(this.uninitsTry);
            AbstractCollection abstractCollection = jCTry.catchers;
            while (((List)abstractCollection).nonEmpty()) {
                object = ((JCTree.JCCatch)((List)abstractCollection).head).param;
                this.inits.assign(bits5);
                this.uninits.assign(bits6);
                this.scan((JCTree)object);
                this.initParam((JCTree.JCVariableDecl)object);
                this.scan(((JCTree.JCCatch)((List)abstractCollection).head).body);
                bits3.andSet(this.inits);
                bits4.andSet(this.uninits);
                this.nextadr = n;
                abstractCollection = ((List)abstractCollection).tail;
            }
            if (jCTry.finalizer != null) {
                this.inits.assign(bits2);
                this.uninits.assign(this.uninitsTry);
                abstractCollection = this.pendingExits;
                this.pendingExits = listBuffer2;
                this.scan(jCTry.finalizer);
                if (jCTry.finallyCanCompleteNormally) {
                    this.uninits.andSet(bits4);
                    while (((ListBuffer)abstractCollection).nonEmpty()) {
                        object = (AssignPendingExit)((ListBuffer)abstractCollection).next();
                        if (((AssignPendingExit)object).exit_inits != null) {
                            ((AssignPendingExit)object).exit_inits.orSet(this.inits);
                            ((AssignPendingExit)object).exit_uninits.andSet(this.uninits);
                        }
                        this.pendingExits.append(object);
                    }
                    this.inits.orSet(bits3);
                }
            } else {
                this.inits.assign(bits3);
                this.uninits.assign(bits4);
                abstractCollection = this.pendingExits;
                this.pendingExits = listBuffer2;
                while (((ListBuffer)abstractCollection).nonEmpty()) {
                    this.pendingExits.append(((ListBuffer)abstractCollection).next());
                }
            }
            this.uninitsTry.andSet(bits).andSet(this.uninits);
        }

        @Override
        public void visitConditional(JCTree.JCConditional jCConditional) {
            this.scanCond(jCConditional.cond);
            Bits bits = new Bits(this.initsWhenFalse);
            Bits bits2 = new Bits(this.uninitsWhenFalse);
            this.inits.assign(this.initsWhenTrue);
            this.uninits.assign(this.uninitsWhenTrue);
            if (jCConditional.truepart.type.hasTag(TypeTag.BOOLEAN) && jCConditional.falsepart.type.hasTag(TypeTag.BOOLEAN)) {
                this.scanCond(jCConditional.truepart);
                Bits bits3 = new Bits(this.initsWhenTrue);
                Bits bits4 = new Bits(this.initsWhenFalse);
                Bits bits5 = new Bits(this.uninitsWhenTrue);
                Bits bits6 = new Bits(this.uninitsWhenFalse);
                this.inits.assign(bits);
                this.uninits.assign(bits2);
                this.scanCond(jCConditional.falsepart);
                this.initsWhenTrue.andSet(bits3);
                this.initsWhenFalse.andSet(bits4);
                this.uninitsWhenTrue.andSet(bits5);
                this.uninitsWhenFalse.andSet(bits6);
            } else {
                this.scanExpr(jCConditional.truepart);
                Bits bits7 = new Bits(this.inits);
                Bits bits8 = new Bits(this.uninits);
                this.inits.assign(bits);
                this.uninits.assign(bits2);
                this.scanExpr(jCConditional.falsepart);
                this.inits.andSet(bits7);
                this.uninits.andSet(bits8);
            }
        }

        @Override
        public void visitIf(JCTree.JCIf jCIf) {
            this.scanCond(jCIf.cond);
            Bits bits = new Bits(this.initsWhenFalse);
            Bits bits2 = new Bits(this.uninitsWhenFalse);
            this.inits.assign(this.initsWhenTrue);
            this.uninits.assign(this.uninitsWhenTrue);
            this.scan(jCIf.thenpart);
            if (jCIf.elsepart != null) {
                Bits bits3 = new Bits(this.inits);
                Bits bits4 = new Bits(this.uninits);
                this.inits.assign(bits);
                this.uninits.assign(bits2);
                this.scan(jCIf.elsepart);
                this.inits.andSet(bits3);
                this.uninits.andSet(bits4);
            } else {
                this.inits.andSet(bits);
                this.uninits.andSet(bits2);
            }
        }

        @Override
        public void visitBreak(JCTree.JCBreak jCBreak) {
            this.recordExit(new AssignPendingExit(jCBreak, this.inits, this.uninits));
        }

        @Override
        public void visitContinue(JCTree.JCContinue jCContinue) {
            this.recordExit(new AssignPendingExit(jCContinue, this.inits, this.uninits));
        }

        @Override
        public void visitReturn(JCTree.JCReturn jCReturn) {
            this.scanExpr(jCReturn.expr);
            this.recordExit(new AssignPendingExit(jCReturn, this.inits, this.uninits));
        }

        @Override
        public void visitThrow(JCTree.JCThrow jCThrow) {
            this.scanExpr(jCThrow.expr);
            this.markDead();
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            this.scanExpr(jCMethodInvocation.meth);
            this.scanExprs(jCMethodInvocation.args);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            this.scanExpr(jCNewClass.encl);
            this.scanExprs(jCNewClass.args);
            this.scan(jCNewClass.def);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            Bits bits = new Bits(this.uninits);
            Bits bits2 = new Bits(this.inits);
            int n = this.returnadr;
            int n2 = this.nextadr;
            ListBuffer listBuffer = this.pendingExits;
            try {
                this.returnadr = this.nextadr;
                this.pendingExits = new ListBuffer();
                List<JCTree.JCVariableDecl> list = jCLambda.params;
                while (list.nonEmpty()) {
                    JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                    this.scan(jCVariableDecl);
                    this.inits.incl(jCVariableDecl.sym.adr);
                    this.uninits.excl(jCVariableDecl.sym.adr);
                    list = list.tail;
                }
                if (jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                    this.scanExpr(jCLambda.body);
                } else {
                    this.scan(jCLambda.body);
                }
            }
            finally {
                this.returnadr = n;
                this.uninits.assign(bits);
                this.inits.assign(bits2);
                this.pendingExits = listBuffer;
                this.nextadr = n2;
            }
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray jCNewArray) {
            this.scanExprs(jCNewArray.dims);
            this.scanExprs(jCNewArray.elems);
        }

        @Override
        public void visitAssert(JCTree.JCAssert jCAssert) {
            Bits bits = new Bits(this.inits);
            Bits bits2 = new Bits(this.uninits);
            this.scanCond(jCAssert.cond);
            bits2.andSet(this.uninitsWhenTrue);
            if (jCAssert.detail != null) {
                this.inits.assign(this.initsWhenFalse);
                this.uninits.assign(this.uninitsWhenFalse);
                this.scanExpr(jCAssert.detail);
            }
            this.inits.assign(bits);
            this.uninits.assign(bits2);
        }

        @Override
        public void visitAssign(JCTree.JCAssign jCAssign) {
            JCTree.JCExpression jCExpression = TreeInfo.skipParens(jCAssign.lhs);
            if (!this.isIdentOrThisDotIdent(jCExpression)) {
                this.scanExpr(jCExpression);
            }
            this.scanExpr(jCAssign.rhs);
            this.letInit(jCExpression);
        }

        private boolean isIdentOrThisDotIdent(JCTree jCTree) {
            if (jCTree.hasTag(JCTree.Tag.IDENT)) {
                return true;
            }
            if (!jCTree.hasTag(JCTree.Tag.SELECT)) {
                return false;
            }
            JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCTree;
            return jCFieldAccess.selected.hasTag(JCTree.Tag.IDENT) && ((JCTree.JCIdent)jCFieldAccess.selected).name == ((Flow)Flow.this).names._this;
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            super.visitSelect(jCFieldAccess);
            JCTree.JCExpression jCExpression = TreeInfo.skipParens(jCFieldAccess.selected);
            if (Flow.this.enforceThisDotInit && jCExpression.hasTag(JCTree.Tag.IDENT) && ((JCTree.JCIdent)jCExpression).name == ((Flow)Flow.this).names._this && jCFieldAccess.sym.kind == Kinds.Kind.VAR) {
                this.checkInit(jCFieldAccess.pos(), (Symbol.VarSymbol)jCFieldAccess.sym);
            }
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
            this.scanExpr(jCAssignOp.lhs);
            this.scanExpr(jCAssignOp.rhs);
            this.letInit(jCAssignOp.lhs);
        }

        @Override
        public void visitUnary(JCTree.JCUnary jCUnary) {
            switch (jCUnary.getTag()) {
                case NOT: {
                    this.scanCond(jCUnary.arg);
                    Bits bits = new Bits(this.initsWhenFalse);
                    this.initsWhenFalse.assign(this.initsWhenTrue);
                    this.initsWhenTrue.assign(bits);
                    bits.assign(this.uninitsWhenFalse);
                    this.uninitsWhenFalse.assign(this.uninitsWhenTrue);
                    this.uninitsWhenTrue.assign(bits);
                    break;
                }
                case PREINC: 
                case POSTINC: 
                case PREDEC: 
                case POSTDEC: {
                    this.scanExpr(jCUnary.arg);
                    this.letInit(jCUnary.arg);
                    break;
                }
                default: {
                    this.scanExpr(jCUnary.arg);
                }
            }
        }

        @Override
        public void visitBinary(JCTree.JCBinary jCBinary) {
            switch (jCBinary.getTag()) {
                case AND: {
                    this.scanCond(jCBinary.lhs);
                    Bits bits = new Bits(this.initsWhenFalse);
                    Bits bits2 = new Bits(this.uninitsWhenFalse);
                    this.inits.assign(this.initsWhenTrue);
                    this.uninits.assign(this.uninitsWhenTrue);
                    this.scanCond(jCBinary.rhs);
                    this.initsWhenFalse.andSet(bits);
                    this.uninitsWhenFalse.andSet(bits2);
                    break;
                }
                case OR: {
                    this.scanCond(jCBinary.lhs);
                    Bits bits = new Bits(this.initsWhenTrue);
                    Bits bits3 = new Bits(this.uninitsWhenTrue);
                    this.inits.assign(this.initsWhenFalse);
                    this.uninits.assign(this.uninitsWhenFalse);
                    this.scanCond(jCBinary.rhs);
                    this.initsWhenTrue.andSet(bits);
                    this.uninitsWhenTrue.andSet(bits3);
                    break;
                }
                default: {
                    this.scanExpr(jCBinary.lhs);
                    this.scanExpr(jCBinary.rhs);
                }
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            if (jCIdent.sym.kind == Kinds.Kind.VAR) {
                this.checkInit(jCIdent.pos(), (Symbol.VarSymbol)jCIdent.sym);
                this.referenced(jCIdent.sym);
            }
        }

        void referenced(Symbol symbol) {
            this.unrefdResources.remove(symbol);
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType jCAnnotatedType) {
            jCAnnotatedType.underlyingType.accept(this);
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        }

        public void analyzeTree(Env<?> env) {
            this.analyzeTree(env, env.tree);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<?> env, JCTree jCTree) {
            int n;
            try {
                this.startPos = jCTree.pos().getStartPosition();
                if (this.vardecls == null) {
                    this.vardecls = new JCTree.JCVariableDecl[32];
                } else {
                    for (n = 0; n < this.vardecls.length; ++n) {
                        this.vardecls[n] = null;
                    }
                }
                this.firstadr = 0;
                this.nextadr = 0;
                this.pendingExits = new ListBuffer();
                this.classDef = null;
                this.unrefdResources = Scope.WriteableScope.create(env.enclClass.sym);
                this.scan(jCTree);
                this.startPos = -1;
            }
            catch (Throwable throwable) {
                this.startPos = -1;
                this.resetBits(this.inits, this.uninits, this.uninitsTry, this.initsWhenTrue, this.initsWhenFalse, this.uninitsWhenTrue, this.uninitsWhenFalse);
                if (this.vardecls != null) {
                    for (int i = 0; i < this.vardecls.length; ++i) {
                        this.vardecls[i] = null;
                    }
                }
                this.firstadr = 0;
                this.nextadr = 0;
                this.pendingExits = null;
                this.classDef = null;
                this.unrefdResources = null;
                throw throwable;
            }
            this.resetBits(this.inits, this.uninits, this.uninitsTry, this.initsWhenTrue, this.initsWhenFalse, this.uninitsWhenTrue, this.uninitsWhenFalse);
            if (this.vardecls != null) {
                for (n = 0; n < this.vardecls.length; ++n) {
                    this.vardecls[n] = null;
                }
            }
            this.firstadr = 0;
            this.nextadr = 0;
            this.pendingExits = null;
            this.classDef = null;
            this.unrefdResources = null;
        }

        public class AssignPendingExit
        extends BaseAnalyzer.PendingExit {
            final Bits inits;
            final Bits uninits;
            final Bits exit_inits;
            final Bits exit_uninits;

            public AssignPendingExit(JCTree jCTree, Bits bits, Bits bits2) {
                super(jCTree);
                this.exit_inits = new Bits(true);
                this.exit_uninits = new Bits(true);
                this.inits = bits;
                this.uninits = bits2;
                this.exit_inits.assign(bits);
                this.exit_uninits.assign(bits2);
            }

            @Override
            public void resolveJump() {
                this.inits.andSet(this.exit_inits);
                this.uninits.andSet(this.exit_uninits);
            }
        }
    }

    class LambdaFlowAnalyzer
    extends FlowAnalyzer {
        List<Type> inferredThrownTypes;
        boolean inLambda;

        LambdaFlowAnalyzer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (jCLambda.type != null && jCLambda.type.isErroneous() || this.inLambda) {
                return;
            }
            List list = this.caught;
            List list2 = this.thrown;
            ListBuffer listBuffer = this.pendingExits;
            this.inLambda = true;
            try {
                this.pendingExits = new ListBuffer();
                this.caught = List.of(((Flow)Flow.this).syms.throwableType);
                this.thrown = List.nil();
                this.scan(jCLambda.body);
                this.inferredThrownTypes = this.thrown;
            }
            finally {
                this.pendingExits = listBuffer;
                this.caught = list;
                this.thrown = list2;
                this.inLambda = false;
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }
    }

    class LambdaAssignAnalyzer
    extends AssignAnalyzer {
        Scope.WriteableScope enclosedSymbols;
        boolean inLambda;

        LambdaAssignAnalyzer(Env<AttrContext> env) {
            this.enclosedSymbols = Scope.WriteableScope.create(env.enclClass.sym);
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (this.inLambda) {
                return;
            }
            this.inLambda = true;
            try {
                super.visitLambda(jCLambda);
            }
            finally {
                this.inLambda = false;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            this.enclosedSymbols.enter(jCVariableDecl.sym);
            super.visitVarDef(jCVariableDecl);
        }

        @Override
        protected boolean trackable(Symbol.VarSymbol varSymbol) {
            return this.enclosedSymbols.includes(varSymbol) && varSymbol.owner.kind == Kinds.Kind.MTH;
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }
    }

    class LambdaAliveAnalyzer
    extends AliveAnalyzer {
        boolean inLambda;

        LambdaAliveAnalyzer() {
        }

        @Override
        public void visitReturn(JCTree.JCReturn jCReturn) {
            this.recordExit(new BaseAnalyzer.PendingExit(jCReturn));
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (this.inLambda || jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                return;
            }
            this.inLambda = true;
            try {
                super.visitLambda(jCLambda);
            }
            finally {
                this.inLambda = false;
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }
    }

    class FlowAnalyzer
    extends BaseAnalyzer<FlowPendingExit> {
        HashMap<Symbol, List<Type>> preciseRethrowTypes;
        JCTree.JCClassDecl classDef;
        List<Type> thrown;
        List<Type> caught;

        FlowAnalyzer() {
        }

        @Override
        void markDead() {
        }

        void errorUncaught() {
            FlowPendingExit flowPendingExit = (FlowPendingExit)this.pendingExits.next();
            while (flowPendingExit != null) {
                if (this.classDef != null && this.classDef.pos == flowPendingExit.tree.pos) {
                    Flow.this.log.error(flowPendingExit.tree.pos(), "unreported.exception.default.constructor", flowPendingExit.thrown);
                } else if (flowPendingExit.tree.hasTag(JCTree.Tag.VARDEF) && ((JCTree.JCVariableDecl)flowPendingExit.tree).sym.isResourceVariable()) {
                    Flow.this.log.error(flowPendingExit.tree.pos(), "unreported.exception.implicit.close", flowPendingExit.thrown, ((JCTree.JCVariableDecl)flowPendingExit.tree).sym.name);
                } else {
                    Flow.this.log.error(flowPendingExit.tree.pos(), "unreported.exception.need.to.catch.or.throw", flowPendingExit.thrown);
                }
                flowPendingExit = (FlowPendingExit)this.pendingExits.next();
            }
        }

        void markThrown(JCTree jCTree, Type type) {
            if (!Flow.this.chk.isUnchecked(jCTree.pos(), type)) {
                if (!Flow.this.chk.isHandled(type, this.caught)) {
                    this.pendingExits.append(new FlowPendingExit(jCTree, type));
                }
                this.thrown = Flow.this.chk.incl(type, this.thrown);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            if (jCClassDecl.sym == null) {
                return;
            }
            JCTree.JCClassDecl jCClassDecl2 = this.classDef;
            List<Type> list = this.thrown;
            List<Type> list2 = this.caught;
            ListBuffer listBuffer = this.pendingExits;
            Lint lint = Flow.this.lint;
            boolean bl = jCClassDecl.name == ((Flow)Flow.this).names.empty;
            this.pendingExits = new ListBuffer();
            if (!bl) {
                this.caught = List.nil();
            }
            this.classDef = jCClassDecl;
            this.thrown = List.nil();
            Flow.this.lint = Flow.this.lint.augment(jCClassDecl.sym);
            try {
                Object object;
                List<JCTree> list3 = jCClassDecl.defs;
                while (list3.nonEmpty()) {
                    if (!((JCTree)list3.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)list3.head) & 8L) != 0L) {
                        this.scan((JCTree)list3.head);
                        this.errorUncaught();
                    }
                    list3 = list3.tail;
                }
                if (!bl) {
                    boolean bl2 = true;
                    object = jCClassDecl.defs;
                    while (((List)object).nonEmpty()) {
                        if (TreeInfo.isInitialConstructor((JCTree)((List)object).head)) {
                            List<Type> list4 = ((JCTree.JCMethodDecl)((List)object).head).sym.type.getThrownTypes();
                            if (bl2) {
                                this.caught = list4;
                                bl2 = false;
                            } else {
                                this.caught = Flow.this.chk.intersect(list4, this.caught);
                            }
                        }
                        object = ((List)object).tail;
                    }
                }
                list3 = jCClassDecl.defs;
                while (list3.nonEmpty()) {
                    if (!((JCTree)list3.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)list3.head) & 8L) == 0L) {
                        this.scan((JCTree)list3.head);
                        this.errorUncaught();
                    }
                    list3 = list3.tail;
                }
                if (bl) {
                    list3 = jCClassDecl.defs;
                    while (list3.nonEmpty()) {
                        if (TreeInfo.isConstructor((JCTree)list3.head)) {
                            object = (JCTree.JCMethodDecl)list3.head;
                            this.scan((JCTree)object);
                            ((JCTree.JCMethodDecl)object).thrown = Flow.this.make.Types(this.thrown);
                            ((JCTree.JCMethodDecl)object).sym.type = Flow.this.types.createMethodTypeWithThrown(((JCTree.JCMethodDecl)object).sym.type, this.thrown);
                        }
                        list3 = list3.tail;
                    }
                    list = Flow.this.chk.union(this.thrown, list);
                }
                list3 = jCClassDecl.defs;
                while (list3.nonEmpty()) {
                    if (!(bl && TreeInfo.isConstructor((JCTree)list3.head) || !((JCTree)list3.head).hasTag(JCTree.Tag.METHODDEF))) {
                        this.scan((JCTree)list3.head);
                        this.errorUncaught();
                    }
                    list3 = list3.tail;
                }
                this.thrown = list;
            }
            finally {
                this.pendingExits = listBuffer;
                this.caught = list2;
                this.classDef = jCClassDecl2;
                Flow.this.lint = lint;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            if (jCMethodDecl.body == null) {
                return;
            }
            List<Type> list = this.caught;
            List<Type> list2 = jCMethodDecl.sym.type.getThrownTypes();
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCMethodDecl.sym);
            Assert.check(this.pendingExits.isEmpty());
            try {
                Object object;
                List<JCTree.JCVariableDecl> list3 = jCMethodDecl.params;
                while (list3.nonEmpty()) {
                    object = (JCTree.JCVariableDecl)list3.head;
                    this.scan((JCTree)object);
                    list3 = list3.tail;
                }
                if (TreeInfo.isInitialConstructor(jCMethodDecl)) {
                    this.caught = Flow.this.chk.union(this.caught, list2);
                } else if ((jCMethodDecl.sym.flags() & 0x100008L) != 0x100000L) {
                    this.caught = list2;
                }
                this.scan(jCMethodDecl.body);
                list3 = this.pendingExits.toList();
                this.pendingExits = new ListBuffer();
                while (list3.nonEmpty()) {
                    object = (FlowPendingExit)list3.head;
                    list3 = list3.tail;
                    if (((FlowPendingExit)object).thrown == null) {
                        Assert.check(((FlowPendingExit)object).tree.hasTag(JCTree.Tag.RETURN));
                        continue;
                    }
                    this.pendingExits.append(object);
                }
            }
            finally {
                this.caught = list;
                Flow.this.lint = lint;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            if (jCVariableDecl.init != null) {
                Lint lint = Flow.this.lint;
                Flow.this.lint = Flow.this.lint.augment(jCVariableDecl.sym);
                try {
                    this.scan(jCVariableDecl.init);
                }
                finally {
                    Flow.this.lint = lint;
                }
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
            this.scan(jCBlock.stats);
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCDoWhileLoop.body);
            this.resolveContinues(jCDoWhileLoop);
            this.scan(jCDoWhileLoop.cond);
            this.resolveBreaks(jCDoWhileLoop, listBuffer);
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCWhileLoop.cond);
            this.scan(jCWhileLoop.body);
            this.resolveContinues(jCWhileLoop);
            this.resolveBreaks(jCWhileLoop, listBuffer);
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop jCForLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.scan(jCForLoop.init);
            this.pendingExits = new ListBuffer();
            if (jCForLoop.cond != null) {
                this.scan(jCForLoop.cond);
            }
            this.scan(jCForLoop.body);
            this.resolveContinues(jCForLoop);
            this.scan(jCForLoop.step);
            this.resolveBreaks(jCForLoop, listBuffer);
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            this.visitVarDef(jCEnhancedForLoop.var);
            ListBuffer listBuffer = this.pendingExits;
            this.scan(jCEnhancedForLoop.expr);
            this.pendingExits = new ListBuffer();
            this.scan(jCEnhancedForLoop.body);
            this.resolveContinues(jCEnhancedForLoop);
            this.resolveBreaks(jCEnhancedForLoop, listBuffer);
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCLabeledStatement.body);
            this.resolveBreaks(jCLabeledStatement, listBuffer);
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch jCSwitch) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCSwitch.selector);
            List<JCTree.JCCase> list = jCSwitch.cases;
            while (list.nonEmpty()) {
                JCTree.JCCase jCCase = (JCTree.JCCase)list.head;
                if (jCCase.pat != null) {
                    this.scan(jCCase.pat);
                }
                this.scan(jCCase.stats);
                list = list.tail;
            }
            this.resolveBreaks(jCSwitch, listBuffer);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitTry(JCTree.JCTry jCTry) {
            void var6_12;
            Object object;
            Object object2;
            List<Type> list;
            AbstractCollection abstractCollection;
            Object object4;
            List<Type> list2 = this.caught;
            List<Type> list3 = this.thrown;
            this.thrown = List.nil();
            AbstractCollection abstractCollection2 = jCTry.catchers;
            while (abstractCollection2.nonEmpty()) {
                object4 = TreeInfo.isMultiCatch((JCTree.JCCatch)abstractCollection2.head) ? ((JCTree.JCTypeUnion)((JCTree.JCCatch)abstractCollection2.head).param.vartype).alternatives : List.of(((JCTree.JCCatch)abstractCollection2.head).param.vartype);
                Iterator object32 = ((List)object4).iterator();
                while (object32.hasNext()) {
                    abstractCollection = (JCTree.JCExpression)object32.next();
                    this.caught = Flow.this.chk.incl(((JCTree.JCExpression)((Object)abstractCollection)).type, this.caught);
                }
                abstractCollection2 = abstractCollection2.tail;
            }
            abstractCollection2 = this.pendingExits;
            this.pendingExits = new ListBuffer();
            for (JCTree jCTree : jCTry.resources) {
                if (jCTree instanceof JCTree.JCVariableDecl) {
                    abstractCollection = (JCTree.JCVariableDecl)jCTree;
                    this.visitVarDef((JCTree.JCVariableDecl)((Object)abstractCollection));
                    continue;
                }
                if (jCTree instanceof JCTree.JCExpression) {
                    this.scan((JCTree.JCExpression)jCTree);
                    continue;
                }
                throw new AssertionError(jCTry);
            }
            for (JCTree jCTree : jCTry.resources) {
                abstractCollection = jCTree.type.isCompound() ? Flow.this.types.interfaces(jCTree.type).prepend(Flow.this.types.supertype(jCTree.type)) : List.of(jCTree.type);
                for (Object object3 : abstractCollection) {
                    if (Flow.this.types.asSuper((Type)object3, ((Flow)Flow.this).syms.autoCloseableType.tsym) == null) continue;
                    list = Flow.this.rs.resolveQualifiedMethod(jCTry, Flow.this.attrEnv, Flow.this.types.skipTypeVars((Type)object3, false), ((Flow)Flow.this).names.close, List.nil(), List.nil());
                    object2 = Flow.this.types.memberType(jCTree.type, (Symbol)((Object)list));
                    if (((Symbol)((Object)list)).kind != Kinds.Kind.MTH) continue;
                    for (Type type : ((Type)object2).getThrownTypes()) {
                        this.markThrown(jCTree, type);
                    }
                }
            }
            this.scan(jCTry.body);
            object4 = Flow.this.allowImprovedCatchAnalysis ? Flow.this.chk.union(this.thrown, List.of(((Flow)Flow.this).syms.runtimeExceptionType, ((Flow)Flow.this).syms.errorType)) : this.thrown;
            this.thrown = list3;
            this.caught = list2;
            List list4 = List.nil();
            abstractCollection = jCTry.catchers;
            while (((List)abstractCollection).nonEmpty()) {
                Object object3;
                object = ((JCTree.JCCatch)((List)abstractCollection).head).param;
                object3 = TreeInfo.isMultiCatch((JCTree.JCCatch)((List)abstractCollection).head) ? ((JCTree.JCTypeUnion)((JCTree.JCCatch)((List)abstractCollection).head).param.vartype).alternatives : List.of(((JCTree.JCCatch)((List)abstractCollection).head).param.vartype);
                list = List.nil();
                object2 = Flow.this.chk.diff((List<Type>)object4, (List<Type>)var6_12);
                Iterator<Object> iterator = ((List)object3).iterator();
                while (iterator.hasNext()) {
                    JCTree.JCExpression jCExpression = (JCTree.JCExpression)iterator.next();
                    Type type = jCExpression.type;
                    if (type == ((Flow)Flow.this).syms.unknownType) continue;
                    list = list.append(type);
                    if (Flow.this.types.isSameType(type, ((Flow)Flow.this).syms.objectType)) continue;
                    this.checkCaughtType(((JCTree.JCCatch)((List)abstractCollection).head).pos(), type, (List<Type>)object4, (List<Type>)var6_12);
                    List<Type> list5 = Flow.this.chk.incl(type, (List<Type>)var6_12);
                }
                this.scan((JCTree)object);
                this.preciseRethrowTypes.put(((JCTree.JCVariableDecl)object).sym, Flow.this.chk.intersect(list, (List<Type>)object2));
                this.scan(((JCTree.JCCatch)((List)abstractCollection).head).body);
                this.preciseRethrowTypes.remove(((JCTree.JCVariableDecl)object).sym);
                abstractCollection = ((List)abstractCollection).tail;
            }
            if (jCTry.finalizer != null) {
                abstractCollection = this.thrown;
                this.thrown = List.nil();
                object = this.pendingExits;
                this.pendingExits = abstractCollection2;
                this.scan(jCTry.finalizer);
                if (!jCTry.finallyCanCompleteNormally) {
                    this.thrown = Flow.this.chk.union(this.thrown, list3);
                } else {
                    this.thrown = Flow.this.chk.union(this.thrown, Flow.this.chk.diff((List<Type>)object4, (List<Type>)var6_12));
                    this.thrown = Flow.this.chk.union(this.thrown, (List<Type>)abstractCollection);
                    while (((ListBuffer)object).nonEmpty()) {
                        this.pendingExits.append(((ListBuffer)object).next());
                    }
                }
            } else {
                this.thrown = Flow.this.chk.union(this.thrown, Flow.this.chk.diff((List<Type>)object4, (List<Type>)var6_12));
                abstractCollection = this.pendingExits;
                this.pendingExits = abstractCollection2;
                while (((ListBuffer)abstractCollection).nonEmpty()) {
                    this.pendingExits.append(((ListBuffer)abstractCollection).next());
                }
            }
        }

        @Override
        public void visitIf(JCTree.JCIf jCIf) {
            this.scan(jCIf.cond);
            this.scan(jCIf.thenpart);
            if (jCIf.elsepart != null) {
                this.scan(jCIf.elsepart);
            }
        }

        void checkCaughtType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, List<Type> list, List<Type> list2) {
            if (Flow.this.chk.subset(type, list2)) {
                Flow.this.log.error(diagnosticPosition, "except.already.caught", type);
            } else if (!(Flow.this.chk.isUnchecked(diagnosticPosition, type) || this.isExceptionOrThrowable(type) || Flow.this.chk.intersects(type, list))) {
                Flow.this.log.error(diagnosticPosition, "except.never.thrown.in.try", type);
            } else if (Flow.this.allowImprovedCatchAnalysis) {
                List<Type> list3 = Flow.this.chk.intersect(List.of(type), list);
                if (Flow.this.chk.diff(list3, list2).isEmpty() && !this.isExceptionOrThrowable(type)) {
                    String string = list3.length() == 1 ? "unreachable.catch" : "unreachable.catch.1";
                    Flow.this.log.warning(diagnosticPosition, string, list3);
                }
            }
        }

        private boolean isExceptionOrThrowable(Type type) {
            return type.tsym == ((Flow)Flow.this).syms.throwableType.tsym || type.tsym == ((Flow)Flow.this).syms.exceptionType.tsym;
        }

        @Override
        public void visitBreak(JCTree.JCBreak jCBreak) {
            this.recordExit(new FlowPendingExit(jCBreak, null));
        }

        @Override
        public void visitContinue(JCTree.JCContinue jCContinue) {
            this.recordExit(new FlowPendingExit(jCContinue, null));
        }

        @Override
        public void visitReturn(JCTree.JCReturn jCReturn) {
            this.scan(jCReturn.expr);
            this.recordExit(new FlowPendingExit(jCReturn, null));
        }

        @Override
        public void visitThrow(JCTree.JCThrow jCThrow) {
            this.scan(jCThrow.expr);
            Symbol symbol = TreeInfo.symbol(jCThrow.expr);
            if (symbol != null && symbol.kind == Kinds.Kind.VAR && (symbol.flags() & 0x20000000010L) != 0L && this.preciseRethrowTypes.get(symbol) != null && Flow.this.allowImprovedRethrowAnalysis) {
                for (Type type : this.preciseRethrowTypes.get(symbol)) {
                    this.markThrown(jCThrow, type);
                }
            } else {
                this.markThrown(jCThrow, jCThrow.expr.type);
            }
            this.markDead();
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            this.scan(jCMethodInvocation.meth);
            this.scan(jCMethodInvocation.args);
            List<Type> list = jCMethodInvocation.meth.type.getThrownTypes();
            while (list.nonEmpty()) {
                this.markThrown(jCMethodInvocation, (Type)list.head);
                list = list.tail;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            this.scan(jCNewClass.encl);
            this.scan(jCNewClass.args);
            List<Type> list = jCNewClass.constructorType.getThrownTypes();
            while (list.nonEmpty()) {
                this.markThrown(jCNewClass, (Type)list.head);
                list = list.tail;
            }
            list = this.caught;
            try {
                if (jCNewClass.def != null) {
                    List<Type> list2 = jCNewClass.constructor.type.getThrownTypes();
                    while (list2.nonEmpty()) {
                        this.caught = Flow.this.chk.incl((Type)list2.head, this.caught);
                        list2 = list2.tail;
                    }
                }
                this.scan(jCNewClass.def);
            }
            finally {
                this.caught = list;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (jCLambda.type != null && jCLambda.type.isErroneous()) {
                return;
            }
            List<Type> list = this.caught;
            List<Type> list2 = this.thrown;
            ListBuffer listBuffer = this.pendingExits;
            try {
                this.pendingExits = new ListBuffer();
                this.caught = jCLambda.getDescriptorType(Flow.this.types).getThrownTypes();
                this.thrown = List.nil();
                this.scan(jCLambda.body);
                List list3 = this.pendingExits.toList();
                this.pendingExits = new ListBuffer();
                while (list3.nonEmpty()) {
                    FlowPendingExit flowPendingExit = (FlowPendingExit)list3.head;
                    list3 = list3.tail;
                    if (flowPendingExit.thrown == null) {
                        Assert.check(flowPendingExit.tree.hasTag(JCTree.Tag.RETURN));
                        continue;
                    }
                    this.pendingExits.append(flowPendingExit);
                }
                this.errorUncaught();
            }
            finally {
                this.pendingExits = listBuffer;
                this.caught = list;
                this.thrown = list2;
            }
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker treeMaker) {
            this.analyzeTree(env, env.tree, treeMaker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree jCTree, TreeMaker treeMaker) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = treeMaker;
                this.pendingExits = new ListBuffer();
                this.preciseRethrowTypes = new HashMap();
                this.caught = null;
                this.thrown = null;
                this.classDef = null;
                this.scan(jCTree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
                this.caught = null;
                this.thrown = null;
                this.classDef = null;
            }
        }

        class FlowPendingExit
        extends BaseAnalyzer.PendingExit {
            Type thrown;

            FlowPendingExit(JCTree jCTree, Type type) {
                super(jCTree);
                this.thrown = type;
            }
        }
    }

    class AliveAnalyzer
    extends BaseAnalyzer<BaseAnalyzer.PendingExit> {
        private boolean alive;

        AliveAnalyzer() {
        }

        @Override
        void markDead() {
            this.alive = false;
        }

        void scanDef(JCTree jCTree) {
            this.scanStat(jCTree);
            if (jCTree != null && jCTree.hasTag(JCTree.Tag.BLOCK) && !this.alive) {
                Flow.this.log.error(jCTree.pos(), "initializer.must.be.able.to.complete.normally", new Object[0]);
            }
        }

        void scanStat(JCTree jCTree) {
            if (!this.alive && jCTree != null) {
                Flow.this.log.error(jCTree.pos(), "unreachable.stmt", new Object[0]);
                if (!jCTree.hasTag(JCTree.Tag.SKIP)) {
                    this.alive = true;
                }
            }
            this.scan(jCTree);
        }

        void scanStats(List<? extends JCTree.JCStatement> list) {
            if (list != null) {
                List<JCTree.JCStatement> list2 = list;
                while (list2.nonEmpty()) {
                    this.scanStat((JCTree)list2.head);
                    list2 = list2.tail;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            if (jCClassDecl.sym == null) {
                return;
            }
            boolean bl = this.alive;
            ListBuffer listBuffer = this.pendingExits;
            Lint lint = Flow.this.lint;
            this.pendingExits = new ListBuffer();
            Flow.this.lint = Flow.this.lint.augment(jCClassDecl.sym);
            try {
                List<JCTree> list = jCClassDecl.defs;
                while (list.nonEmpty()) {
                    if (!((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)list.head) & 8L) != 0L) {
                        this.scanDef((JCTree)list.head);
                    }
                    list = list.tail;
                }
                list = jCClassDecl.defs;
                while (list.nonEmpty()) {
                    if (!((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)list.head) & 8L) == 0L) {
                        this.scanDef((JCTree)list.head);
                    }
                    list = list.tail;
                }
                list = jCClassDecl.defs;
                while (list.nonEmpty()) {
                    if (((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF)) {
                        this.scan((JCTree)list.head);
                    }
                    list = list.tail;
                }
            }
            finally {
                this.pendingExits = listBuffer;
                this.alive = bl;
                Flow.this.lint = lint;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            if (jCMethodDecl.body == null) {
                return;
            }
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCMethodDecl.sym);
            Assert.check(this.pendingExits.isEmpty());
            try {
                this.alive = true;
                this.scanStat(jCMethodDecl.body);
                if (this.alive && !jCMethodDecl.sym.type.getReturnType().hasTag(TypeTag.VOID)) {
                    Flow.this.log.error(TreeInfo.diagEndPos(jCMethodDecl.body), "missing.ret.stmt", new Object[0]);
                }
                List list = this.pendingExits.toList();
                this.pendingExits = new ListBuffer();
                while (list.nonEmpty()) {
                    BaseAnalyzer.PendingExit pendingExit = (BaseAnalyzer.PendingExit)list.head;
                    list = list.tail;
                    Assert.check(pendingExit.tree.hasTag(JCTree.Tag.RETURN));
                }
            }
            finally {
                Flow.this.lint = lint;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            if (jCVariableDecl.init != null) {
                Lint lint = Flow.this.lint;
                Flow.this.lint = Flow.this.lint.augment(jCVariableDecl.sym);
                try {
                    this.scan(jCVariableDecl.init);
                }
                finally {
                    Flow.this.lint = lint;
                }
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
            this.scanStats(jCBlock.stats);
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scanStat(jCDoWhileLoop.body);
            this.alive |= this.resolveContinues(jCDoWhileLoop);
            this.scan(jCDoWhileLoop.cond);
            this.alive = this.alive && !jCDoWhileLoop.cond.type.isTrue();
            this.alive |= this.resolveBreaks(jCDoWhileLoop, listBuffer);
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCWhileLoop.cond);
            this.alive = !jCWhileLoop.cond.type.isFalse();
            this.scanStat(jCWhileLoop.body);
            this.alive |= this.resolveContinues(jCWhileLoop);
            this.alive = this.resolveBreaks(jCWhileLoop, listBuffer) || !jCWhileLoop.cond.type.isTrue();
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop jCForLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.scanStats(jCForLoop.init);
            this.pendingExits = new ListBuffer();
            if (jCForLoop.cond != null) {
                this.scan(jCForLoop.cond);
                this.alive = !jCForLoop.cond.type.isFalse();
            } else {
                this.alive = true;
            }
            this.scanStat(jCForLoop.body);
            this.alive |= this.resolveContinues(jCForLoop);
            this.scan(jCForLoop.step);
            this.alive = this.resolveBreaks(jCForLoop, listBuffer) || jCForLoop.cond != null && !jCForLoop.cond.type.isTrue();
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            this.visitVarDef(jCEnhancedForLoop.var);
            ListBuffer listBuffer = this.pendingExits;
            this.scan(jCEnhancedForLoop.expr);
            this.pendingExits = new ListBuffer();
            this.scanStat(jCEnhancedForLoop.body);
            this.alive |= this.resolveContinues(jCEnhancedForLoop);
            this.resolveBreaks(jCEnhancedForLoop, listBuffer);
            this.alive = true;
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scanStat(jCLabeledStatement.body);
            this.alive |= this.resolveBreaks(jCLabeledStatement, listBuffer);
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch jCSwitch) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCSwitch.selector);
            boolean bl = false;
            List<JCTree.JCCase> list = jCSwitch.cases;
            while (list.nonEmpty()) {
                this.alive = true;
                JCTree.JCCase jCCase = (JCTree.JCCase)list.head;
                if (jCCase.pat == null) {
                    bl = true;
                } else {
                    this.scan(jCCase.pat);
                }
                this.scanStats(jCCase.stats);
                if (this.alive && Flow.this.lint.isEnabled(Lint.LintCategory.FALLTHROUGH) && jCCase.stats.nonEmpty() && list.tail.nonEmpty()) {
                    Flow.this.log.warning(Lint.LintCategory.FALLTHROUGH, ((JCTree.JCCase)list.tail.head).pos(), "possible.fall-through.into.case", new Object[0]);
                }
                list = list.tail;
            }
            if (!bl) {
                this.alive = true;
            }
            this.alive |= this.resolveBreaks(jCSwitch, listBuffer);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitTry(JCTree.JCTry jCTry) {
            void var4_7;
            JCTree.JCVariableDecl jCVariableDecl;
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            for (JCTree object2 : jCTry.resources) {
                if (object2 instanceof JCTree.JCVariableDecl) {
                    jCVariableDecl = (JCTree.JCVariableDecl)object2;
                    this.visitVarDef(jCVariableDecl);
                    continue;
                }
                if (object2 instanceof JCTree.JCExpression) {
                    this.scan((JCTree.JCExpression)object2);
                    continue;
                }
                throw new AssertionError(jCTry);
            }
            this.scanStat(jCTry.body);
            boolean bl = this.alive;
            List<JCTree.JCCatch> list = jCTry.catchers;
            while (var4_7.nonEmpty()) {
                this.alive = true;
                jCVariableDecl = ((JCTree.JCCatch)var4_7.head).param;
                this.scan(jCVariableDecl);
                this.scanStat(((JCTree.JCCatch)var4_7.head).body);
                bl |= this.alive;
                List list2 = var4_7.tail;
            }
            if (jCTry.finalizer != null) {
                ListBuffer listBuffer2 = this.pendingExits;
                this.pendingExits = listBuffer;
                this.alive = true;
                this.scanStat(jCTry.finalizer);
                jCTry.finallyCanCompleteNormally = this.alive;
                if (!this.alive) {
                    if (Flow.this.lint.isEnabled(Lint.LintCategory.FINALLY)) {
                        Flow.this.log.warning(Lint.LintCategory.FINALLY, TreeInfo.diagEndPos(jCTry.finalizer), "finally.cannot.complete", new Object[0]);
                    }
                } else {
                    while (listBuffer2.nonEmpty()) {
                        this.pendingExits.append(listBuffer2.next());
                    }
                    this.alive = bl;
                }
            } else {
                this.alive = bl;
                ListBuffer listBuffer3 = this.pendingExits;
                this.pendingExits = listBuffer;
                while (listBuffer3.nonEmpty()) {
                    this.pendingExits.append(listBuffer3.next());
                }
            }
        }

        @Override
        public void visitIf(JCTree.JCIf jCIf) {
            this.scan(jCIf.cond);
            this.scanStat(jCIf.thenpart);
            if (jCIf.elsepart != null) {
                boolean bl = this.alive;
                this.alive = true;
                this.scanStat(jCIf.elsepart);
                this.alive |= bl;
            } else {
                this.alive = true;
            }
        }

        @Override
        public void visitBreak(JCTree.JCBreak jCBreak) {
            this.recordExit(new BaseAnalyzer.PendingExit(jCBreak));
        }

        @Override
        public void visitContinue(JCTree.JCContinue jCContinue) {
            this.recordExit(new BaseAnalyzer.PendingExit(jCContinue));
        }

        @Override
        public void visitReturn(JCTree.JCReturn jCReturn) {
            this.scan(jCReturn.expr);
            this.recordExit(new BaseAnalyzer.PendingExit(jCReturn));
        }

        @Override
        public void visitThrow(JCTree.JCThrow jCThrow) {
            this.scan(jCThrow.expr);
            this.markDead();
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            this.scan(jCMethodInvocation.meth);
            this.scan(jCMethodInvocation.args);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            this.scan(jCNewClass.encl);
            this.scan(jCNewClass.args);
            if (jCNewClass.def != null) {
                this.scan(jCNewClass.def);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (jCLambda.type != null && jCLambda.type.isErroneous()) {
                return;
            }
            ListBuffer listBuffer = this.pendingExits;
            boolean bl = this.alive;
            try {
                this.pendingExits = new ListBuffer();
                this.alive = true;
                this.scanStat(jCLambda.body);
                jCLambda.canCompleteNormally = this.alive;
            }
            finally {
                this.pendingExits = listBuffer;
                this.alive = bl;
            }
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker treeMaker) {
            this.analyzeTree(env, env.tree, treeMaker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree jCTree, TreeMaker treeMaker) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = treeMaker;
                this.pendingExits = new ListBuffer();
                this.alive = true;
                this.scan(jCTree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
            }
        }
    }

    static abstract class BaseAnalyzer<P extends PendingExit>
    extends TreeScanner {
        ListBuffer<P> pendingExits;

        BaseAnalyzer() {
        }

        abstract void markDead();

        void recordExit(P p) {
            this.pendingExits.append(p);
            this.markDead();
        }

        private boolean resolveJump(JCTree jCTree, ListBuffer<P> listBuffer, JumpKind jumpKind) {
            boolean bl = false;
            List<Object> list = this.pendingExits.toList();
            this.pendingExits = listBuffer;
            while (list.nonEmpty()) {
                PendingExit pendingExit = (PendingExit)list.head;
                if (pendingExit.tree.hasTag(jumpKind.treeTag) && jumpKind.getTarget(pendingExit.tree) == jCTree) {
                    pendingExit.resolveJump();
                    bl = true;
                } else {
                    this.pendingExits.append(pendingExit);
                }
                list = list.tail;
            }
            return bl;
        }

        boolean resolveContinues(JCTree jCTree) {
            return this.resolveJump(jCTree, new ListBuffer(), JumpKind.CONTINUE);
        }

        boolean resolveBreaks(JCTree jCTree, ListBuffer<P> listBuffer) {
            return this.resolveJump(jCTree, listBuffer, JumpKind.BREAK);
        }

        @Override
        public void scan(JCTree jCTree) {
            if (jCTree != null && (jCTree.type == null || jCTree.type != Type.stuckType)) {
                super.scan(jCTree);
            }
        }

        @Override
        public void visitPackageDef(JCTree.JCPackageDecl jCPackageDecl) {
        }

        static class PendingExit {
            JCTree tree;

            PendingExit(JCTree jCTree) {
                this.tree = jCTree;
            }

            void resolveJump() {
            }
        }

        static enum JumpKind {
            BREAK(JCTree.Tag.BREAK){

                @Override
                JCTree getTarget(JCTree jCTree) {
                    return ((JCTree.JCBreak)jCTree).target;
                }
            }
            ,
            CONTINUE(JCTree.Tag.CONTINUE){

                @Override
                JCTree getTarget(JCTree jCTree) {
                    return ((JCTree.JCContinue)jCTree).target;
                }
            };

            final JCTree.Tag treeTag;

            private JumpKind(JCTree.Tag tag) {
                this.treeTag = tag;
            }

            abstract JCTree getTarget(JCTree var1);
        }
    }

    static enum FlowKind {
        NORMAL("var.might.already.be.assigned", false),
        SPECULATIVE_LOOP("var.might.be.assigned.in.loop", true);

        final String errKey;
        final boolean isFinal;

        private FlowKind(String string2, boolean bl) {
            this.errKey = string2;
            this.isFinal = bl;
        }

        boolean isFinal() {
            return this.isFinal;
        }
    }
}

