/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.ds.AbstractPullOMDataSource;
import org.codehaus.jettison.AbstractXMLInputFactory;
import org.codehaus.jettison.json.JSONTokener;

public abstract class AbstractJSONDataSource
extends AbstractPullOMDataSource {
    private Reader jsonReader;
    private String jsonString;
    private boolean isRead = false;

    public AbstractJSONDataSource(Reader jsonReader) {
        this.jsonReader = jsonReader;
    }

    public final XMLStreamReader getReader() throws XMLStreamException {
        return this.getXMLInputFactory().createXMLStreamReader(new JSONTokener(this.getJSONString()));
    }

    protected abstract AbstractXMLInputFactory getXMLInputFactory() throws XMLStreamException;

    public boolean isDestructiveRead() {
        return false;
    }

    public Object getObject() {
        return this.getJSONString();
    }

    private String getJSONString() {
        if (this.isRead) {
            return this.jsonString;
        }
        try {
            int readLen;
            BufferedReader br = new BufferedReader(this.jsonReader);
            StringBuilder sb = new StringBuilder(512);
            char[] tempBuf = new char[512];
            while ((readLen = br.read(tempBuf)) != -1) {
                sb.append(tempBuf, 0, readLen);
            }
            this.jsonString = sb.toString();
        }
        catch (IOException e) {
            throw new OMException();
        }
        this.isRead = true;
        return this.jsonString;
    }
}

