/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.xmpp.util;

import java.io.ByteArrayInputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;

public class XMPPClientResponseManager
implements PacketListener {
    private static Log log = LogFactory.getLog(XMPPClientResponseManager.class);
    private ConcurrentHashMap<String, WaitingDetails> prespectiveResponseMap = new ConcurrentHashMap();

    public void listenForResponse(String key, MessageContext messageContext) {
        this.prespectiveResponseMap.put(key, new WaitingDetails(messageContext));
    }

    public void processPacket(Packet packet) {
        Message message = (Message)packet;
        String xml = StringEscapeUtils.unescapeXml((String)message.getBody());
        log.debug((Object)("Client received message : " + message.toXML()));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        String sequenceNumber = (String)message.getProperty("transport.xmpp.sequenceID");
        if (sequenceNumber != null) {
            WaitingDetails waitingDetails = this.prespectiveResponseMap.remove(sequenceNumber);
            if (waitingDetails != null) {
                waitingDetails.messageContext.setProperty("TRANSPORT_IN", (Object)inputStream);
                waitingDetails.wait.release();
            } else {
                log.error((Object)("No one waiting for message " + xml));
            }
        } else {
            log.error((Object)"transport.xmpp.sequenceID not found in the message");
        }
    }

    public void waitFor(String key) throws InterruptedException {
        WaitingDetails waitingDetails = this.prespectiveResponseMap.get(key);
        if (waitingDetails == null) {
            return;
        }
        waitingDetails.wait.acquire();
    }

    public class WaitingDetails {
        Semaphore wait = new Semaphore(0);
        MessageContext messageContext;

        public WaitingDetails(MessageContext messageContext) {
            this.messageContext = messageContext;
        }
    }
}

