/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.trevni.Input;
import org.apache.trevni.InputBytes;
import org.apache.trevni.TrevniRuntimeException;
import org.apache.trevni.ValueType;

class InputBuffer {
    private Input in;
    private long inLength;
    private long offset;
    private byte[] buf;
    private int pos;
    private int limit;
    private CharsetDecoder utf8 = Charset.forName("UTF-8").newDecoder();
    private int bitCount;
    private int runLength;
    private int runValue;

    public InputBuffer(Input in) throws IOException {
        this(in, 0L);
    }

    public InputBuffer(Input in, long position) throws IOException {
        this.in = in;
        this.inLength = in.length();
        this.offset = position;
        if (in instanceof InputBytes) {
            this.buf = ((InputBytes)in).getBuffer();
            this.limit = (int)in.length();
            this.offset = this.limit;
            this.pos = (int)position;
        } else {
            this.buf = new byte[8192];
        }
    }

    public void seek(long position) throws IOException {
        this.runLength = 0;
        if (position >= this.offset - (long)this.limit && position <= this.offset) {
            this.pos = (int)((long)this.limit - (this.offset - position));
            return;
        }
        this.pos = 0;
        this.limit = 0;
        this.offset = position;
    }

    public long tell() {
        return this.offset - (long)this.limit + (long)this.pos;
    }

    public long length() {
        return this.inLength;
    }

    public <T extends Comparable> T readValue(ValueType type) throws IOException {
        switch (type) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return (T)Boolean.valueOf(this.readBoolean());
            }
            case INT: {
                return (T)Integer.valueOf(this.readInt());
            }
            case LONG: {
                return (T)Long.valueOf(this.readLong());
            }
            case FIXED32: {
                return (T)Integer.valueOf(this.readFixed32());
            }
            case FIXED64: {
                return (T)Long.valueOf(this.readFixed64());
            }
            case FLOAT: {
                return (T)Float.valueOf(this.readFloat());
            }
            case DOUBLE: {
                return (T)Double.valueOf(this.readDouble());
            }
            case STRING: {
                return (T)this.readString();
            }
            case BYTES: {
                return (T)this.readBytes(null);
            }
        }
        throw new TrevniRuntimeException("Unknown value type: " + (Object)((Object)type));
    }

    public void skipValue(ValueType type) throws IOException {
        switch (type) {
            case NULL: {
                break;
            }
            case BOOLEAN: {
                this.readBoolean();
                break;
            }
            case INT: {
                this.readInt();
                break;
            }
            case LONG: {
                this.readLong();
                break;
            }
            case FIXED32: 
            case FLOAT: {
                this.skip(4L);
                break;
            }
            case FIXED64: 
            case DOUBLE: {
                this.skip(8L);
                break;
            }
            case STRING: 
            case BYTES: {
                this.skipBytes();
                break;
            }
            default: {
                throw new TrevniRuntimeException("Unknown value type: " + (Object)((Object)type));
            }
        }
    }

    public boolean readBoolean() throws IOException {
        if (this.bitCount == 0) {
            this.read();
        }
        int bits = this.buf[this.pos - 1] & 0xFF;
        int bit = bits >> this.bitCount & 1;
        ++this.bitCount;
        if (this.bitCount == 8) {
            this.bitCount = 0;
        }
        return bit != 0;
    }

    public int readLength() throws IOException {
        this.bitCount = 0;
        if (this.runLength > 0) {
            --this.runLength;
            return this.runValue;
        }
        int length = this.readInt();
        if (length >= 0) {
            return length;
        }
        this.runLength = 1 - length >>> 1;
        this.runValue = length + 1 & 1;
        return this.runValue;
    }

    public int readInt() throws IOException {
        if (this.limit - this.pos < 5) {
            int b = this.read();
            int n = b & 0x7F;
            int shift = 7;
            while (b > 127) {
                b = this.read();
                n ^= (b & 0x7F) << shift;
                shift += 7;
            }
            return n >>> 1 ^ -(n & 1);
        }
        int len = 1;
        int b = this.buf[this.pos] & 0xFF;
        int n = b & 0x7F;
        if (b > 127) {
            b = this.buf[this.pos + len++] & 0xFF;
            n ^= (b & 0x7F) << 7;
            if (b > 127) {
                b = this.buf[this.pos + len++] & 0xFF;
                n ^= (b & 0x7F) << 14;
                if (b > 127) {
                    b = this.buf[this.pos + len++] & 0xFF;
                    n ^= (b & 0x7F) << 21;
                    if (b > 127) {
                        b = this.buf[this.pos + len++] & 0xFF;
                        n ^= (b & 0x7F) << 28;
                        if (b > 127) {
                            throw new IOException("Invalid int encoding");
                        }
                    }
                }
            }
        }
        this.pos += len;
        if (this.pos > this.limit) {
            throw new EOFException();
        }
        return n >>> 1 ^ -(n & 1);
    }

    public long readLong() throws IOException {
        long l;
        if (this.limit - this.pos < 10) {
            int b = this.read();
            long n = b & 0x7F;
            int shift = 7;
            while (b > 127) {
                b = this.read();
                n ^= ((long)b & 0x7FL) << shift;
                shift += 7;
            }
            return n >>> 1 ^ -(n & 1L);
        }
        int b = this.buf[this.pos++] & 0xFF;
        int n = b & 0x7F;
        if (b > 127) {
            b = this.buf[this.pos++] & 0xFF;
            n ^= (b & 0x7F) << 7;
            if (b > 127) {
                b = this.buf[this.pos++] & 0xFF;
                n ^= (b & 0x7F) << 14;
                if (b > 127) {
                    b = this.buf[this.pos++] & 0xFF;
                    l = b > 127 ? this.innerLongDecode(n) : (long)(n ^= (b & 0x7F) << 21);
                } else {
                    l = n;
                }
            } else {
                l = n;
            }
        } else {
            l = n;
        }
        if (this.pos > this.limit) {
            throw new EOFException();
        }
        return l >>> 1 ^ -(l & 1L);
    }

    private long innerLongDecode(long l) throws IOException {
        int len = 1;
        int b = this.buf[this.pos] & 0xFF;
        l ^= ((long)b & 0x7FL) << 28;
        if (b > 127) {
            b = this.buf[this.pos + len++] & 0xFF;
            l ^= ((long)b & 0x7FL) << 35;
            if (b > 127) {
                b = this.buf[this.pos + len++] & 0xFF;
                l ^= ((long)b & 0x7FL) << 42;
                if (b > 127) {
                    b = this.buf[this.pos + len++] & 0xFF;
                    l ^= ((long)b & 0x7FL) << 49;
                    if (b > 127) {
                        b = this.buf[this.pos + len++] & 0xFF;
                        l ^= ((long)b & 0x7FL) << 56;
                        if (b > 127) {
                            b = this.buf[this.pos + len++] & 0xFF;
                            l ^= ((long)b & 0x7FL) << 63;
                            if (b > 127) {
                                throw new IOException("Invalid long encoding");
                            }
                        }
                    }
                }
            }
        }
        this.pos += len;
        return l;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readFixed32());
    }

    public int readFixed32() throws IOException {
        if (this.limit - this.pos < 4) {
            return this.read() | this.read() << 8 | this.read() << 16 | this.read() << 24;
        }
        int len = 1;
        int n = this.buf[this.pos] & 0xFF | (this.buf[this.pos + len++] & 0xFF) << 8 | (this.buf[this.pos + len++] & 0xFF) << 16 | (this.buf[this.pos + len++] & 0xFF) << 24;
        if (this.pos + 4 > this.limit) {
            throw new EOFException();
        }
        this.pos += 4;
        return n;
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readFixed64());
    }

    public long readFixed64() throws IOException {
        return (long)this.readFixed32() & 0xFFFFFFFFL | (long)this.readFixed32() << 32;
    }

    public String readString() throws IOException {
        int length = this.readInt();
        if (length <= this.limit - this.pos) {
            String result = this.utf8.decode(ByteBuffer.wrap(this.buf, this.pos, length)).toString();
            this.pos += length;
            return result;
        }
        byte[] bytes = new byte[length];
        this.readFully(bytes, 0, length);
        return this.utf8.decode(ByteBuffer.wrap(bytes, 0, length)).toString();
    }

    public byte[] readBytes() throws IOException {
        byte[] result = new byte[this.readInt()];
        this.readFully(result);
        return result;
    }

    public ByteBuffer readBytes(ByteBuffer old) throws IOException {
        ByteBuffer result;
        int length = this.readInt();
        if (old != null && length <= old.capacity()) {
            result = old;
            ((Buffer)result).clear();
        } else {
            result = ByteBuffer.allocate(length);
        }
        this.readFully(result.array(), result.position(), length);
        ((Buffer)result).limit(length);
        return result;
    }

    public void skipBytes() throws IOException {
        this.skip(this.readInt());
    }

    private void skip(long length) throws IOException {
        this.seek(this.tell() + length);
    }

    public int read() throws IOException {
        if (this.pos >= this.limit) {
            this.limit = this.readInput(this.buf, 0, this.buf.length);
            this.pos = 0;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public void readFully(byte[] bytes) throws IOException {
        this.readFully(bytes, 0, bytes.length);
    }

    public void readFully(byte[] bytes, int start, int len) throws IOException {
        int buffered = this.limit - this.pos;
        if (len > buffered) {
            System.arraycopy(this.buf, this.pos, bytes, start, buffered);
            start += buffered;
            this.pos += buffered;
            if ((len -= buffered) > this.buf.length) {
                int read;
                do {
                    read = this.readInput(bytes, start, len);
                    start += read;
                } while ((len -= read) > 0);
                return;
            }
            this.limit = this.readInput(this.buf, 0, this.buf.length);
            this.pos = 0;
        }
        System.arraycopy(this.buf, this.pos, bytes, start, len);
        this.pos += len;
    }

    private int readInput(byte[] b, int start, int len) throws IOException {
        int read = this.in.read(this.offset, b, start, len);
        if (read < 0) {
            throw new EOFException();
        }
        this.offset += (long)read;
        return read;
    }
}

